/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLConnection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.core.runtime.adaptor.EclipseLog;
import org.eclipse.core.runtime.adaptor.LocationManager;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.hooks.AdaptorHook;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.internal.baseadaptor.AdaptorUtil;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class EclipseLogHook
implements HookConfigurator,
AdaptorHook {
    private static final String LOG_EXT = ".log";
    BaseAdaptor adaptor;

    public void addHooks(HookRegistry hookRegistry) {
        hookRegistry.addAdaptorHook(this);
    }

    public void initialize(BaseAdaptor adaptor) {
        this.adaptor = adaptor;
    }

    public void frameworkStart(BundleContext context) throws BundleException {
        AdaptorUtil.register(FrameworkLog.class.getName(), this.adaptor.getFrameworkLog(), context);
        this.registerPerformanceLog(context);
    }

    public void frameworkStop(BundleContext context) throws BundleException {
    }

    public void frameworkStopping(BundleContext context) {
    }

    public void addProperties(Properties properties) {
    }

    public URLConnection mapLocationToURLConnection(String location) throws IOException {
        return null;
    }

    public void handleRuntimeError(Throwable error) {
    }

    public boolean matchDNChain(String pattern, String[] dnChain) {
        return false;
    }

    public FrameworkLog createFrameworkLog() {
        EclipseLog frameworkLog;
        String logFileProp = FrameworkProperties.getProperty("osgi.logfile");
        if (logFileProp != null) {
            frameworkLog = new EclipseLog(new File(logFileProp));
        } else {
            Location location = LocationManager.getConfigurationLocation();
            File configAreaDirectory = null;
            if (location != null) {
                configAreaDirectory = new File(location.getURL().getFile());
            }
            if (configAreaDirectory != null) {
                String logFileName = String.valueOf(Long.toString(System.currentTimeMillis())) + LOG_EXT;
                File logFile = new File(configAreaDirectory, logFileName);
                FrameworkProperties.setProperty("osgi.logfile", logFile.getAbsolutePath());
                frameworkLog = new EclipseLog(logFile);
            } else {
                frameworkLog = new EclipseLog();
            }
        }
        if ("true".equals(FrameworkProperties.getProperty("eclipse.consoleLog"))) {
            frameworkLog.setConsoleLog(true);
        }
        return frameworkLog;
    }

    private void registerPerformanceLog(BundleContext context) {
        FrameworkLog service = this.createPerformanceLog();
        String serviceName = FrameworkLog.class.getName();
        Hashtable serviceProperties = new Hashtable(7);
        Dictionary headers = context.getBundle().getHeaders();
        serviceProperties.put("service.vendor", headers.get("Bundle-Vendor"));
        serviceProperties.put("service.ranking", new Integer(Integer.MIN_VALUE));
        serviceProperties.put("service.pid", String.valueOf(context.getBundle().getBundleId() + 46L) + service.getClass().getName());
        serviceProperties.put("performance", Boolean.TRUE.toString());
        context.registerService(serviceName, (Object)service, serviceProperties);
    }

    private FrameworkLog createPerformanceLog() {
        int lastSlash;
        String logFileProp = FrameworkProperties.getProperty("osgi.logfile");
        if (logFileProp != null && (lastSlash = logFileProp.lastIndexOf(File.separatorChar)) > 0) {
            String logFile = String.valueOf(logFileProp.substring(0, lastSlash + 1)) + "performance.log";
            return new EclipseLog(new File(logFile));
        }
        return new EclipseLog(new PrintWriter(System.err));
    }
}

