/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationMigrationDelegate;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

public class JavaMigrationDelegate
implements ILaunchConfigurationMigrationDelegate {
    protected static final String EMPTY_STRING = "";

    protected IProject[] getProjectsForCandidate(ILaunchConfiguration candidate) throws CoreException {
        String pname = candidate.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, EMPTY_STRING);
        return new IProject[]{ResourcesPlugin.getWorkspace().getRoot().getProject(pname)};
    }

    public boolean isCandidate(ILaunchConfiguration candidate) throws CoreException {
        if (candidate.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, EMPTY_STRING).equals(EMPTY_STRING)) {
            return false;
        }
        IResource[] mappedResources = candidate.getMappedResources();
        return mappedResources == null || mappedResources.length <= 0;
    }

    public void migrate(ILaunchConfiguration candidate) throws CoreException {
        IProject[] projects = this.getProjectsForCandidate(candidate);
        ArrayList<IProject> mappings = new ArrayList<IProject>();
        int i = 0;
        while (i < projects.length) {
            if (!mappings.contains(projects[i])) {
                mappings.add(projects[i]);
            }
            ++i;
        }
        ILaunchConfigurationWorkingCopy wc = candidate.getWorkingCopy();
        wc.setMappedResources(mappings.toArray(new IResource[mappings.size()]));
        wc.doSave();
    }
}

