/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.ResourceBundle;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.CompoundEditExitStrategy;
import org.eclipse.jdt.internal.ui.javaeditor.ICompoundEditListener;
import org.eclipse.jdt.internal.ui.javaeditor.IndentUtil;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class JavaMoveLinesAction
extends TextEditorAction {
    private final boolean fUpwards;
    private final boolean fCopy;
    private final SharedState fSharedState;

    public static JavaMoveLinesAction[] createMoveCopyActionSet(ResourceBundle bundle, CompilationUnitEditor editor) {
        SharedState state = new SharedState(editor);
        JavaMoveLinesAction[] actions = new JavaMoveLinesAction[]{new JavaMoveLinesAction(bundle, "Editor.MoveLinesUp.", true, false, state), new JavaMoveLinesAction(bundle, "Editor.MoveLinesDown.", false, false, state), new JavaMoveLinesAction(bundle, "Editor.CopyLineUp.", true, true, state), new JavaMoveLinesAction(bundle, "Editor.CopyLineDown.", false, true, state)};
        return actions;
    }

    public void setEditor(ITextEditor editor) {
        Assert.isTrue((boolean)(editor instanceof CompilationUnitEditor));
        super.setEditor(editor);
        if (this.fSharedState != null) {
            this.fSharedState.fEditor = (CompilationUnitEditor)editor;
        }
    }

    private JavaMoveLinesAction(ResourceBundle bundle, String prefix, boolean upwards, boolean copy, SharedState state) {
        super(bundle, prefix, (ITextEditor)state.fEditor);
        this.fUpwards = upwards;
        this.fCopy = copy;
        this.fSharedState = state;
        this.update();
    }

    private boolean containedByVisibleRegion(ITextSelection selection, ISourceViewer viewer) {
        block7: {
            int visEnd;
            IDocument document;
            int max;
            block8: {
                int visOffset;
                IRegion visible;
                block5: {
                    int min;
                    block6: {
                        min = selection.getOffset();
                        max = min + selection.getLength();
                        document = viewer.getDocument();
                        visible = viewer instanceof ITextViewerExtension5 ? ((ITextViewerExtension5)viewer).getModelCoverage() : viewer.getVisibleRegion();
                        visOffset = visible.getOffset();
                        try {
                            if (visOffset <= min) break block5;
                            if (document.getLineOfOffset(visOffset) == selection.getStartLine()) break block6;
                            return false;
                        }
                        catch (BadLocationException badLocationException) {
                            return false;
                        }
                    }
                    if (this.isWhitespace(document.get(min, visOffset - min))) break block5;
                    this.showStatus();
                    return false;
                }
                visEnd = visOffset + visible.getLength();
                if (visEnd >= max) break block7;
                if (document.getLineOfOffset(visEnd) == selection.getEndLine()) break block8;
                return false;
            }
            if (this.isWhitespace(document.get(visEnd, max - visEnd))) break block7;
            this.showStatus();
            return false;
        }
        return true;
    }

    private ITextSelection getMovingSelection(IDocument document, ITextSelection selection, ISourceViewer viewer) throws BadLocationException {
        int low = document.getLineOffset(selection.getStartLine());
        int endLine = selection.getEndLine();
        int high = document.getLineOffset(endLine) + document.getLineLength(endLine);
        String delim = document.getLineDelimiter(endLine);
        if (delim != null) {
            high -= delim.length();
        }
        return new TextSelection(document, low, high - low);
    }

    private ITextSelection getSkippedLine(IDocument document, ITextSelection selection) {
        int skippedLineN;
        int n = skippedLineN = this.fUpwards ? selection.getStartLine() - 1 : selection.getEndLine() + 1;
        if (skippedLineN > document.getNumberOfLines() || !this.fCopy && (skippedLineN < 0 || skippedLineN == document.getNumberOfLines())) {
            return null;
        }
        try {
            if (this.fCopy && skippedLineN == -1) {
                skippedLineN = 0;
            }
            IRegion line = document.getLineInformation(skippedLineN);
            return new TextSelection(document, line.getOffset(), line.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private boolean isWhitespace(String string) {
        return string == null ? true : string.trim().length() == 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runWithEvent(Event event) {
        ITextSelection movingArea;
        if (this.fSharedState.fEditor == null) {
            return;
        }
        if (!this.validateEditorInputState()) {
            return;
        }
        ISourceViewer viewer = this.fSharedState.fEditor.getViewer();
        if (viewer == null) {
            return;
        }
        IDocument document = viewer.getDocument();
        if (document == null) {
            return;
        }
        StyledText widget = viewer.getTextWidget();
        if (widget == null) {
            return;
        }
        Point p = viewer.getSelectedRange();
        if (p == null) {
            return;
        }
        TextSelection sel = new TextSelection(document, p.x, p.y);
        ITextSelection skippedLine = this.getSkippedLine(document, (ITextSelection)sel);
        if (skippedLine == null) {
            return;
        }
        try {
            movingArea = this.getMovingSelection(document, (ITextSelection)sel, viewer);
            if (!this.containedByVisibleRegion(movingArea, viewer)) return;
            if (!this.containedByVisibleRegion(skippedLine, viewer)) {
                return;
            }
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        {
            void var16_21;
            int offset;
            String insertion;
            String moving = movingArea.getText();
            String skipped = skippedLine.getText();
            if (moving == null) return;
            if (skipped == null) return;
            if (document.getLength() == 0) {
                return;
            }
            if (this.fUpwards) {
                String delim = document.getLineDelimiter(skippedLine.getEndLine());
                if (this.fCopy) {
                    delim = TextUtilities.getDefaultLineDelimiter((IDocument)document);
                    insertion = String.valueOf(moving) + delim;
                    offset = movingArea.getOffset();
                } else {
                    Assert.isNotNull((Object)delim);
                    insertion = String.valueOf(moving) + delim + skipped;
                    offset = skippedLine.getOffset();
                }
            } else {
                String delim = document.getLineDelimiter(movingArea.getEndLine());
                if (this.fCopy) {
                    if (delim == null) {
                        delim = TextUtilities.getDefaultLineDelimiter((IDocument)document);
                        insertion = String.valueOf(delim) + moving;
                    } else {
                        insertion = String.valueOf(moving) + delim;
                    }
                    offset = skippedLine.getOffset();
                } else {
                    Assert.isNotNull((Object)delim);
                    insertion = String.valueOf(skipped) + delim + moving;
                    offset = movingArea.getOffset();
                }
            }
            int lenght = this.fCopy ? 0 : insertion.length();
            ILineRange selectionBefore = this.getLineRange(document, movingArea);
            if (this.fCopy) {
                this.fSharedState.endCompoundEdit();
            }
            this.fSharedState.beginCompoundEdit();
            this.fSharedState.fIsChanging = true;
            document.replace(offset, lenght, insertion);
            if (this.fUpwards && this.fCopy) {
                ILineRange iLineRange = selectionBefore;
            } else if (this.fUpwards) {
                LineRange lineRange = new LineRange(selectionBefore.getStartLine() - 1, selectionBefore.getNumberOfLines());
            } else if (this.fCopy) {
                LineRange lineRange = new LineRange(selectionBefore.getStartLine() + selectionBefore.getNumberOfLines(), selectionBefore.getNumberOfLines());
            } else {
                LineRange lineRange = new LineRange(selectionBefore.getStartLine() + 1, selectionBefore.getNumberOfLines());
            }
            this.fSharedState.fResult = IndentUtil.indentLines(document, (ILineRange)var16_21, this.getProject(), this.fSharedState.fResult);
            IRegion region = this.getRegion(document, (ILineRange)var16_21);
            this.selectAndReveal((ITextViewer)viewer, region.getOffset(), region.getLength());
            return;
        }
    }

    private IJavaProject getProject() {
        IEditorInput editorInput = this.fSharedState.fEditor.getEditorInput();
        ICompilationUnit unit = JavaPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput);
        if (unit != null) {
            return unit.getJavaProject();
        }
        return null;
    }

    private ILineRange getLineRange(IDocument document, ITextSelection selection) throws BadLocationException {
        int offset = selection.getOffset();
        int startLine = document.getLineOfOffset(offset);
        int endOffset = offset + selection.getLength();
        int endLine = document.getLineOfOffset(endOffset);
        int nLines = endLine - startLine + 1;
        return new LineRange(startLine, nLines);
    }

    private IRegion getRegion(IDocument document, ILineRange lineRange) throws BadLocationException {
        int startLine = lineRange.getStartLine();
        int offset = document.getLineOffset(startLine);
        int numberOfLines = lineRange.getNumberOfLines();
        if (numberOfLines < 1) {
            return new Region(offset, 0);
        }
        int endLine = startLine + numberOfLines - 1;
        int endOffset = document.getLineOffset(endLine) + document.getLineLength(endLine);
        return new Region(offset, endOffset - offset);
    }

    private void selectAndReveal(ITextViewer viewer, int offset, int length) {
        viewer.setSelectedRange(offset + length, -length);
        StyledText st = viewer.getTextWidget();
        if (st != null) {
            st.showSelection();
        }
    }

    private void showStatus() {
        IEditorStatusLine status = (IEditorStatusLine)this.fSharedState.fEditor.getAdapter(IEditorStatusLine.class);
        if (status == null) {
            return;
        }
        status.setMessage(false, JavaEditorMessages.Editor_MoveLines_IllegalMove_status, null);
    }

    public void update() {
        super.update();
        if (this.isEnabled()) {
            this.setEnabled(this.canModifyEditor());
        }
    }

    private static final class SharedState {
        public CompilationUnitEditor fEditor;
        public IndentUtil.IndentResult fResult = null;
        boolean fIsChanging = false;
        private boolean fEditInProgress = false;
        private final CompoundEditExitStrategy fExitStrategy;

        public SharedState(CompilationUnitEditor editor) {
            this.fEditor = editor;
            this.fExitStrategy = new CompoundEditExitStrategy(new String[]{"org.eclipse.ui.edit.text.moveLineUp", "org.eclipse.ui.edit.text.moveLineDown", "org.eclipse.ui.edit.text.copyLineUp", "org.eclipse.ui.edit.text.copyLineDown"});
            this.fExitStrategy.addCompoundListener(new ICompoundEditListener(){

                public void endCompoundEdit() {
                    SharedState.this.endCompoundEdit();
                }
            });
        }

        public void beginCompoundEdit() {
            if (this.fEditInProgress || this.fEditor == null) {
                return;
            }
            this.fEditInProgress = true;
            this.fExitStrategy.arm((ITextViewer)this.fEditor.getViewer());
            IRewriteTarget target = (IRewriteTarget)this.fEditor.getAdapter(IRewriteTarget.class);
            if (target != null) {
                target.beginCompoundChange();
            }
        }

        public void endCompoundEdit() {
            if (!this.fEditInProgress || this.fEditor == null) {
                return;
            }
            this.fExitStrategy.disarm();
            IRewriteTarget target = (IRewriteTarget)this.fEditor.getAdapter(IRewriteTarget.class);
            if (target != null) {
                target.endCompoundChange();
            }
            this.fResult = null;
            this.fEditInProgress = false;
        }
    }
}

