/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.text.Assert;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class ASTProvider {
    public static final WAIT_FLAG WAIT_YES = new WAIT_FLAG("wait yes");
    public static final WAIT_FLAG WAIT_ACTIVE_ONLY = new WAIT_FLAG("wait active only");
    public static final WAIT_FLAG WAIT_NO = new WAIT_FLAG("don't wait");
    private static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jdt.ui/debug/ASTProvider"));
    public static final int SHARED_AST_LEVEL = 3;
    public static final boolean SHARED_AST_STATEMENT_RECOVERY = true;
    private static final String DEBUG_PREFIX = "ASTProvider > ";
    private IJavaElement fReconcilingJavaElement;
    private IJavaElement fActiveJavaElement;
    private CompilationUnit fAST;
    private ActivationListener fActivationListener;
    private Object fReconcileLock = new Object();
    private Object fWaitLock = new Object();
    private boolean fIsReconciling;
    private IWorkbenchPart fActiveEditor;

    public static ASTProvider getASTProvider() {
        return JavaPlugin.getDefault().getASTProvider();
    }

    public ASTProvider() {
        this.install();
    }

    void install() {
        this.fActivationListener = new ActivationListener();
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this.fActivationListener);
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        int length = windows.length;
        while (i < length) {
            windows[i].getPartService().addPartListener((IPartListener2)this.fActivationListener);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activeJavaEditorChanged(IWorkbenchPart editor) {
        IJavaElement javaElement = null;
        if (editor instanceof JavaEditor) {
            javaElement = ((JavaEditor)editor).getInputJavaElement();
        }
        Object object = this;
        synchronized (object) {
            this.fActiveEditor = editor;
            this.fActiveJavaElement = javaElement;
            this.cache(null, javaElement);
        }
        if (DEBUG) {
            System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "active editor is: " + this.toString(javaElement));
        }
        object = this.fReconcileLock;
        synchronized (object) {
            if (this.fIsReconciling && (this.fReconcilingJavaElement == null || !this.fReconcilingJavaElement.equals(javaElement))) {
                this.fIsReconciling = false;
                this.fReconcilingJavaElement = null;
            } else if (javaElement == null) {
                this.fIsReconciling = false;
                this.fReconcilingJavaElement = null;
            }
        }
    }

    public boolean isCached(CompilationUnit ast) {
        return ast != null && this.fAST == ast;
    }

    public boolean isActive(ICompilationUnit cu) {
        return cu != null && cu.equals(this.fActiveJavaElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void aboutToBeReconciled(IJavaElement javaElement) {
        if (javaElement == null) {
            return;
        }
        if (DEBUG) {
            System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "about to reconcile: " + this.toString(javaElement));
        }
        Object object = this.fReconcileLock;
        synchronized (object) {
            this.fIsReconciling = true;
            this.fReconcilingJavaElement = javaElement;
        }
        this.cache(null, javaElement);
    }

    private synchronized void disposeAST() {
        if (this.fAST == null) {
            return;
        }
        if (DEBUG) {
            System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "disposing AST: " + this.toString(this.fAST) + " for: " + this.toString(this.fActiveJavaElement));
        }
        this.fAST = null;
        this.cache(null, null);
    }

    private String toString(IJavaElement javaElement) {
        if (javaElement == null) {
            return "null";
        }
        return javaElement.getElementName();
    }

    private String toString(CompilationUnit ast) {
        if (ast == null) {
            return "null";
        }
        List types = ast.types();
        if (types != null && types.size() > 0) {
            return ((AbstractTypeDeclaration)types.get(0)).getName().getIdentifier();
        }
        return "AST without any type";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cache(CompilationUnit ast, IJavaElement javaElement) {
        if (this.fActiveJavaElement != null && !this.fActiveJavaElement.equals(javaElement)) {
            if (DEBUG && javaElement != null) {
                System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "don't cache AST for inactive: " + this.toString(javaElement));
            }
            return;
        }
        if (DEBUG && (javaElement != null || ast != null)) {
            System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "caching AST: " + this.toString(ast) + " for: " + this.toString(javaElement));
        }
        if (this.fAST != null) {
            this.disposeAST();
        }
        this.fAST = ast;
        Object object = this.fWaitLock;
        synchronized (object) {
            this.fWaitLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompilationUnit getAST(IJavaElement je, WAIT_FLAG waitFlag, IProgressMonitor progressMonitor) {
        boolean isActiveElement;
        if (je == null) {
            return null;
        }
        Assert.isTrue((je.getElementType() == 6 || je.getElementType() == 5 ? 1 : 0) != 0);
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        ASTProvider aSTProvider = this;
        synchronized (aSTProvider) {
            isActiveElement = je.equals(this.fActiveJavaElement);
            if (isActiveElement) {
                if (this.fAST != null) {
                    if (!DEBUG) return this.fAST;
                    System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "returning cached AST:" + this.toString(this.fAST) + " for: " + je.getElementName());
                    return this.fAST;
                }
                if (waitFlag == WAIT_NO) {
                    if (!DEBUG) return null;
                    System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "returning null (WAIT_NO) for: " + je.getElementName());
                    return null;
                }
            }
        }
        if (isActiveElement && this.isReconciling(je)) {
            try {
                IJavaElement activeElement = this.fReconcilingJavaElement;
                Object object = this.fWaitLock;
                synchronized (object) {
                    if (DEBUG) {
                        System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "waiting for AST for: " + je.getElementName());
                    }
                    this.fWaitLock.wait();
                }
                object = this;
                synchronized (object) {
                    if (activeElement != this.fActiveJavaElement) return this.getAST(je, waitFlag, progressMonitor);
                    if (this.fAST == null) return this.getAST(je, waitFlag, progressMonitor);
                    if (!DEBUG) return this.fAST;
                    System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "...got AST for: " + je.getElementName());
                    return this.fAST;
                }
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
        if (waitFlag == WAIT_NO) return null;
        if (waitFlag == WAIT_ACTIVE_ONLY) {
            if (!isActiveElement) return null;
            if (this.fAST != null) {
                return null;
            }
        }
        if (isActiveElement) {
            this.aboutToBeReconciled(je);
        }
        CompilationUnit ast = null;
        try {
            ast = this.createAST(je, progressMonitor);
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                ast = null;
                return ast;
            }
            if (!DEBUG) return ast;
            if (ast == null) return ast;
            System.err.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "created AST for: " + je.getElementName());
            return ast;
        }
        finally {
            if (isActiveElement) {
                if (this.fAST != null) {
                    if (DEBUG) {
                        System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "Ignore created AST for " + je.getElementName() + "- AST from reconciler is newer");
                    }
                    this.reconciled(this.fAST, je, null);
                } else {
                    this.reconciled(ast, je, null);
                }
            }
        }
    }

    public CompilationUnit getAST(IJavaElement je, boolean wait, IProgressMonitor progressMonitor) {
        if (wait) {
            return this.getAST(je, WAIT_YES, progressMonitor);
        }
        return this.getAST(je, WAIT_NO, progressMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReconciling(IJavaElement javaElement) {
        Object object = this.fReconcileLock;
        synchronized (object) {
            return javaElement != null && javaElement.equals(this.fReconcilingJavaElement) && this.fIsReconciling;
        }
    }

    private CompilationUnit createAST(IJavaElement je, final IProgressMonitor progressMonitor) {
        if (!this.hasSource(je)) {
            return null;
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        final ASTParser parser = ASTParser.newParser((int)3);
        parser.setResolveBindings(true);
        parser.setStatementsRecovery(true);
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        if (je.getElementType() == 5) {
            parser.setSource((ICompilationUnit)je);
        } else if (je.getElementType() == 6) {
            parser.setSource((IClassFile)je);
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        final CompilationUnit[] root = new CompilationUnit[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() {
                try {
                    if (progressMonitor != null && progressMonitor.isCanceled()) {
                        root[0] = null;
                    }
                    root[0] = (CompilationUnit)parser.createAST(progressMonitor);
                }
                catch (OperationCanceledException operationCanceledException) {
                    root[0] = null;
                }
            }

            public void handleException(Throwable ex) {
                Status status = new Status(4, "org.eclipse.jdt.ui", 0, "Error in JDT Core during AST creation", ex);
                JavaPlugin.getDefault().getLog().log((IStatus)status);
            }
        });
        if (root[0] != null) {
            ASTNodes.setFlagsToAST((ASTNode)root[0], 4);
        }
        return root[0];
    }

    private boolean hasSource(IJavaElement je) {
        if (je == null || !je.exists()) {
            return false;
        }
        try {
            return je instanceof ISourceReference && ((ISourceReference)je).getSource() != null;
        }
        catch (JavaModelException ex) {
            Status status = new Status(4, "org.eclipse.jdt.ui", 0, "Error in JDT Core during AST creation", (Throwable)ex);
            JavaPlugin.getDefault().getLog().log((IStatus)status);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this.fActivationListener);
        this.fActivationListener = null;
        this.disposeAST();
        Object object = this.fWaitLock;
        synchronized (object) {
            this.fWaitLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reconciled(CompilationUnit ast, IJavaElement javaElement, IProgressMonitor progressMonitor) {
        if (DEBUG) {
            System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "reconciled: " + this.toString(javaElement) + ", AST: " + this.toString(ast));
        }
        Object object = this.fReconcileLock;
        synchronized (object) {
            boolean bl = this.fIsReconciling = progressMonitor != null && progressMonitor.isCanceled();
            if (javaElement == null || !javaElement.equals(this.fReconcilingJavaElement)) {
                if (DEBUG) {
                    System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "  ignoring AST of out-dated editor");
                }
                Object object2 = this.fWaitLock;
                synchronized (object2) {
                    this.fWaitLock.notifyAll();
                }
                return;
            }
            this.cache(ast, javaElement);
        }
    }

    private String getThreadName() {
        String name = Thread.currentThread().getName();
        if (name != null) {
            return name;
        }
        return Thread.currentThread().toString();
    }

    public static final class WAIT_FLAG {
        String fName;

        private WAIT_FLAG(String name) {
            this.fName = name;
        }

        public String toString() {
            return this.fName;
        }
    }

    private class ActivationListener
    implements IPartListener2,
    IWindowListener {
        private ActivationListener() {
        }

        public void partActivated(IWorkbenchPartReference ref) {
            if (this.isJavaEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeJavaEditorChanged(ref.getPart(true));
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
            if (this.isJavaEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeJavaEditorChanged(ref.getPart(true));
            }
        }

        public void partClosed(IWorkbenchPartReference ref) {
            if (this.isActiveEditor(ref)) {
                if (DEBUG) {
                    System.out.println(String.valueOf(ASTProvider.this.getThreadName()) + " - " + ASTProvider.DEBUG_PREFIX + "closed active editor: " + ref.getTitle());
                }
                ASTProvider.this.activeJavaEditorChanged(null);
            }
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
            if (this.isJavaEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeJavaEditorChanged(ref.getPart(true));
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            if (this.isJavaEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeJavaEditorChanged(ref.getPart(true));
            }
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
            if (this.isJavaEditor(ref) && this.isActiveEditor(ref)) {
                ASTProvider.this.activeJavaEditorChanged(ref.getPart(true));
            }
        }

        public void windowActivated(IWorkbenchWindow window) {
            IWorkbenchPartReference ref = window.getPartService().getActivePartReference();
            if (this.isJavaEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeJavaEditorChanged(ref.getPart(true));
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            if (ASTProvider.this.fActiveEditor != null && ASTProvider.this.fActiveEditor.getSite() != null && window == ASTProvider.this.fActiveEditor.getSite().getWorkbenchWindow()) {
                if (DEBUG) {
                    System.out.println(String.valueOf(ASTProvider.this.getThreadName()) + " - " + ASTProvider.DEBUG_PREFIX + "closed active editor: " + ASTProvider.this.fActiveEditor.getTitle());
                }
                ASTProvider.this.activeJavaEditorChanged(null);
            }
            window.getPartService().removePartListener((IPartListener2)this);
        }

        public void windowOpened(IWorkbenchWindow window) {
            window.getPartService().addPartListener((IPartListener2)this);
        }

        private boolean isActiveEditor(IWorkbenchPartReference ref) {
            return ref != null && this.isActiveEditor(ref.getPart(false));
        }

        private boolean isActiveEditor(IWorkbenchPart part) {
            return part != null && part == ASTProvider.this.fActiveEditor;
        }

        private boolean isJavaEditor(IWorkbenchPartReference ref) {
            if (ref == null) {
                return false;
            }
            String id = ref.getId();
            return "org.eclipse.jdt.ui.ClassFileEditor".equals(id) || "org.eclipse.jdt.ui.CompilationUnitEditor".equals(id) || ref.getPart(false) instanceof JavaEditor;
        }
    }
}

