/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.observable.value;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jface.internal.databinding.provisional.observable.AbstractObservable;
import org.eclipse.jface.internal.databinding.provisional.observable.ObservableTracker;
import org.eclipse.jface.internal.databinding.provisional.observable.value.IObservableValue;
import org.eclipse.jface.internal.databinding.provisional.observable.value.IValueChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.value.ValueDiff;

public abstract class AbstractObservableValue
extends AbstractObservable
implements IObservableValue {
    private Collection valueChangeListeners = null;

    public void addValueChangeListener(IValueChangeListener listener) {
        if (this.valueChangeListeners == null) {
            boolean hadListeners = this.hasListeners();
            this.valueChangeListeners = new ArrayList();
            this.valueChangeListeners.add(listener);
            if (!hadListeners) {
                this.firstListenerAdded();
            }
        } else if (this.valueChangeListeners.size() > 16) {
            HashSet listenerList = new HashSet();
            listenerList.addAll(this.valueChangeListeners);
            this.valueChangeListeners = listenerList;
            this.valueChangeListeners.add(listener);
        } else {
            this.valueChangeListeners.add(listener);
        }
    }

    public void removeValueChangeListener(IValueChangeListener listener) {
        if (this.valueChangeListeners == null) {
            return;
        }
        this.valueChangeListeners.remove(listener);
        if (this.valueChangeListeners.size() == 0) {
            this.valueChangeListeners = null;
        }
        if (!this.hasListeners()) {
            this.lastListenerRemoved();
        }
    }

    public void setValue(Object value) {
        throw new UnsupportedOperationException();
    }

    protected void fireValueChange(ValueDiff diff) {
        super.fireChange();
        if (this.valueChangeListeners != null) {
            IValueChangeListener[] listeners = this.valueChangeListeners.toArray(new IValueChangeListener[this.valueChangeListeners.size()]);
            int i = 0;
            while (i < listeners.length) {
                listeners[i].handleValueChange(this, diff);
                ++i;
            }
        }
    }

    public final Object getValue() {
        ObservableTracker.getterCalled(this);
        return this.doGetValue();
    }

    protected abstract Object doGetValue();

    public boolean isStale() {
        return false;
    }

    protected boolean hasListeners() {
        return super.hasListeners() || this.valueChangeListeners != null;
    }

    protected void fireChange() {
        throw new RuntimeException("fireChange should not be called, use fireValueChange() instead");
    }

    public void dispose() {
        this.valueChangeListeners = null;
        super.dispose();
    }
}

