/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.text;

import java.util.ArrayList;
import java.util.Stack;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.pde.internal.core.text.IDocumentAttribute;
import org.eclipse.pde.internal.core.text.IDocumentNode;
import org.eclipse.pde.internal.core.text.IDocumentTextNode;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class DocumentHandler
extends DefaultHandler {
    protected FindReplaceDocumentAdapter fFindReplaceAdapter;
    protected Stack fDocumentNodeStack = new Stack();
    protected int fHighestOffset = 0;
    private Locator fLocator;

    public void startDocument() throws SAXException {
        this.fDocumentNodeStack.clear();
        this.fHighestOffset = 0;
        this.fFindReplaceAdapter = new FindReplaceDocumentAdapter(this.getDocument());
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        IDocumentNode parent = this.fDocumentNodeStack.isEmpty() ? null : (IDocumentNode)this.fDocumentNodeStack.peek();
        IDocumentNode node = this.getDocumentNode(qName, parent);
        node.setXMLTagName(qName);
        try {
            int nodeOffset = this.getStartOffset(qName);
            node.setOffset(nodeOffset);
            IDocument doc = this.getDocument();
            int line = doc.getLineOfOffset(nodeOffset);
            node.setLineIndent(node.getOffset() - doc.getLineOffset(line));
            int i = 0;
            while (i < attributes.getLength()) {
                String attValue;
                String attName = attributes.getQName(i);
                IDocumentAttribute attribute = this.getDocumentAttribute(attName, attValue = attributes.getValue(i), node);
                if (attribute != null) {
                    IRegion region = this.getAttributeRegion(attName, attValue, nodeOffset);
                    if (region == null) {
                        attValue = CoreUtility.getWritableString(attValue);
                        region = this.getAttributeRegion(attName, attValue, nodeOffset);
                    }
                    if (region != null) {
                        attribute.setNameOffset(region.getOffset());
                        attribute.setNameLength(attName.length());
                        attribute.setValueOffset(region.getOffset() + region.getLength() - 1 - attValue.length());
                        attribute.setValueLength(attValue.length());
                    }
                    node.setXMLAttribute(attribute);
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
        this.appendChildToParent(parent, node);
        this.fDocumentNodeStack.push(node);
    }

    protected void appendChildToParent(IDocumentNode parent, IDocumentNode child) {
        if (parent != null && child != null) {
            parent.addChildNode(child);
        }
    }

    protected abstract IDocumentNode getDocumentNode(String var1, IDocumentNode var2);

    protected abstract IDocumentAttribute getDocumentAttribute(String var1, String var2, IDocumentNode var3);

    private int getStartOffset(String elementName) throws BadLocationException {
        int line = this.fLocator.getLineNumber();
        int col = this.fLocator.getColumnNumber();
        IDocument doc = this.getDocument();
        if (col < 0) {
            col = doc.getLineLength(line);
        }
        String text = doc.get(this.fHighestOffset + 1, doc.getLineOffset(line) - this.fHighestOffset - 1);
        ArrayList<Position> commentPositions = new ArrayList<Position>();
        int idx = 0;
        while (idx < text.length()) {
            int end;
            if ((idx = text.indexOf("<!--", idx)) == -1 || (end = text.indexOf("-->", idx)) == -1) break;
            commentPositions.add(new Position(idx, end - idx));
            idx = end + 1;
        }
        idx = 0;
        while (idx < text.length()) {
            idx = text.indexOf("<" + elementName, idx);
            if (idx == -1) break;
            boolean valid = true;
            int i = 0;
            while (i < commentPositions.size()) {
                Position pos = (Position)commentPositions.get(i);
                if (pos.includes(idx)) {
                    valid = false;
                    break;
                }
                ++i;
            }
            if (valid) break;
            ++idx;
        }
        if (idx > -1) {
            this.fHighestOffset += idx + 1;
        }
        return this.fHighestOffset;
    }

    private int getElementLength(IDocumentNode node, int line, int column) throws BadLocationException {
        int start;
        int endIndex = node.getOffset();
        IDocument doc = this.getDocument();
        String lineText = doc.get(start = Math.max(doc.getLineOffset(line), node.getOffset()), (column = doc.getLineLength(line)) - start + doc.getLineOffset(line));
        int index = lineText.indexOf("</" + node.getXMLTagName() + ">");
        endIndex = index == -1 ? ((index = lineText.indexOf("/>")) == -1 ? column : index + 2) : index + node.getXMLTagName().length() + 3;
        return start + endIndex - node.getOffset();
    }

    private IRegion getAttributeRegion(String name, String value, int offset) throws BadLocationException {
        IRegion nameRegion = this.fFindReplaceAdapter.find(offset, String.valueOf(name) + "\\s*=\\s*\"", true, true, false, true);
        if (nameRegion != null && this.getDocument().get(nameRegion.getOffset() + nameRegion.getLength(), value.length()).equals(value)) {
            return new Region(nameRegion.getOffset(), nameRegion.getLength() + value.length() + 1);
        }
        return null;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        IDocumentNode node = (IDocumentNode)this.fDocumentNodeStack.pop();
        try {
            node.setLength(this.getElementLength(node, this.fLocator.getLineNumber() - 1, this.fLocator.getColumnNumber()));
            this.setTextNodeOffset(node);
        }
        catch (BadLocationException badLocationException) {}
    }

    protected void setTextNodeOffset(IDocumentNode node) throws BadLocationException {
        IDocumentTextNode textNode = node.getTextNode();
        if (textNode != null && textNode.getText() != null) {
            if (textNode.getText().trim().length() == 0) {
                node.removeTextNode();
                return;
            }
            IDocument doc = this.getDocument();
            String text = doc.get(node.getOffset(), node.getLength());
            int relativeStartOffset = text.indexOf(62) + 1;
            int relativeEndOffset = text.lastIndexOf(60) - 1;
            while (Character.isWhitespace(text.charAt(relativeStartOffset))) {
                ++relativeStartOffset;
            }
            while (Character.isWhitespace(text.charAt(relativeEndOffset))) {
                --relativeEndOffset;
            }
            textNode.setOffset(node.getOffset() + relativeStartOffset);
            textNode.setLength(relativeEndOffset - relativeStartOffset + 1);
            textNode.setText(textNode.getText().trim());
        }
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.generateErrorElementHierarchy();
    }

    private void generateErrorElementHierarchy() {
        while (!this.fDocumentNodeStack.isEmpty()) {
            ((IDocumentNode)this.fDocumentNodeStack.pop()).setIsErrorNode(true);
        }
    }

    public void error(SAXParseException e) throws SAXException {
        this.generateErrorElementHierarchy();
    }

    public void setDocumentLocator(Locator locator) {
        this.fLocator = locator;
    }

    protected abstract IDocument getDocument();
}

