/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.pde.internal.core.itarget.IImplicitDependenciesInfo;
import org.eclipse.pde.internal.core.itarget.ITargetModel;
import org.eclipse.pde.internal.core.itarget.ITargetPlugin;
import org.eclipse.pde.internal.core.target.TargetObject;
import org.eclipse.pde.internal.core.target.TargetPlugin;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImplicitDependenciesInfo
extends TargetObject
implements IImplicitDependenciesInfo {
    private static final long serialVersionUID = 1L;
    Map fPlugins = new HashMap();

    public ImplicitDependenciesInfo(ITargetModel model) {
        super(model);
    }

    public ITargetPlugin[] getPlugins() {
        return this.fPlugins.values().toArray(new ITargetPlugin[this.fPlugins.size()]);
    }

    public void addPlugin(ITargetPlugin plugin) {
        this.addPlugins(new ITargetPlugin[]{plugin});
    }

    public void addPlugins(ITargetPlugin[] plugins) {
        ArrayList<ITargetPlugin> addedPlugins = new ArrayList<ITargetPlugin>();
        int i = 0;
        while (i < plugins.length) {
            String id = plugins[i].getId();
            if (!this.fPlugins.containsKey(id)) {
                plugins[i].setModel(this.getModel());
                this.fPlugins.put(id, plugins[i]);
                addedPlugins.add(plugins[i]);
            }
            ++i;
        }
        if (this.isEditable() && addedPlugins.size() > 0) {
            this.firePropertyChanged("implicit-plugins", new ITargetPlugin[0], addedPlugins.toArray(new ITargetPlugin[addedPlugins.size()]));
        }
    }

    public void removePlugin(ITargetPlugin plugin) {
        this.removePlugins(new ITargetPlugin[]{plugin});
    }

    public void removePlugins(ITargetPlugin[] plugins) {
        ArrayList<ITargetPlugin> removedPlugins = new ArrayList<ITargetPlugin>();
        int i = 0;
        while (i < plugins.length) {
            if (this.fPlugins.remove(plugins[i].getId()) != null) {
                removedPlugins.add(plugins[i]);
            }
            ++i;
        }
        if (this.isEditable() && removedPlugins.size() > 0) {
            this.firePropertyChanged("implicit-plugins", removedPlugins.toArray(new ITargetPlugin[removedPlugins.size()]), new ITargetPlugin[0]);
        }
    }

    public void parse(Node node) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeName().equals("plugin")) {
                ITargetPlugin plugin = this.getModel().getFactory().createPlugin();
                plugin.parse(child);
                this.fPlugins.put(plugin.getId(), plugin);
            }
            ++i;
        }
    }

    public void write(String indent, PrintWriter writer) {
        if (this.fPlugins.size() == 0) {
            return;
        }
        writer.println();
        writer.println(String.valueOf(indent) + "<implicitDependencies>");
        for (TargetPlugin plugin : this.fPlugins.values()) {
            plugin.write(String.valueOf(indent) + "   ", writer);
        }
        writer.println(String.valueOf(indent) + "</implicitDependencies>");
    }

    public boolean containsPlugin(String id) {
        return this.fPlugins.containsKey(id);
    }
}

