/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.IModelProviderListener;
import org.eclipse.pde.internal.core.ModelProviderEvent;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginPathFinder;
import org.eclipse.pde.internal.core.feature.ExternalFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;

public class ExternalFeatureModelManager
implements Preferences.IPropertyChangeListener {
    private Vector fListeners = new Vector();
    private IFeatureModel[] fModels;
    private String fPlatformHome;
    private Preferences fPref = PDECore.getDefault().getPluginPreferences();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IFeatureModel createModel(File manifest) {
        FileInputStream stream;
        block10: {
            ExternalFeatureModel externalFeatureModel;
            ExternalFeatureModel model = new ExternalFeatureModel();
            model.setInstallLocation(manifest.getParent());
            stream = null;
            try {
                stream = new FileInputStream(manifest);
                model.load(stream, false);
                externalFeatureModel = model;
                if (stream == null) return externalFeatureModel;
            }
            catch (Exception exception) {
                try {
                    break block10;
                }
                catch (Throwable throwable) {
                    if (stream == null) throw throwable;
                    try {
                        ((InputStream)stream).close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                ((InputStream)stream).close();
                return externalFeatureModel;
            }
            catch (IOException iOException) {}
            return externalFeatureModel;
        }
        if (stream == null) return null;
        try {
            ((InputStream)stream).close();
            return null;
        }
        catch (IOException iOException) {}
        return null;
    }

    private static IFeatureModel[] createModels(URL[] featurePaths, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", featurePaths.length);
        HashMap<String, IFeatureModel> uniqueFeatures = new HashMap<String, IFeatureModel>();
        int i = 0;
        while (i < featurePaths.length) {
            File manifest = new File(featurePaths[i].getFile(), "feature.xml");
            if (!manifest.exists() || !manifest.isFile()) {
                monitor.worked(1);
            } else {
                IFeatureModel model = ExternalFeatureModelManager.createModel(manifest);
                if (model != null && model.isLoaded()) {
                    IFeature feature = model.getFeature();
                    uniqueFeatures.put(String.valueOf(feature.getId()) + "_" + feature.getVersion(), model);
                }
                monitor.worked(1);
            }
            ++i;
        }
        Collection models = uniqueFeatures.values();
        return models.toArray(new IFeatureModel[models.size()]);
    }

    public void addModelProviderListener(IModelProviderListener listener) {
        this.fListeners.add(listener);
    }

    private boolean equalPaths(String path1, String path2) {
        if (path1 == null) {
            return path2 == null;
        }
        if (path2 == null) {
            return false;
        }
        return new File(path1).equals(new File(path2));
    }

    private void fireModelProviderEvent(IModelProviderEvent e) {
        for (IModelProviderListener listener : this.fListeners) {
            listener.modelsChanged(e);
        }
    }

    private String getPathString(Object propertyValue) {
        String path;
        if (propertyValue != null && propertyValue instanceof String && (path = (String)propertyValue).length() > 0) {
            return path;
        }
        return null;
    }

    public static IFeatureModel[] createModels(String platformHome, ArrayList additionalLocations, IProgressMonitor monitor) {
        if (platformHome != null && platformHome.length() > 0) {
            URL[] featureURLs = PluginPathFinder.getFeaturePaths(platformHome);
            if (additionalLocations.size() == 0) {
                return ExternalFeatureModelManager.createModels(featureURLs, monitor);
            }
            File[] dirs = new File[additionalLocations.size()];
            int i = 0;
            while (i < dirs.length) {
                String directory = additionalLocations.get(i).toString();
                File dir = new File(directory, "features");
                if (!dir.exists()) {
                    dir = new File(directory);
                }
                dirs[i] = dir;
                ++i;
            }
            URL[] newUrls = PluginPathFinder.scanLocations(dirs);
            URL[] result = new URL[featureURLs.length + newUrls.length];
            System.arraycopy(featureURLs, 0, result, 0, featureURLs.length);
            System.arraycopy(newUrls, 0, result, featureURLs.length, newUrls.length);
            return ExternalFeatureModelManager.createModels(result, monitor);
        }
        return new IFeatureModel[0];
    }

    public void loadModels(String platformHome, String additionalLocations) {
        IFeatureModel[] oldModels = this.fModels != null ? this.fModels : new IFeatureModel[]{};
        this.fModels = ExternalFeatureModelManager.createModels(platformHome, this.parseAdditionalLocations(additionalLocations), null);
        this.fPlatformHome = platformHome;
        this.notifyListeners(oldModels, this.fModels);
    }

    private ArrayList parseAdditionalLocations(String additionalLocations) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(additionalLocations, ",");
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken().trim());
        }
        return result;
    }

    private void notifyListeners(IFeatureModel[] oldModels, IFeatureModel[] newFeatureModels) {
        if (oldModels.length > 0 || newFeatureModels.length > 0) {
            int type = 0;
            if (oldModels.length > 0) {
                type |= 2;
            }
            if (newFeatureModels.length > 0) {
                type |= 1;
            }
            ModelProviderEvent replacedFeatures = new ModelProviderEvent(this, type, newFeatureModels, oldModels, null);
            this.fireModelProviderEvent(replacedFeatures);
        }
    }

    private synchronized void platformPathChanged(String newHome) {
        if (!this.equalPaths(newHome, this.fPlatformHome)) {
            this.loadModels(newHome, this.fPref.getString("additional_locations"));
        }
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        if (!"platform_path".equals(event.getProperty())) {
            return;
        }
        String newHome = this.getPathString(event.getNewValue());
        this.platformPathChanged(newHome);
    }

    public void removeModelProviderListener(IModelProviderListener listener) {
        this.fListeners.remove(listener);
    }

    public synchronized void shutdown() {
        this.fPref.removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
    }

    public synchronized void startup() {
        this.fPref.addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
        this.loadModels(this.fPref.getString("platform_path"), this.fPref.getString("additional_locations"));
    }

    public synchronized void reload() {
        this.loadModels(this.fPref.getString("platform_path"), this.fPref.getString("additional_locations"));
    }

    public IFeatureModel[] getModels() {
        return this.fModels;
    }
}

