/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ICompareNavigator;
import org.eclipse.compare.internal.INavigatable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.internal.ui.synchronize.actions.OpenInCompareAction;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizePageSite;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;

public class NavigateAction
extends Action {
    private final boolean next;
    private ISynchronizePageSite site;
    private ISynchronizePageConfiguration configuration;
    private final ISynchronizeParticipant participant;

    public NavigateAction(ISynchronizePageSite site, ISynchronizeParticipant participant, ISynchronizePageConfiguration configuration, boolean next) {
        this.site = site;
        this.participant = participant;
        this.configuration = configuration;
        this.next = next;
        IActionBars bars = site.getActionBars();
        if (next) {
            Utils.initAction((IAction)this, "action.navigateNext.");
            if (bars != null) {
                bars.setGlobalActionHandler(ActionFactory.NEXT.getId(), (IAction)this);
            }
        } else {
            Utils.initAction((IAction)this, "action.navigatePrevious.");
            if (bars != null) {
                bars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), (IAction)this);
            }
        }
    }

    public void run() {
        IWorkbenchSite ws = this.site.getWorkbenchSite();
        INavigatable nav = (INavigatable)this.configuration.getProperty("org.eclipse.team.ui.P_NAVIGATOR");
        if (nav != null && ws != null && ws instanceof IViewSite) {
            this.navigateInView(nav);
        } else {
            nav.gotoDifference(this.next);
        }
    }

    private void navigateInView(INavigatable nav) {
        SyncInfo syncInfo;
        Object selectedObject = this.getSelectedObject();
        if (selectedObject == null) {
            if (nav.gotoDifference(this.next)) {
                return;
            }
            selectedObject = this.getSelectedObject();
            if (selectedObject == null) {
                return;
            }
        }
        if ((syncInfo = this.getSyncInfoFromSelection()) != null && syncInfo.getLocal().getType() != 1) {
            if (!nav.gotoDifference(this.next)) {
                selectedObject = this.getSelectedObject();
                OpenInCompareAction.openCompareEditor(this.participant, syncInfo, true, this.site);
            }
            return;
        }
        IWorkbenchSite ws = this.site.getWorkbenchSite();
        if (ws instanceof IWorkbenchPartSite) {
            IEditorPart editor = OpenInCompareAction.findOpenCompareEditor((IWorkbenchPartSite)ws, selectedObject, this.participant);
            if (editor != null) {
                CompareEditorInput input = (CompareEditorInput)editor.getEditorInput();
                ICompareNavigator navigator = (ICompareNavigator)input.getAdapter(ICompareNavigator.class);
                if (navigator != null && navigator.selectChange(this.next) && !nav.gotoDifference(this.next)) {
                    selectedObject = this.getSelectedObject();
                    OpenInCompareAction.openCompareEditor(this.participant, selectedObject, true, this.site);
                }
            } else {
                IEditorInput input = OpenInCompareAction.openCompareEditor(this.participant, selectedObject, true, this.site);
                if (input == null && !nav.gotoDifference(this.next)) {
                    selectedObject = this.getSelectedObject();
                    OpenInCompareAction.openCompareEditor(this.participant, selectedObject, true, this.site);
                }
            }
        }
    }

    private SyncInfo getSyncInfoFromSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.site.getSelectionProvider().getSelection();
        if (selection == null) {
            return null;
        }
        Object obj = selection.getFirstElement();
        if (obj instanceof SyncInfoModelElement) {
            return ((SyncInfoModelElement)obj).getSyncInfo();
        }
        return null;
    }

    private Object getSelectedObject() {
        IStructuredSelection selection = (IStructuredSelection)this.site.getSelectionProvider().getSelection();
        if (selection == null) {
            return null;
        }
        return selection.getFirstElement();
    }
}

