/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.model;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.util.SWTResourceUtil;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.IWorkbenchAdapter2;

public class WorkbenchLabelProvider
extends LabelProvider
implements IColorProvider,
IFontProvider {
    private IPropertyListener editorRegistryListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (propId == 1) {
                WorkbenchLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)WorkbenchLabelProvider.this));
            }
        }
    };

    public static ILabelProvider getDecoratingWorkbenchLabelProvider() {
        return new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
    }

    public WorkbenchLabelProvider() {
        PlatformUI.getWorkbench().getEditorRegistry().addPropertyListener(this.editorRegistryListener);
    }

    protected ImageDescriptor decorateImage(ImageDescriptor input, Object element) {
        return input;
    }

    protected String decorateText(String input, Object element) {
        return input;
    }

    public void dispose() {
        PlatformUI.getWorkbench().getEditorRegistry().removePropertyListener(this.editorRegistryListener);
        super.dispose();
    }

    protected final IWorkbenchAdapter getAdapter(Object o) {
        if (!(o instanceof IAdaptable)) {
            return null;
        }
        return (IWorkbenchAdapter)((IAdaptable)o).getAdapter(IWorkbenchAdapter.class);
    }

    protected final IWorkbenchAdapter2 getAdapter2(Object o) {
        if (!(o instanceof IAdaptable)) {
            return null;
        }
        return (IWorkbenchAdapter2)((IAdaptable)o).getAdapter(IWorkbenchAdapter2.class);
    }

    public final Image getImage(Object element) {
        IWorkbenchAdapter adapter = this.getAdapter(element);
        if (adapter == null) {
            return null;
        }
        ImageDescriptor descriptor = adapter.getImageDescriptor(element);
        if (descriptor == null) {
            return null;
        }
        descriptor = this.decorateImage(descriptor, element);
        Image image = (Image)SWTResourceUtil.getImageTable().get(descriptor);
        if (image == null) {
            image = descriptor.createImage();
            SWTResourceUtil.getImageTable().put(descriptor, image);
        }
        return image;
    }

    public final String getText(Object element) {
        IWorkbenchAdapter adapter = this.getAdapter(element);
        if (adapter == null) {
            return "";
        }
        String label = adapter.getLabel(element);
        return this.decorateText(label, element);
    }

    public Color getForeground(Object element) {
        return this.getColor(element, true);
    }

    public Color getBackground(Object element) {
        return this.getColor(element, false);
    }

    public Font getFont(Object element) {
        IWorkbenchAdapter2 adapter = this.getAdapter2(element);
        if (adapter == null) {
            return null;
        }
        FontData descriptor = adapter.getFont(element);
        if (descriptor == null) {
            return null;
        }
        Font font = (Font)SWTResourceUtil.getFontTable().get(descriptor);
        if (font == null) {
            font = new Font((Device)Display.getCurrent(), descriptor);
            SWTResourceUtil.getFontTable().put(descriptor, font);
        }
        return font;
    }

    private Color getColor(Object element, boolean forground) {
        RGB descriptor;
        IWorkbenchAdapter2 adapter = this.getAdapter2(element);
        if (adapter == null) {
            return null;
        }
        RGB rGB = descriptor = forground ? adapter.getForeground(element) : adapter.getBackground(element);
        if (descriptor == null) {
            return null;
        }
        Color color = (Color)SWTResourceUtil.getColorTable().get(descriptor);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), descriptor);
            SWTResourceUtil.getColorTable().put(descriptor, color);
        }
        return color;
    }
}

