/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.preferences;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.ui.internal.preferences.PropertyMapAdapter;

public final class PreferencesAdapter
extends PropertyMapAdapter {
    private Preferences store;
    private Preferences.IPropertyChangeListener listener = new Preferences.IPropertyChangeListener(){

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            PreferencesAdapter.this.firePropertyChange(event.getProperty());
        }
    };

    public PreferencesAdapter(Preferences toConvert) {
        this.store = toConvert;
    }

    protected void attachListener() {
        this.store.addPropertyChangeListener(this.listener);
    }

    protected void detachListener() {
        this.store.removePropertyChangeListener(this.listener);
    }

    public Set keySet() {
        HashSet<String> result = new HashSet<String>();
        String[] names = this.store.propertyNames();
        int i = 0;
        while (i < names.length) {
            String string = names[i];
            result.add(string);
            ++i;
        }
        return result;
    }

    public Object getValue(String propertyId, Class propertyType) {
        if (propertyType.isAssignableFrom(String.class)) {
            return this.store.getString(propertyId);
        }
        if (propertyType == Boolean.class) {
            return new Boolean(this.store.getBoolean(propertyId));
        }
        if (propertyType == Double.class) {
            return new Double(this.store.getDouble(propertyId));
        }
        if (propertyType == Float.class) {
            return new Float(this.store.getFloat(propertyId));
        }
        if (propertyType == Integer.class) {
            return new Integer(this.store.getInt(propertyId));
        }
        if (propertyType == Long.class) {
            return new Long(this.store.getLong(propertyId));
        }
        return null;
    }

    public boolean propertyExists(String propertyId) {
        return this.store.contains(propertyId);
    }

    public void setValue(String propertyId, Object newValue) {
        if (newValue instanceof String) {
            this.store.setValue(propertyId, (String)newValue);
        } else if (newValue instanceof Integer) {
            this.store.setValue(propertyId, ((Integer)newValue).intValue());
        } else if (newValue instanceof Boolean) {
            this.store.setValue(propertyId, ((Boolean)newValue).booleanValue());
        } else if (newValue instanceof Double) {
            this.store.setValue(propertyId, ((Double)newValue).doubleValue());
        } else if (newValue instanceof Float) {
            this.store.setValue(propertyId, ((Float)newValue).floatValue());
        } else if (newValue instanceof Integer) {
            this.store.setValue(propertyId, ((Integer)newValue).intValue());
        } else if (newValue instanceof Long) {
            this.store.setValue(propertyId, ((Long)newValue).longValue());
        }
    }
}

