/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.context;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.RelaunchActionDelegate;
import org.eclipse.debug.internal.ui.actions.context.AbstractDebugContextAction;
import org.eclipse.debug.internal.ui.actions.context.ActionRequestMonitor;
import org.eclipse.debug.internal.ui.actions.provisional.IAsynchronousTerminateAdapter;
import org.eclipse.debug.internal.ui.actions.provisional.IBooleanRequestMonitor;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.jface.resource.ImageDescriptor;

public class TerminateAndRelaunchAction
extends AbstractDebugContextAction {
    protected void doAction(Object element) {
        IAsynchronousTerminateAdapter adapter;
        ILaunch launch = RelaunchActionDelegate.getLaunch(element);
        if (launch == null || !(element instanceof ITerminate)) {
            return;
        }
        if (element instanceof IAdaptable && (adapter = (IAsynchronousTerminateAdapter)((IAdaptable)element).getAdapter(IAsynchronousTerminateAdapter.class)) != null) {
            adapter.terminate(element, new RequestMonitor(launch));
        }
    }

    protected void isEnabledFor(Object element, IBooleanRequestMonitor monitor) {
        ILaunch launch;
        IAsynchronousTerminateAdapter adapter;
        if (element instanceof IAdaptable && (adapter = (IAsynchronousTerminateAdapter)((IAdaptable)element).getAdapter(IAsynchronousTerminateAdapter.class)) != null && (launch = RelaunchActionDelegate.getLaunch(element)) != null && LaunchConfigurationManager.isVisible(launch.getLaunchConfiguration())) {
            adapter.canTerminate(element, monitor);
            return;
        }
        this.notSupported(monitor);
    }

    public String getActionDefinitionId() {
        return ActionMessages.TerminateAndRelaunchAction_0;
    }

    public String getHelpContextId() {
        return "terminate_and_relaunch_action_context";
    }

    public String getId() {
        return "org.eclipse.debug.ui.debugview.popupMenu.TerminateAndRelaunch";
    }

    public String getText() {
        return ActionMessages.TerminateAndRelaunchAction_3;
    }

    public String getToolTipText() {
        return ActionMessages.TerminateAndRelaunchAction_4;
    }

    public ImageDescriptor getDisabledImageDescriptor() {
        return DebugPluginImages.getImageDescriptor("IMG_DLCL_TERMINATE_AND_RELAUNCH");
    }

    public ImageDescriptor getHoverImageDescriptor() {
        return DebugPluginImages.getImageDescriptor("IMG_ELCL_TERMINATE_AND_RELAUNCH");
    }

    public ImageDescriptor getImageDescriptor() {
        return DebugPluginImages.getImageDescriptor("IMG_ELCL_TERMINATE_AND_RELAUNCH");
    }

    class RequestMonitor
    extends ActionRequestMonitor {
        private ILaunch fLaunch;

        public RequestMonitor(ILaunch launch) {
            this.fLaunch = launch;
        }

        public void done() {
            super.done();
            DebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

                public void run() {
                    RelaunchActionDelegate.relaunch(RequestMonitor.this.fLaunch.getLaunchConfiguration(), RequestMonitor.this.fLaunch.getLaunchMode());
                }
            });
        }
    }
}

