/*******************************************************************************
 * Copyright (c) 2001, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.common.ui.properties.internal.provisional;

/**
 * An extension to a section that overrides the tabs that are provided by the
 * tabbed property registry with a new list of tabs.
 * 
 * @author Anthony Hunter
 * @deprecated Use org.eclipse.ui.views.properties.tabbed
 */
public interface IDynamicTabListSection
	extends ISection {

	/**
	 * Get the list of tabs that this section provides.
	 * 
	 * @return the list of tabs.
	 */
	public IDynamicTabItem[] getTabs();

	/**
	 * Select the tab at the provided index.
	 * 
	 * @param index
	 *            the index in the list of tabs to select.
	 */
	public void selectTab(int index);
}
