/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.connection.internal.ui.util;

import com.ibm.icu.util.StringTokenizer;
import org.eclipse.wst.rdb.connection.internal.ui.util.resource.ResourceLoader;

public class StringUtility {
    private static final String ALPHABET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String ALPHANUMERIC = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final String NUMERIC = "0123456789";

    public static String change(String in, String oldPat, String newPat) {
        if (oldPat.length() == 0) {
            return in;
        }
        if (oldPat.length() == 1 && newPat.length() == 1) {
            return in.replace(oldPat.charAt(0), newPat.charAt(0));
        }
        int lastIndex = 0;
        int newIndex = 0;
        StringBuffer newString = new StringBuffer();
        while ((newIndex = in.indexOf(oldPat, lastIndex)) != -1) {
            newString.append(String.valueOf(in.substring(lastIndex, newIndex)) + newPat);
            lastIndex = newIndex + oldPat.length();
        }
        newString.append(in.substring(lastIndex));
        return newString.toString();
    }

    public static String change(String in, String oldPat, String newPat, int startPos, int numChanges) {
        StringBuffer newString;
        block5: {
            if (oldPat.length() == 0) {
                return in;
            }
            if (oldPat.length() == 1 && newPat.length() == 1) {
                return in.replace(oldPat.charAt(0), newPat.charAt(0));
            }
            int inLen = in.length();
            if (startPos >= inLen) {
                return in;
            }
            int lastIndex = startPos;
            int newIndex = 0;
            int countChanges = 0;
            newString = new StringBuffer();
            do {
                if ((newIndex = in.indexOf(oldPat, lastIndex)) == -1) {
                    newString.append(in.substring(lastIndex));
                    break block5;
                }
                newString.append(String.valueOf(in.substring(lastIndex, newIndex)) + newPat);
                lastIndex = newIndex + oldPat.length();
            } while (++countChanges != numChanges);
            newString.append(in.substring(lastIndex));
        }
        return newString.toString();
    }

    public static String word(String in, int i) {
        StringTokenizer st = new StringTokenizer(in);
        if (i <= 0 || i > st.countTokens()) {
            return "";
        }
        String ret = new String();
        while (st.hasMoreTokens()) {
            ret = st.nextToken();
            if (--i != 0) continue;
            return ret;
        }
        return "";
    }

    /*
     * Unable to fully structure code
     */
    public static String words(String in, int i) {
        st = new StringTokenizer(in);
        if (i > 0 && i <= st.countTokens()) ** GOTO lbl7
        return "";
        while (--i != 0) {
            st.nextToken();
lbl7:
            // 2 sources

            if (st.hasMoreTokens()) continue;
        }
        if (st.hasMoreTokens()) {
            return st.nextToken("");
        }
        return "";
    }

    public static int numWords(String in) {
        StringTokenizer st = new StringTokenizer(in);
        return st.countTokens();
    }

    public static int indexOfAnyBut(String srcString, String validString) {
        int result = -1;
        int srcLen = srcString.length();
        int i = 0;
        while (i < srcLen) {
            if (validString.indexOf(srcString.charAt(i)) == -1) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    public static int lastIndexOfAnyBut(String srcString, String validString) {
        int result = -1;
        int srcLen = srcString.length();
        int i = srcLen - 1;
        while (i >= 0) {
            if (validString.indexOf(srcString.charAt(i)) == -1) {
                result = i;
                break;
            }
            --i;
        }
        return result;
    }

    public static int occurrenceOf(String srcString, char searchChar) {
        int result = 0;
        if (srcString.length() > 0) {
            int i = 0;
            while (i < srcString.length()) {
                if (searchChar == srcString.charAt(i)) {
                    ++result;
                }
                ++i;
            }
        }
        return result;
    }

    public static String stripLeading(String srcString, String pString) {
        String result = srcString.startsWith(pString) ? srcString.substring(pString.length(), srcString.length()) : srcString;
        return result;
    }

    public static String stripTrailing(String srcString, String pString) {
        String result = srcString.endsWith(pString) ? srcString.substring(0, srcString.lastIndexOf(pString)) : srcString;
        return result;
    }

    public static String stripTrailingBlanks(String src) {
        if (src != null) {
            while (src.length() > 0) {
                if (!src.endsWith(" ")) break;
                src = src.substring(0, src.length() - 1);
            }
        }
        return src;
    }

    public static String copy(String srcString, int numberOfCopies) {
        StringBuffer result = new StringBuffer();
        if (numberOfCopies > 0) {
            int i = 1;
            while (i <= numberOfCopies) {
                result.append(srcString);
                ++i;
            }
        } else {
            result = new StringBuffer(srcString);
        }
        return result.toString();
    }

    public static boolean isAlphabetic(String srcString) {
        return StringUtility.lastIndexOfAnyBut(srcString, ALPHABET) == -1;
    }

    public static boolean isAlphanumeric(String srcString) {
        return StringUtility.lastIndexOfAnyBut(srcString, ALPHANUMERIC) == -1;
    }

    public static boolean isDigits(String srcString) {
        return StringUtility.lastIndexOfAnyBut(srcString, NUMERIC) == -1;
    }

    public static boolean isEmptyOrNull(String string) {
        return string == null || string.length() == 0;
    }

    public static String match(String in, String token) throws Exception {
        if (in == null) {
            return null;
        }
        if ((in = in.trim()).startsWith(token)) {
            return in.substring(token.length(), in.length());
        }
        throw new Exception(String.valueOf(ResourceLoader.INSTANCE.queryString("STRING_MATCH_EXPECTED_EXCEPTION_MESSAGE")) + token + ResourceLoader.INSTANCE.queryString("STRING_MATCH_RETURNED_EXCEPTION_MESSAGE") + StringUtility.word(in, 1));
    }

    public static long getLong(String str) {
        try {
            return Long.parseLong(str);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static boolean containsDoubleBlanks(String srcString) {
        String bb = "  ";
        char b = bb.charAt(0);
        if (srcString.length() > 0) {
            int i = 0;
            while (i < srcString.length() - 1) {
                if (b == srcString.charAt(i) & b == srcString.charAt(i + 1)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static String stripNewLines(String label) {
        block2: {
            newLabel = "";
            newLine = System.getProperties().getProperty("line.separator");
            i = label.indexOf(newLine);
            if (i != -1) ** GOTO lbl10
            newLabel = label;
            break block2;
lbl-1000:
            // 1 sources

            {
                newLabel = String.valueOf(newLabel) + label.substring(0, i);
                label = label.substring(i + 2);
                i = label.indexOf(newLine);
lbl10:
                // 2 sources

                ** while (i != -1)
            }
lbl11:
            // 1 sources

            if (label.length() > 0) {
                newLabel = String.valueOf(newLabel) + label;
            }
        }
        return newLabel;
    }

    public static String toUnicode(String value) {
        if (value == null) {
            return value;
        }
        String result = "";
        int i = 0;
        while (i < value.length()) {
            char character = value.charAt(i);
            result = character == '>' ? String.valueOf(result) + "&gt;" : (character == '<' ? String.valueOf(result) + "&lt;" : String.valueOf(result) + character);
            ++i;
        }
        return result;
    }
}

