/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.extensions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.wst.wsdl.ui.internal.actions.IWSDLToolbarAction;
import org.eclipse.wst.wsdl.ui.internal.extensions.WSDLEditorExtensionProperties;

public class WSDLEditorConfiguration {
    public static final String WSDLEDITORCONFIGURATIONEXTENSIONID = "org.eclipse.wst.wsdl.ui.WSDLEditorExtensionConfiguration";
    public static final String CLASSNAME = "class";
    public static final String ADAPTERFACTORY = "adapterFactory";
    public static final String TOOLBARACTION = "toolbarAction";
    public static final String FIGUREFACTORY = "figureFactory";
    public static final String EDITPARTFACTORY = "editPartFactory";
    List definedExtensionsList = null;

    public AdapterFactory getAdapterFactory() {
        if (this.definedExtensionsList == null) {
            this.readWSDLConfigurationRegistry();
        }
        if (!this.definedExtensionsList.isEmpty()) {
            return ((WSDLEditorExtensionProperties)this.definedExtensionsList.get(0)).getAdapterFactory();
        }
        return null;
    }

    public EditPartFactory getEditPartFactory() {
        if (this.definedExtensionsList == null) {
            this.readWSDLConfigurationRegistry();
        }
        if (!this.definedExtensionsList.isEmpty()) {
            return ((WSDLEditorExtensionProperties)this.definedExtensionsList.get(0)).getEditPartFactory();
        }
        return null;
    }

    public List getToolbarActions() {
        if (this.definedExtensionsList == null) {
            this.readWSDLConfigurationRegistry();
        }
        if (!this.definedExtensionsList.isEmpty()) {
            return ((WSDLEditorExtensionProperties)this.definedExtensionsList.get(0)).getActionList();
        }
        return Collections.EMPTY_LIST;
    }

    protected Object loadClass(IConfigurationElement element, String classString) {
        String pluginId = element.getDeclaringExtension().getContributor().getName();
        try {
            Class theClass = Platform.getBundle((String)pluginId).loadClass(classString);
            Object instance = theClass.newInstance();
            return instance;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void readWSDLConfigurationRegistry() {
        IConfigurationElement[] wsdlEditorExtensionList = Platform.getExtensionRegistry().getConfigurationElementsFor(WSDLEDITORCONFIGURATIONEXTENSIONID);
        boolean definedExtensionsExist = wsdlEditorExtensionList != null && wsdlEditorExtensionList.length > 0;
        this.definedExtensionsList = new ArrayList();
        if (definedExtensionsExist) {
            int i = 0;
            while (i < wsdlEditorExtensionList.length) {
                String editPartFactoryClass;
                Object object;
                WSDLEditorExtensionProperties properties = new WSDLEditorExtensionProperties();
                this.definedExtensionsList.add(properties);
                IConfigurationElement element = wsdlEditorExtensionList[i];
                String adapterFactoryClass = element.getAttribute(ADAPTERFACTORY);
                if (adapterFactoryClass != null && (object = this.loadClass(element, adapterFactoryClass)) instanceof AdapterFactory) {
                    properties.setAdapterFactory((AdapterFactory)object);
                }
                if ((editPartFactoryClass = element.getAttribute(EDITPARTFACTORY)) != null) {
                    Object object2 = this.loadClass(element, editPartFactoryClass);
                    EditPartFactory editPartFactory = null;
                    if (object2 instanceof EditPartFactory) {
                        editPartFactory = (EditPartFactory)object2;
                        properties.setEditPartFactoryList(editPartFactory);
                    }
                }
                IConfigurationElement[] toolbarActions = element.getChildren(TOOLBARACTION);
                ArrayList<IWSDLToolbarAction> actionList = new ArrayList<IWSDLToolbarAction>();
                if (toolbarActions != null) {
                    int j = 0;
                    while (j < toolbarActions.length) {
                        Object object3;
                        IConfigurationElement actionElement = toolbarActions[j];
                        String actionClass = actionElement.getAttribute(CLASSNAME);
                        IWSDLToolbarAction action = null;
                        if (actionClass != null && (object3 = this.loadClass(actionElement, actionClass)) instanceof IWSDLToolbarAction) {
                            action = (IWSDLToolbarAction)object3;
                            actionList.add(action);
                        }
                        ++j;
                    }
                }
                properties.setActionList(actionList);
                ++i;
            }
        }
    }
}

