/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.sqleditor.internal;

import java.io.File;
import java.io.FileWriter;
import java.io.StringReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.sqleditor.internal.ISQLEditorInput;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditorInputFactory;

public class SQLEditorFileEditorInput
extends FileEditorInput
implements ISQLEditorInput {
    private ConnectionInfo fConnInfo;
    private Database fDatabase;
    private String fDefaultSchemaName;

    public static IFile createTempFileResource(String initialFileContent) {
        String fileNamePrefix = "SQLStatement";
        String fileExtension = ".sql";
        return SQLEditorFileEditorInput.createTempFileResource(initialFileContent, fileNamePrefix, fileExtension);
    }

    public static IFile createTempFileResource(String initialFileContent, String fileNamePrefix, String fileExtension) {
        IFile fileResource = null;
        if (initialFileContent == null) {
            initialFileContent = "";
        }
        if (fileNamePrefix == null) {
            fileNamePrefix = "";
        }
        if (fileExtension == null) {
            fileExtension = ".sql";
        } else if (!fileExtension.startsWith(".")) {
            fileExtension = "." + fileExtension;
        }
        try {
            int c;
            File tempFile = File.createTempFile(fileNamePrefix, fileExtension);
            StringReader reader = new StringReader(initialFileContent);
            FileWriter writer = new FileWriter(tempFile);
            while ((c = reader.read()) != -1) {
                writer.write(c);
            }
            reader.close();
            writer.close();
            String pathStr = tempFile.getAbsolutePath();
            Path path = new Path(pathStr);
            fileResource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        catch (Exception exception) {}
        return fileResource;
    }

    public SQLEditorFileEditorInput(IFile aFile) {
        super(aFile);
    }

    public ConnectionInfo getConnectionInfo() {
        return this.fConnInfo;
    }

    public Database getDatabase() {
        return this.fDatabase;
    }

    public String getDefaultSchemaName() {
        return this.fDefaultSchemaName;
    }

    public String getFactoryId() {
        return "org.eclipse.wst.rdb.sqleditor.SQLEditorInputFactory";
    }

    public void saveState(IMemento memento) {
        SQLEditorInputFactory.saveState(memento, this);
    }

    public void setConnectionInfo(ConnectionInfo connInfo) {
        this.fConnInfo = connInfo;
    }

    public void setDatabase(Database database) {
        this.fDatabase = database;
    }

    public void setDefaultSchemaName(String schemaName) {
        this.fDefaultSchemaName = schemaName;
    }
}

