/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.preferences;

import java.io.File;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.svnclientadapter.SVNClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapterFactory;

public class SVNPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button javahlRadio;
    private Button svnKitRadio;
    private Button showCompareRevisionInDialog;
    private Button fetchChangePathOnDemand;
    private Button showTagsInRemoteHistory;
    private Button showOutOfDateFolders;
    private Button showUnadded;
    private Button selectUnadded;
    private Button removeOnReplace;
    private Text logEntriesToFetchText;
    private Button defaultConfigLocationRadio;
    private Button useDirectoryLocationRadio;
    private Text directoryLocationText;
    private Button browseConfigDirButton;
    private boolean javahlErrorShown = false;
    private Button quickDiffAnnotateYes;
    private Button quickDiffAnnotateNo;
    private Button quickDiffAnnotatePrompt;

    public SVNPreferencesPage() {
        this.setDescription(Policy.bind("SVNPreferencePage.description"));
        SVNProviderPlugin.getPlugin().getSVNClientManager().loadAdapters();
    }

    private Label createLabel(Composite parent, String text, int horizontalSpan) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = horizontalSpan;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    private Button createCheckBox(Composite group, String label) {
        Button button = new Button(group, 16416);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        button.setLayoutData((Object)data);
        return button;
    }

    private Button createRadio(Composite group, String label, int horizontalSpan) {
        Button button = new Button(group, 16);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalSpan = horizontalSpan;
        button.setLayoutData((Object)data);
        return button;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.showCompareRevisionInDialog = this.createCheckBox(composite, Policy.bind("SVNPreferencePage.showCompareMergeInSync"));
        this.showUnadded = this.createCheckBox(composite, Policy.bind("SVNPreferencePage.showUnadded"));
        this.selectUnadded = this.createCheckBox(composite, Policy.bind("SVNPreferencePage.selectUnadded"));
        this.removeOnReplace = this.createCheckBox(composite, Policy.bind("SVNPreferencePage.removeOnReplace"));
        this.fetchChangePathOnDemand = this.createCheckBox(composite, Policy.bind("SVNPreferencePage.fetchChangePathOnDemand"));
        this.showTagsInRemoteHistory = this.createCheckBox(composite, Policy.bind("SVNPreferencePage.showTags"));
        this.showOutOfDateFolders = this.createCheckBox(composite, Policy.bind("SVNPreferencePage.showOutOfDateFolders"));
        this.createLabel(composite, "", 2);
        this.createLabel(composite, Policy.bind("SVNPreferencePage.logEntriesToFetch"), 1);
        this.logEntriesToFetchText = new Text(composite, 2048);
        gridData = new GridData();
        gridData.widthHint = 40;
        this.logEntriesToFetchText.setLayoutData((Object)gridData);
        this.createLabel(composite, "", 2);
        Group group = new Group(composite, 0);
        group.setText(Policy.bind("SVNPreferencePage.useQuickdiffAnnotateGroup"));
        group.setLayout((Layout)new GridLayout(3, true));
        group.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.quickDiffAnnotateYes = this.createRadio((Composite)group, Policy.bind("yes"), 1);
        this.quickDiffAnnotateNo = this.createRadio((Composite)group, Policy.bind("no"), 1);
        this.quickDiffAnnotatePrompt = this.createRadio((Composite)group, Policy.bind("prompt"), 1);
        this.createLabel(composite, "", 2);
        group = new Group(composite, 0);
        group.setText(Policy.bind("SVNPreferencePage.svnClientInterface"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        layout = new GridLayout();
        group.setLayout((Layout)layout);
        this.javahlRadio = this.createRadio((Composite)group, Policy.bind("SVNPreferencePage.svnjavahl"), 1);
        this.svnKitRadio = this.createRadio((Composite)group, Policy.bind("SVNPreferencePage.javasvn"), 1);
        Listener checkInterfaceListener = new Listener(){

            public void handleEvent(Event event) {
                SVNPreferencesPage.this.verifyValidation();
            }
        };
        this.javahlRadio.addListener(13, checkInterfaceListener);
        this.svnKitRadio.addListener(13, checkInterfaceListener);
        this.createLabel(composite, "", 2);
        group = new Group(composite, 0);
        group.setText(Policy.bind("SVNPreferencePage.configurationLocation"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        this.defaultConfigLocationRadio = this.createRadio((Composite)group, Policy.bind("SVNPreferencePage.useDefaultConfigLocation"), 3);
        this.useDirectoryLocationRadio = this.createRadio((Composite)group, Policy.bind("SVNPreferencePage.useDirectoryConfig"), 1);
        this.directoryLocationText = new Text((Composite)group, 2052);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 200;
        gridData.grabExcessHorizontalSpace = true;
        this.directoryLocationText.setLayoutData((Object)gridData);
        this.directoryLocationText.setEditable(false);
        this.browseConfigDirButton = new Button((Composite)group, 0);
        this.browseConfigDirButton.setText(Policy.bind("SVNPreferencePage.browseDirectory"));
        Listener configUpdateEnablements = new Listener(){

            public void handleEvent(Event event) {
                SVNPreferencesPage.this.browseConfigDirButton.setEnabled(SVNPreferencesPage.this.useDirectoryLocationRadio.getSelection());
                SVNPreferencesPage.this.verifyValidation();
            }
        };
        this.defaultConfigLocationRadio.addListener(13, configUpdateEnablements);
        this.useDirectoryLocationRadio.addListener(13, configUpdateEnablements);
        this.browseConfigDirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog directoryDialog = new DirectoryDialog(SVNPreferencesPage.this.getShell(), 4096);
                String res = directoryDialog.open();
                if (res != null) {
                    SVNPreferencesPage.this.directoryLocationText.setText(res);
                }
                SVNPreferencesPage.this.verifyValidation();
            }
        });
        this.initializeValues();
        this.verifyValidation();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.tigris.subversion.subclipse.ui.svn_preference_page_context");
        return composite;
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.showCompareRevisionInDialog.setSelection(store.getBoolean("pref_show_compare_revision_in_dialog"));
        this.fetchChangePathOnDemand.setSelection(store.getBoolean("pref_fetch_change_path_on_Demand"));
        this.showTagsInRemoteHistory.setSelection(store.getBoolean("pref_show_tags_in_remote"));
        this.showOutOfDateFolders.setSelection(SVNProviderPlugin.getPlugin().getPluginPreferences().getBoolean("show_out_of_date_folders"));
        this.showUnadded.setSelection(store.getBoolean("pref_show_unadded_resources_on_commit"));
        this.selectUnadded.setSelection(store.getBoolean("pref_select_unadded_resources_on_commit"));
        if (!this.showUnadded.getSelection()) {
            this.selectUnadded.setVisible(false);
        }
        this.showUnadded.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                SVNPreferencesPage.this.selectUnadded.setVisible(SVNPreferencesPage.this.showUnadded.getSelection());
            }
        });
        this.removeOnReplace.setSelection(store.getBoolean("pref_remove_unadded_resources_on_replace"));
        this.logEntriesToFetchText.setText(Integer.toString(store.getInt("pref_log_entries_to_fetch")));
        this.quickDiffAnnotateYes.setSelection("always".equals(store.getString("pref_use_quickdiffannotate")));
        this.quickDiffAnnotateNo.setSelection("never".equals(store.getString("pref_use_quickdiffannotate")));
        this.quickDiffAnnotatePrompt.setSelection("prompt".equals(store.getString("pref_use_quickdiffannotate")));
        String clientInterface = store.getString("pref_svninterface");
        if ("commandline".equals(clientInterface)) {
            clientInterface = "svnkit";
        }
        if ("javasvn".equals(clientInterface)) {
            clientInterface = "svnkit";
        }
        this.javahlRadio.setSelection(clientInterface.equals("javahl"));
        this.svnKitRadio.setSelection(clientInterface.equals("svnkit"));
        String configLocation = store.getString("pref_svnconfigdir");
        this.directoryLocationText.setText(configLocation);
        if (configLocation.equals("")) {
            this.defaultConfigLocationRadio.setSelection(true);
            this.useDirectoryLocationRadio.setSelection(false);
            this.browseConfigDirButton.setEnabled(false);
        } else {
            this.defaultConfigLocationRadio.setSelection(false);
            this.useDirectoryLocationRadio.setSelection(true);
            this.browseConfigDirButton.setEnabled(true);
        }
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("pref_show_compare_revision_in_dialog", this.showCompareRevisionInDialog.getSelection());
        store.setValue("pref_fetch_change_path_on_Demand", this.fetchChangePathOnDemand.getSelection());
        store.setValue("pref_show_tags_in_remote", this.showTagsInRemoteHistory.getSelection());
        if (SVNProviderPlugin.getPlugin().getPluginPreferences().getBoolean("show_out_of_date_folders") != this.showOutOfDateFolders.getSelection()) {
            SVNProviderPlugin.getPlugin().getPluginPreferences().setValue("show_out_of_date_folders", this.showOutOfDateFolders.getSelection());
            SVNUIPlugin.getPlugin().getShowOutOfDateFoldersAction().setChecked(this.showOutOfDateFolders.getSelection());
        }
        store.setValue("pref_show_unadded_resources_on_commit", this.showUnadded.getSelection());
        store.setValue("pref_select_unadded_resources_on_commit", this.selectUnadded.getSelection());
        store.setValue("pref_remove_unadded_resources_on_replace", this.removeOnReplace.getSelection());
        if (this.quickDiffAnnotateYes.getSelection()) {
            store.setValue("pref_use_quickdiffannotate", "always");
        } else if (this.quickDiffAnnotateNo.getSelection()) {
            store.setValue("pref_use_quickdiffannotate", "never");
        } else if (this.quickDiffAnnotatePrompt.getSelection()) {
            store.setValue("pref_use_quickdiffannotate", "prompt");
        }
        int entriesToFetch = store.getInt("pref_log_entries_to_fetch");
        try {
            entriesToFetch = Integer.parseInt(this.logEntriesToFetchText.getText().trim());
        }
        catch (Exception exception) {}
        store.setValue("pref_log_entries_to_fetch", entriesToFetch);
        if (this.javahlRadio.getSelection()) {
            store.setValue("pref_svninterface", "javahl");
        } else {
            store.setValue("pref_svninterface", "svnkit");
        }
        if (this.defaultConfigLocationRadio.getSelection()) {
            store.setValue("pref_svnconfigdir", "");
        } else {
            store.setValue("pref_svnconfigdir", this.directoryLocationText.getText());
        }
        SVNUIPlugin.getPlugin().savePluginPreferences();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeValues();
        this.verifyValidation();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return SVNUIPlugin.getPlugin().getPreferenceStore();
    }

    private void verifyValidation() {
        this.setErrorMessage(null);
        if (this.useDirectoryLocationRadio.getSelection()) {
            File configDir = new File(this.directoryLocationText.getText());
            if (!configDir.exists()) {
                this.setErrorMessage(Policy.bind("SVNPreferencePage.svnConfigDirDoesNotExist"));
            } else {
                File serversFile = new File(configDir, "servers");
                File configFile = new File(configDir, "config");
                if (!serversFile.exists() && !configFile.exists()) {
                    this.setErrorMessage(Policy.bind("SVNPreferencePage.isNotSvnConfigDir"));
                }
            }
        }
        if (this.javahlRadio.getSelection() && !SVNClientAdapterFactory.isSVNClientAvailable((String)"javahl")) {
            this.setErrorMessage(Policy.bind("SVNPreferencePage.javahlNotAvailable"));
            if (!this.javahlErrorShown) {
                this.javahlErrorShown = true;
                MessageDialog.openError((Shell)this.getShell(), (String)"Error Loading JavaHL Library", (String)JhlClientAdapterFactory.getLibraryLoadErrors());
            }
        }
        if (this.svnKitRadio.getSelection() && !SVNClientAdapterFactory.isSVNClientAvailable((String)"svnkit")) {
            this.setErrorMessage(Policy.bind("SVNPreferencePage.javaSvnNotAvailable"));
        }
        this.setValid(this.getErrorMessage() == null);
    }
}

