/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.comments.CommitCommentArea;
import org.tigris.subversion.subclipse.ui.dialogs.AdaptableResourceList;
import org.tigris.subversion.subclipse.ui.dialogs.ResourceLabelProvider;
import org.tigris.subversion.subclipse.ui.settings.CommentProperties;
import org.tigris.subversion.subclipse.ui.util.TableSetter;

public class LockDialog
extends TrayDialog {
    private static final int WIDTH_HINT = 500;
    private static final int SELECTION_HEIGHT_HINT = 100;
    private CommitCommentArea commitCommentArea;
    private Button stealButton;
    private String comment;
    private boolean stealLock;
    private IResource[] files;
    private Button okButton;
    private CommentProperties commentProperties;
    private TableViewer listViewer;
    private IDialogSettings settings;
    private TableSetter setter;
    protected static final int LABEL_WIDTH_HINT = 400;

    public LockDialog(Shell parentShell, IResource[] files) {
        super(parentShell);
        this.files = files;
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x10);
        if (files.length > 0) {
            try {
                this.commentProperties = CommentProperties.getCommentProperties(files[0]);
                this.commentProperties.setMinimumLogMessageSize(this.commentProperties.getMinimumLockMessageSize());
            }
            catch (SVNException sVNException) {}
            if (this.commentProperties != null) {
                this.commentProperties.setLogTemplate(null);
            }
        }
        this.commitCommentArea = new CommitCommentArea((Dialog)this, null, Policy.bind("LockDialog.enterComment"), this.commentProperties);
        if (this.commentProperties != null && this.commentProperties.getMinimumLockMessageSize() != 0) {
            ModifyListener modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    LockDialog.this.okButton.setEnabled(LockDialog.this.commitCommentArea.getComment().trim().length() >= LockDialog.this.commentProperties.getMinimumLockMessageSize());
                }
            };
            this.commitCommentArea.setModifyListener(modifyListener);
        }
        this.commitCommentArea.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty() == "OkRequested") {
                    LockDialog.this.okPressed();
                }
            }
        });
        this.settings = SVNUIPlugin.getPlugin().getDialogSettings();
        this.setter = new TableSetter();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Policy.bind("LockDialog.title"));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        SashForm sashForm = new SashForm(composite, 512);
        sashForm.setLayout((Layout)new GridLayout());
        sashForm.setLayoutData((Object)new GridData(1808));
        Composite cTop = new Composite((Composite)sashForm, 0);
        cTop.setLayout((Layout)new GridLayout());
        cTop.setLayoutData((Object)new GridData(1808));
        Composite cBottom1 = new Composite((Composite)sashForm, 0);
        cBottom1.setLayout((Layout)new GridLayout());
        cBottom1.setLayoutData((Object)new GridData(1808));
        Composite cBottom2 = new Composite(cBottom1, 0);
        cBottom2.setLayout((Layout)new GridLayout());
        cBottom2.setLayoutData((Object)new GridData(1808));
        this.commitCommentArea.createArea(cTop);
        this.addResourcesArea(cBottom2);
        this.stealButton = new Button(cBottom2, 32);
        this.stealButton.setText(Policy.bind("LockDialog.stealLock"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.lock_dialog_context");
        return composite;
    }

    private void addResourcesArea(Composite composite) {
        Label label = this.createWrappingLabel(composite);
        label.setText(Policy.bind("LockDialog.resources"));
        Table table = new Table(composite, 68354);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        this.listViewer = new TableViewer(table);
        GridData data = new GridData(1808);
        data.heightHint = 100;
        data.widthHint = 500;
        this.listViewer.getTable().setLayoutData((Object)data);
        this.createColumns(table, layout);
        this.listViewer.setLabelProvider((IBaseLabelProvider)new ResourceLabelProvider());
        this.listViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return LockDialog.this.files;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.listViewer.setInput((Object)new AdaptableResourceList(this.files));
    }

    private void createColumns(Table table, TableLayout layout) {
        int[] widths = this.setter.getColumnWidths("LockDialog", 1);
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(Policy.bind("PendingOperationsView.resource"));
        if (widths[0] == 0 || widths[0] == 150) {
            widths[0] = 500;
        }
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(widths[0], true));
    }

    protected void okPressed() {
        this.saveLocation();
        this.stealLock = this.stealButton.getSelection();
        this.comment = this.commitCommentArea.getComment();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.saveLocation();
        super.cancelPressed();
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.okButton = button;
            if (this.commentProperties != null && this.commentProperties.getMinimumLockMessageSize() != 0) {
                this.okButton.setEnabled(false);
            }
        }
        return button;
    }

    protected Label createWrappingLabel(Composite parent) {
        Label label = new Label(parent, 16448);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.horizontalIndent = 0;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 400;
        label.setLayoutData((Object)data);
        return label;
    }

    private void saveLocation() {
        int x = this.getShell().getLocation().x;
        int y = this.getShell().getLocation().y;
        this.settings.put("LockDialog.location.x", x);
        this.settings.put("LockDialog.location.y", y);
        x = this.getShell().getSize().x;
        y = this.getShell().getSize().y;
        this.settings.put("LockDialog.size.x", x);
        this.settings.put("LockDialog.size.y", y);
        TableSetter setter = new TableSetter();
        setter.saveColumnWidths(this.listViewer.getTable(), "LockDialog");
    }

    protected Point getInitialLocation(Point initialSize) {
        try {
            int x = this.settings.getInt("LockDialog.location.x");
            int y = this.settings.getInt("LockDialog.location.y");
            return new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            return super.getInitialLocation(initialSize);
        }
    }

    protected Point getInitialSize() {
        try {
            int x = this.settings.getInt("LockDialog.size.x");
            int y = this.settings.getInt("LockDialog.size.y");
            return new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            return super.getInitialSize();
        }
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isStealLock() {
        return this.stealLock;
    }
}

