/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Display;
import org.tigris.subversion.subclipse.core.resources.ISVNFileModificationValidatorPrompt;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.dialogs.LockDialog;

public class SVNFileModificationValidatorPrompt
implements ISVNFileModificationValidatorPrompt {
    private String comment;
    private boolean stealLock;
    private boolean success;
    private IFile[] files;

    public boolean prompt(IFile[] lockFiles, Object context) {
        if (context == null) {
            this.comment = "";
            this.stealLock = false;
            return true;
        }
        this.files = lockFiles;
        this.success = false;
        SVNUIPlugin.getStandardDisplay().syncExec(new Runnable(){

            public void run() {
                LockDialog lockDialog = new LockDialog(Display.getCurrent().getActiveShell(), (IResource[])SVNFileModificationValidatorPrompt.this.files);
                if (lockDialog.open() != 1) {
                    SVNFileModificationValidatorPrompt.this.success = true;
                    SVNFileModificationValidatorPrompt.this.comment = lockDialog.getComment();
                    SVNFileModificationValidatorPrompt.this.stealLock = lockDialog.isStealLock();
                }
            }
        });
        return this.success;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isStealLock() {
        return this.stealLock;
    }
}

