/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.builder;

import java.io.InputStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.jruby.ast.Node;
import org.jruby.lexer.yacc.SyntaxException;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.core.builder.IMarkerManager;
import org.rubypeople.rdt.internal.core.builder.IndexUpdater;
import org.rubypeople.rdt.internal.core.builder.IoUtils;
import org.rubypeople.rdt.internal.core.builder.SingleFileCompiler;
import org.rubypeople.rdt.internal.core.parser.ImmediateWarnings;
import org.rubypeople.rdt.internal.core.parser.RubyParser;

public final class RubyCodeAnalyzer
implements SingleFileCompiler {
    private final IMarkerManager markerManager;
    private RubyParser parser;
    private final IndexUpdater indexUpdater;

    public RubyCodeAnalyzer(IMarkerManager iMarkerManager) {
        this(iMarkerManager, new RubyParser(new ImmediateWarnings(iMarkerManager)), new IndexUpdater(RubyCore.getPlugin().getSymbolIndex()));
    }

    public RubyCodeAnalyzer(IMarkerManager iMarkerManager, RubyParser rubyParser, IndexUpdater indexUpdater) {
        this.markerManager = iMarkerManager;
        this.parser = rubyParser;
        this.indexUpdater = indexUpdater;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void compileFile(IFile iFile) throws CoreException {
        InputStreamReader inputStreamReader = new InputStreamReader(iFile.getContents());
        try {
            try {
                Node node = this.parser.parse(iFile, inputStreamReader);
                this.indexUpdater.update(iFile, node, true);
            }
            catch (SyntaxException syntaxException) {
                this.markerManager.createSyntaxError(iFile, syntaxException);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            IoUtils.closeQuietly(inputStreamReader);
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        IoUtils.closeQuietly(inputStreamReader);
    }
}

