/*
 * Decompiled with CFR 0.152.
 */
package org.jayasoft.ivyde.eclipse.ui.editors.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformationValidator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Point;
import org.jayasoft.ivyde.eclipse.ui.core.model.IvyFile;
import org.jayasoft.ivyde.eclipse.ui.core.model.IvyModel;
import org.jayasoft.ivyde.eclipse.ui.core.model.IvyTag;
import org.jayasoft.ivyde.eclipse.ui.core.model.IvyTagAttribute;
import org.jayasoft.ivyde.eclipse.ui.core.model.Proposal;

public class IvyContentAssistProcessor
implements IContentAssistProcessor {
    private IContextInformationValidator fValidator = new ContextInformationValidator((IContentAssistProcessor)this);
    private String errorMessage = null;
    private IFile file;
    private IvyModel _model;

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        String ivyFileString;
        IDocument doc = viewer.getDocument();
        Point selectedRange = viewer.getSelectedRange();
        ArrayList propList = new ArrayList();
        try {
            ivyFileString = doc.get(0, doc.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
        IProject project = this.getProject();
        IvyFile ivyfile = new IvyFile(project != null ? project.getName() : "", ivyFileString, documentOffset);
        if (ivyfile.inTag()) {
            String tagName = ivyfile.getTagName();
            if (ivyfile.readyForValue()) {
                this.computeValueProposals(tagName, ivyfile, propList, selectedRange);
            } else {
                this.computeTagAttributeProposals(tagName, ivyfile, propList, selectedRange);
            }
        } else {
            this.computeStructureProposals(ivyfile, propList, selectedRange);
        }
        ICompletionProposal[] proposals = new ICompletionProposal[propList.size()];
        propList.toArray(proposals);
        return proposals;
    }

    private void computeTagAttributeProposals(String tagName, IvyFile ivyfile, List propList, Point selectedRange) {
        String qualifier = ivyfile.getQualifier();
        int qlen = qualifier.length();
        if (qualifier.indexOf(47) > -1) {
            String text = "/>";
            CompletionProposal proposal = new CompletionProposal(text, ivyfile.getOffset() - qlen, qlen + selectedRange.y, text.length());
            propList.add(proposal);
        } else {
            String parent = ivyfile.getParentTagName();
            IvyTag tag = this._model.getIvyTag(tagName, parent);
            if (tag == null) {
                this.errorMessage = "tag :" + tagName + " not found in model:";
                return;
            }
            this.errorMessage = null;
            List atts = tag.getAttributes();
            Map existingAtts = ivyfile.getAllAttsValues();
            Iterator iter = atts.iterator();
            while (iter.hasNext()) {
                IvyTagAttribute att = (IvyTagAttribute)iter.next();
                if (!att.getName().startsWith(qualifier) || existingAtts.containsKey(att.getName())) continue;
                String text = String.valueOf(att.getName()) + "=\"\"";
                CompletionProposal proposal = new CompletionProposal(text, ivyfile.getOffset() - qlen, qlen + selectedRange.y, text.length() - 1, null, att.getName(), null, att.getDoc());
                propList.add(proposal);
            }
        }
    }

    private void computeValueProposals(String tagName, IvyFile ivyfile, List propList, Point selection) {
        Object[] values;
        IvyTag ivyTag;
        String parent = null;
        String tag = ivyfile.getTagName();
        if (tag != null) {
            parent = ivyfile.getParentTagName(ivyfile.getStringIndexBackward("<" + tag));
        }
        if ((ivyTag = this._model.getIvyTag(tag, parent)) != null && (values = ivyTag.getPossibleValuesForAttribute(ivyfile.getAttributeName(), ivyfile)) != null) {
            String qualifier = ivyfile.getAttributeValueQualifier();
            int qlen = qualifier == null ? 0 : qualifier.length();
            Arrays.sort(values);
            int i = 0;
            while (i < values.length) {
                Object val = values[i];
                CompletionProposal proposal = new CompletionProposal((String)val, ivyfile.getOffset() - qlen, qlen + selection.y, ((String)val).length());
                propList.add(proposal);
                ++i;
            }
        }
    }

    private void computeStructureProposals(IvyFile ivyfile, List propList, Point selectedRange) {
        String parent = ivyfile.getParentTagName();
        String qualifier = ivyfile.getQualifier();
        int qlen = qualifier.length();
        if (parent != null && ivyfile.getOffset() >= 2 + qualifier.length() && ivyfile.getString(ivyfile.getOffset() - 2 - qualifier.length(), ivyfile.getOffset()).startsWith("</")) {
            String text = "</" + parent + ">";
            CompletionProposal proposal = new CompletionProposal(text, ivyfile.getOffset() - qlen - 2, qlen + 2 + selectedRange.y, text.length());
            propList.add(proposal);
        } else {
            if (parent != null && qualifier.length() == 0) {
                String text = "</" + parent + ">";
                int closingIndex = ivyfile.getStringIndexForward(text);
                int openingIndex = ivyfile.getStringIndexForward("<" + parent);
                if (closingIndex == -1 || openingIndex != -1 && closingIndex > openingIndex) {
                    CompletionProposal proposal = new CompletionProposal(text, ivyfile.getOffset(), selectedRange.y, text.length());
                    propList.add(proposal);
                }
            }
            List childs = null;
            if (parent != null) {
                String parentParent = ivyfile.getParentTagName(ivyfile.getStringIndexBackward("<" + parent));
                IvyTag root = this._model.getIvyTag(parent, parentParent);
                if (root == null) {
                    this.errorMessage = "parent tag :" + parent + " not found in model:";
                    return;
                }
                childs = root.getChilds();
            } else {
                childs = Collections.singletonList(this._model.getRootIvyTag());
            }
            this.errorMessage = null;
            Iterator<IvyTag> iter = childs.iterator();
            while (iter.hasNext()) {
                IvyTag child = iter.next();
                if (!child.getStartTag().startsWith(qualifier)) continue;
                Proposal[] props = child.getProposals();
                int i = 0;
                while (i < props.length) {
                    propList.add(new CompletionProposal(props[i].getProposal(), ivyfile.getOffset() - qlen, qlen + selectedRange.y, props[i].getCursor(), null, null, null, props[i].getDoc()));
                    ++i;
                }
            }
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'<', '\"'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.fValidator;
    }

    public IJavaProject getJavaProject() {
        IProject p = this.getProject();
        return JavaCore.create((IProject)p);
    }

    public IProject getProject() {
        return this.file == null ? null : this.file.getProject();
    }

    public void setFile(IFile file) {
        this.file = file;
        this._model = new IvyModel(this.getJavaProject());
    }
}

