/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.vna;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.util.Strings;
import java.util.HashMap;
import org.apache.bcel.generic.InstructionHandle;

public class ValueNumberCache {
    private static final boolean DEBUG = SystemProperties.getBoolean("vn.debug");
    private HashMap<Entry, ValueNumber[]> entryToOutputMap = new HashMap();

    public ValueNumber[] lookupOutputValues(Entry entry) {
        if (DEBUG) {
            System.out.println("VN cache lookup: " + entry);
        }
        Object[] result = this.entryToOutputMap.get(entry);
        if (DEBUG) {
            System.out.println("   result ==> " + Strings.toString(result));
        }
        return result;
    }

    public void addOutputValues(Entry entry, ValueNumber[] outputValueList) {
        ValueNumber[] old = this.entryToOutputMap.put(entry, outputValueList);
        if (old != null) {
            throw new IllegalStateException("overwriting output values for entry!");
        }
    }

    public static class Entry {
        public final InstructionHandle handle;
        public final ValueNumber[] inputValueList;
        private int cachedHashCode;

        @SuppressWarnings(value={"EI2"})
        public Entry(InstructionHandle handle, ValueNumber[] inputValueList) {
            this.handle = handle;
            this.inputValueList = inputValueList;
            this.cachedHashCode = 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            if (this.handle.getPosition() != other.handle.getPosition()) {
                return false;
            }
            ValueNumber[] myList = this.inputValueList;
            ValueNumber[] otherList = other.inputValueList;
            if (myList.length != otherList.length) {
                return false;
            }
            for (int i = 0; i < myList.length; ++i) {
                if (myList[i].equals(otherList[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            if (this.cachedHashCode == 0) {
                int code = this.handle.getPosition();
                ValueNumber[] arr$ = this.inputValueList;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    ValueNumber aInputValueList = arr$[i$];
                    code *= 101;
                    ValueNumber valueNumber = aInputValueList;
                    code += valueNumber.hashCode();
                }
                this.cachedHashCode = code;
            }
            return this.cachedHashCode;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.handle.toString());
            ValueNumber[] arr$ = this.inputValueList;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                ValueNumber aInputValueList = arr$[i$];
                buf.append(", ");
                buf.append(aInputValueList.toString());
            }
            return buf.toString();
        }
    }
}

