/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.AbstractBlockOrder;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.ReverseDepthFirstSearch;
import java.util.Comparator;

public class ReverseDFSOrder
extends AbstractBlockOrder {
    public ReverseDepthFirstSearch rdfs;
    public DepthFirstSearch dfs;

    public ReverseDFSOrder(CFG cfg, ReverseDepthFirstSearch rdfs, DepthFirstSearch dfs) {
        super(cfg, new ReverseDFSComparator(rdfs, dfs));
        this.rdfs = rdfs;
        this.dfs = dfs;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReverseDFSComparator
    implements Comparator<BasicBlock> {
        public ReverseDepthFirstSearch rdfs;
        public DepthFirstSearch dfs;

        public ReverseDFSComparator(ReverseDepthFirstSearch rdfs, DepthFirstSearch dfs) {
            if (rdfs == null) {
                throw new IllegalArgumentException();
            }
            this.rdfs = rdfs;
            if (dfs == null) {
                throw new IllegalArgumentException();
            }
            this.dfs = dfs;
        }

        @Override
        public int compare(BasicBlock a, BasicBlock b) {
            return this.dfs.getFinishTime(a) - this.dfs.getFinishTime(b);
        }

        @Override
        public /* synthetic */ int compare(Object x0, Object x1) {
            return this.compare((BasicBlock)x0, (BasicBlock)x1);
        }
    }
}

