/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.ba.BasicAbstractDataflowAnalysis;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.BlockOrder;
import edu.umd.cs.findbugs.ba.BlockType;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DataflowTestDriver;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.ReversePostOrder;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.ObjectType;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockTypeAnalysis
extends BasicAbstractDataflowAnalysis<BlockType> {
    private DepthFirstSearch dfs;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$ba$BlockTypeAnalysis;

    public BlockTypeAnalysis(DepthFirstSearch dfs) {
        this.dfs = dfs;
    }

    @Override
    public BlockType createFact() {
        return new BlockType();
    }

    @Override
    public void copy(BlockType source, BlockType dest) {
        dest.copyFrom(source);
    }

    @Override
    public void initEntryFact(BlockType result) throws DataflowAnalysisException {
        result.setNormal();
    }

    @Override
    public void initResultFact(BlockType result) {
        this.makeFactTop(result);
    }

    @Override
    public void makeFactTop(BlockType fact) {
        fact.setTop();
    }

    @Override
    public boolean isTop(BlockType fact) {
        return fact.isTop();
    }

    @Override
    public boolean isForwards() {
        return true;
    }

    @Override
    public BlockOrder getBlockOrder(CFG cfg) {
        return new ReversePostOrder(cfg, this.dfs);
    }

    @Override
    public boolean same(BlockType fact1, BlockType fact2) {
        return fact1.sameAs(fact2);
    }

    @Override
    public void transfer(BasicBlock basicBlock, @CheckForNull InstructionHandle end, BlockType start, BlockType result) throws DataflowAnalysisException {
        result.copyFrom(start);
        if (start.isValid() && basicBlock.isExceptionHandler()) {
            CodeExceptionGen exceptionGen = basicBlock.getExceptionGen();
            ObjectType catchType = exceptionGen.getCatchType();
            if (catchType == null) {
                result.pushFinally();
            } else {
                result.pushCatch();
            }
        }
    }

    @Override
    public void meetInto(BlockType fact, Edge edge, BlockType result) throws DataflowAnalysisException {
        result.mergeWith(fact);
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length != 1) {
            System.err.println(new StringBuffer().append("Usage: ").append((class$edu$umd$cs$findbugs$ba$BlockTypeAnalysis == null ? (class$edu$umd$cs$findbugs$ba$BlockTypeAnalysis = BlockTypeAnalysis.class$("edu.umd.cs.findbugs.ba.BlockTypeAnalysis")) : class$edu$umd$cs$findbugs$ba$BlockTypeAnalysis).getName()).append(" <classfile>").toString());
            System.exit(1);
        }
        DataflowTestDriver<BlockType, BlockTypeAnalysis> driver = new DataflowTestDriver<BlockType, BlockTypeAnalysis>(){

            @Override
            public Dataflow<BlockType, BlockTypeAnalysis> createDataflow(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
                return classContext.getBlockTypeDataflow(method);
            }
        };
        driver.execute(argv[0]);
    }

    @Override
    public /* synthetic */ void meetInto(Object x0, Edge x1, Object x2) throws DataflowAnalysisException {
        this.meetInto((BlockType)x0, x1, (BlockType)x2);
    }

    @Override
    public /* synthetic */ void transfer(BasicBlock x0, InstructionHandle x1, Object x2, Object x3) throws DataflowAnalysisException {
        this.transfer(x0, x1, (BlockType)x2, (BlockType)x3);
    }

    @Override
    public /* synthetic */ boolean same(Object x0, Object x1) {
        return this.same((BlockType)x0, (BlockType)x1);
    }

    @Override
    public /* synthetic */ boolean isTop(Object x0) {
        return this.isTop((BlockType)x0);
    }

    @Override
    public /* synthetic */ void makeFactTop(Object x0) {
        this.makeFactTop((BlockType)x0);
    }

    @Override
    public /* synthetic */ void initResultFact(Object x0) {
        this.initResultFact((BlockType)x0);
    }

    @Override
    public /* synthetic */ void initEntryFact(Object x0) throws DataflowAnalysisException {
        this.initEntryFact((BlockType)x0);
    }

    @Override
    public /* synthetic */ void copy(Object x0, Object x1) {
        this.copy((BlockType)x0, (BlockType)x1);
    }

    @Override
    public /* synthetic */ Object createFact() {
        return this.createFact();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

