/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.leveldb;

import java.io.File;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.activemq.leveldb.LevelDBClient$;
import org.apache.activemq.leveldb.record.CollectionKey;
import org.apache.activemq.leveldb.record.CollectionRecord;
import org.apache.activemq.leveldb.record.EntryKey;
import org.apache.activemq.leveldb.record.EntryRecord;
import org.apache.activemq.leveldb.util.FileSupport$;
import org.apache.activemq.leveldb.util.Log;
import org.apache.activemq.leveldb.util.Log$class;
import org.fusesource.hawtbuf.AbstractVarIntSupport;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.TreeMap;
import scala.collection.immutable.TreeMap$;
import scala.math.Ordering;
import scala.math.Ordering$Long$;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.reflect.OptManifest;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LevelDBClient$
implements Log,
ScalaObject {
    public static final LevelDBClient$ MODULE$;
    private final String STORE_SCHEMA_PREFIX;
    private final int STORE_SCHEMA_VERSION;
    private final long THREAD_POOL_STACK_SIZE;
    private final ThreadPoolExecutor THREAD_POOL;
    private final byte[] DIRTY_INDEX_KEY;
    private final byte[] LOG_REF_INDEX_KEY;
    private final byte[] COLLECTION_META_KEY;
    private final byte[] TRUE;
    private final byte[] FALSE;
    private final AsciiBuffer ACK_POSITION;
    private final byte COLLECTION_PREFIX;
    private final byte[] COLLECTION_PREFIX_ARRAY;
    private final byte ENTRY_PREFIX;
    private final byte[] ENTRY_PREFIX_ARRAY;
    private final byte LOG_ADD_COLLECTION;
    private final byte LOG_REMOVE_COLLECTION;
    private final byte LOG_ADD_ENTRY;
    private final byte LOG_REMOVE_ENTRY;
    private final byte LOG_DATA;
    private final byte LOG_TRACE;
    private final String LOG_SUFFIX;
    private final String INDEX_SUFFIX;
    private final boolean $enable_assertions;
    private final Logger log;

    static {
        new LevelDBClient$();
    }

    public final String STORE_SCHEMA_PREFIX() {
        return "activemq_leveldb_store:";
    }

    public final int STORE_SCHEMA_VERSION() {
        return 1;
    }

    public final long THREAD_POOL_STACK_SIZE() {
        return this.THREAD_POOL_STACK_SIZE;
    }

    public final ThreadPoolExecutor THREAD_POOL() {
        return this.THREAD_POOL;
    }

    public final byte[] DIRTY_INDEX_KEY() {
        return this.DIRTY_INDEX_KEY;
    }

    public final byte[] LOG_REF_INDEX_KEY() {
        return this.LOG_REF_INDEX_KEY;
    }

    public final byte[] COLLECTION_META_KEY() {
        return this.COLLECTION_META_KEY;
    }

    public final byte[] TRUE() {
        return this.TRUE;
    }

    public final byte[] FALSE() {
        return this.FALSE;
    }

    public final AsciiBuffer ACK_POSITION() {
        return this.ACK_POSITION;
    }

    public final byte COLLECTION_PREFIX() {
        return this.COLLECTION_PREFIX;
    }

    public final byte[] COLLECTION_PREFIX_ARRAY() {
        return this.COLLECTION_PREFIX_ARRAY;
    }

    public final byte ENTRY_PREFIX() {
        return this.ENTRY_PREFIX;
    }

    public final byte[] ENTRY_PREFIX_ARRAY() {
        return this.ENTRY_PREFIX_ARRAY;
    }

    public final byte LOG_ADD_COLLECTION() {
        return this.LOG_ADD_COLLECTION;
    }

    public final byte LOG_REMOVE_COLLECTION() {
        return this.LOG_REMOVE_COLLECTION;
    }

    public final byte LOG_ADD_ENTRY() {
        return this.LOG_ADD_ENTRY;
    }

    public final byte LOG_REMOVE_ENTRY() {
        return this.LOG_REMOVE_ENTRY;
    }

    public final byte LOG_DATA() {
        return this.LOG_DATA;
    }

    public final byte LOG_TRACE() {
        return this.LOG_TRACE;
    }

    public final String LOG_SUFFIX() {
        return ".log";
    }

    public final String INDEX_SUFFIX() {
        return ".index";
    }

    public byte[] toByteArray(Buffer buffer) {
        return buffer.toByteArray();
    }

    public Buffer toBuffer(byte[] buffer) {
        return new Buffer(buffer);
    }

    public byte[] encodeCollectionRecord(CollectionRecord.Buffer v) {
        return v.toUnframedByteArray();
    }

    public CollectionRecord.Buffer decodeCollectionRecord(Buffer data) {
        return CollectionRecord.FACTORY.parseUnframed(data);
    }

    public byte[] encodeCollectionKeyRecord(CollectionKey.Buffer v) {
        return v.toUnframedByteArray();
    }

    public CollectionKey.Buffer decodeCollectionKeyRecord(Buffer data) {
        return CollectionKey.FACTORY.parseUnframed(data);
    }

    public Buffer encodeEntryRecord(EntryRecord.Buffer v) {
        return v.toUnframedBuffer();
    }

    public EntryRecord.Buffer decodeEntryRecord(Buffer data) {
        return EntryRecord.FACTORY.parseUnframed(data);
    }

    public byte[] encodeEntryKeyRecord(EntryKey.Buffer v) {
        return v.toUnframedByteArray();
    }

    public EntryKey.Buffer decodeEntryKeyRecord(Buffer data) {
        return EntryKey.FACTORY.parseUnframed(data);
    }

    public byte[] encodeLocator(long pos, int len) {
        DataByteArrayOutputStream out = new DataByteArrayOutputStream(AbstractVarIntSupport.computeVarLongSize((long)pos) + AbstractVarIntSupport.computeVarIntSize((int)len));
        out.writeVarLong(pos);
        out.writeVarInt(len);
        return out.getData();
    }

    public Tuple2<Object, Object> decodeLocator(Buffer bytes) {
        DataByteArrayInputStream in = new DataByteArrayInputStream(bytes);
        return new Tuple2.mcJI.sp(in.readVarLong(), in.readVarInt());
    }

    public Tuple2<Object, Object> decodeLocator(byte[] bytes) {
        DataByteArrayInputStream in = new DataByteArrayInputStream(bytes);
        return new Tuple2.mcJI.sp(in.readVarLong(), in.readVarInt());
    }

    public Buffer encodeLong(long a1) {
        DataByteArrayOutputStream out = new DataByteArrayOutputStream(8);
        out.writeLong(a1);
        return out.toBuffer();
    }

    public byte[] encodeVLong(long a1) {
        DataByteArrayOutputStream out = new DataByteArrayOutputStream(AbstractVarIntSupport.computeVarLongSize((long)a1));
        out.writeVarLong(a1);
        return out.getData();
    }

    public long decodeVLong(byte[] bytes) {
        DataByteArrayInputStream in = new DataByteArrayInputStream(bytes);
        return in.readVarLong();
    }

    public byte[] encodeLongKey(byte a1, long a2) {
        DataByteArrayOutputStream out = new DataByteArrayOutputStream(9);
        out.writeByte((int)a1);
        out.writeLong(a2);
        return out.getData();
    }

    public Tuple2<Object, Object> decodeLongKey(byte[] bytes) {
        DataByteArrayInputStream in = new DataByteArrayInputStream(bytes);
        return new Tuple2((Object)BoxesRunTime.boxToByte((byte)in.readByte()), (Object)BoxesRunTime.boxToLong((long)in.readLong()));
    }

    public long decodeLong(Buffer bytes) {
        DataByteArrayInputStream in = new DataByteArrayInputStream(bytes);
        return in.readLong();
    }

    public long decodeLong(byte[] bytes) {
        DataByteArrayInputStream in = new DataByteArrayInputStream(bytes);
        return in.readLong();
    }

    public byte[] encodeEntryKey(byte a1, long a2, long a3) {
        DataByteArrayOutputStream out = new DataByteArrayOutputStream(17);
        out.writeByte((int)a1);
        out.writeLong(a2);
        out.writeLong(a3);
        return out.getData();
    }

    public byte[] encodeEntryKey(byte a1, long a2, Buffer a3) {
        DataByteArrayOutputStream out = new DataByteArrayOutputStream(9 + a3.length);
        out.writeByte((int)a1);
        out.writeLong(a2);
        out.write(a3);
        return out.getData();
    }

    public Tuple3<Object, Object, Buffer> decodeEntryKey(byte[] bytes) {
        DataByteArrayInputStream in = new DataByteArrayInputStream(bytes);
        return new Tuple3((Object)BoxesRunTime.boxToByte((byte)in.readByte()), (Object)BoxesRunTime.boxToLong((long)in.readLong()), (Object)in.readBuffer(in.available()));
    }

    public byte[] bytes(String value) {
        return value.getBytes("UTF-8");
    }

    public File create_sequence_file(File directory, long id, String suffix) {
        return FileSupport$.MODULE$.toRichFile(directory).$div(Predef$.MODULE$.augmentString("%016x%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)id), suffix})));
    }

    public TreeMap<Object, File> find_sequence_files(File directory, String suffix$1) {
        return (TreeMap)TreeMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])directory.listFiles()).flatMap((Function1)new Serializable(suffix$1){
            public static final long serialVersionUID;
            private final String suffix$1;

            static {
                long l = serialVersionUID = 0L;
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Iterable<Tuple2<Object, File>> apply(File f) {
                void var2_2;
                Iterable iterable;
                if (!f.getName().endsWith(this.suffix$1)) {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    return iterable;
                }
                Iterable exceptionResult6 = null;
                try {
                    String base = Predef$.MODULE$.augmentString(f.getName()).stripSuffix(this.suffix$1);
                    long position = Long.parseLong(base, 16);
                    exceptionResult6 = Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToLong((long)position)).$minus$greater((Object)f)));
                }
                catch (NumberFormatException numberFormatException) {
                    exceptionResult6 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                iterable = var2_2;
                return iterable;
            }
            {
                this.suffix$1 = string;
            }
        }, Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(Tuple2.class, (OptManifest)Manifest$.MODULE$.Long(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{ClassManifest$.MODULE$.classType(File.class)}))))), (Ordering)Ordering$Long$.MODULE$);
    }

    public boolean $enable_assertions() {
        return this.$enable_assertions;
    }

    private LevelDBClient$() {
        MODULE$ = this;
        Log$class.$init$(this);
        this.THREAD_POOL_STACK_SIZE = Predef$.MODULE$.augmentString(System.getProperty("leveldb.thread.stack.size", String.valueOf(BoxesRunTime.boxToInteger((int)524288)))).toLong();
        this.THREAD_POOL = new anon.1();
        this.DIRTY_INDEX_KEY = this.bytes(":dirty");
        this.LOG_REF_INDEX_KEY = this.bytes(":log-refs");
        this.COLLECTION_META_KEY = this.bytes(":collection-meta");
        this.TRUE = this.bytes("true");
        this.FALSE = this.bytes("false");
        this.ACK_POSITION = new AsciiBuffer("p");
        this.COLLECTION_PREFIX = (byte)99;
        this.COLLECTION_PREFIX_ARRAY = Array$.MODULE$.apply(this.COLLECTION_PREFIX(), (Seq)Predef$.MODULE$.wrapByteArray(new byte[0]));
        this.ENTRY_PREFIX = (byte)101;
        this.ENTRY_PREFIX_ARRAY = Array$.MODULE$.apply(this.ENTRY_PREFIX(), (Seq)Predef$.MODULE$.wrapByteArray(new byte[0]));
        this.LOG_ADD_COLLECTION = (byte)1;
        this.LOG_REMOVE_COLLECTION = (byte)2;
        this.LOG_ADD_ENTRY = (byte)3;
        this.LOG_REMOVE_ENTRY = (byte)4;
        this.LOG_DATA = (byte)5;
        this.LOG_TRACE = (byte)6;
        this.$enable_assertions = this.getClass().desiredAssertionStatus();
    }
}

