/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Locale;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.PollingConsumerPollingStrategy;
import org.apache.camel.Processor;
import org.apache.camel.SuspendableService;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultPollingConsumerPollStrategy;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScheduledPollConsumer
extends DefaultConsumer
implements Runnable,
SuspendableService,
PollingConsumerPollingStrategy {
    private static final transient Logger LOG = LoggerFactory.getLogger(ScheduledPollConsumer.class);
    private ScheduledExecutorService scheduledExecutorService;
    private boolean shutdownExecutor;
    private ScheduledFuture<?> future;
    private boolean startScheduler = true;
    private long initialDelay = 1000L;
    private long delay = 500L;
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private boolean useFixedDelay = true;
    private PollingConsumerPollStrategy pollStrategy = new DefaultPollingConsumerPollStrategy();
    private LoggingLevel runLoggingLevel = LoggingLevel.TRACE;
    private boolean sendEmptyMessageWhenIdle;
    private volatile boolean polling;

    public ScheduledPollConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    public ScheduledPollConsumer(Endpoint endpoint, Processor processor, ScheduledExecutorService scheduledExecutorService) {
        super(endpoint, processor);
        this.scheduledExecutorService = scheduledExecutorService;
        ObjectHelper.notNull(scheduledExecutorService, "scheduledExecutorService");
    }

    @Override
    public void run() {
        try {
            if (LoggingLevel.ERROR == this.runLoggingLevel) {
                LOG.error("Scheduled task started on:   {}", (Object)this.getEndpoint());
            } else if (LoggingLevel.WARN == this.runLoggingLevel) {
                LOG.warn("Scheduled task started on:   {}", (Object)this.getEndpoint());
            } else if (LoggingLevel.INFO == this.runLoggingLevel) {
                LOG.info("Scheduled task started on:   {}", (Object)this.getEndpoint());
            } else if (LoggingLevel.DEBUG == this.runLoggingLevel) {
                LOG.debug("Scheduled task started on:   {}", (Object)this.getEndpoint());
            } else {
                LOG.trace("Scheduled task started on:   {}", (Object)this.getEndpoint());
            }
            this.doRun();
            if (LoggingLevel.ERROR == this.runLoggingLevel) {
                LOG.error("Scheduled task completed on: {}", (Object)this.getEndpoint());
            } else if (LoggingLevel.WARN == this.runLoggingLevel) {
                LOG.warn("Scheduled task completed on: {}", (Object)this.getEndpoint());
            } else if (LoggingLevel.INFO == this.runLoggingLevel) {
                LOG.info("Scheduled task completed on: {}", (Object)this.getEndpoint());
            } else if (LoggingLevel.DEBUG == this.runLoggingLevel) {
                LOG.debug("Scheduled task completed on: {}", (Object)this.getEndpoint());
            } else {
                LOG.trace("Scheduled task completed on: {}", (Object)this.getEndpoint());
            }
        }
        catch (Error e) {
            LOG.error("Error occurred during running scheduled task on: " + this.getEndpoint() + ", due: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun() {
        if (this.isSuspended()) {
            LOG.trace("Cannot start to poll: {} as its suspended", (Object)this.getEndpoint());
            return;
        }
        int retryCounter = -1;
        boolean done = false;
        while (!done) {
            try {
                done = true;
                if (this.isPollAllowed()) {
                    if (retryCounter == -1) {
                        LOG.trace("Starting to poll: {}", (Object)this.getEndpoint());
                    } else {
                        LOG.debug("Retrying attempt {} to poll: {}", (Object)retryCounter, (Object)this.getEndpoint());
                    }
                    this.polling = true;
                    try {
                        boolean begin = this.pollStrategy.begin(this, this.getEndpoint());
                        if (begin) {
                            ++retryCounter;
                            int polledMessages = this.poll();
                            if (polledMessages == 0 && this.isSendEmptyMessageWhenIdle()) {
                                this.processEmptyMessage();
                            }
                            this.pollStrategy.commit(this, this.getEndpoint(), polledMessages);
                        } else {
                            LOG.debug("Cannot begin polling as pollStrategy returned false: {}", (Object)this.pollStrategy);
                        }
                    }
                    finally {
                        this.polling = false;
                    }
                }
                LOG.trace("Finished polling: {}", (Object)this.getEndpoint());
            }
            catch (Exception e) {
                try {
                    boolean retry = this.pollStrategy.rollback(this, this.getEndpoint(), retryCounter, e);
                    if (!retry) continue;
                    done = false;
                }
                catch (Throwable t) {
                    this.getExceptionHandler().handleException("Consumer " + this + " failed polling endpoint: " + this.getEndpoint() + ". Will try again at next poll", t);
                    done = true;
                }
            }
            catch (Throwable t) {
                this.getExceptionHandler().handleException("Consumer " + this + " failed polling endpoint: " + this.getEndpoint() + ". Will try again at next poll", t);
                done = true;
            }
        }
    }

    protected void processEmptyMessage() throws Exception {
        Exchange exchange = this.getEndpoint().createExchange();
        this.log.debug("Sending empty message as there were no messages from polling: {}", (Object)this.getEndpoint());
        this.getProcessor().process(exchange);
    }

    protected boolean isPollAllowed() {
        return this.isRunAllowed() && !this.isSuspended();
    }

    protected boolean isPolling() {
        return this.polling;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(long initialDelay) {
        this.initialDelay = initialDelay;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public boolean isUseFixedDelay() {
        return this.useFixedDelay;
    }

    public void setUseFixedDelay(boolean useFixedDelay) {
        this.useFixedDelay = useFixedDelay;
    }

    public LoggingLevel getRunLoggingLevel() {
        return this.runLoggingLevel;
    }

    public void setRunLoggingLevel(LoggingLevel runLoggingLevel) {
        this.runLoggingLevel = runLoggingLevel;
    }

    public PollingConsumerPollStrategy getPollStrategy() {
        return this.pollStrategy;
    }

    public void setPollStrategy(PollingConsumerPollStrategy pollStrategy) {
        this.pollStrategy = pollStrategy;
    }

    public boolean isStartScheduler() {
        return this.startScheduler;
    }

    public void setStartScheduler(boolean startScheduler) {
        this.startScheduler = startScheduler;
    }

    public void setSendEmptyMessageWhenIdle(boolean sendEmptyMessageWhenIdle) {
        this.sendEmptyMessageWhenIdle = sendEmptyMessageWhenIdle;
    }

    public boolean isSendEmptyMessageWhenIdle() {
        return this.sendEmptyMessageWhenIdle;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
    }

    protected abstract int poll() throws Exception;

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.scheduledExecutorService == null) {
            this.scheduledExecutorService = this.getEndpoint().getCamelContext().getExecutorServiceManager().newScheduledThreadPool((Object)this, this.getEndpoint().getEndpointUri(), 1);
            this.shutdownExecutor = true;
        }
        ObjectHelper.notNull(this.scheduledExecutorService, "scheduledExecutorService", this);
        ObjectHelper.notNull(this.pollStrategy, "pollStrategy", this);
        if (this.isStartScheduler()) {
            this.startScheduler();
        }
    }

    protected void startScheduler() {
        if (this.isUseFixedDelay()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduling poll (fixed delay) with initialDelay: {}, delay: {} ({}) for: {}", new Object[]{this.getInitialDelay(), this.getDelay(), this.getTimeUnit().name().toLowerCase(Locale.ENGLISH), this.getEndpoint()});
            }
            this.future = this.scheduledExecutorService.scheduleWithFixedDelay(this, this.getInitialDelay(), this.getDelay(), this.getTimeUnit());
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduling poll (fixed rate) with initialDelay: {}, delay: {} ({}) for: {}", new Object[]{this.getInitialDelay(), this.getDelay(), this.getTimeUnit().name().toLowerCase(Locale.ENGLISH), this.getEndpoint()});
            }
            this.future = this.scheduledExecutorService.scheduleAtFixedRate(this, this.getInitialDelay(), this.getDelay(), this.getTimeUnit());
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (this.future != null) {
            LOG.debug("This consumer is stopping, so cancelling scheduled task: " + this.future);
            this.future.cancel(false);
        }
        super.doStop();
    }

    @Override
    protected void doShutdown() throws Exception {
        if (this.shutdownExecutor && this.scheduledExecutorService != null) {
            this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.scheduledExecutorService);
            this.scheduledExecutorService = null;
            this.future = null;
        }
        super.doShutdown();
    }

    @Override
    protected void doSuspend() throws Exception {
    }

    @Override
    public void onInit() throws Exception {
    }

    @Override
    public long beforePoll(long timeout) throws Exception {
        LOG.trace("Before poll {}", (Object)this.getEndpoint());
        if (!ServiceHelper.resumeService(this)) {
            ServiceHelper.startService(this);
        }
        return Math.max(timeout, this.getDelay());
    }

    @Override
    public void afterPoll() throws Exception {
        LOG.trace("After poll {}", (Object)this.getEndpoint());
        if (!ServiceHelper.suspendService(this)) {
            ServiceHelper.stopService(this);
        }
    }
}

