/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.config.AbstractConfigurationParser;
import flex.messaging.config.AdapterSettings;
import flex.messaging.config.ChannelSettings;
import flex.messaging.config.ClusterSettings;
import flex.messaging.config.ConfigMap;
import flex.messaging.config.ConfigurationException;
import flex.messaging.config.DestinationSettings;
import flex.messaging.config.FactorySettings;
import flex.messaging.config.FlexClientSettings;
import flex.messaging.config.LoggingSettings;
import flex.messaging.config.LoginCommandSettings;
import flex.messaging.config.MessagingConfiguration;
import flex.messaging.config.SecurityConstraint;
import flex.messaging.config.ServiceSettings;
import flex.messaging.config.SharedServerSettings;
import flex.messaging.config.SystemSettings;
import flex.messaging.config.TargetSettings;
import flex.messaging.util.LocaleUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ServerConfigurationParser
extends AbstractConfigurationParser {
    protected void parseTopLevelConfig(Document doc) {
        Node root = this.selectSingleNode(doc, "/services-config");
        if (root == null) {
            ConfigurationException e = new ConfigurationException();
            e.setMessage(10103, new Object[]{"services-config"});
            throw e;
        }
        this.allowedChildElements(root, SERVICES_CONFIG_CHILDREN);
        this.securitySection(root);
        this.serversSection(root);
        this.channelsSection(root);
        this.services(root);
        this.clusters(root);
        this.logging(root);
        this.system(root);
        this.flexClient(root);
        this.factories(root);
    }

    private void clusters(Node root) {
        Node clusteringNode = this.selectSingleNode(root, "clusters");
        if (clusteringNode != null) {
            this.allowedAttributesOrElements(clusteringNode, CLUSTERING_CHILDREN);
            NodeList clusters = this.selectNodeList(clusteringNode, "cluster");
            for (int i = 0; i < clusters.getLength(); ++i) {
                String ulb;
                String defaultValue;
                Node cluster = clusters.item(i);
                this.requiredAttributesOrElements(cluster, CLUSTER_DEFINITION_CHILDREN);
                String clusterName = this.getAttributeOrChildElement(cluster, "id");
                if (!ServerConfigurationParser.isValidID((String)clusterName)) continue;
                String propsFileName = this.getAttributeOrChildElement(cluster, "properties");
                ClusterSettings clusterSettings = new ClusterSettings();
                clusterSettings.setClusterName(clusterName);
                clusterSettings.setPropsFileName(propsFileName);
                String className = this.getAttributeOrChildElement(cluster, "class");
                if (className != null && className.length() > 0) {
                    clusterSettings.setImplementationClass(className);
                }
                if ((defaultValue = this.getAttributeOrChildElement(cluster, "default")) != null && defaultValue.length() > 0) {
                    if (defaultValue.equalsIgnoreCase("true")) {
                        clusterSettings.setDefault(true);
                    } else if (!defaultValue.equalsIgnoreCase("false")) {
                        ConfigurationException e = new ConfigurationException();
                        e.setMessage(10215, new Object[]{clusterName, defaultValue});
                        throw e;
                    }
                }
                if ((ulb = this.getAttributeOrChildElement(cluster, "url-load-balancing")) != null && ulb.length() > 0) {
                    if (ulb.equalsIgnoreCase("false")) {
                        clusterSettings.setURLLoadBalancing(false);
                    } else if (!ulb.equalsIgnoreCase("true")) {
                        ConfigurationException e = new ConfigurationException();
                        e.setMessage(10216, new Object[]{clusterName, ulb});
                        throw e;
                    }
                }
                ((MessagingConfiguration)this.config).addClusterSettings(clusterSettings);
            }
        }
    }

    private void securitySection(Node root) {
        Node security = this.selectSingleNode(root, "security");
        if (security != null) {
            int i;
            this.allowedChildElements(security, SECURITY_CHILDREN);
            NodeList list = this.selectNodeList(security, "security-constraint");
            for (i = 0; i < list.getLength(); ++i) {
                Node constraint = list.item(i);
                this.securityConstraint(constraint, false);
            }
            list = this.selectNodeList(security, "login-command");
            for (i = 0; i < list.getLength(); ++i) {
                Node login = list.item(i);
                LoginCommandSettings loginCommandSettings = new LoginCommandSettings();
                this.requiredAttributesOrElements(login, LOGIN_COMMAND_REQ_CHILDREN);
                this.allowedAttributesOrElements(login, LOGIN_COMMAND_CHILDREN);
                String server = this.getAttributeOrChildElement(login, "server");
                if (server.length() == 0) {
                    ConfigurationException e = new ConfigurationException();
                    e.setMessage(10105, new Object[]{"server", "login-command"});
                    throw e;
                }
                loginCommandSettings.setServer(server);
                String loginClass = this.getAttributeOrChildElement(login, "class");
                if (loginClass.length() == 0) {
                    ConfigurationException e = new ConfigurationException();
                    e.setMessage(10105, new Object[]{"class", "login-command"});
                    throw e;
                }
                loginCommandSettings.setClassName(loginClass);
                boolean isPerClientAuth = Boolean.valueOf(this.getAttributeOrChildElement(login, "per-client-authentication"));
                loginCommandSettings.setPerClientAuthentication(isPerClientAuth);
                ((MessagingConfiguration)this.config).getSecuritySettings().addLoginCommandSettings(loginCommandSettings);
            }
        }
    }

    private SecurityConstraint securityConstraint(Node constraint, boolean inline) {
        SecurityConstraint sc;
        this.allowedAttributesOrElements(constraint, SECURITY_CONSTRAINT_DEFINITION_CHILDREN);
        String ref = this.getAttributeOrChildElement(constraint, "ref");
        if (ref.length() > 0) {
            this.allowedAttributesOrElements(constraint, new String[]{"ref"});
            sc = ((MessagingConfiguration)this.config).getSecuritySettings().getConstraint(ref);
            if (sc == null) {
                ConfigurationException e = new ConfigurationException();
                e.setMessage(10109, new Object[]{"security-constraint", ref});
                throw e;
            }
        } else {
            String id = this.getAttributeOrChildElement(constraint, "id");
            if (inline) {
                sc = new SecurityConstraint("");
            } else if (ServerConfigurationParser.isValidID((String)id)) {
                sc = new SecurityConstraint(id);
                ((MessagingConfiguration)this.config).getSecuritySettings().addConstraint(sc);
            } else {
                ConfigurationException ex = new ConfigurationException();
                ex.setMessage(10110, new Object[]{"security-constraint", id});
                ex.setDetails(10110);
                throw ex;
            }
            String method = this.getAttributeOrChildElement(constraint, "auth-method");
            sc.setMethod(method);
            Node rolesNode = this.selectSingleNode(constraint, "roles");
            if (rolesNode != null) {
                this.allowedChildElements(rolesNode, ROLES_CHILDREN);
                NodeList roles = this.selectNodeList(rolesNode, "role");
                for (int r = 0; r < roles.getLength(); ++r) {
                    Node roleNode = roles.item(r);
                    String role = this.evaluateExpression(roleNode, ".").toString().trim();
                    if (role.length() <= 0) continue;
                    sc.addRole(role);
                }
            }
        }
        return sc;
    }

    private void serversSection(Node root) {
        if (!(this.config instanceof MessagingConfiguration)) {
            return;
        }
        Node serversNode = this.selectSingleNode(root, "servers");
        if (serversNode != null) {
            this.allowedAttributesOrElements(serversNode, SERVERS_CHILDREN);
            NodeList servers = this.selectNodeList(serversNode, "server");
            for (int i = 0; i < servers.getLength(); ++i) {
                Node server = servers.item(i);
                this.serverDefinition(server);
            }
        }
    }

    private void serverDefinition(Node server) {
        this.requiredAttributesOrElements(server, SERVER_REQ_CHILDREN);
        String id = this.getAttributeOrChildElement(server, "id");
        if (ServerConfigurationParser.isValidID((String)id)) {
            SharedServerSettings settings = new SharedServerSettings();
            settings.setId(id);
            settings.setClassName(this.getAttributeOrChildElement(server, "class"));
            NodeList properties = this.selectNodeList(server, "properties/*");
            if (properties.getLength() > 0) {
                ConfigMap map = this.properties(properties, this.getSourceFileOf(server));
                settings.setProperties(map);
            }
            ((MessagingConfiguration)this.config).addSharedServerSettings(settings);
        }
    }

    private void channelsSection(Node root) {
        Node channelsNode = this.selectSingleNode(root, "channels");
        if (channelsNode != null) {
            this.allowedAttributesOrElements(channelsNode, CHANNELS_CHILDREN);
            NodeList channels = this.selectNodeList(channelsNode, "channel-definition");
            for (int i = 0; i < channels.getLength(); ++i) {
                Node channel = channels.item(i);
                this.channelDefinition(channel);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void channelDefinition(Node channel) {
        String ref;
        NodeList properties;
        Node server;
        this.requiredAttributesOrElements(channel, CHANNEL_DEFINITION_REQ_CHILDREN);
        this.allowedAttributesOrElements(channel, CHANNEL_DEFINITION_CHILDREN);
        String id = this.getAttributeOrChildElement(channel, "id");
        if (!ServerConfigurationParser.isValidID((String)id)) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(10110, new Object[]{"channel-definition", id});
            ex.setDetails(10110);
            throw ex;
        }
        if (this.config.getChannelSettings(id) != null) {
            ConfigurationException e = new ConfigurationException();
            e.setMessage(11127, new Object[]{id});
            throw e;
        }
        ChannelSettings channelSettings = new ChannelSettings(id);
        channelSettings.setSourceFile(this.getSourceFileOf(channel));
        String clientType = this.getAttributeOrChildElement(channel, "class");
        channelSettings.setClientType(clientType);
        String remote = this.getAttributeOrChildElement(channel, "remote");
        channelSettings.setRemote(Boolean.valueOf(remote).booleanValue());
        Node endpoint = this.selectSingleNode(channel, "endpoint");
        if (endpoint != null) {
            this.allowedAttributesOrElements(endpoint, ENDPOINT_CHILDREN);
            String type = this.getAttributeOrChildElement(endpoint, "class");
            channelSettings.setEndpointType(type);
            String uri = this.getAttributeOrChildElement(endpoint, "url");
            if (uri == null || "".equals(uri)) {
                uri = this.getAttributeOrChildElement(endpoint, "uri");
            }
            channelSettings.setUri(uri);
            this.config.addChannelSettings(id, channelSettings);
        }
        if ((server = this.selectSingleNode(channel, "server")) != null) {
            this.requiredAttributesOrElements(server, CHANNEL_DEFINITION_SERVER_REQ_CHILDREN);
            String serverId = this.getAttributeOrChildElement(server, "ref");
            channelSettings.setServerId(serverId);
        }
        if ((properties = this.selectNodeList(channel, "properties/*")).getLength() > 0) {
            ConfigMap map = this.properties(properties, this.getSourceFileOf(channel));
            channelSettings.addProperties(map);
        }
        if ((ref = this.evaluateExpression(channel, "@security-constraint").toString().trim()).length() <= 0) {
            Node security = this.selectSingleNode(channel, "security");
            if (security == null) return;
            this.allowedChildElements(security, EMBEDDED_SECURITY_CHILDREN);
            Node constraint = this.selectSingleNode(security, "security-constraint");
            if (constraint == null) return;
            SecurityConstraint sc = this.securityConstraint(constraint, true);
            channelSettings.setConstraint(sc);
            return;
        }
        SecurityConstraint sc = ((MessagingConfiguration)this.config).getSecuritySettings().getConstraint(ref);
        if (sc != null) {
            channelSettings.setConstraint(sc);
            return;
        }
        ConfigurationException ex = new ConfigurationException();
        ex.setMessage(10132, new Object[]{"security-constraint", ref, id});
        throw ex;
    }

    private void services(Node root) {
        Node servicesNode = this.selectSingleNode(root, "services");
        if (servicesNode != null) {
            Node service;
            int i;
            this.allowedChildElements(servicesNode, SERVICES_CHILDREN);
            Node defaultChannels = this.selectSingleNode(servicesNode, "default-channels");
            if (defaultChannels != null) {
                this.allowedChildElements(defaultChannels, DEFAULT_CHANNELS_CHILDREN);
                NodeList channels = this.selectNodeList(defaultChannels, "channel");
                for (int c = 0; c < channels.getLength(); ++c) {
                    Node chan = channels.item(c);
                    this.allowedAttributes(chan, new String[]{"ref"});
                    this.defaultChannel(chan);
                }
            }
            NodeList services = this.selectNodeList(servicesNode, "service-include");
            for (i = 0; i < services.getLength(); ++i) {
                service = services.item(i);
                this.serviceInclude(service);
            }
            services = this.selectNodeList(servicesNode, "service");
            for (i = 0; i < services.getLength(); ++i) {
                service = services.item(i);
                this.service(service);
            }
        }
    }

    private void serviceInclude(Node serviceInclude) {
        this.requiredAttributesOrElements(serviceInclude, SERVICE_INCLUDE_CHILDREN);
        String src = this.getAttributeOrChildElement(serviceInclude, "file-path");
        if (src.length() > 0) {
            Document doc = this.loadDocument(src, this.fileResolver.getIncludedFile(src));
            doc.getDocumentElement().normalize();
            Node service = this.selectSingleNode(doc, "/service");
            if (service != null) {
                this.service(service);
                this.fileResolver.popIncludedFile();
            } else {
                ConfigurationException ex = new ConfigurationException();
                ex.setMessage(10112, new Object[]{"service"});
                throw ex;
            }
        }
    }

    private void service(Node service) {
        this.requiredAttributesOrElements(service, SERVICE_REQ_CHILDREN);
        this.allowedAttributesOrElements(service, SERVICE_CHILDREN);
        String id = this.getAttributeOrChildElement(service, "id");
        if (ServerConfigurationParser.isValidID((String)id)) {
            Node dest;
            int i;
            Node adapters;
            Node defaultSecurityConstraint;
            Node defaultChannels;
            ServiceSettings serviceSettings = this.config.getServiceSettings(id);
            if (serviceSettings != null) {
                ConfigurationException e = new ConfigurationException();
                e.setMessage(10113, new Object[]{id});
                throw e;
            }
            serviceSettings = new ServiceSettings(id);
            serviceSettings.setSourceFile(this.getSourceFileOf(service));
            this.config.addServiceSettings(serviceSettings);
            String className = this.getAttributeOrChildElement(service, "class");
            if (className.length() <= 0) {
                ConfigurationException ex = new ConfigurationException();
                ex.setMessage(10114, new Object[]{"service", id});
                throw ex;
            }
            serviceSettings.setClassName(className);
            NodeList properties = this.selectNodeList(service, "properties/*");
            if (properties.getLength() > 0) {
                ConfigMap map = this.properties(properties, this.getSourceFileOf(service));
                serviceSettings.addProperties(map);
            }
            if ((defaultChannels = this.selectSingleNode(service, "default-channels")) != null) {
                this.allowedChildElements(defaultChannels, DEFAULT_CHANNELS_CHILDREN);
                NodeList channels = this.selectNodeList(defaultChannels, "channel");
                for (int c = 0; c < channels.getLength(); ++c) {
                    Node chan = channels.item(c);
                    this.allowedAttributes(chan, new String[]{"ref"});
                    this.defaultChannel(chan, serviceSettings);
                }
            } else if (this.config.getDefaultChannels().size() > 0) {
                Iterator iter = this.config.getDefaultChannels().iterator();
                while (iter.hasNext()) {
                    String channelId = (String)iter.next();
                    ChannelSettings channel = this.config.getChannelSettings(channelId);
                    serviceSettings.addDefaultChannel(channel);
                }
            }
            if ((defaultSecurityConstraint = this.selectSingleNode(service, "default-security-constraint")) != null) {
                this.requiredAttributesOrElements(defaultSecurityConstraint, new String[]{"ref"});
                this.allowedAttributesOrElements(defaultSecurityConstraint, new String[]{"ref"});
                String ref = this.getAttributeOrChildElement(defaultSecurityConstraint, "ref");
                if (ref.length() > 0) {
                    SecurityConstraint sc = ((MessagingConfiguration)this.config).getSecuritySettings().getConstraint(ref);
                    if (sc == null) {
                        ConfigurationException e = new ConfigurationException();
                        e.setMessage(10109, new Object[]{"security-constraint", ref});
                        throw e;
                    }
                    serviceSettings.setConstraint(sc);
                } else {
                    ConfigurationException ex = new ConfigurationException();
                    ex.setMessage(11124, new Object[]{ref, id});
                    throw ex;
                }
            }
            if ((adapters = this.selectSingleNode(service, "adapters")) != null) {
                this.allowedChildElements(adapters, ADAPTERS_CHILDREN);
                NodeList serverAdapters = this.selectNodeList(adapters, "adapter-definition");
                for (int a = 0; a < serverAdapters.getLength(); ++a) {
                    Node adapter = serverAdapters.item(a);
                    this.adapterDefinition(adapter, serviceSettings);
                }
            }
            NodeList list = this.selectNodeList(service, "destination");
            for (i = 0; i < list.getLength(); ++i) {
                dest = list.item(i);
                this.destination(dest, serviceSettings);
            }
            list = this.selectNodeList(service, "destination-include");
            for (i = 0; i < list.getLength(); ++i) {
                dest = list.item(i);
                this.destinationInclude(dest, serviceSettings);
            }
        } else {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(10110, new Object[]{"service", id});
            throw ex;
        }
    }

    private void defaultChannel(Node chan) {
        ChannelSettings channel;
        String ref = this.getAttributeOrChildElement(chan, "ref");
        if (ref.length() > 0) {
            channel = this.config.getChannelSettings(ref);
            if (channel == null) {
                ConfigurationException e = new ConfigurationException();
                e.setMessage(10109, new Object[]{"channel", ref});
                throw e;
            }
        } else {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(10116, new Object[]{"MessageBroker"});
            throw ex;
        }
        this.config.addDefaultChannel(channel.getId());
    }

    private void defaultChannel(Node chan, ServiceSettings serviceSettings) {
        ChannelSettings channel;
        String ref = this.getAttributeOrChildElement(chan, "ref");
        if (ref.length() > 0) {
            channel = this.config.getChannelSettings(ref);
            if (channel == null) {
                ConfigurationException e = new ConfigurationException();
                e.setMessage(10109, new Object[]{"channel", ref});
                throw e;
            }
        } else {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(10116, new Object[]{serviceSettings.getId()});
            throw ex;
        }
        serviceSettings.addDefaultChannel(channel);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void adapterDefinition(Node adapter, ServiceSettings serviceSettings) {
        this.requiredAttributesOrElements(adapter, ADAPTER_DEFINITION_REQ_CHILDREN);
        this.allowedChildElements(adapter, ADAPTER_DEFINITION_CHILDREN);
        String serviceId = serviceSettings.getId();
        String id = this.getAttributeOrChildElement(adapter, "id");
        if (!ServerConfigurationParser.isValidID((String)id)) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(10119, new Object[]{"adapter-definition", id, serviceId});
            throw ex;
        }
        AdapterSettings adapterSettings = new AdapterSettings(id);
        adapterSettings.setSourceFile(this.getSourceFileOf(adapter));
        String className = this.getAttributeOrChildElement(adapter, "class");
        if (className.length() <= 0) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(10114, new Object[]{"adapter-definition", id});
            throw ex;
        }
        adapterSettings.setClassName(className);
        boolean isDefault = Boolean.valueOf(this.getAttributeOrChildElement(adapter, "default"));
        if (isDefault) {
            adapterSettings.setDefault(isDefault);
            AdapterSettings defaultAdapter = serviceSettings.getDefaultAdapter();
            if (defaultAdapter != null) {
                ConfigurationException ex = new ConfigurationException();
                ex.setMessage(10117, new Object[]{id, serviceId, defaultAdapter.getId()});
                throw ex;
            }
        }
        serviceSettings.addAdapterSettings(adapterSettings);
        NodeList properties = this.selectNodeList(adapter, "properties/*");
        if (properties.getLength() <= 0) return;
        ConfigMap map = this.properties(properties, this.getSourceFileOf(adapter));
        adapterSettings.addProperties(map);
    }

    private void destinationInclude(Node destInclude, ServiceSettings serviceSettings) {
        this.requiredAttributesOrElements(destInclude, DESTINATION_INCLUDE_CHILDREN);
        String src = this.getAttributeOrChildElement(destInclude, "file-path");
        if (src.length() > 0) {
            Document doc = this.loadDocument(src, this.fileResolver.getIncludedFile(src));
            doc.getDocumentElement().normalize();
            Node dest = this.selectSingleNode(doc, "/destination");
            if (dest != null) {
                this.destination(dest, serviceSettings);
                this.fileResolver.popIncludedFile();
            } else {
                ConfigurationException ex = new ConfigurationException();
                ex.setMessage(10118, new Object[]{"destination"});
                throw ex;
            }
        }
    }

    private void destination(Node dest, ServiceSettings serviceSettings) {
        DestinationSettings destinationSettings;
        this.requiredAttributesOrElements(dest, DESTINATION_REQ_CHILDREN);
        this.allowedAttributes(dest, DESTINATION_ATTR);
        this.allowedChildElements(dest, DESTINATION_CHILDREN);
        String serviceId = serviceSettings.getId();
        String id = this.getAttributeOrChildElement(dest, "id");
        if (ServerConfigurationParser.isValidID((String)id)) {
            destinationSettings = (DestinationSettings)serviceSettings.getDestinationSettings().get(id);
            if (destinationSettings != null) {
                ConfigurationException e = new ConfigurationException();
                e.setMessage(10122, new Object[]{id, serviceId});
                throw e;
            }
        } else {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(10119, new Object[]{"destination", id, serviceId});
            throw ex;
        }
        destinationSettings = new DestinationSettings(id);
        destinationSettings.setSourceFile(this.getSourceFileOf(dest));
        serviceSettings.addDestinationSettings(destinationSettings);
        NodeList properties = this.selectNodeList(dest, "properties/*");
        if (properties.getLength() > 0) {
            ConfigMap map = this.properties(properties, this.getSourceFileOf(dest));
            destinationSettings.addProperties(map);
        }
        this.destinationChannels(dest, destinationSettings, serviceSettings);
        this.destinationSecurity(dest, destinationSettings, serviceSettings);
        this.destinationAdapter(dest, destinationSettings, serviceSettings);
    }

    private void destinationChannels(Node dest, DestinationSettings destinationSettings, ServiceSettings serviceSettings) {
        String destId = destinationSettings.getId();
        String channelsList = this.evaluateExpression(dest, "@channels").toString().trim();
        if (channelsList.length() > 0) {
            StringTokenizer st = new StringTokenizer(channelsList, ",;:");
            while (st.hasMoreTokens()) {
                String ref = st.nextToken().trim();
                ChannelSettings channel = this.config.getChannelSettings(ref);
                if (channel != null) {
                    destinationSettings.addChannelSettings(channel);
                    continue;
                }
                ConfigurationException ex = new ConfigurationException();
                ex.setMessage(10120, new Object[]{"channel", ref, destId});
                throw ex;
            }
        } else {
            Node channelsNode = this.selectSingleNode(dest, "channels");
            if (channelsNode != null) {
                this.allowedChildElements(channelsNode, DESTINATION_CHANNELS_CHILDREN);
                NodeList channels = this.selectNodeList(channelsNode, "channel");
                for (int c = 0; c < channels.getLength(); ++c) {
                    ChannelSettings channel;
                    Node chan = channels.item(c);
                    this.requiredAttributesOrElements(chan, DESTINATION_CHANNEL_REQ_CHILDREN);
                    String ref = this.getAttributeOrChildElement(chan, "ref");
                    if (ref.length() > 0) {
                        channel = this.config.getChannelSettings(ref);
                        if (channel == null) {
                            ConfigurationException ex = new ConfigurationException();
                            ex.setMessage(10120, new Object[]{"channel", ref, destId});
                            throw ex;
                        }
                    } else {
                        ConfigurationException ex = new ConfigurationException();
                        ex.setMessage(10121, new Object[]{"channel", ref, destId});
                        throw ex;
                    }
                    destinationSettings.addChannelSettings(channel);
                }
            } else {
                List defaultChannels = serviceSettings.getDefaultChannels();
                Iterator it = defaultChannels.iterator();
                while (it.hasNext()) {
                    ChannelSettings channel = (ChannelSettings)it.next();
                    destinationSettings.addChannelSettings(channel);
                }
            }
        }
        if (destinationSettings.getChannelSettings().size() <= 0) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(10123, new Object[]{destId});
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void destinationSecurity(Node dest, DestinationSettings destinationSettings, ServiceSettings serviceSettings) {
        String destId = destinationSettings.getId();
        String ref = this.evaluateExpression(dest, "@security-constraint").toString().trim();
        if (ref.length() > 0) {
            SecurityConstraint sc = ((MessagingConfiguration)this.config).getSecuritySettings().getConstraint(ref);
            if (sc != null) {
                destinationSettings.setConstraint(sc);
                return;
            }
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(10120, new Object[]{"security-constraint", ref, destId});
            throw ex;
        }
        Node security = this.selectSingleNode(dest, "security");
        if (security != null) {
            this.allowedChildElements(security, EMBEDDED_SECURITY_CHILDREN);
            Node constraint = this.selectSingleNode(security, "security-constraint");
            if (constraint == null) return;
            SecurityConstraint sc = this.securityConstraint(constraint, true);
            destinationSettings.setConstraint(sc);
            return;
        }
        SecurityConstraint sc = serviceSettings.getConstraint();
        if (sc == null) return;
        destinationSettings.setConstraint(sc);
    }

    private void destinationAdapter(Node dest, DestinationSettings destinationSettings, ServiceSettings serviceSettings) {
        String destId = destinationSettings.getId();
        String ref = this.evaluateExpression(dest, "@adapter").toString().trim();
        if (ref.length() > 0) {
            this.adapterReference(ref, destinationSettings, serviceSettings);
        } else {
            Node adapter = this.selectSingleNode(dest, "adapter");
            if (adapter != null) {
                this.allowedAttributesOrElements(adapter, DESTINATION_ADAPTER_CHILDREN);
                ref = this.getAttributeOrChildElement(adapter, "ref");
                this.adapterReference(ref, destinationSettings, serviceSettings);
            } else {
                AdapterSettings adapterSettings = serviceSettings.getDefaultAdapter();
                if (adapterSettings != null) {
                    destinationSettings.setAdapterSettings(adapterSettings);
                }
            }
        }
        if (destinationSettings.getAdapterSettings() == null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(10127, new Object[]{destId});
            throw ex;
        }
    }

    private void adapterReference(String ref, DestinationSettings destinationSettings, ServiceSettings serviceSettings) {
        AdapterSettings adapterSettings;
        String destId = destinationSettings.getId();
        if (ref.length() > 0) {
            adapterSettings = serviceSettings.getAdapterSettings(ref);
            if (adapterSettings == null) {
                ConfigurationException ex = new ConfigurationException();
                ex.setMessage(10120, new Object[]{"adapter", ref, destId});
                throw ex;
            }
        } else {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(10121, new Object[]{"adapter", ref, destId});
            throw ex;
        }
        destinationSettings.setAdapterSettings(adapterSettings);
    }

    private void logging(Node root) {
        Node logging = this.selectSingleNode(root, "logging");
        if (logging != null) {
            this.allowedAttributesOrElements(logging, LOGGING_CHILDREN);
            LoggingSettings settings = new LoggingSettings();
            NodeList properties = this.selectNodeList(logging, "properties/*");
            if (properties.getLength() > 0) {
                ConfigMap map = this.properties(properties, this.getSourceFileOf(logging));
                settings.addProperties(map);
            }
            NodeList targets = this.selectNodeList(logging, "target");
            for (int i = 0; i < targets.getLength(); ++i) {
                Node filtersNode;
                Node targetNode = targets.item(i);
                this.requiredAttributesOrElements(targetNode, TARGET_REQ_CHILDREN);
                this.allowedAttributesOrElements(targetNode, TARGET_CHILDREN);
                String className = this.getAttributeOrChildElement(targetNode, "class");
                if (className.length() <= 0) continue;
                TargetSettings targetSettings = new TargetSettings(className);
                String targetLevel = this.getAttributeOrChildElement(targetNode, "level");
                if (targetLevel.length() > 0) {
                    targetSettings.setLevel(targetLevel);
                }
                if ((filtersNode = this.selectSingleNode(targetNode, "filters")) != null) {
                    this.allowedChildElements(filtersNode, FILTERS_CHILDREN);
                    NodeList filters = this.selectNodeList(filtersNode, "pattern");
                    for (int f = 0; f < filters.getLength(); ++f) {
                        Node pattern = filters.item(f);
                        String filter = this.evaluateExpression(pattern, ".").toString().trim();
                        targetSettings.addFilter(filter);
                    }
                }
                if ((properties = this.selectNodeList(targetNode, "properties/*")).getLength() > 0) {
                    ConfigMap map = this.properties(properties, this.getSourceFileOf(targetNode));
                    targetSettings.addProperties(map);
                }
                settings.addTarget(targetSettings);
            }
            this.config.setLoggingSettings(settings);
        }
    }

    private void system(Node root) {
        Node system = this.selectSingleNode(root, "system");
        if (system != null) {
            this.allowedAttributesOrElements(system, SYSTEM_CHILDREN);
            SystemSettings settings = new SystemSettings();
            Node localeNode = this.selectSingleNode(system, "locale");
            if (localeNode != null) {
                this.allowedAttributesOrElements(localeNode, LOCALE_CHILDREN);
                String defaultLocaleString = this.getAttributeOrChildElement(localeNode, "default-locale");
                Locale defaultLocale = defaultLocaleString.length() > 0 ? LocaleUtils.buildLocale((String)defaultLocaleString) : LocaleUtils.buildLocale(null);
                settings.setDefaultLocale(defaultLocale);
            }
            String manageable = this.getAttributeOrChildElement(system, "manageable");
            settings.setManageable(manageable);
            Node redeployNode = this.selectSingleNode(system, "redeploy");
            if (redeployNode != null) {
                this.allowedAttributesOrElements(redeployNode, REDEPLOY_CHILDREN);
                String enabled = this.getAttributeOrChildElement(redeployNode, "enabled");
                settings.setRedeployEnabled(enabled);
                String interval = this.getAttributeOrChildElement(redeployNode, "watch-interval");
                if (interval.length() > 0) {
                    settings.setWatchInterval(interval);
                }
                NodeList watches = this.selectNodeList(redeployNode, "watch-file");
                for (int i = 0; i < watches.getLength(); ++i) {
                    Node watchNode = watches.item(i);
                    String watch = this.evaluateExpression(watchNode, ".").toString().trim();
                    if (watch.length() <= 0) continue;
                    settings.addWatchFile(watch);
                }
                NodeList touches = this.selectNodeList(redeployNode, "touch-file");
                for (int i = 0; i < touches.getLength(); ++i) {
                    Node touchNode = touches.item(i);
                    String touch = this.evaluateExpression(touchNode, ".").toString().trim();
                    if (touch.length() <= 0) continue;
                    settings.addTouchFile(touch);
                }
            }
            ((MessagingConfiguration)this.config).setSystemSettings(settings);
        } else {
            ((MessagingConfiguration)this.config).setSystemSettings(new SystemSettings());
        }
    }

    private void flexClient(Node root) {
        Node flexClient = this.selectSingleNode(root, "flex-client");
        if (flexClient != null) {
            FlexClientSettings flexClientSettings = new FlexClientSettings();
            String timeout = this.getAttributeOrChildElement(flexClient, "timeout-minutes");
            if (timeout.length() > 0) {
                try {
                    long timeoutMinutes = Long.parseLong(timeout);
                    if (timeoutMinutes < 0L) {
                        ConfigurationException e = new ConfigurationException();
                        e.setMessage(11123, new Object[]{timeout});
                        throw e;
                    }
                    flexClientSettings.setTimeoutMinutes(timeoutMinutes);
                }
                catch (NumberFormatException nfe) {
                    ConfigurationException e = new ConfigurationException();
                    e.setMessage(11123, new Object[]{timeout});
                    throw e;
                }
            } else {
                flexClientSettings.setTimeoutMinutes(0L);
            }
            ((MessagingConfiguration)this.config).setFlexClientSettings(flexClientSettings);
        }
    }

    private void factories(Node root) {
        Node factories = this.selectSingleNode(root, "factories");
        if (factories != null) {
            this.allowedAttributesOrElements(factories, FACTORIES_CHILDREN);
            NodeList factoryList = this.selectNodeList(factories, "factory");
            for (int i = 0; i < factoryList.getLength(); ++i) {
                Node factory = factoryList.item(i);
                this.factory(factory);
            }
        }
    }

    private void factory(Node factory) {
        FactorySettings factorySettings;
        this.requiredAttributesOrElements(factory, FACTORY_REQ_CHILDREN);
        String id = this.getAttributeOrChildElement(factory, "id");
        String className = this.getAttributeOrChildElement(factory, "class");
        if (ServerConfigurationParser.isValidID((String)id)) {
            factorySettings = new FactorySettings(id, className);
            NodeList properties = this.selectNodeList(factory, "properties/*");
            if (properties.getLength() > 0) {
                ConfigMap map = this.properties(properties, this.getSourceFileOf(factory));
                factorySettings.addProperties(map);
            }
        } else {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(10110, new Object[]{"factory", id});
            ex.setDetails(10110);
            throw ex;
        }
        ((MessagingConfiguration)this.config).addFactorySettings(id, factorySettings);
    }
}

