/*
 * Decompiled with CFR 0.152.
 */
package railo.loader.engine;

import com.intergral.fusiondebug.server.FDControllerFactory;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import railo.Version;
import railo.loader.TP;
import railo.loader.classloader.RailoClassLoader;
import railo.loader.engine.CFMLEngine;
import railo.loader.engine.CFMLEngineWrapper;
import railo.loader.engine.EngineChangeListener;
import railo.loader.util.ExtensionFilter;
import railo.loader.util.Util;

public class CFMLEngineFactory {
    private static final boolean PATCH_ENABLED = true;
    private static CFMLEngineFactory factory;
    private static File railoServerRoot;
    private static CFMLEngineWrapper engineListener;
    private CFMLEngine engine;
    private ClassLoader mainClassLoader = new TP().getClass().getClassLoader();
    private int version;
    private ArrayList listeners = new ArrayList();
    private File resourceRoot;
    private PrintWriter out;

    protected CFMLEngineFactory() {
    }

    public static CFMLEngine getInstance(ServletConfig servletConfig) throws ServletException {
        if (engineListener != null) {
            if (factory == null) {
                factory = engineListener.getCFMLEngineFactory();
            }
            return engineListener;
        }
        if (factory == null) {
            factory = new CFMLEngineFactory();
        }
        factory.setInitParam(servletConfig);
        CFMLEngine cFMLEngine = factory.getEngine();
        cFMLEngine.addServletConfig(servletConfig);
        engineListener = new CFMLEngineWrapper(cFMLEngine);
        factory.addListener(engineListener);
        return engineListener;
    }

    public static CFMLEngine getInstance() throws RuntimeException {
        if (engineListener != null) {
            return engineListener;
        }
        throw new RuntimeException("engine is not initalized, you must first call getInstance(ServletConfig)");
    }

    public static void registerInstance(CFMLEngine cFMLEngine) throws RuntimeException {
        if (factory == null) {
            factory = cFMLEngine.getCFMLEngineFactory();
        }
        if (engineListener != null) {
            if (engineListener.equalTo(cFMLEngine, true)) {
                return;
            }
            engineListener.onUpdate(cFMLEngine);
            factory.removeListener(engineListener);
        }
        engineListener = cFMLEngine instanceof CFMLEngineWrapper ? (CFMLEngineWrapper)cFMLEngine : new CFMLEngineWrapper(cFMLEngine);
        factory.addListener(engineListener);
    }

    public static CFMLEngine getInstance(ServletConfig servletConfig, EngineChangeListener engineChangeListener) throws ServletException {
        CFMLEngineFactory.getInstance(servletConfig);
        factory.addListener(engineChangeListener);
        factory.setInitParam(servletConfig);
        CFMLEngine cFMLEngine = factory.getEngine();
        cFMLEngine.addServletConfig(servletConfig);
        FDControllerFactory.makeVisible();
        return cFMLEngine;
    }

    void setInitParam(ServletConfig servletConfig) {
        if (railoServerRoot != null) {
            return;
        }
        String string = servletConfig.getInitParameter("railo-server-directory");
        if (Util.isEmpty(string)) {
            string = servletConfig.getInitParameter("railo-server-root");
        }
        if (Util.isEmpty(string)) {
            string = servletConfig.getInitParameter("railo-server-dir");
        }
        if (Util.isEmpty(string)) {
            string = servletConfig.getInitParameter("railo-server");
        }
        string = Util.parsePlaceHolder(Util.removeQuotes(string, true));
        try {
            if (!Util.isEmpty(string)) {
                File file = new File(string);
                if (!file.exists()) {
                    if (file.mkdirs()) {
                        railoServerRoot = file.getCanonicalFile();
                        return;
                    }
                } else if (file.canWrite()) {
                    railoServerRoot = file.getCanonicalFile();
                    return;
                }
            }
        }
        catch (IOException iOException) {}
    }

    private void addListener(EngineChangeListener engineChangeListener) {
        if (!this.listeners.contains(engineChangeListener)) {
            this.listeners.add(engineChangeListener);
        }
    }

    private void removeListener(EngineChangeListener engineChangeListener) {
        this.listeners.remove(engineChangeListener);
    }

    private CFMLEngine getEngine() throws ServletException {
        if (this.engine == null) {
            this.initEngine();
        }
        return this.engine;
    }

    private void initEngine() throws ServletException {
        int n = Version.getIntVersion();
        long l = Version.getCreateTime();
        File file = null;
        try {
            file = this.getPatchDirectory();
            this.log("railo-server-root:" + file.getParent());
        }
        catch (IOException iOException) {
            throw new ServletException((Throwable)iOException);
        }
        File[] fileArray = file.listFiles(new ExtensionFilter(new String[]{"." + this.getCoreExtension()}));
        File file2 = null;
        if (fileArray != null) {
            int n2 = 0;
            while (n2 < fileArray.length) {
                if (fileArray[n2].getName().startsWith("tmp.rc")) {
                    fileArray[n2].delete();
                } else if (fileArray[n2].lastModified() < l) {
                    fileArray[n2].delete();
                } else if (file2 == null || this.isNewerThan(Util.toInVersion(fileArray[n2].getName()), Util.toInVersion(file2.getName()))) {
                    file2 = fileArray[n2];
                }
                ++n2;
            }
        }
        if (file2 != null && this.isNewerThan(n, Util.toInVersion(file2.getName()))) {
            file2 = null;
        }
        try {
            if (file2 == null) {
                this.tlog("Load Build in Core");
                String string = this.getCoreExtension();
                this.engine = this.getCore(string);
                file2 = new File(file, String.valueOf(this.engine.getVersion()) + "." + string);
                InputStream inputStream = new TP().getClass().getResourceAsStream("/core/core." + string);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                Util.copy(inputStream, bufferedOutputStream);
                Util.closeEL(inputStream, bufferedOutputStream);
            } else {
                try {
                    this.engine = this.getEngine(new RailoClassLoader(file2, this.mainClassLoader));
                }
                catch (EOFException eOFException) {
                    System.err.println("Railo patch file " + file2 + " is invalid, please delete it");
                    this.engine = this.getCore(this.getCoreExtension());
                }
            }
            this.version = Util.toInVersion(this.engine.getVersion());
            this.tlog("Loaded Railo Version " + this.engine.getVersion());
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.getTargetException().printStackTrace();
            throw new ServletException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ServletException((Throwable)exception);
        }
        String string = this.engine.getUpdateType();
        if (string == null || string.length() == 0) {
            string = "manuell";
        }
        if (string.equalsIgnoreCase("auto")) {
            new UpdateChecker(this).start();
        }
    }

    private String getCoreExtension() throws ServletException {
        URL uRL = new TP().getClass().getResource("/core/core.rcs");
        if (uRL != null) {
            return "rcs";
        }
        uRL = new TP().getClass().getResource("/core/core.rc");
        if (uRL != null) {
            return "rc";
        }
        throw new ServletException("missing core file");
    }

    private CFMLEngine getCore(String string) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, IOException {
        CFMLEngine cFMLEngine;
        InputStream inputStream = null;
        try {
            inputStream = new TP().getClass().getResourceAsStream("/core/core." + string);
            RailoClassLoader railoClassLoader = new RailoClassLoader(inputStream, this.mainClassLoader, string.equalsIgnoreCase("rcs"));
            cFMLEngine = this.getEngine(railoClassLoader);
        }
        catch (Throwable throwable) {
            Util.closeEL(inputStream);
            throw throwable;
        }
        Util.closeEL(inputStream);
        return cFMLEngine;
    }

    public boolean update(String string) throws IOException, ServletException {
        if (!this.engine.can(0, string)) {
            throw new IOException("access denied to update CFMLEngine");
        }
        return this.update();
    }

    public boolean restart(String string) throws IOException, ServletException {
        if (!this.engine.can(1, string)) {
            throw new IOException("access denied to restart CFMLEngine");
        }
        return this._restart();
    }

    public boolean restart(String string, String string2) throws IOException, ServletException {
        if (!this.engine.can(2, string2)) {
            throw new IOException("access denied to restart CFML Context (configId:" + string + ")");
        }
        return this._restart();
    }

    private synchronized boolean _restart() throws ServletException {
        this.engine.reset();
        this.initEngine();
        CFMLEngineFactory.registerInstance(this.engine);
        this.callListeners(this.engine);
        System.gc();
        System.gc();
        return true;
    }

    private boolean update() throws IOException, ServletException {
        URL uRL = this.getEngine().getUpdateLocation();
        if (uRL == null) {
            uRL = new URL("http://www.getrailo.org");
        }
        URL uRL2 = new URL(uRL, "/railo/remote/version/info.cfm?ext=" + this.getCoreExtension() + "&version=" + this.version);
        this.tlog("Check for update at " + uRL);
        String string = Util.toString((InputStream)uRL2.getContent()).trim();
        if (string.length() != 9) {
            throw new IOException("can't get update info from [" + uRL2 + "]");
        }
        if (!this.isNewerThan(Util.toInVersion(string), this.version)) {
            this.tlog("There is no newer Version available");
            return false;
        }
        this.tlog("Found a newer Version \n - current Version " + Util.toStringVersion(this.version) + "\n - available Version " + string);
        URL uRL3 = new URL(uRL, "/railo/remote/version/update.cfm?ext=" + this.getCoreExtension() + "&version=" + string);
        File file = this.getPatchDirectory();
        File file2 = new File(file, String.valueOf(string) + "." + this.getCoreExtension());
        if (!file2.createNewFile()) {
            this.tlog("File for new Version already exists, won't copy new one");
            return false;
        }
        Util.copy((InputStream)uRL3.getContent(), new FileOutputStream(file2));
        try {
            this.engine.reset();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        RailoClassLoader railoClassLoader = new RailoClassLoader(file2, this.mainClassLoader);
        String string2 = "";
        try {
            CFMLEngine cFMLEngine = this.getEngine(railoClassLoader);
            if (cFMLEngine == null) {
                throw new IOException("can't load engine");
            }
            string2 = cFMLEngine.getVersion();
            this.engine = cFMLEngine;
            this.version = Util.toInVersion(string2);
            this.callListeners(cFMLEngine);
        }
        catch (Exception exception) {
            railoClassLoader = null;
            System.gc();
            try {
                file2.delete();
            }
            catch (Exception exception2) {}
            this.tlog("There was a Problem with the new Version, can't install (" + exception + ":" + exception.getMessage() + ")");
            exception.printStackTrace();
            return false;
        }
        this.tlog("Version (" + string2 + ")installed");
        return true;
    }

    public boolean removeUpdate(String string) throws IOException, ServletException {
        if (!this.engine.can(0, string)) {
            throw new IOException("access denied to update CFMLEngine");
        }
        return this.removeUpdate();
    }

    public boolean removeLatestUpdate(String string) throws IOException, ServletException {
        if (!this.engine.can(0, string)) {
            throw new IOException("access denied to update CFMLEngine");
        }
        return this.removeLatestUpdate();
    }

    private boolean removeUpdate() throws IOException, ServletException {
        File file = this.getPatchDirectory();
        File[] fileArray = file.listFiles(new ExtensionFilter(new String[]{"railo", "rc", "rcs"}));
        int n = 0;
        while (n < fileArray.length) {
            if (!fileArray[n].delete()) {
                fileArray[n].deleteOnExit();
            }
            ++n;
        }
        this._restart();
        return true;
    }

    private boolean removeLatestUpdate() throws IOException, ServletException {
        File file = this.getPatchDirectory();
        File[] fileArray = file.listFiles(new ExtensionFilter(new String[]{"." + this.getCoreExtension()}));
        File file2 = null;
        int n = 0;
        while (n < fileArray.length) {
            if (file2 == null || this.isNewerThan(Util.toInVersion(fileArray[n].getName()), Util.toInVersion(file2.getName()))) {
                file2 = fileArray[n];
            }
            ++n;
        }
        if (file2 != null && !file2.delete()) {
            file2.deleteOnExit();
        }
        this._restart();
        return true;
    }

    public String[] getInstalledPatches() throws ServletException, IOException {
        File file = this.getPatchDirectory();
        File[] fileArray = file.listFiles(new ExtensionFilter(new String[]{"." + this.getCoreExtension()}));
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.getCoreExtension().length() + 1;
        int n2 = 0;
        while (n2 < fileArray.length) {
            String string = fileArray[n2].getName();
            string = string.substring(0, string.length() - n);
            arrayList.add(string);
            ++n2;
        }
        Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    private void callListeners(CFMLEngine cFMLEngine) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((EngineChangeListener)iterator.next()).onUpdate(cFMLEngine);
        }
    }

    private File getPatchDirectory() throws IOException {
        File file = new File(this.getResourceRoot(), "patches");
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public File getResourceRoot() throws IOException {
        if (this.resourceRoot == null) {
            this.resourceRoot = new File(this.getRuningContextRoot(), "railo-server");
            if (!this.resourceRoot.exists()) {
                this.resourceRoot.mkdirs();
            }
        }
        return this.resourceRoot;
    }

    private File getRuningContextRoot() throws IOException {
        if (railoServerRoot != null) {
            return railoServerRoot;
        }
        File file = CFMLEngineFactory.getClassLoaderRoot(this.mainClassLoader);
        file.mkdirs();
        if (file.exists() && file.isDirectory()) {
            return file;
        }
        throw new IOException("can't create/write to directory [" + file + "], set \"init-param\" \"railo-server-directory\" with path to writable directory");
    }

    public static File getClassLoaderRoot(ClassLoader classLoader) {
        File file;
        String string = "railo/loader/engine/CFMLEngine.class";
        URL uRL = classLoader.getResource(string);
        String string2 = null;
        try {
            string2 = URLDecoder.decode(uRL.getFile().trim(), "iso-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        int n = string2.indexOf(33);
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        if ((n = string2.lastIndexOf(string)) != -1) {
            string2 = string2.substring(0, n);
        }
        if (string2.startsWith("file:")) {
            string2 = string2.substring(5);
        }
        if (string2.endsWith("railo.jar")) {
            string2 = string2.substring(0, string2.length() - 9);
        }
        if ((file = new File(string2)).isFile()) {
            file = file.getParentFile();
        }
        return file;
    }

    private boolean isNewerThan(int n, int n2) {
        return n > n2;
    }

    private CFMLEngine getEngine(ClassLoader classLoader) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = classLoader.loadClass("railo.runtime.engine.CFMLEngineImpl");
        Method method = clazz.getMethod("getInstance", CFMLEngineFactory.class);
        return (CFMLEngine)method.invoke(null, this);
    }

    public void tlog(Object object) {
        this.log(new Date() + " " + object);
    }

    public void log(Object object) {
        if (this.out == null) {
            boolean bl = false;
            String string = System.getProperty("railo.cli.call");
            if (!Util.isEmpty(string, true)) {
                boolean bl2 = bl = "true".equalsIgnoreCase(string = string.trim()) || "yes".equalsIgnoreCase(string);
            }
            if (bl) {
                try {
                    File file = new File(this.getResourceRoot(), "logs");
                    file.mkdirs();
                    File file2 = new File(file, "out");
                    file2.createNewFile();
                    this.out = new PrintWriter(file2);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            if (this.out == null) {
                this.out = new PrintWriter(System.out);
            }
        }
        this.out.write(object + "\n");
        this.out.flush();
    }

    private class UpdateChecker
    extends Thread {
        private CFMLEngineFactory factory;

        private UpdateChecker(CFMLEngineFactory cFMLEngineFactory2) {
            this.factory = cFMLEngineFactory2;
        }

        @Override
        public void run() {
            long l = 10000L;
            while (true) {
                try {
                    while (true) {
                        UpdateChecker.sleep(l);
                        l = 86400000L;
                        this.factory.update();
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }
}

