require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&IWN_TX_RING_COUNT)) {
    sub IWN_TX_RING_COUNT () {	256;}
}
unless(defined(&IWN_TX_RING_LOMARK)) {
    sub IWN_TX_RING_LOMARK () {	192;}
}
unless(defined(&IWN_TX_RING_HIMARK)) {
    sub IWN_TX_RING_HIMARK () {	224;}
}
unless(defined(&IWN_RX_RING_COUNT_LOG)) {
    sub IWN_RX_RING_COUNT_LOG () {	6;}
}
unless(defined(&IWN_RX_RING_COUNT)) {
    sub IWN_RX_RING_COUNT () {	(1<<  &IWN_RX_RING_COUNT_LOG);}
}
unless(defined(&IWN4965_NTXQUEUES)) {
    sub IWN4965_NTXQUEUES () {	16;}
}
unless(defined(&IWN5000_NTXQUEUES)) {
    sub IWN5000_NTXQUEUES () {	20;}
}
unless(defined(&IWN4965_NDMACHNLS)) {
    sub IWN4965_NDMACHNLS () {	7;}
}
unless(defined(&IWN5000_NDMACHNLS)) {
    sub IWN5000_NDMACHNLS () {	8;}
}
unless(defined(&IWN_SRVC_DMACHNL)) {
    sub IWN_SRVC_DMACHNL () {	9;}
}
unless(defined(&IWN_ICT_SIZE)) {
    sub IWN_ICT_SIZE () {	4096;}
}
unless(defined(&IWN_ICT_COUNT)) {
    sub IWN_ICT_COUNT () {	( &IWN_ICT_SIZE / $sizeof{ &uint32_t});}
}
unless(defined(&IWN_MAX_SCATTER)) {
    sub IWN_MAX_SCATTER () {	20;}
}
unless(defined(&IWN_RBUF_SIZE)) {
    sub IWN_RBUF_SIZE () {	(4* 1024);}
}
if(defined(&__LP64__)) {
    eval 'sub IWN_LOADDR {
        my($paddr) = @_;
	    eval q((( &uint32_t)($paddr)));
    }' unless defined(&IWN_LOADDR);
    eval 'sub IWN_HIADDR {
        my($paddr) = @_;
	    eval q(((($paddr) >> 32) & 0xf));
    }' unless defined(&IWN_HIADDR);
} else {
    eval 'sub IWN_LOADDR {
        my($paddr) = @_;
	    eval q(($paddr));
    }' unless defined(&IWN_LOADDR);
    eval 'sub IWN_HIADDR {
        my($paddr) = @_;
	    eval q((0));
    }' unless defined(&IWN_HIADDR);
}
unless(defined(&IWN_PCI_BAR0)) {
    sub IWN_PCI_BAR0 () {	 &PCI_MAPREG_START;}
}
unless(defined(&IWN_HW_IF_CONFIG)) {
    sub IWN_HW_IF_CONFIG () {	0x;}
}
unless(defined(&IWN_INT_COALESCING)) {
    sub IWN_INT_COALESCING () {	0x4;}
}
unless(defined(&IWN_INT_PERIODIC)) {
    sub IWN_INT_PERIODIC () {	0x5;}
}
unless(defined(&IWN_INT)) {
    sub IWN_INT () {	0x8;}
}
unless(defined(&IWN_INT_MASK)) {
    sub IWN_INT_MASK () {	0xc;}
}
unless(defined(&IWN_FH_INT)) {
    sub IWN_FH_INT () {	0x10;}
}
unless(defined(&IWN_RESET)) {
    sub IWN_RESET () {	0x20;}
}
unless(defined(&IWN_GP_CNTRL)) {
    sub IWN_GP_CNTRL () {	0x24;}
}
unless(defined(&IWN_HW_REV)) {
    sub IWN_HW_REV () {	0x28;}
}
unless(defined(&IWN_EEPROM)) {
    sub IWN_EEPROM () {	0x2c;}
}
unless(defined(&IWN_EEPROM_GP)) {
    sub IWN_EEPROM_GP () {	0x30;}
}
unless(defined(&IWN_OTP_GP)) {
    sub IWN_OTP_GP () {	0x34;}
}
unless(defined(&IWN_GIO)) {
    sub IWN_GIO () {	0x3c;}
}
unless(defined(&IWN_GP_DRIVER)) {
    sub IWN_GP_DRIVER () {	0x50;}
}
unless(defined(&IWN_UCODE_GP1_CLR)) {
    sub IWN_UCODE_GP1_CLR () {	0x5c;}
}
unless(defined(&IWN_LED)) {
    sub IWN_LED () {	0x94;}
}
unless(defined(&IWN_DRAM_INT_TBL)) {
    sub IWN_DRAM_INT_TBL () {	0xa0;}
}
unless(defined(&IWN_SHADOW_REG_CTRL)) {
    sub IWN_SHADOW_REG_CTRL () {	0xa8;}
}
unless(defined(&IWN_GIO_CHICKEN)) {
    sub IWN_GIO_CHICKEN () {	0x100;}
}
unless(defined(&IWN_ANA_PLL)) {
    sub IWN_ANA_PLL () {	0x20c;}
}
unless(defined(&IWN_HW_REV_WA)) {
    sub IWN_HW_REV_WA () {	0x22c;}
}
unless(defined(&IWN_DBG_HPET_MEM)) {
    sub IWN_DBG_HPET_MEM () {	0x240;}
}
unless(defined(&IWN_DBG_LINK_PWR_MGMT)) {
    sub IWN_DBG_LINK_PWR_MGMT () {	0x250;}
}
unless(defined(&IWN_MEM_RADDR)) {
    sub IWN_MEM_RADDR () {	0x40c;}
}
unless(defined(&IWN_MEM_WADDR)) {
    sub IWN_MEM_WADDR () {	0x410;}
}
unless(defined(&IWN_MEM_WDATA)) {
    sub IWN_MEM_WDATA () {	0x418;}
}
unless(defined(&IWN_MEM_RDATA)) {
    sub IWN_MEM_RDATA () {	0x41c;}
}
unless(defined(&IWN_PRPH_WADDR)) {
    sub IWN_PRPH_WADDR () {	0x444;}
}
unless(defined(&IWN_PRPH_RADDR)) {
    sub IWN_PRPH_RADDR () {	0x448;}
}
unless(defined(&IWN_PRPH_WDATA)) {
    sub IWN_PRPH_WDATA () {	0x44c;}
}
unless(defined(&IWN_PRPH_RDATA)) {
    sub IWN_PRPH_RDATA () {	0x450;}
}
unless(defined(&IWN_HBUS_TARG_WRPTR)) {
    sub IWN_HBUS_TARG_WRPTR () {	0x460;}
}
unless(defined(&IWN_FH_TFBD_CTRL0)) {
    sub IWN_FH_TFBD_CTRL0 {
	my($qid) = @_;
	eval q((0x1900 + ($qid) * 8));
    }
}
unless(defined(&IWN_FH_TFBD_CTRL1)) {
    sub IWN_FH_TFBD_CTRL1 {
	my($qid) = @_;
	eval q((0x1904 + ($qid) * 8));
    }
}
unless(defined(&IWN_FH_KW_ADDR)) {
    sub IWN_FH_KW_ADDR () {	0x197c;}
}
unless(defined(&IWN_FH_SRAM_ADDR)) {
    sub IWN_FH_SRAM_ADDR {
	my($qid) = @_;
	eval q((0x19a4 + ($qid) * 4));
    }
}
unless(defined(&IWN_FH_CBBC_QUEUE)) {
    sub IWN_FH_CBBC_QUEUE {
	my($qid) = @_;
	eval q((0x19d0 + ($qid) * 4));
    }
}
unless(defined(&IWN_FH_STATUS_WPTR)) {
    sub IWN_FH_STATUS_WPTR () {	0x1bc0;}
}
unless(defined(&IWN_FH_RX_BASE)) {
    sub IWN_FH_RX_BASE () {	0x1bc4;}
}
unless(defined(&IWN_FH_RX_WPTR)) {
    sub IWN_FH_RX_WPTR () {	0x1bc8;}
}
unless(defined(&IWN_FH_RX_CONFIG)) {
    sub IWN_FH_RX_CONFIG () {	0x1c00;}
}
unless(defined(&IWN_FH_RX_STATUS)) {
    sub IWN_FH_RX_STATUS () {	0x1c44;}
}
unless(defined(&IWN_FH_TX_CONFIG)) {
    sub IWN_FH_TX_CONFIG {
	my($qid) = @_;
	eval q((0x1d00 + ($qid) * 32));
    }
}
unless(defined(&IWN_FH_TXBUF_STATUS)) {
    sub IWN_FH_TXBUF_STATUS {
	my($qid) = @_;
	eval q((0x1d08 + ($qid) * 32));
    }
}
unless(defined(&IWN_FH_TX_CHICKEN)) {
    sub IWN_FH_TX_CHICKEN () {	0x1e98;}
}
unless(defined(&IWN_FH_TX_STATUS)) {
    sub IWN_FH_TX_STATUS () {	0x1eb0;}
}
unless(defined(&IWN_SCHED_BASE)) {
    sub IWN_SCHED_BASE () {	0xa02c00;}
}
unless(defined(&IWN_SCHED_SRAM_ADDR)) {
    sub IWN_SCHED_SRAM_ADDR () {	( &IWN_SCHED_BASE + 0x);}
}
unless(defined(&IWN5000_SCHED_DRAM_ADDR)) {
    sub IWN5000_SCHED_DRAM_ADDR () {	( &IWN_SCHED_BASE + 0x8);}
}
unless(defined(&IWN4965_SCHED_DRAM_ADDR)) {
    sub IWN4965_SCHED_DRAM_ADDR () {	( &IWN_SCHED_BASE + 0x10);}
}
unless(defined(&IWN5000_SCHED_TXFACT)) {
    sub IWN5000_SCHED_TXFACT () {	( &IWN_SCHED_BASE + 0x10);}
}
unless(defined(&IWN4965_SCHED_TXFACT)) {
    sub IWN4965_SCHED_TXFACT () {	( &IWN_SCHED_BASE + 0x1c);}
}
unless(defined(&IWN4965_SCHED_QUEUE_RDPTR)) {
    sub IWN4965_SCHED_QUEUE_RDPTR {
	my($qid) = @_;
	eval q(( &IWN_SCHED_BASE + 0x64 + ($qid) * 4));
    }
}
unless(defined(&IWN5000_SCHED_QUEUE_RDPTR)) {
    sub IWN5000_SCHED_QUEUE_RDPTR {
	my($qid) = @_;
	eval q(( &IWN_SCHED_BASE + 0x68 + ($qid) * 4));
    }
}
unless(defined(&IWN4965_SCHED_QCHAIN_SEL)) {
    sub IWN4965_SCHED_QCHAIN_SEL () {	( &IWN_SCHED_BASE + 0xd0);}
}
unless(defined(&IWN4965_SCHED_INTR_MASK)) {
    sub IWN4965_SCHED_INTR_MASK () {	( &IWN_SCHED_BASE + 0xe4);}
}
unless(defined(&IWN5000_SCHED_QCHAIN_SEL)) {
    sub IWN5000_SCHED_QCHAIN_SEL () {	( &IWN_SCHED_BASE + 0xe8);}
}
unless(defined(&IWN4965_SCHED_QUEUE_STATUS)) {
    sub IWN4965_SCHED_QUEUE_STATUS {
	my($qid) = @_;
	eval q(( &IWN_SCHED_BASE + 0x104 + ($qid) * 4));
    }
}
unless(defined(&IWN5000_SCHED_INTR_MASK)) {
    sub IWN5000_SCHED_INTR_MASK () {	( &IWN_SCHED_BASE + 0x108);}
}
unless(defined(&IWN5000_SCHED_QUEUE_STATUS)) {
    sub IWN5000_SCHED_QUEUE_STATUS {
	my($qid) = @_;
	eval q(( &IWN_SCHED_BASE + 0x10c + ($qid) * 4));
    }
}
unless(defined(&IWN5000_SCHED_AGGR_SEL)) {
    sub IWN5000_SCHED_AGGR_SEL () {	( &IWN_SCHED_BASE + 0x248);}
}
unless(defined(&IWN4965_SCHED_CTX_OFF)) {
    sub IWN4965_SCHED_CTX_OFF () {	0x380;}
}
unless(defined(&IWN4965_SCHED_CTX_LEN)) {
    sub IWN4965_SCHED_CTX_LEN () {	416;}
}
unless(defined(&IWN4965_SCHED_QUEUE_OFFSET)) {
    sub IWN4965_SCHED_QUEUE_OFFSET {
	my($qid) = @_;
	eval q((0x380 + ($qid) * 8));
    }
}
unless(defined(&IWN4965_SCHED_TRANS_TBL)) {
    sub IWN4965_SCHED_TRANS_TBL {
	my($qid) = @_;
	eval q((0x500 + ($qid) * 2));
    }
}
unless(defined(&IWN5000_SCHED_CTX_OFF)) {
    sub IWN5000_SCHED_CTX_OFF () {	0x600;}
}
unless(defined(&IWN5000_SCHED_CTX_LEN)) {
    sub IWN5000_SCHED_CTX_LEN () {	520;}
}
unless(defined(&IWN5000_SCHED_QUEUE_OFFSET)) {
    sub IWN5000_SCHED_QUEUE_OFFSET {
	my($qid) = @_;
	eval q((0x600 + ($qid) * 8));
    }
}
unless(defined(&IWN5000_SCHED_TRANS_TBL)) {
    sub IWN5000_SCHED_TRANS_TBL {
	my($qid) = @_;
	eval q((0x7e0 + ($qid) * 2));
    }
}
unless(defined(&IWN_APMG_CLK_CTRL)) {
    sub IWN_APMG_CLK_CTRL () {	0x3000;}
}
unless(defined(&IWN_APMG_CLK_EN)) {
    sub IWN_APMG_CLK_EN () {	0x3004;}
}
unless(defined(&IWN_APMG_CLK_DIS)) {
    sub IWN_APMG_CLK_DIS () {	0x3008;}
}
unless(defined(&IWN_APMG_PS)) {
    sub IWN_APMG_PS () {	0x300c;}
}
unless(defined(&IWN_APMG_DIGITAL_SVR)) {
    sub IWN_APMG_DIGITAL_SVR () {	0x3058;}
}
unless(defined(&IWN_APMG_ANALOG_SVR)) {
    sub IWN_APMG_ANALOG_SVR () {	0x306c;}
}
unless(defined(&IWN_APMG_PCI_STT)) {
    sub IWN_APMG_PCI_STT () {	0x3010;}
}
unless(defined(&IWN_BSM_WR_CTRL)) {
    sub IWN_BSM_WR_CTRL () {	0x3400;}
}
unless(defined(&IWN_BSM_WR_MEM_SRC)) {
    sub IWN_BSM_WR_MEM_SRC () {	0x3404;}
}
unless(defined(&IWN_BSM_WR_MEM_DST)) {
    sub IWN_BSM_WR_MEM_DST () {	0x3408;}
}
unless(defined(&IWN_BSM_WR_DWCOUNT)) {
    sub IWN_BSM_WR_DWCOUNT () {	0x340c;}
}
unless(defined(&IWN_BSM_DRAM_TEXT_ADDR)) {
    sub IWN_BSM_DRAM_TEXT_ADDR () {	0x3490;}
}
unless(defined(&IWN_BSM_DRAM_TEXT_SIZE)) {
    sub IWN_BSM_DRAM_TEXT_SIZE () {	0x3494;}
}
unless(defined(&IWN_BSM_DRAM_DATA_ADDR)) {
    sub IWN_BSM_DRAM_DATA_ADDR () {	0x3498;}
}
unless(defined(&IWN_BSM_DRAM_DATA_SIZE)) {
    sub IWN_BSM_DRAM_DATA_SIZE () {	0x349c;}
}
unless(defined(&IWN_BSM_SRAM_BASE)) {
    sub IWN_BSM_SRAM_BASE () {	0x3800;}
}
unless(defined(&IWN_HW_IF_CONFIG_4965_R)) {
    sub IWN_HW_IF_CONFIG_4965_R () {	(1<< 4);}
}
unless(defined(&IWN_HW_IF_CONFIG_MAC_SI)) {
    sub IWN_HW_IF_CONFIG_MAC_SI () {	(1<< 8);}
}
unless(defined(&IWN_HW_IF_CONFIG_RADIO_SI)) {
    sub IWN_HW_IF_CONFIG_RADIO_SI () {	(1<< 9);}
}
unless(defined(&IWN_HW_IF_CONFIG_EEPROM_LOCKED)) {
    sub IWN_HW_IF_CONFIG_EEPROM_LOCKED () {	(1<< 21);}
}
unless(defined(&IWN_HW_IF_CONFIG_NIC_READY)) {
    sub IWN_HW_IF_CONFIG_NIC_READY () {	(1<< 22);}
}
unless(defined(&IWN_HW_IF_CONFIG_HAP_WAKE_L1A)) {
    sub IWN_HW_IF_CONFIG_HAP_WAKE_L1A () {	(1<< 23);}
}
unless(defined(&IWN_HW_IF_CONFIG_PREPARE_DONE)) {
    sub IWN_HW_IF_CONFIG_PREPARE_DONE () {	(1<< 25);}
}
unless(defined(&IWN_HW_IF_CONFIG_PREPARE)) {
    sub IWN_HW_IF_CONFIG_PREPARE () {	(1<< 27);}
}
unless(defined(&IWN_INT_PERIODIC_DIS)) {
    sub IWN_INT_PERIODIC_DIS () {	0x;}
}
unless(defined(&IWN_INT_PERIODIC_ENA)) {
    sub IWN_INT_PERIODIC_ENA () {	0xff;}
}
unless(defined(&IWN_PRPH_DWORD)) {
    sub IWN_PRPH_DWORD () {	(($sizeof{ &uint32_t} - 1) << 24);}
}
unless(defined(&IWN_FW_TEXT_BASE)) {
    sub IWN_FW_TEXT_BASE () {	0x;}
}
unless(defined(&IWN_FW_DATA_BASE)) {
    sub IWN_FW_DATA_BASE () {	0x800000;}
}
unless(defined(&IWN_RESET_NEVO)) {
    sub IWN_RESET_NEVO () {	(1<< 0);}
}
unless(defined(&IWN_RESET_SW)) {
    sub IWN_RESET_SW () {	(1<< 7);}
}
unless(defined(&IWN_RESET_MASTER_DISABLED)) {
    sub IWN_RESET_MASTER_DISABLED () {	(1<< 8);}
}
unless(defined(&IWN_RESET_STOP_MASTER)) {
    sub IWN_RESET_STOP_MASTER () {	(1<< 9);}
}
unless(defined(&IWN_RESET_LINK_PWR_MGMT_DIS)) {
    sub IWN_RESET_LINK_PWR_MGMT_DIS () {	(1<< 31);}
}
unless(defined(&IWN_GP_CNTRL_MAC_ACCESS_ENA)) {
    sub IWN_GP_CNTRL_MAC_ACCESS_ENA () {	(1<< 0);}
}
unless(defined(&IWN_GP_CNTRL_MAC_CLOCK_READY)) {
    sub IWN_GP_CNTRL_MAC_CLOCK_READY () {	(1<< 0);}
}
unless(defined(&IWN_GP_CNTRL_INIT_DONE)) {
    sub IWN_GP_CNTRL_INIT_DONE () {	(1<< 2);}
}
unless(defined(&IWN_GP_CNTRL_MAC_ACCESS_REQ)) {
    sub IWN_GP_CNTRL_MAC_ACCESS_REQ () {	(1<< 3);}
}
unless(defined(&IWN_GP_CNTRL_SLEEP)) {
    sub IWN_GP_CNTRL_SLEEP () {	(1<< 4);}
}
unless(defined(&IWN_GP_CNTRL_RFKILL)) {
    sub IWN_GP_CNTRL_RFKILL () {	(1<< 27);}
}
unless(defined(&IWN_HW_REV_TYPE_SHIFT)) {
    sub IWN_HW_REV_TYPE_SHIFT () {	4;}
}
unless(defined(&IWN_HW_REV_TYPE_MASK)) {
    sub IWN_HW_REV_TYPE_MASK () {	0xf0;}
}
unless(defined(&IWN_HW_REV_TYPE_4965)) {
    sub IWN_HW_REV_TYPE_4965 () {	0;}
}
unless(defined(&IWN_HW_REV_TYPE_5300)) {
    sub IWN_HW_REV_TYPE_5300 () {	2;}
}
unless(defined(&IWN_HW_REV_TYPE_5350)) {
    sub IWN_HW_REV_TYPE_5350 () {	3;}
}
unless(defined(&IWN_HW_REV_TYPE_5150)) {
    sub IWN_HW_REV_TYPE_5150 () {	4;}
}
unless(defined(&IWN_HW_REV_TYPE_5100)) {
    sub IWN_HW_REV_TYPE_5100 () {	5;}
}
unless(defined(&IWN_HW_REV_TYPE_1000)) {
    sub IWN_HW_REV_TYPE_1000 () {	6;}
}
unless(defined(&IWN_HW_REV_TYPE_6000)) {
    sub IWN_HW_REV_TYPE_6000 () {	7;}
}
unless(defined(&IWN_HW_REV_TYPE_6050)) {
    sub IWN_HW_REV_TYPE_6050 () {	8;}
}
unless(defined(&IWN_HW_REV_TYPE_6005)) {
    sub IWN_HW_REV_TYPE_6005 () {	11;}
}
unless(defined(&IWN_GIO_CHICKEN_L1A_NO_L0S_RX)) {
    sub IWN_GIO_CHICKEN_L1A_NO_L0S_RX () {	(1<< 23);}
}
unless(defined(&IWN_GIO_CHICKEN_DIS_L0S_TIMER)) {
    sub IWN_GIO_CHICKEN_DIS_L0S_TIMER () {	(1<< 29);}
}
unless(defined(&IWN_GIO_L0S_ENA)) {
    sub IWN_GIO_L0S_ENA () {	(1<< 1);}
}
unless(defined(&IWN_GP_DRIVER_RADIO_3X3_HYB)) {
    sub IWN_GP_DRIVER_RADIO_3X3_HYB () {	(0<< 0);}
}
unless(defined(&IWN_GP_DRIVER_RADIO_2X2_HYB)) {
    sub IWN_GP_DRIVER_RADIO_2X2_HYB () {	(1<< 0);}
}
unless(defined(&IWN_GP_DRIVER_RADIO_2X2_IPA)) {
    sub IWN_GP_DRIVER_RADIO_2X2_IPA () {	(2<< 0);}
}
unless(defined(&IWN_GP_DRIVER_CALIB_VER6)) {
    sub IWN_GP_DRIVER_CALIB_VER6 () {	(1<< 2);}
}
unless(defined(&IWN_GP_DRIVER_6050_1X2)) {
    sub IWN_GP_DRIVER_6050_1X2 () {	(1<< 3);}
}
unless(defined(&IWN_UCODE_GP1_RFKILL)) {
    sub IWN_UCODE_GP1_RFKILL () {	(1<< 1);}
}
unless(defined(&IWN_UCODE_GP1_CMD_BLOCKED)) {
    sub IWN_UCODE_GP1_CMD_BLOCKED () {	(1<< 2);}
}
unless(defined(&IWN_UCODE_GP1_CTEMP_STOP_RF)) {
    sub IWN_UCODE_GP1_CTEMP_STOP_RF () {	(1<< 3);}
}
unless(defined(&IWN_LED_BSM_CTRL)) {
    sub IWN_LED_BSM_CTRL () {	(1<< 5);}
}
unless(defined(&IWN_LED_OFF)) {
    sub IWN_LED_OFF () {	0x38;}
}
unless(defined(&IWN_LED_ON)) {
    sub IWN_LED_ON () {	0x78;}
}
unless(defined(&IWN_DRAM_INT_TBL_WRAP_CHECK)) {
    sub IWN_DRAM_INT_TBL_WRAP_CHECK () {	(1<< 27);}
}
unless(defined(&IWN_DRAM_INT_TBL_ENABLE)) {
    sub IWN_DRAM_INT_TBL_ENABLE () {	(1<< 31);}
}
unless(defined(&IWN_ANA_PLL_INIT)) {
    sub IWN_ANA_PLL_INIT () {	0x880300;}
}
unless(defined(&IWN_FH_RX_STATUS_IDLE)) {
    sub IWN_FH_RX_STATUS_IDLE () {	(1<< 24);}
}
unless(defined(&IWN_BSM_WR_CTRL_START_EN)) {
    sub IWN_BSM_WR_CTRL_START_EN () {	(1<< 30);}
}
unless(defined(&IWN_BSM_WR_CTRL_START)) {
    sub IWN_BSM_WR_CTRL_START () {	(1<< 31);}
}
unless(defined(&IWN_INT_ALIVE)) {
    sub IWN_INT_ALIVE () {	(1<< 0);}
}
unless(defined(&IWN_INT_WAKEUP)) {
    sub IWN_INT_WAKEUP () {	(1<< 1);}
}
unless(defined(&IWN_INT_SW_RX)) {
    sub IWN_INT_SW_RX () {	(1<< 3);}
}
unless(defined(&IWN_INT_CT_REACHED)) {
    sub IWN_INT_CT_REACHED () {	(1<< 6);}
}
unless(defined(&IWN_INT_RF_TOGGLED)) {
    sub IWN_INT_RF_TOGGLED () {	(1<< 7);}
}
unless(defined(&IWN_INT_SW_ERR)) {
    sub IWN_INT_SW_ERR () {	(1<< 25);}
}
unless(defined(&IWN_INT_SCHED)) {
    sub IWN_INT_SCHED () {	(1<< 26);}
}
unless(defined(&IWN_INT_FH_TX)) {
    sub IWN_INT_FH_TX () {	(1<< 27);}
}
unless(defined(&IWN_INT_RX_PERIODIC)) {
    sub IWN_INT_RX_PERIODIC () {	(1<< 28);}
}
unless(defined(&IWN_INT_HW_ERR)) {
    sub IWN_INT_HW_ERR () {	(1<< 29);}
}
unless(defined(&IWN_INT_FH_RX)) {
    sub IWN_INT_FH_RX () {	(1<< 31);}
}
unless(defined(&IWN_INT_MASK_DEF)) {
    sub IWN_INT_MASK_DEF () {	( &IWN_INT_SW_ERR |  &IWN_INT_HW_ERR |  &IWN_INT_FH_TX |  &IWN_INT_FH_RX |  &IWN_INT_ALIVE |  &IWN_INT_WAKEUP |  &IWN_INT_SW_RX |  &IWN_INT_CT_REACHED |  &IWN_INT_RF_TOGGLED);}
}
unless(defined(&IWN_FH_INT_TX_CHNL)) {
    sub IWN_FH_INT_TX_CHNL {
	my($x) = @_;
	eval q((1<< ($x)));
    }
}
unless(defined(&IWN_FH_INT_RX_CHNL)) {
    sub IWN_FH_INT_RX_CHNL {
	my($x) = @_;
	eval q((1<< (($x) + 16)));
    }
}
unless(defined(&IWN_FH_INT_HI_PRIOR)) {
    sub IWN_FH_INT_HI_PRIOR () {	(1<< 30);}
}
unless(defined(&IWN_FH_INT_TX)) {
    sub IWN_FH_INT_TX () {	( &IWN_FH_INT_TX_CHNL(0) |  &IWN_FH_INT_TX_CHNL(1));}
}
unless(defined(&IWN_FH_INT_RX)) {
    sub IWN_FH_INT_RX () {	( &IWN_FH_INT_RX_CHNL(0) |  &IWN_FH_INT_RX_CHNL(1) |  &IWN_FH_INT_HI_PRIOR);}
}
unless(defined(&IWN_FH_TX_CONFIG_DMA_PAUSE)) {
    sub IWN_FH_TX_CONFIG_DMA_PAUSE () {	0;}
}
unless(defined(&IWN_FH_TX_CONFIG_DMA_ENA)) {
    sub IWN_FH_TX_CONFIG_DMA_ENA () {	(1<< 31);}
}
unless(defined(&IWN_FH_TX_CONFIG_CIRQ_HOST_ENDTFD)) {
    sub IWN_FH_TX_CONFIG_CIRQ_HOST_ENDTFD () {	(1<< 20);}
}
unless(defined(&IWN_FH_TXBUF_STATUS_TBNUM)) {
    sub IWN_FH_TXBUF_STATUS_TBNUM {
	my($x) = @_;
	eval q((($x) << 20));
    }
}
unless(defined(&IWN_FH_TXBUF_STATUS_TBIDX)) {
    sub IWN_FH_TXBUF_STATUS_TBIDX {
	my($x) = @_;
	eval q((($x) << 12));
    }
}
unless(defined(&IWN_FH_TXBUF_STATUS_TFBD_VALID)) {
    sub IWN_FH_TXBUF_STATUS_TFBD_VALID () {	3;}
}
unless(defined(&IWN_FH_TX_CHICKEN_SCHED_RETRY)) {
    sub IWN_FH_TX_CHICKEN_SCHED_RETRY () {	(1<< 1);}
}
unless(defined(&IWN_FH_TX_STATUS_IDLE)) {
    sub IWN_FH_TX_STATUS_IDLE {
	my($chnl) = @_;
	eval q((1<< (($chnl) + 16)));
    }
}
unless(defined(&IWN_FH_RX_CONFIG_ENA)) {
    sub IWN_FH_RX_CONFIG_ENA () {	(1<< 31);}
}
unless(defined(&IWN_FH_RX_CONFIG_NRBD)) {
    sub IWN_FH_RX_CONFIG_NRBD {
	my($x) = @_;
	eval q((($x) << 20));
    }
}
unless(defined(&IWN_FH_RX_CONFIG_RB_SIZE_8K)) {
    sub IWN_FH_RX_CONFIG_RB_SIZE_8K () {	(1<< 16);}
}
unless(defined(&IWN_FH_RX_CONFIG_SINGLE_FRAME)) {
    sub IWN_FH_RX_CONFIG_SINGLE_FRAME () {	(1<< 15);}
}
unless(defined(&IWN_FH_RX_CONFIG_IRQ_DST_HOST)) {
    sub IWN_FH_RX_CONFIG_IRQ_DST_HOST () {	(1<< 12);}
}
unless(defined(&IWN_FH_RX_CONFIG_RB_TIMEOUT)) {
    sub IWN_FH_RX_CONFIG_RB_TIMEOUT {
	my($x) = @_;
	eval q((($x) << 4));
    }
}
unless(defined(&IWN_FH_RX_CONFIG_IGN_RXF_EMPTY)) {
    sub IWN_FH_RX_CONFIG_IGN_RXF_EMPTY () {	(1<< 2);}
}
unless(defined(&IWN_FH_TX_CONFIG_DMA_ENA)) {
    sub IWN_FH_TX_CONFIG_DMA_ENA () {	(1<< 31);}
}
unless(defined(&IWN_FH_TX_CONFIG_DMA_CREDIT_ENA)) {
    sub IWN_FH_TX_CONFIG_DMA_CREDIT_ENA () {	(1<< 3);}
}
unless(defined(&IWN_EEPROM_READ_VALID)) {
    sub IWN_EEPROM_READ_VALID () {	(1<< 0);}
}
unless(defined(&IWN_EEPROM_CMD)) {
    sub IWN_EEPROM_CMD () {	(1<< 1);}
}
unless(defined(&IWN_EEPROM_GP_IF_OWNER)) {
    sub IWN_EEPROM_GP_IF_OWNER () {	0x180;}
}
unless(defined(&IWN_OTP_GP_DEV_SEL_OTP)) {
    sub IWN_OTP_GP_DEV_SEL_OTP () {	(1<< 16);}
}
unless(defined(&IWN_OTP_GP_RELATIVE_ACCESS)) {
    sub IWN_OTP_GP_RELATIVE_ACCESS () {	(1<< 17);}
}
unless(defined(&IWN_OTP_GP_ECC_CORR_STTS)) {
    sub IWN_OTP_GP_ECC_CORR_STTS () {	(1<< 20);}
}
unless(defined(&IWN_OTP_GP_ECC_UNCORR_STTS)) {
    sub IWN_OTP_GP_ECC_UNCORR_STTS () {	(1<< 21);}
}
unless(defined(&IWN4965_TXQ_STATUS_ACTIVE)) {
    sub IWN4965_TXQ_STATUS_ACTIVE () {	0x7fc01;}
}
unless(defined(&IWN4965_TXQ_STATUS_INACTIVE)) {
    sub IWN4965_TXQ_STATUS_INACTIVE () {	0x7fc00;}
}
unless(defined(&IWN4965_TXQ_STATUS_AGGR_ENA)) {
    sub IWN4965_TXQ_STATUS_AGGR_ENA () {	(1<< 5| 1<< 8);}
}
unless(defined(&IWN4965_TXQ_STATUS_CHGACT)) {
    sub IWN4965_TXQ_STATUS_CHGACT () {	(1<< 10);}
}
unless(defined(&IWN5000_TXQ_STATUS_ACTIVE)) {
    sub IWN5000_TXQ_STATUS_ACTIVE () {	0xff0018;}
}
unless(defined(&IWN5000_TXQ_STATUS_INACTIVE)) {
    sub IWN5000_TXQ_STATUS_INACTIVE () {	0xff0010;}
}
unless(defined(&IWN5000_TXQ_STATUS_CHGACT)) {
    sub IWN5000_TXQ_STATUS_CHGACT () {	(1<< 19);}
}
unless(defined(&IWN_APMG_CLK_CTRL_DMA_CLK_RQT)) {
    sub IWN_APMG_CLK_CTRL_DMA_CLK_RQT () {	(1<< 9);}
}
unless(defined(&IWN_APMG_CLK_CTRL_BSM_CLK_RQT)) {
    sub IWN_APMG_CLK_CTRL_BSM_CLK_RQT () {	(1<< 11);}
}
unless(defined(&IWN_APMG_PS_EARLY_PWROFF_DIS)) {
    sub IWN_APMG_PS_EARLY_PWROFF_DIS () {	(1<< 22);}
}
unless(defined(&IWN_APMG_PS_PWR_SRC)) {
    sub IWN_APMG_PS_PWR_SRC {
	my($x) = @_;
	eval q((($x) << 24));
    }
}
unless(defined(&IWN_APMG_PS_PWR_SRC_VMAIN)) {
    sub IWN_APMG_PS_PWR_SRC_VMAIN () {	0;}
}
unless(defined(&IWN_APMG_PS_PWR_SRC_VAUX)) {
    sub IWN_APMG_PS_PWR_SRC_VAUX () {	2;}
}
unless(defined(&IWN_APMG_PS_PWR_SRC_MASK)) {
    sub IWN_APMG_PS_PWR_SRC_MASK () {	 &IWN_APMG_PS_PWR_SRC(3);}
}
unless(defined(&IWN_APMG_PS_RESET_REQ)) {
    sub IWN_APMG_PS_RESET_REQ () {	(1<< 26);}
}
unless(defined(&IWN_APMG_DIGITAL_SVR_VOLTAGE)) {
    sub IWN_APMG_DIGITAL_SVR_VOLTAGE {
	my($x) = @_;
	eval q(((($x) & 0xf) << 5));
    }
}
unless(defined(&IWN_APMG_DIGITAL_SVR_VOLTAGE_MASK)) {
    sub IWN_APMG_DIGITAL_SVR_VOLTAGE_MASK () {	 &IWN_APMG_DIGITAL_SVR_VOLTAGE(0xf);}
}
unless(defined(&IWN_APMG_DIGITAL_SVR_VOLTAGE_1_32)) {
    sub IWN_APMG_DIGITAL_SVR_VOLTAGE_1_32 () {	 &IWN_APMG_DIGITAL_SVR_VOLTAGE(3);}
}
unless(defined(&IWN_APMG_PCI_STT_L1A_DIS)) {
    sub IWN_APMG_PCI_STT_L1A_DIS () {	(1<< 11);}
}
unless(defined(&IWN_FW_UPDATED)) {
    sub IWN_FW_UPDATED () {	(1<< 31);}
}
unless(defined(&IWN_SCHED_WINSZ)) {
    sub IWN_SCHED_WINSZ () {	64;}
}
unless(defined(&IWN_SCHED_LIMIT)) {
    sub IWN_SCHED_LIMIT () {	64;}
}
unless(defined(&IWN4965_SCHED_COUNT)) {
    sub IWN4965_SCHED_COUNT () {	512;}
}
unless(defined(&IWN5000_SCHED_COUNT)) {
    sub IWN5000_SCHED_COUNT () {	( &IWN_TX_RING_COUNT +  &IWN_SCHED_WINSZ);}
}
unless(defined(&IWN4965_SCHEDSZ)) {
    sub IWN4965_SCHEDSZ () {	( &IWN4965_NTXQUEUES *  &IWN4965_SCHED_COUNT * 2);}
}
unless(defined(&IWN5000_SCHEDSZ)) {
    sub IWN5000_SCHEDSZ () {	( &IWN5000_NTXQUEUES *  &IWN5000_SCHED_COUNT * 2);}
}
unless(defined(&IWN_UC_READY)) {
    sub IWN_UC_READY () {	1;}
}
unless(defined(&IWN_ADD_NODE_DONE)) {
    sub IWN_ADD_NODE_DONE () {	24;}
}
unless(defined(&IWN_TX_DONE)) {
    sub IWN_TX_DONE () {	28;}
}
unless(defined(&IWN5000_CALIBRATION_RESULT)) {
    sub IWN5000_CALIBRATION_RESULT () {	102;}
}
unless(defined(&IWN5000_CALIBRATION_DONE)) {
    sub IWN5000_CALIBRATION_DONE () {	103;}
}
unless(defined(&IWN_START_SCAN)) {
    sub IWN_START_SCAN () {	130;}
}
unless(defined(&IWN_STOP_SCAN)) {
    sub IWN_STOP_SCAN () {	132;}
}
unless(defined(&IWN_RX_STATISTICS)) {
    sub IWN_RX_STATISTICS () {	156;}
}
unless(defined(&IWN_BEACON_STATISTICS)) {
    sub IWN_BEACON_STATISTICS () {	157;}
}
unless(defined(&IWN_STATE_CHANGED)) {
    sub IWN_STATE_CHANGED () {	161;}
}
unless(defined(&IWN_BEACON_MISSED)) {
    sub IWN_BEACON_MISSED () {	162;}
}
unless(defined(&IWN_RX_PHY)) {
    sub IWN_RX_PHY () {	192;}
}
unless(defined(&IWN_MPDU_RX_DONE)) {
    sub IWN_MPDU_RX_DONE () {	193;}
}
unless(defined(&IWN_RX_DONE)) {
    sub IWN_RX_DONE () {	195;}
}
unless(defined(&IWN_RX_COMPRESSED_BA)) {
    sub IWN_RX_COMPRESSED_BA () {	197;}
}
unless(defined(&IWN_RX_NO_CRC_ERR)) {
    sub IWN_RX_NO_CRC_ERR () {	(1<< 0);}
}
unless(defined(&IWN_RX_NO_OVFL_ERR)) {
    sub IWN_RX_NO_OVFL_ERR () {	(1<< 1);}
}
unless(defined(&IWN_RX_NOERROR)) {
    sub IWN_RX_NOERROR () {	( &IWN_RX_NO_CRC_ERR |  &IWN_RX_NO_OVFL_ERR);}
}
unless(defined(&IWN_RX_MPDU_MIC_OK)) {
    sub IWN_RX_MPDU_MIC_OK () {	(1<< 6);}
}
unless(defined(&IWN_RX_CIPHER_MASK)) {
    sub IWN_RX_CIPHER_MASK () {	(7<< 8);}
}
unless(defined(&IWN_RX_CIPHER_CCMP)) {
    sub IWN_RX_CIPHER_CCMP () {	(2<< 8);}
}
unless(defined(&IWN_RX_MPDU_DEC)) {
    sub IWN_RX_MPDU_DEC () {	(1<< 11);}
}
unless(defined(&IWN_RX_DECRYPT_MASK)) {
    sub IWN_RX_DECRYPT_MASK () {	(3<< 11);}
}
unless(defined(&IWN_RX_DECRYPT_OK)) {
    sub IWN_RX_DECRYPT_OK () {	(3<< 11);}
}
unless(defined(&IWN_CMD_RXON)) {
    sub IWN_CMD_RXON () {	16;}
}
unless(defined(&IWN_CMD_RXON_ASSOC)) {
    sub IWN_CMD_RXON_ASSOC () {	17;}
}
unless(defined(&IWN_CMD_EDCA_PARAMS)) {
    sub IWN_CMD_EDCA_PARAMS () {	19;}
}
unless(defined(&IWN_CMD_TIMING)) {
    sub IWN_CMD_TIMING () {	20;}
}
unless(defined(&IWN_CMD_ADD_NODE)) {
    sub IWN_CMD_ADD_NODE () {	24;}
}
unless(defined(&IWN_CMD_TX_DATA)) {
    sub IWN_CMD_TX_DATA () {	28;}
}
unless(defined(&IWN_CMD_LINK_QUALITY)) {
    sub IWN_CMD_LINK_QUALITY () {	78;}
}
unless(defined(&IWN_CMD_SET_LED)) {
    sub IWN_CMD_SET_LED () {	72;}
}
unless(defined(&IWN5000_CMD_WIMAX_COEX)) {
    sub IWN5000_CMD_WIMAX_COEX () {	90;}
}
unless(defined(&IWN5000_CMD_CALIB_CONFIG)) {
    sub IWN5000_CMD_CALIB_CONFIG () {	101;}
}
unless(defined(&IWN_CMD_SET_POWER_MODE)) {
    sub IWN_CMD_SET_POWER_MODE () {	119;}
}
unless(defined(&IWN_CMD_SCAN)) {
    sub IWN_CMD_SCAN () {	128;}
}
unless(defined(&IWN_CMD_TXPOWER_DBM)) {
    sub IWN_CMD_TXPOWER_DBM () {	149;}
}
unless(defined(&IWN_CMD_TXPOWER)) {
    sub IWN_CMD_TXPOWER () {	151;}
}
unless(defined(&IWN5000_CMD_TX_ANT_CONFIG)) {
    sub IWN5000_CMD_TX_ANT_CONFIG () {	152;}
}
unless(defined(&IWN_CMD_BT_COEX)) {
    sub IWN_CMD_BT_COEX () {	155;}
}
unless(defined(&IWN_CMD_GET_STATISTICS)) {
    sub IWN_CMD_GET_STATISTICS () {	156;}
}
unless(defined(&IWN_CMD_SET_CRITICAL_TEMP)) {
    sub IWN_CMD_SET_CRITICAL_TEMP () {	164;}
}
unless(defined(&IWN_CMD_SET_SENSITIVITY)) {
    sub IWN_CMD_SET_SENSITIVITY () {	168;}
}
unless(defined(&IWN_CMD_PHY_CALIB)) {
    sub IWN_CMD_PHY_CALIB () {	176;}
}
unless(defined(&IWN_ANT_A)) {
    sub IWN_ANT_A () {	(1<< 0);}
}
unless(defined(&IWN_ANT_B)) {
    sub IWN_ANT_B () {	(1<< 1);}
}
unless(defined(&IWN_ANT_C)) {
    sub IWN_ANT_C () {	(1<< 2);}
}
unless(defined(&IWN_ANT_AB)) {
    sub IWN_ANT_AB () {	( &IWN_ANT_A |  &IWN_ANT_B);}
}
unless(defined(&IWN_ANT_BC)) {
    sub IWN_ANT_BC () {	( &IWN_ANT_B |  &IWN_ANT_C);}
}
unless(defined(&IWN_ANT_ABC)) {
    sub IWN_ANT_ABC () {	( &IWN_ANT_A |  &IWN_ANT_B |  &IWN_ANT_C);}
}
unless(defined(&IWN_MODE_HOSTAP)) {
    sub IWN_MODE_HOSTAP () {	1;}
}
unless(defined(&IWN_MODE_STA)) {
    sub IWN_MODE_STA () {	3;}
}
unless(defined(&IWN_MODE_IBSS)) {
    sub IWN_MODE_IBSS () {	4;}
}
unless(defined(&IWN_MODE_MONITOR)) {
    sub IWN_MODE_MONITOR () {	6;}
}
unless(defined(&IWN_RXCHAIN_DRIVER_FORCE)) {
    sub IWN_RXCHAIN_DRIVER_FORCE () {	(1<< 0);}
}
unless(defined(&IWN_RXCHAIN_VALID)) {
    sub IWN_RXCHAIN_VALID {
	my($x) = @_;
	eval q(((($x) &  &IWN_ANT_ABC) << 1));
    }
}
unless(defined(&IWN_RXCHAIN_FORCE_SEL)) {
    sub IWN_RXCHAIN_FORCE_SEL {
	my($x) = @_;
	eval q(((($x) &  &IWN_ANT_ABC) << 4));
    }
}
unless(defined(&IWN_RXCHAIN_FORCE_MIMO_SEL)) {
    sub IWN_RXCHAIN_FORCE_MIMO_SEL {
	my($x) = @_;
	eval q(((($x) &  &IWN_ANT_ABC) << 7));
    }
}
unless(defined(&IWN_RXCHAIN_IDLE_COUNT)) {
    sub IWN_RXCHAIN_IDLE_COUNT {
	my($x) = @_;
	eval q((($x) << 10));
    }
}
unless(defined(&IWN_RXCHAIN_MIMO_COUNT)) {
    sub IWN_RXCHAIN_MIMO_COUNT {
	my($x) = @_;
	eval q((($x) << 12));
    }
}
unless(defined(&IWN_RXCHAIN_MIMO_FORCE)) {
    sub IWN_RXCHAIN_MIMO_FORCE () {	(1<< 14);}
}
unless(defined(&IWN_RXON_24GHZ)) {
    sub IWN_RXON_24GHZ () {	(1<< 0);}
}
unless(defined(&IWN_RXON_CCK)) {
    sub IWN_RXON_CCK () {	(1<< 1);}
}
unless(defined(&IWN_RXON_AUTO)) {
    sub IWN_RXON_AUTO () {	(1<< 2);}
}
unless(defined(&IWN_RXON_SHSLOT)) {
    sub IWN_RXON_SHSLOT () {	(1<< 4);}
}
unless(defined(&IWN_RXON_SHPREAMBLE)) {
    sub IWN_RXON_SHPREAMBLE () {	(1<< 5);}
}
unless(defined(&IWN_RXON_NODIVERSITY)) {
    sub IWN_RXON_NODIVERSITY () {	(1<< 7);}
}
unless(defined(&IWN_RXON_ANTENNA_A)) {
    sub IWN_RXON_ANTENNA_A () {	(1<< 8);}
}
unless(defined(&IWN_RXON_ANTENNA_B)) {
    sub IWN_RXON_ANTENNA_B () {	(1<< 9);}
}
unless(defined(&IWN_RXON_TSF)) {
    sub IWN_RXON_TSF () {	(1<< 15);}
}
unless(defined(&IWN_RXON_CTS_TO_SELF)) {
    sub IWN_RXON_CTS_TO_SELF () {	(1<< 30);}
}
unless(defined(&IWN_FILTER_PROMISC)) {
    sub IWN_FILTER_PROMISC () {	(1<< 0);}
}
unless(defined(&IWN_FILTER_CTL)) {
    sub IWN_FILTER_CTL () {	(1<< 1);}
}
unless(defined(&IWN_FILTER_MULTICAST)) {
    sub IWN_FILTER_MULTICAST () {	(1<< 2);}
}
unless(defined(&IWN_FILTER_NODECRYPT)) {
    sub IWN_FILTER_NODECRYPT () {	(1<< 3);}
}
unless(defined(&IWN_FILTER_BSS)) {
    sub IWN_FILTER_BSS () {	(1<< 5);}
}
unless(defined(&IWN_FILTER_BEACON)) {
    sub IWN_FILTER_BEACON () {	(1<< 6);}
}
unless(defined(&IWN4965_RXONSZ)) {
    sub IWN4965_RXONSZ () {	($sizeof{'struct iwn_rxon'} - 6);}
}
unless(defined(&IWN5000_RXONSZ)) {
    sub IWN5000_RXONSZ () {	($sizeof{'struct iwn_rxon'});}
}
unless(defined(&IWN_EDCA_UPDATE)) {
    sub IWN_EDCA_UPDATE () {	(1<< 0);}
}
unless(defined(&IWN_EDCA_TXOP)) {
    sub IWN_EDCA_TXOP () {	(1<< 4);}
}
unless(defined(&IWN_NODE_UPDATE)) {
    sub IWN_NODE_UPDATE () {	(1<< 0);}
}
unless(defined(&IWN_ID_BSS)) {
    sub IWN_ID_BSS () {	0;}
}
unless(defined(&IWN5000_ID_BROADCAST)) {
    sub IWN5000_ID_BROADCAST () {	15;}
}
unless(defined(&IWN4965_ID_BROADCAST)) {
    sub IWN4965_ID_BROADCAST () {	31;}
}
unless(defined(&IWN_FLAG_SET_KEY)) {
    sub IWN_FLAG_SET_KEY () {	(1<< 0);}
}
unless(defined(&IWN_FLAG_SET_DISABLE_TID)) {
    sub IWN_FLAG_SET_DISABLE_TID () {	(1<< 1);}
}
unless(defined(&IWN_FLAG_SET_TXRATE)) {
    sub IWN_FLAG_SET_TXRATE () {	(1<< 2);}
}
unless(defined(&IWN_FLAG_SET_ADDBA)) {
    sub IWN_FLAG_SET_ADDBA () {	(1<< 3);}
}
unless(defined(&IWN_FLAG_SET_DELBA)) {
    sub IWN_FLAG_SET_DELBA () {	(1<< 4);}
}
unless(defined(&IWN_KFLAG_CCMP)) {
    sub IWN_KFLAG_CCMP () {	(1<< 1);}
}
unless(defined(&IWN_KFLAG_MAP)) {
    sub IWN_KFLAG_MAP () {	(1<< 3);}
}
unless(defined(&IWN_KFLAG_KID)) {
    sub IWN_KFLAG_KID {
	my($kid) = @_;
	eval q((($kid) << 8));
    }
}
unless(defined(&IWN_KFLAG_INVALID)) {
    sub IWN_KFLAG_INVALID () {	(1<< 11);}
}
unless(defined(&IWN_KFLAG_GROUP)) {
    sub IWN_KFLAG_GROUP () {	(1<< 14);}
}
unless(defined(&IWN_AMDPU_SIZE_FACTOR)) {
    sub IWN_AMDPU_SIZE_FACTOR {
	my($x) = @_;
	eval q((($x) << 19));
    }
}
unless(defined(&IWN_AMDPU_DENSITY)) {
    sub IWN_AMDPU_DENSITY {
	my($x) = @_;
	eval q((($x) << 23));
    }
}
unless(defined(&IWN_RFLAG_CCK)) {
    sub IWN_RFLAG_CCK () {	(1<< 1);}
}
unless(defined(&IWN_RFLAG_ANT)) {
    sub IWN_RFLAG_ANT {
	my($x) = @_;
	eval q((($x) << 6));
    }
}
unless(defined(&IWN_TX_NEED_PROTECTION)) {
    sub IWN_TX_NEED_PROTECTION () {	(1<< 0);}
}
unless(defined(&IWN_TX_NEED_RTS)) {
    sub IWN_TX_NEED_RTS () {	(1<< 1);}
}
unless(defined(&IWN_TX_NEED_CTS)) {
    sub IWN_TX_NEED_CTS () {	(1<< 2);}
}
unless(defined(&IWN_TX_NEED_ACK)) {
    sub IWN_TX_NEED_ACK () {	(1<< 3);}
}
unless(defined(&IWN_TX_LINKQ)) {
    sub IWN_TX_LINKQ () {	(1<< 4);}
}
unless(defined(&IWN_TX_IMM_BA)) {
    sub IWN_TX_IMM_BA () {	(1<< 6);}
}
unless(defined(&IWN_TX_FULL_TXOP)) {
    sub IWN_TX_FULL_TXOP () {	(1<< 7);}
}
unless(defined(&IWN_TX_BT_DISABLE)) {
    sub IWN_TX_BT_DISABLE () {	(1<< 12);}
}
unless(defined(&IWN_TX_AUTO_SEQ)) {
    sub IWN_TX_AUTO_SEQ () {	(1<< 13);}
}
unless(defined(&IWN_TX_MORE_FRAG)) {
    sub IWN_TX_MORE_FRAG () {	(1<< 14);}
}
unless(defined(&IWN_TX_INSERT_TSTAMP)) {
    sub IWN_TX_INSERT_TSTAMP () {	(1<< 16);}
}
unless(defined(&IWN_TX_NEED_PADDING)) {
    sub IWN_TX_NEED_PADDING () {	(1<< 20);}
}
unless(defined(&IWN_CIPHER_WEP40)) {
    sub IWN_CIPHER_WEP40 () {	1;}
}
unless(defined(&IWN_CIPHER_CCMP)) {
    sub IWN_CIPHER_CCMP () {	2;}
}
unless(defined(&IWN_CIPHER_TKIP)) {
    sub IWN_CIPHER_TKIP () {	3;}
}
unless(defined(&IWN_CIPHER_WEP104)) {
    sub IWN_CIPHER_WEP104 () {	9;}
}
unless(defined(&IWN_LIFETIME_INFINITE)) {
    sub IWN_LIFETIME_INFINITE () {	0xffffffff;}
}
unless(defined(&IWN_MAX_TX_RETRIES)) {
    sub IWN_MAX_TX_RETRIES () {	16;}
}
unless(defined(&IWN_LED_ACTIVITY)) {
    sub IWN_LED_ACTIVITY () {	1;}
}
unless(defined(&IWN_LED_LINK)) {
    sub IWN_LED_LINK () {	2;}
}
unless(defined(&IWN_WIMAX_COEX_STA_TABLE_VALID)) {
    sub IWN_WIMAX_COEX_STA_TABLE_VALID () {	(1<< 0);}
}
unless(defined(&IWN_WIMAX_COEX_UNASSOC_WA_UNMASK)) {
    sub IWN_WIMAX_COEX_UNASSOC_WA_UNMASK () {	(1<< 2);}
}
unless(defined(&IWN_WIMAX_COEX_ASSOC_WA_UNMASK)) {
    sub IWN_WIMAX_COEX_ASSOC_WA_UNMASK () {	(1<< 3);}
}
unless(defined(&IWN_WIMAX_COEX_ENABLE)) {
    sub IWN_WIMAX_COEX_ENABLE () {	(1<< 7);}
}
unless(defined(&IWN5000_CALIB_DC)) {
    sub IWN5000_CALIB_DC () {	(1<< 1);}
}
unless(defined(&IWN_PS_ALLOW_SLEEP)) {
    sub IWN_PS_ALLOW_SLEEP () {	(1<< 0);}
}
unless(defined(&IWN_PS_NOTIFY)) {
    sub IWN_PS_NOTIFY () {	(1<< 1);}
}
unless(defined(&IWN_PS_SLEEP_OVER_DTIM)) {
    sub IWN_PS_SLEEP_OVER_DTIM () {	(1<< 2);}
}
unless(defined(&IWN_PS_PCI_PMGT)) {
    sub IWN_PS_PCI_PMGT () {	(1<< 3);}
}
unless(defined(&IWN_PS_FAST_PD)) {
    sub IWN_PS_FAST_PD () {	(1<< 4);}
}
unless(defined(&IWN_CHAN_ACTIVE)) {
    sub IWN_CHAN_ACTIVE () {	(1<< 0);}
}
unless(defined(&IWN_CHAN_NPBREQS)) {
    sub IWN_CHAN_NPBREQS {
	my($x) = @_;
	eval q((((1<< ($x)) - 1) << 1));
    }
}
unless(defined(&IWN_SCAN_MAXSZ)) {
    sub IWN_SCAN_MAXSZ () {	( &MCLBYTES - 4);}
}
unless(defined(&IWN_RIDX_MAX)) {
    sub IWN_RIDX_MAX () {	32;}
}
unless(defined(&IWN5000_TXPOWER_AUTO)) {
    sub IWN5000_TXPOWER_AUTO () {	0x7f;}
}
unless(defined(&IWN5000_TXPOWER_MAX_DBM)) {
    sub IWN5000_TXPOWER_MAX_DBM () {	16;}
}
unless(defined(&IWN5000_TXPOWER_NO_CLOSED)) {
    sub IWN5000_TXPOWER_NO_CLOSED () {	(1<< 6);}
}
unless(defined(&IWN_BT_COEX_CHAN_ANN)) {
    sub IWN_BT_COEX_CHAN_ANN () {	(1<< 0);}
}
unless(defined(&IWN_BT_COEX_BT_PRIO)) {
    sub IWN_BT_COEX_BT_PRIO () {	(1<< 1);}
}
unless(defined(&IWN_BT_COEX_2_WIRE)) {
    sub IWN_BT_COEX_2_WIRE () {	(1<< 2);}
}
unless(defined(&IWN_BT_LEAD_TIME_DEF)) {
    sub IWN_BT_LEAD_TIME_DEF () {	30;}
}
unless(defined(&IWN_BT_MAX_KILL_DEF)) {
    sub IWN_BT_MAX_KILL_DEF () {	5;}
}
unless(defined(&IWN_CTOK)) {
    sub IWN_CTOK {
	my($c) = @_;
	eval q((($c) + 273));
    }
}
unless(defined(&IWN_KTOC)) {
    sub IWN_KTOC {
	my($k) = @_;
	eval q((($k) - 273));
    }
}
unless(defined(&IWN_CTOMUK)) {
    sub IWN_CTOMUK {
	my($c) = @_;
	eval q(((($c) * 1000000) + 273150000));
    }
}
unless(defined(&IWN_SENSITIVITY_DEFAULTTBL)) {
    sub IWN_SENSITIVITY_DEFAULTTBL () {	0;}
}
unless(defined(&IWN_SENSITIVITY_WORKTBL)) {
    sub IWN_SENSITIVITY_WORKTBL () {	1;}
}
unless(defined(&IWN4965_PHY_CALIB_DIFF_GAIN)) {
    sub IWN4965_PHY_CALIB_DIFF_GAIN () {	7;}
}
unless(defined(&IWN5000_PHY_CALIB_DC)) {
    sub IWN5000_PHY_CALIB_DC () {	8;}
}
unless(defined(&IWN5000_PHY_CALIB_LO)) {
    sub IWN5000_PHY_CALIB_LO () {	9;}
}
unless(defined(&IWN5000_PHY_CALIB_TX_IQ)) {
    sub IWN5000_PHY_CALIB_TX_IQ () {	11;}
}
unless(defined(&IWN5000_PHY_CALIB_CRYSTAL)) {
    sub IWN5000_PHY_CALIB_CRYSTAL () {	15;}
}
unless(defined(&IWN5000_PHY_CALIB_BASE_BAND)) {
    sub IWN5000_PHY_CALIB_BASE_BAND () {	16;}
}
unless(defined(&IWN5000_PHY_CALIB_TX_IQ_PERIODIC)) {
    sub IWN5000_PHY_CALIB_TX_IQ_PERIODIC () {	17;}
}
unless(defined(&IWN5000_PHY_CALIB_TEMP_OFFSET)) {
    sub IWN5000_PHY_CALIB_TEMP_OFFSET () {	18;}
}
unless(defined(&IWN5000_PHY_CALIB_RESET_NOISE_GAIN)) {
    sub IWN5000_PHY_CALIB_RESET_NOISE_GAIN () {	18;}
}
unless(defined(&IWN5000_PHY_CALIB_NOISE_GAIN)) {
    sub IWN5000_PHY_CALIB_NOISE_GAIN () {	19;}
}
unless(defined(&IWN_DEFAULT_TEMP_OFFSET)) {
    sub IWN_DEFAULT_TEMP_OFFSET () {	2700;}
}
unless(defined(&IWN_MEASUREMENT_BASIC)) {
    sub IWN_MEASUREMENT_BASIC () {	(1<< 0);}
}
unless(defined(&IWN_MEASUREMENT_CCA)) {
    sub IWN_MEASUREMENT_CCA () {	(1<< 1);}
}
unless(defined(&IWN_MEASUREMENT_RPI_HISTOGRAM)) {
    sub IWN_MEASUREMENT_RPI_HISTOGRAM () {	(1<< 2);}
}
unless(defined(&IWN_MEASUREMENT_NOISE_HISTOGRAM)) {
    sub IWN_MEASUREMENT_NOISE_HISTOGRAM () {	(1<< 3);}
}
unless(defined(&IWN_MEASUREMENT_FRAME)) {
    sub IWN_MEASUREMENT_FRAME () {	(1<< 4);}
}
unless(defined(&IWN_MEASUREMENT_IDLE)) {
    sub IWN_MEASUREMENT_IDLE () {	(1<< 7);}
}
unless(defined(&IWN_NATTEN_GROUPS)) {
    sub IWN_NATTEN_GROUPS () {	5;}
}
unless(defined(&IWN_UCODE_RUNTIME)) {
    sub IWN_UCODE_RUNTIME () {	0;}
}
unless(defined(&IWN_UCODE_INIT)) {
    sub IWN_UCODE_INIT () {	9;}
}
unless(defined(&IWN_STAT_MAXLEN)) {
    sub IWN_STAT_MAXLEN () {	20;}
}
unless(defined(&IWN_STAT_FLAG_SHPREAMBLE)) {
    sub IWN_STAT_FLAG_SHPREAMBLE () {	(1<< 2);}
}
unless(defined(&IWN_RSSI_TO_DBM)) {
    sub IWN_RSSI_TO_DBM () {	44;}
}
unless(defined(&IWN_MEASUREMENT_START)) {
    sub IWN_MEASUREMENT_START () {	0;}
}
unless(defined(&IWN_MEASUREMENT_STOP)) {
    sub IWN_MEASUREMENT_STOP () {	1;}
}
unless(defined(&IWN_MEASUREMENT_OK)) {
    sub IWN_MEASUREMENT_OK () {	0;}
}
unless(defined(&IWN_MEASUREMENT_CONCURRENT)) {
    sub IWN_MEASUREMENT_CONCURRENT () {	1;}
}
unless(defined(&IWN_MEASUREMENT_CSA_CONFLICT)) {
    sub IWN_MEASUREMENT_CSA_CONFLICT () {	2;}
}
unless(defined(&IWN_MEASUREMENT_TGH_CONFLICT)) {
    sub IWN_MEASUREMENT_TGH_CONFLICT () {	3;}
}
unless(defined(&IWN_MEASUREMENT_STOPPED)) {
    sub IWN_MEASUREMENT_STOPPED () {	6;}
}
unless(defined(&IWN_MEASUREMENT_TIMEOUT)) {
    sub IWN_MEASUREMENT_TIMEOUT () {	7;}
}
unless(defined(&IWN_MEASUREMENT_FAILED)) {
    sub IWN_MEASUREMENT_FAILED () {	8;}
}
unless(defined(&IWN_FW_SIGNATURE)) {
    sub IWN_FW_SIGNATURE () {	0xa4c5749;}
}
unless(defined(&IWN_FW_API)) {
    sub IWN_FW_API {
	my($x) = @_;
	eval q(((($x) >> 8) & 0xff));
    }
}
unless(defined(&IWN_FW_TLV_MAIN_TEXT)) {
    sub IWN_FW_TLV_MAIN_TEXT () {	1;}
}
unless(defined(&IWN_FW_TLV_MAIN_DATA)) {
    sub IWN_FW_TLV_MAIN_DATA () {	2;}
}
unless(defined(&IWN_FW_TLV_INIT_TEXT)) {
    sub IWN_FW_TLV_INIT_TEXT () {	3;}
}
unless(defined(&IWN_FW_TLV_INIT_DATA)) {
    sub IWN_FW_TLV_INIT_DATA () {	4;}
}
unless(defined(&IWN_FW_TLV_BOOT_TEXT)) {
    sub IWN_FW_TLV_BOOT_TEXT () {	5;}
}
unless(defined(&IWN_FW_TLV_PBREQ_MAXLEN)) {
    sub IWN_FW_TLV_PBREQ_MAXLEN () {	6;}
}
unless(defined(&IWN4965_FW_TEXT_MAXSZ)) {
    sub IWN4965_FW_TEXT_MAXSZ () {	( 96* 1024);}
}
unless(defined(&IWN4965_FW_DATA_MAXSZ)) {
    sub IWN4965_FW_DATA_MAXSZ () {	( 40* 1024);}
}
unless(defined(&IWN5000_FW_TEXT_MAXSZ)) {
    sub IWN5000_FW_TEXT_MAXSZ () {	(256* 1024);}
}
unless(defined(&IWN5000_FW_DATA_MAXSZ)) {
    sub IWN5000_FW_DATA_MAXSZ () {	( 80* 1024);}
}
unless(defined(&IWN_FW_BOOT_TEXT_MAXSZ)) {
    sub IWN_FW_BOOT_TEXT_MAXSZ () {	1024;}
}
unless(defined(&IWN4965_FWSZ)) {
    sub IWN4965_FWSZ () {	( &IWN4965_FW_TEXT_MAXSZ +  &IWN4965_FW_DATA_MAXSZ);}
}
unless(defined(&IWN5000_FWSZ)) {
    sub IWN5000_FWSZ () {	 &IWN5000_FW_TEXT_MAXSZ;}
}
unless(defined(&IWN_EEPROM_MAC)) {
    sub IWN_EEPROM_MAC () {	0x15;}
}
unless(defined(&IWN_EEPROM_SKU_CAP)) {
    sub IWN_EEPROM_SKU_CAP () {	0x45;}
}
unless(defined(&IWN_EEPROM_RFCFG)) {
    sub IWN_EEPROM_RFCFG () {	0x48;}
}
unless(defined(&IWN4965_EEPROM_DOMAIN)) {
    sub IWN4965_EEPROM_DOMAIN () {	0x60;}
}
unless(defined(&IWN4965_EEPROM_BAND1)) {
    sub IWN4965_EEPROM_BAND1 () {	0x63;}
}
unless(defined(&IWN5000_EEPROM_REG)) {
    sub IWN5000_EEPROM_REG () {	0x66;}
}
unless(defined(&IWN5000_EEPROM_CAL)) {
    sub IWN5000_EEPROM_CAL () {	0x67;}
}
unless(defined(&IWN4965_EEPROM_BAND2)) {
    sub IWN4965_EEPROM_BAND2 () {	0x72;}
}
unless(defined(&IWN4965_EEPROM_BAND3)) {
    sub IWN4965_EEPROM_BAND3 () {	0x80;}
}
unless(defined(&IWN4965_EEPROM_BAND4)) {
    sub IWN4965_EEPROM_BAND4 () {	0x8d;}
}
unless(defined(&IWN4965_EEPROM_BAND5)) {
    sub IWN4965_EEPROM_BAND5 () {	0x99;}
}
unless(defined(&IWN4965_EEPROM_BAND6)) {
    sub IWN4965_EEPROM_BAND6 () {	0xa0;}
}
unless(defined(&IWN4965_EEPROM_BAND7)) {
    sub IWN4965_EEPROM_BAND7 () {	0xa8;}
}
unless(defined(&IWN4965_EEPROM_MAXPOW)) {
    sub IWN4965_EEPROM_MAXPOW () {	0xe8;}
}
unless(defined(&IWN4965_EEPROM_VOLTAGE)) {
    sub IWN4965_EEPROM_VOLTAGE () {	0xe9;}
}
unless(defined(&IWN4965_EEPROM_BANDS)) {
    sub IWN4965_EEPROM_BANDS () {	0xea;}
}
unless(defined(&IWN5000_EEPROM_DOMAIN)) {
    sub IWN5000_EEPROM_DOMAIN () {	0x1;}
}
unless(defined(&IWN5000_EEPROM_BAND1)) {
    sub IWN5000_EEPROM_BAND1 () {	0x4;}
}
unless(defined(&IWN5000_EEPROM_BAND2)) {
    sub IWN5000_EEPROM_BAND2 () {	0x13;}
}
unless(defined(&IWN5000_EEPROM_BAND3)) {
    sub IWN5000_EEPROM_BAND3 () {	0x21;}
}
unless(defined(&IWN5000_EEPROM_BAND4)) {
    sub IWN5000_EEPROM_BAND4 () {	0x2e;}
}
unless(defined(&IWN5000_EEPROM_BAND5)) {
    sub IWN5000_EEPROM_BAND5 () {	0x3a;}
}
unless(defined(&IWN5000_EEPROM_BAND6)) {
    sub IWN5000_EEPROM_BAND6 () {	0x41;}
}
unless(defined(&IWN5000_EEPROM_BAND7)) {
    sub IWN5000_EEPROM_BAND7 () {	0x49;}
}
unless(defined(&IWN6000_EEPROM_ENHINFO)) {
    sub IWN6000_EEPROM_ENHINFO () {	0x54;}
}
unless(defined(&IWN5000_EEPROM_CRYSTAL)) {
    sub IWN5000_EEPROM_CRYSTAL () {	0x128;}
}
unless(defined(&IWN5000_EEPROM_TEMP)) {
    sub IWN5000_EEPROM_TEMP () {	0x12a;}
}
unless(defined(&IWN5000_EEPROM_VOLT)) {
    sub IWN5000_EEPROM_VOLT () {	0x12b;}
}
unless(defined(&IWN_EEPROM_SKU_CAP_11N)) {
    sub IWN_EEPROM_SKU_CAP_11N () {	(1<< 6);}
}
unless(defined(&IWN_EEPROM_SKU_CAP_AMT)) {
    sub IWN_EEPROM_SKU_CAP_AMT () {	(1<< 7);}
}
unless(defined(&IWN_EEPROM_SKU_CAP_IPAN)) {
    sub IWN_EEPROM_SKU_CAP_IPAN () {	(1<< 8);}
}
unless(defined(&IWN_RFCFG_TYPE)) {
    sub IWN_RFCFG_TYPE {
	my($x) = @_;
	eval q(((($x) >> 0) & 0x3));
    }
}
unless(defined(&IWN_RFCFG_STEP)) {
    sub IWN_RFCFG_STEP {
	my($x) = @_;
	eval q(((($x) >> 2) & 0x3));
    }
}
unless(defined(&IWN_RFCFG_DASH)) {
    sub IWN_RFCFG_DASH {
	my($x) = @_;
	eval q(((($x) >> 4) & 0x3));
    }
}
unless(defined(&IWN_RFCFG_TXANTMSK)) {
    sub IWN_RFCFG_TXANTMSK {
	my($x) = @_;
	eval q(((($x) >> 8) & 0xf));
    }
}
unless(defined(&IWN_RFCFG_RXANTMSK)) {
    sub IWN_RFCFG_RXANTMSK {
	my($x) = @_;
	eval q(((($x) >> 12) & 0xf));
    }
}
unless(defined(&IWN_EEPROM_CHAN_VALID)) {
    sub IWN_EEPROM_CHAN_VALID () {	(1<< 0);}
}
unless(defined(&IWN_EEPROM_CHAN_IBSS)) {
    sub IWN_EEPROM_CHAN_IBSS () {	(1<< 1);}
}
unless(defined(&IWN_EEPROM_CHAN_ACTIVE)) {
    sub IWN_EEPROM_CHAN_ACTIVE () {	(1<< 3);}
}
unless(defined(&IWN_EEPROM_CHAN_RADAR)) {
    sub IWN_EEPROM_CHAN_RADAR () {	(1<< 4);}
}
unless(defined(&IWN_NSAMPLES)) {
    sub IWN_NSAMPLES () {	3;}
}
unless(defined(&IWN_NBANDS)) {
    sub IWN_NBANDS () {	8;}
}
unless(defined(&IWN_CHAN_BANDS_COUNT)) {
    sub IWN_CHAN_BANDS_COUNT () {	7;}
}
unless(defined(&IWN_MAX_CHAN_PER_BAND)) {
    sub IWN_MAX_CHAN_PER_BAND () {	14;}
}
unless(defined(&IWN1000_OTP_NBLOCKS)) {
    sub IWN1000_OTP_NBLOCKS () {	3;}
}
unless(defined(&IWN6000_OTP_NBLOCKS)) {
    sub IWN6000_OTP_NBLOCKS () {	4;}
}
unless(defined(&IWN6050_OTP_NBLOCKS)) {
    sub IWN6050_OTP_NBLOCKS () {	7;}
}
unless(defined(&IWN_RIDX_CCK1)) {
    sub IWN_RIDX_CCK1 () {	0;}
}
unless(defined(&IWN_RIDX_OFDM6)) {
    sub IWN_RIDX_OFDM6 () {	4;}
}
unless(defined(&IWN4965_MAX_PWR_INDEX)) {
    sub IWN4965_MAX_PWR_INDEX () {	107;}
}
unless(defined(&IWN_NDTIMRANGES)) {
    sub IWN_NDTIMRANGES () {	3;}
}
unless(defined(&IWN_NPOWERLEVELS)) {
    sub IWN_NPOWERLEVELS () {	6;}
}
unless(defined(&IWN_LSB)) {
    sub IWN_LSB {
	my($x) = @_;
	eval q((((($x) - 1) & ($x)) ^ ($x)));
    }
}
unless(defined(&IWN_READ)) {
    sub IWN_READ {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg)));
    }
}
unless(defined(&IWN_WRITE)) {
    sub IWN_WRITE {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val)));
    }
}
unless(defined(&IWN_WRITE_1)) {
    sub IWN_WRITE_1 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_1(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val)));
    }
}
unless(defined(&IWN_SETBITS)) {
    sub IWN_SETBITS {
	my($sc, $reg, $mask) = @_;
	eval q( &IWN_WRITE($sc, $reg,  &IWN_READ($sc, $reg) | ($mask)));
    }
}
unless(defined(&IWN_CLRBITS)) {
    sub IWN_CLRBITS {
	my($sc, $reg, $mask) = @_;
	eval q( &IWN_WRITE($sc, $reg,  &IWN_READ($sc, $reg) & ~($mask)));
    }
}
unless(defined(&IWN_BARRIER_WRITE)) {
    sub IWN_BARRIER_WRITE {
	my($sc) = @_;
	eval q( &bus_space_barrier(($sc)-> &sc_st, ($sc)-> &sc_sh, 0, ($sc)-> &sc_sz,  &BUS_SPACE_BARRIER_WRITE));
    }
}
unless(defined(&IWN_BARRIER_READ_WRITE)) {
    sub IWN_BARRIER_READ_WRITE {
	my($sc) = @_;
	eval q( &bus_space_barrier(($sc)-> &sc_st, ($sc)-> &sc_sh, 0, ($sc)-> &sc_sz,  &BUS_SPACE_BARRIER_READ |  &BUS_SPACE_BARRIER_WRITE));
    }
}
1;
