require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MIPS64_CPU_H_)) {
    eval 'sub _MIPS64_CPU_H_ () {1;}' unless defined(&_MIPS64_CPU_H_);
    unless(defined(&_LOCORE)) {
	eval 'sub CKSEG0_BASE () {0xffffffff80000000;}' unless defined(&CKSEG0_BASE);
	eval 'sub CKSEG1_BASE () {0xffffffffa0000000;}' unless defined(&CKSEG1_BASE);
	eval 'sub CKSSEG_BASE () {0xffffffffc0000000;}' unless defined(&CKSSEG_BASE);
	eval 'sub CKSEG3_BASE () {0xffffffffe0000000;}' unless defined(&CKSEG3_BASE);
	eval 'sub CKSEG_SIZE () {0x20000000;}' unless defined(&CKSEG_SIZE);
	eval 'sub CKSEG0_TO_PHYS {
	    my($x) = @_;
    	    eval q((($x) & ( &CKSEG_SIZE - 1)));
	}' unless defined(&CKSEG0_TO_PHYS);
	eval 'sub CKSEG1_TO_PHYS {
	    my($x) = @_;
    	    eval q((($x) & ( &CKSEG_SIZE - 1)));
	}' unless defined(&CKSEG1_TO_PHYS);
	eval 'sub PHYS_TO_CKSEG0 {
	    my($x) = @_;
    	    eval q((($x) |  &CKSEG0_BASE));
	}' unless defined(&PHYS_TO_CKSEG0);
	eval 'sub PHYS_TO_CKSEG1 {
	    my($x) = @_;
    	    eval q((($x) |  &CKSEG1_BASE));
	}' unless defined(&PHYS_TO_CKSEG1);
	eval 'sub CCA_NC_COPROCESSOR () {0;}' unless defined(&CCA_NC_COPROCESSOR);
	eval 'sub CCA_NC () {2;}' unless defined(&CCA_NC);
	eval 'sub CCA_NONCOHERENT () {3;}' unless defined(&CCA_NONCOHERENT);
	eval 'sub CCA_COHERENT_EXCL () {4;}' unless defined(&CCA_COHERENT_EXCL);
	eval 'sub CCA_COHERENT_EXCLWRITE () {5;}' unless defined(&CCA_COHERENT_EXCLWRITE);
	eval 'sub CCA_COHERENT_UPDWRITE () {6;}' unless defined(&CCA_COHERENT_UPDWRITE);
	eval 'sub CCA_NC_ACCELERATED () {7;}' unless defined(&CCA_NC_ACCELERATED);
	if(defined(&TGT_COHERENT)) {
	    eval 'sub CCA_CACHED () { &CCA_COHERENT_EXCLWRITE;}' unless defined(&CCA_CACHED);
	} else {
	    eval 'sub CCA_CACHED () { &CCA_NONCOHERENT;}' unless defined(&CCA_CACHED);
	}
	eval 'sub SP_HUB () {0;}' unless defined(&SP_HUB);
	eval 'sub SP_IO () {1;}' unless defined(&SP_IO);
	eval 'sub SP_SPECIAL () {2;}' unless defined(&SP_SPECIAL);
	eval 'sub SP_NC () {3;}' unless defined(&SP_NC);
	eval 'sub XKSSSEG_BASE () {0x4000000000000000;}' unless defined(&XKSSSEG_BASE);
	eval 'sub XKPHYS_BASE () {0x8000000000000000;}' unless defined(&XKPHYS_BASE);
	eval 'sub XKSSEG_BASE () {0xc000000000000000;}' unless defined(&XKSSEG_BASE);
	eval 'sub XKPHYS_TO_PHYS {
	    my($x) = @_;
    	    eval q((( &paddr_t)($x) & 0xfffffffff));
	}' unless defined(&XKPHYS_TO_PHYS);
	eval 'sub PHYS_TO_XKPHYS {
	    my($x,$c) = @_;
    	    eval q((( &paddr_t)($x) |  &XKPHYS_BASE | (($c) << 59)));
	}' unless defined(&PHYS_TO_XKPHYS);
	eval 'sub PHYS_TO_XKPHYS_UNCACHED {
	    my($x,$s) = @_;
    	    eval q(( &PHYS_TO_XKPHYS($x,  &CCA_NC) | (($s) << 57)));
	}' unless defined(&PHYS_TO_XKPHYS_UNCACHED);
	eval 'sub IS_XKPHYS {
	    my($va) = @_;
    	    eval q(((($va) >> 62) == 2));
	}' unless defined(&IS_XKPHYS);
	eval 'sub XKPHYS_TO_CCA {
	    my($x) = @_;
    	    eval q(((($x) >> 59) & 0x7));
	}' unless defined(&XKPHYS_TO_CCA);
	eval 'sub XKPHYS_TO_SP {
	    my($x) = @_;
    	    eval q(((($x) >> 57) & 0x3));
	}' unless defined(&XKPHYS_TO_SP);
    }
    if(defined(&_KERNEL)  && !defined(&_LOCORE)) {
	require 'sys/device.ph';
	require 'sys/lock.ph';
	require 'machine/intr.ph';
	require 'sys/sched.ph';
	if(defined(&MULTIPROCESSOR)) {
	}
	eval 'sub CI_DDB_RUNNING () {0;}' unless defined(&CI_DDB_RUNNING);
	eval 'sub CI_DDB_SHOULDSTOP () {1;}' unless defined(&CI_DDB_SHOULDSTOP);
	eval 'sub CI_DDB_STOPPED () {2;}' unless defined(&CI_DDB_STOPPED);
	eval 'sub CI_DDB_ENTERDDB () {3;}' unless defined(&CI_DDB_ENTERDDB);
	eval 'sub CI_DDB_INDDB () {4;}' unless defined(&CI_DDB_INDDB);
	if(defined(&DIAGNOSTIC)) {
	}
	eval 'sub CPUF_PRIMARY () {0x1;}' unless defined(&CPUF_PRIMARY);
	eval 'sub CPUF_PRESENT () {0x2;}' unless defined(&CPUF_PRESENT);
	eval 'sub CPUF_RUNNING () {0x4;}' unless defined(&CPUF_RUNNING);
	eval 'sub CPU_INFO_ITERATOR () {\'int\';}' unless defined(&CPU_INFO_ITERATOR);
	eval 'sub CPU_INFO_FOREACH {
	    my($cii, $ci) = @_;
    	    eval q( &for ($cii = 0, $ci =  &cpu_info_list; $ci !=  &NULL; $ci =  ($ci->{ci_next})));
	}' unless defined(&CPU_INFO_FOREACH);
	eval 'sub CPU_INFO_UNIT {
	    my($ci) = @_;
    	    eval q((($ci)-> &ci_dev ? ($ci)-> ($ci_dev->{dv_unit}) : 0));
	}' unless defined(&CPU_INFO_UNIT);
	if(defined(&MULTIPROCESSOR)) {
	    eval 'sub MAXCPUS () {4;}' unless defined(&MAXCPUS);
	    eval 'sub getcurcpu () {
	        eval q( &hw_getcurcpu());
	    }' unless defined(&getcurcpu);
	    eval 'sub setcurcpu {
	        my($ci) = @_;
    		eval q( &hw_setcurcpu($ci));
	    }' unless defined(&setcurcpu);
	    eval 'sub curcpu () {
	        eval q( &getcurcpu());
	    }' unless defined(&curcpu);
	    eval 'sub CPU_IS_PRIMARY {
	        my($ci) = @_;
    		eval q((($ci)-> &ci_flags &  &CPUF_PRIMARY));
	    }' unless defined(&CPU_IS_PRIMARY);
	    eval 'sub cpu_number () {
	        eval q(( &curcpu()-> &ci_cpuid));
	    }' unless defined(&cpu_number);
	    eval 'sub cpu_boot_secondary {
	        my($ci) = @_;
    		eval q( &hw_cpu_boot_secondary($ci));
	    }' unless defined(&cpu_boot_secondary);
	    eval 'sub cpu_hatch {
	        my($ci) = @_;
    		eval q( &hw_cpu_hatch($ci));
	    }' unless defined(&cpu_hatch);
	    eval 'sub MIPS64_IPI_NOP () {0x1;}' unless defined(&MIPS64_IPI_NOP);
	    eval 'sub MIPS64_IPI_RENDEZVOUS () {0x2;}' unless defined(&MIPS64_IPI_RENDEZVOUS);
	    eval 'sub MIPS64_IPI_DDB () {0x4;}' unless defined(&MIPS64_IPI_DDB);
	    eval 'sub MIPS64_NIPIS () {3;}' unless defined(&MIPS64_NIPIS);
	    require 'sys/mplock.ph';
	} else {
	    eval 'sub MAXCPUS () {1;}' unless defined(&MAXCPUS);
	    eval 'sub curcpu () {
	        eval q(( &cpu_info_primary));
	    }' unless defined(&curcpu);
	    eval 'sub CPU_IS_PRIMARY {
	        my($ci) = @_;
    		eval q(1);
	    }' unless defined(&CPU_IS_PRIMARY);
	    eval 'sub cpu_number () {
	        eval q(0);
	    }' unless defined(&cpu_number);
	    eval 'sub cpu_unidle {
	        my($ci) = @_;
    		eval q();
	    }' unless defined(&cpu_unidle);
	    eval 'sub get_cpu_info {
	        my($i) = @_;
    		eval q(( &cpu_info_primary));
	    }' unless defined(&get_cpu_info);
	}
	require 'machine/frame.ph';
	eval 'sub clockframe () { &trap_frame;}' unless defined(&clockframe);
	eval 'sub SR_KSU_USER () {0x10;}' unless defined(&SR_KSU_USER);
	eval 'sub CLKF_USERMODE {
	    my($framep) = @_;
    	    eval q((($framep)-> &sr &  &SR_KSU_USER));
	}' unless defined(&CLKF_USERMODE);
	eval 'sub CLKF_PC {
	    my($framep) = @_;
    	    eval q((($framep)-> &pc));
	}' unless defined(&CLKF_PC);
	eval 'sub CLKF_INTR {
	    my($framep) = @_;
    	    eval q(( &curcpu()-> &ci_intrdepth > 1));
	}' unless defined(&CLKF_INTR);
	eval 'sub PROC_PC {
	    my($p) = @_;
    	    eval q((($p)-> ($p_md->{md_regs}->{pc})));
	}' unless defined(&PROC_PC);
	eval 'sub PROC_STACK {
	    my($p) = @_;
    	    eval q((($p)-> ($p_md->{md_regs}->{s$p})));
	}' unless defined(&PROC_STACK);
	eval 'sub need_resched {
	    my($ci) = @_;
    	    eval q( &do { ($ci)-> &ci_want_resched = 1;  &if (($ci)-> &ci_curproc !=  &NULL)  &aston(($ci)-> &ci_curproc); }  &while(0));
	}' unless defined(&need_resched);
	eval 'sub clear_resched {
	    my($ci) = @_;
    	    eval q(($ci)-> &ci_want_resched = 0);
	}' unless defined(&clear_resched);
	eval 'sub need_proftick {
	    my($p) = @_;
    	    eval q( &aston($p));
	}' unless defined(&need_proftick);
	if(defined(&MULTIPROCESSOR)) {
	    eval 'sub signotify {
	        my($p) = @_;
    		eval q(( &aston($p),  &cpu_unidle( ($p->{p_cpu}))));
	    }' unless defined(&signotify);
	} else {
	    eval 'sub signotify {
	        my($p) = @_;
    		eval q( &aston($p));
	    }' unless defined(&signotify);
	}
	eval 'sub aston {
	    my($p) = @_;
    	    eval q( ($p->{p_md}->{md_astpending}) = 1);
	}' unless defined(&aston);
	if(defined(&CPU_R8000)) {
	    eval 'sub mips_sync () {
	        eval q(\\"(assembly code)\\");
	    }' unless defined(&mips_sync);
	} else {
	    eval 'sub mips_sync () {
	        eval q(\\"(assembly code)\\");
	    }' unless defined(&mips_sync);
	}
    }
    if(defined(&_KERNEL)) {
	eval 'sub BREAK_INSTR () {0xd;}' unless defined(&BREAK_INSTR);
	eval 'sub BREAK_VAL_MASK () {0x3ff0000;}' unless defined(&BREAK_VAL_MASK);
	eval 'sub BREAK_VAL_SHIFT () {16;}' unless defined(&BREAK_VAL_SHIFT);
	eval 'sub BREAK_KDB_VAL () {512;}' unless defined(&BREAK_KDB_VAL);
	eval 'sub BREAK_SSTEP_VAL () {513;}' unless defined(&BREAK_SSTEP_VAL);
	eval 'sub BREAK_BRKPT_VAL () {514;}' unless defined(&BREAK_BRKPT_VAL);
	eval 'sub BREAK_SOVER_VAL () {515;}' unless defined(&BREAK_SOVER_VAL);
	eval 'sub BREAK_DDB_VAL () {516;}' unless defined(&BREAK_DDB_VAL);
	eval 'sub BREAK_FPUEMUL_VAL () {517;}' unless defined(&BREAK_FPUEMUL_VAL);
	eval 'sub BREAK_KDB () {( &BREAK_INSTR | ( &BREAK_KDB_VAL <<  &BREAK_VAL_SHIFT));}' unless defined(&BREAK_KDB);
	eval 'sub BREAK_SSTEP () {( &BREAK_INSTR | ( &BREAK_SSTEP_VAL <<  &BREAK_VAL_SHIFT));}' unless defined(&BREAK_SSTEP);
	eval 'sub BREAK_BRKPT () {( &BREAK_INSTR | ( &BREAK_BRKPT_VAL <<  &BREAK_VAL_SHIFT));}' unless defined(&BREAK_BRKPT);
	eval 'sub BREAK_SOVER () {( &BREAK_INSTR | ( &BREAK_SOVER_VAL <<  &BREAK_VAL_SHIFT));}' unless defined(&BREAK_SOVER);
	eval 'sub BREAK_DDB () {( &BREAK_INSTR | ( &BREAK_DDB_VAL <<  &BREAK_VAL_SHIFT));}' unless defined(&BREAK_DDB);
	eval 'sub BREAK_FPUEMUL () {( &BREAK_INSTR | ( &BREAK_FPUEMUL_VAL <<  &BREAK_VAL_SHIFT));}' unless defined(&BREAK_FPUEMUL);
    }
    eval 'sub CPU_ALLOWAPERTURE () {1;}' unless defined(&CPU_ALLOWAPERTURE);
    eval 'sub CPU_MAXID () {3;}' unless defined(&CPU_MAXID);
    eval 'sub CTL_MACHDEP_NAMES () {{ { 0, 0}, { "allowaperture",  &CTLTYPE_INT }, { 0, 0}, };}' unless defined(&CTL_MACHDEP_NAMES);
    eval 'sub MIPS_R2000 () {0x1;}' unless defined(&MIPS_R2000);
    eval 'sub MIPS_R3000 () {0x2;}' unless defined(&MIPS_R3000);
    eval 'sub MIPS_R6000 () {0x3;}' unless defined(&MIPS_R6000);
    eval 'sub MIPS_R4000 () {0x4;}' unless defined(&MIPS_R4000);
    eval 'sub MIPS_R3LSI () {0x5;}' unless defined(&MIPS_R3LSI);
    eval 'sub MIPS_R6000A () {0x6;}' unless defined(&MIPS_R6000A);
    eval 'sub MIPS_OCTEON () {0x6;}' unless defined(&MIPS_OCTEON);
    eval 'sub MIPS_R3IDT () {0x7;}' unless defined(&MIPS_R3IDT);
    eval 'sub MIPS_R10000 () {0x9;}' unless defined(&MIPS_R10000);
    eval 'sub MIPS_R4200 () {0xa;}' unless defined(&MIPS_R4200);
    eval 'sub MIPS_R4300 () {0xb;}' unless defined(&MIPS_R4300);
    eval 'sub MIPS_R4100 () {0xc;}' unless defined(&MIPS_R4100);
    eval 'sub MIPS_R12000 () {0xe;}' unless defined(&MIPS_R12000);
    eval 'sub MIPS_R14000 () {0xf;}' unless defined(&MIPS_R14000);
    eval 'sub MIPS_R8000 () {0x10;}' unless defined(&MIPS_R8000);
    eval 'sub MIPS_R4600 () {0x20;}' unless defined(&MIPS_R4600);
    eval 'sub MIPS_R4700 () {0x21;}' unless defined(&MIPS_R4700);
    eval 'sub MIPS_R3TOSH () {0x22;}' unless defined(&MIPS_R3TOSH);
    eval 'sub MIPS_R5000 () {0x23;}' unless defined(&MIPS_R5000);
    eval 'sub MIPS_RM7000 () {0x27;}' unless defined(&MIPS_RM7000);
    eval 'sub MIPS_RM52X0 () {0x28;}' unless defined(&MIPS_RM52X0);
    eval 'sub MIPS_RM9000 () {0x34;}' unless defined(&MIPS_RM9000);
    eval 'sub MIPS_LOONGSON () {0x42;}' unless defined(&MIPS_LOONGSON);
    eval 'sub MIPS_VR5400 () {0x54;}' unless defined(&MIPS_VR5400);
    eval 'sub MIPS_LOONGSON2 () {0x63;}' unless defined(&MIPS_LOONGSON2);
    eval 'sub MIPS_SOFT () {0x;}' unless defined(&MIPS_SOFT);
    if(defined(&_KERNEL)  && !defined(&_LOCORE)) {
	unless(defined(&Mips_SyncCache)) {
	    eval 'sub Mips_SyncCache {
	        my($ci) = @_;
    		eval q((($ci)-> &ci_SyncCache)($ci));
	    }' unless defined(&Mips_SyncCache);
	}
	unless(defined(&Mips_InvalidateICache)) {
	    eval 'sub Mips_InvalidateICache {
	        my($ci, $va, $l) = @_;
    		eval q((($ci)-> &ci_InvalidateICache)($ci, $va, $l));
	    }' unless defined(&Mips_InvalidateICache);
	}
	unless(defined(&Mips_SyncDCachePage)) {
	    eval 'sub Mips_SyncDCachePage {
	        my($ci, $va, $pa) = @_;
    		eval q((($ci)-> &ci_SyncDCachePage)($ci, $va, $pa));
	    }' unless defined(&Mips_SyncDCachePage);
	}
	unless(defined(&Mips_HitSyncDCache)) {
	    eval 'sub Mips_HitSyncDCache {
	        my($ci, $va, $l) = @_;
    		eval q((($ci)-> &ci_HitSyncDCache)($ci, $va, $l));
	    }' unless defined(&Mips_HitSyncDCache);
	}
	unless(defined(&Mips_HitInvalidateDCache)) {
	    eval 'sub Mips_HitInvalidateDCache {
	        my($ci, $va, $l) = @_;
    		eval q((($ci)-> &ci_HitInvalidateDCache)($ci, $va, $l));
	    }' unless defined(&Mips_HitInvalidateDCache);
	}
	unless(defined(&Mips_IOSyncDCache)) {
	    eval 'sub Mips_IOSyncDCache {
	        my($ci, $va, $l, $h) = @_;
    		eval q((($ci)-> &ci_IOSyncDCache)($ci, $va, $l, $h));
	    }' unless defined(&Mips_IOSyncDCache);
	}
    }
}
1;
