require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&MPII_DOORBELL)) {
    sub MPII_DOORBELL () {	(0x);}
}
unless(defined(&MPII_DOORBELL_STATE)) {
    sub MPII_DOORBELL_STATE () {	(0xf<<28);}
}
unless(defined(&MPII_DOORBELL_STATE_RESET)) {
    sub MPII_DOORBELL_STATE_RESET () {	(0x<<28);}
}
unless(defined(&MPII_DOORBELL_STATE_READY)) {
    sub MPII_DOORBELL_STATE_READY () {	(0x1<<28);}
}
unless(defined(&MPII_DOORBELL_STATE_OPER)) {
    sub MPII_DOORBELL_STATE_OPER () {	(0x2<<28);}
}
unless(defined(&MPII_DOORBELL_STATE_FAULT)) {
    sub MPII_DOORBELL_STATE_FAULT () {	(0x4<<28);}
}
unless(defined(&MPII_DOORBELL_INUSE)) {
    sub MPII_DOORBELL_INUSE () {	(0x1<<27);}
}
unless(defined(&MPII_DOORBELL_WHOINIT)) {
    sub MPII_DOORBELL_WHOINIT () {	(0x7<<24);}
}
unless(defined(&MPII_DOORBELL_WHOINIT_NOONE)) {
    sub MPII_DOORBELL_WHOINIT_NOONE () {	(0x<<24);}
}
unless(defined(&MPII_DOORBELL_WHOINIT_SYSBIOS)) {
    sub MPII_DOORBELL_WHOINIT_SYSBIOS () {	(0x1<<24);}
}
unless(defined(&MPII_DOORBELL_WHOINIT_ROMBIOS)) {
    sub MPII_DOORBELL_WHOINIT_ROMBIOS () {	(0x2<<24);}
}
unless(defined(&MPII_DOORBELL_WHOINIT_PCIPEER)) {
    sub MPII_DOORBELL_WHOINIT_PCIPEER () {	(0x3<<24);}
}
unless(defined(&MPII_DOORBELL_WHOINIT_DRIVER)) {
    sub MPII_DOORBELL_WHOINIT_DRIVER () {	(0x4<<24);}
}
unless(defined(&MPII_DOORBELL_WHOINIT_MANUFACT)) {
    sub MPII_DOORBELL_WHOINIT_MANUFACT () {	(0x5<<24);}
}
unless(defined(&MPII_DOORBELL_FAULT)) {
    sub MPII_DOORBELL_FAULT () {	(0xffff<<0);}
}
unless(defined(&MPII_DOORBELL_FUNCTION_SHIFT)) {
    sub MPII_DOORBELL_FUNCTION_SHIFT () {	(24);}
}
unless(defined(&MPII_DOORBELL_FUNCTION_MASK)) {
    sub MPII_DOORBELL_FUNCTION_MASK () {	(0xff <<  &MPII_DOORBELL_FUNCTION_SHIFT);}
}
unless(defined(&MPII_DOORBELL_FUNCTION)) {
    sub MPII_DOORBELL_FUNCTION {
	my($x) = @_;
	eval q(((($x) <<  &MPII_DOORBELL_FUNCTION_SHIFT) &  &MPII_DOORBELL_FUNCTION_MASK));
    }
}
unless(defined(&MPII_DOORBELL_DWORDS_SHIFT)) {
    sub MPII_DOORBELL_DWORDS_SHIFT () {	16;}
}
unless(defined(&MPII_DOORBELL_DWORDS_MASK)) {
    sub MPII_DOORBELL_DWORDS_MASK () {	(0xff <<  &MPII_DOORBELL_DWORDS_SHIFT);}
}
unless(defined(&MPII_DOORBELL_DWORDS)) {
    sub MPII_DOORBELL_DWORDS {
	my($x) = @_;
	eval q(((($x) <<  &MPII_DOORBELL_DWORDS_SHIFT) &  &MPII_DOORBELL_DWORDS_MASK));
    }
}
unless(defined(&MPII_DOORBELL_DATA_MASK)) {
    sub MPII_DOORBELL_DATA_MASK () {	(0xffff);}
}
unless(defined(&MPII_WRITESEQ)) {
    sub MPII_WRITESEQ () {	(0x4);}
}
unless(defined(&MPII_WRITESEQ_KEY_VALUE_MASK)) {
    sub MPII_WRITESEQ_KEY_VALUE_MASK () {	(0xf);}
}
unless(defined(&MPII_WRITESEQ_FLUSH)) {
    sub MPII_WRITESEQ_FLUSH () {	(0x);}
}
unless(defined(&MPII_WRITESEQ_1)) {
    sub MPII_WRITESEQ_1 () {	(0xf);}
}
unless(defined(&MPII_WRITESEQ_2)) {
    sub MPII_WRITESEQ_2 () {	(0x4);}
}
unless(defined(&MPII_WRITESEQ_3)) {
    sub MPII_WRITESEQ_3 () {	(0xb);}
}
unless(defined(&MPII_WRITESEQ_4)) {
    sub MPII_WRITESEQ_4 () {	(0x2);}
}
unless(defined(&MPII_WRITESEQ_5)) {
    sub MPII_WRITESEQ_5 () {	(0x7);}
}
unless(defined(&MPII_WRITESEQ_6)) {
    sub MPII_WRITESEQ_6 () {	(0xd);}
}
unless(defined(&MPII_HOSTDIAG)) {
    sub MPII_HOSTDIAG () {	(0x8);}
}
unless(defined(&MPII_HOSTDIAG_BDS_MASK)) {
    sub MPII_HOSTDIAG_BDS_MASK () {	(0x1800);}
}
unless(defined(&MPII_HOSTDIAG_BDS_DEFAULT)) {
    sub MPII_HOSTDIAG_BDS_DEFAULT () {	(0<<11);}
}
unless(defined(&MPII_HOSTDIAG_BDS_HCDW)) {
    sub MPII_HOSTDIAG_BDS_HCDW () {	(1<<11);}
}
unless(defined(&MPII_HOSTDIAG_CLEARFBS)) {
    sub MPII_HOSTDIAG_CLEARFBS () {	(1<<10);}
}
unless(defined(&MPII_HOSTDIAG_FORCE_HCB_ONBOOT)) {
    sub MPII_HOSTDIAG_FORCE_HCB_ONBOOT () {	(1<<9);}
}
unless(defined(&MPII_HOSTDIAG_HCB_MODE)) {
    sub MPII_HOSTDIAG_HCB_MODE () {	(1<<8);}
}
unless(defined(&MPII_HOSTDIAG_DWRE)) {
    sub MPII_HOSTDIAG_DWRE () {	(1<<7);}
}
unless(defined(&MPII_HOSTDIAG_FBS)) {
    sub MPII_HOSTDIAG_FBS () {	(1<<6);}
}
unless(defined(&MPII_HOSTDIAG_RESET_HIST)) {
    sub MPII_HOSTDIAG_RESET_HIST () {	(1<<5);}
}
unless(defined(&MPII_HOSTDIAG_DIAGWR_EN)) {
    sub MPII_HOSTDIAG_DIAGWR_EN () {	(1<<4);}
}
unless(defined(&MPII_HOSTDIAG_RESET_ADAPTER)) {
    sub MPII_HOSTDIAG_RESET_ADAPTER () {	(1<<2);}
}
unless(defined(&MPII_HOSTDIAG_HOLD_IOC_RESET)) {
    sub MPII_HOSTDIAG_HOLD_IOC_RESET () {	(1<<1);}
}
unless(defined(&MPII_HOSTDIAG_DIAGMEM_EN)) {
    sub MPII_HOSTDIAG_DIAGMEM_EN () {	(1<<0);}
}
unless(defined(&MPII_DIAGRWDATA)) {
    sub MPII_DIAGRWDATA () {	(0x10);}
}
unless(defined(&MPII_DIAGRWADDRLOW)) {
    sub MPII_DIAGRWADDRLOW () {	(0x14);}
}
unless(defined(&MPII_DIAGRWADDRHIGH)) {
    sub MPII_DIAGRWADDRHIGH () {	(0x18);}
}
unless(defined(&MPII_INTR_STATUS)) {
    sub MPII_INTR_STATUS () {	(0x30);}
}
unless(defined(&MPII_INTR_STATUS_SYS2IOCDB)) {
    sub MPII_INTR_STATUS_SYS2IOCDB () {	(1<<31);}
}
unless(defined(&MPII_INTR_STATUS_RESET)) {
    sub MPII_INTR_STATUS_RESET () {	(1<<30);}
}
unless(defined(&MPII_INTR_STATUS_REPLY)) {
    sub MPII_INTR_STATUS_REPLY () {	(1<<3);}
}
unless(defined(&MPII_INTR_STATUS_IOC2SYSDB)) {
    sub MPII_INTR_STATUS_IOC2SYSDB () {	(1<<0);}
}
unless(defined(&MPII_INTR_MASK)) {
    sub MPII_INTR_MASK () {	(0x34);}
}
unless(defined(&MPII_INTR_MASK_RESET)) {
    sub MPII_INTR_MASK_RESET () {	(1<<30);}
}
unless(defined(&MPII_INTR_MASK_REPLY)) {
    sub MPII_INTR_MASK_REPLY () {	(1<<3);}
}
unless(defined(&MPII_INTR_MASK_DOORBELL)) {
    sub MPII_INTR_MASK_DOORBELL () {	(1<<0);}
}
unless(defined(&MPII_DCR_DATA)) {
    sub MPII_DCR_DATA () {	(0x38);}
}
unless(defined(&MPII_DCR_ADDRESS)) {
    sub MPII_DCR_ADDRESS () {	(0x3c);}
}
unless(defined(&MPII_REPLY_FREE_HOST_INDEX)) {
    sub MPII_REPLY_FREE_HOST_INDEX () {	(0x48);}
}
unless(defined(&MPII_REPLY_POST_HOST_INDEX)) {
    sub MPII_REPLY_POST_HOST_INDEX () {	(0x6c);}
}
unless(defined(&MPII_HCB_SIZE)) {
    sub MPII_HCB_SIZE () {	(0x74);}
}
unless(defined(&MPII_HCB_ADDRESS_LOW)) {
    sub MPII_HCB_ADDRESS_LOW () {	(0x78);}
}
unless(defined(&MPII_HCB_ADDRESS_HIGH)) {
    sub MPII_HCB_ADDRESS_HIGH () {	(0x7c);}
}
unless(defined(&MPII_REQ_DESCR_POST_LOW)) {
    sub MPII_REQ_DESCR_POST_LOW () {	(0xc0);}
}
unless(defined(&MPII_REQ_DESCR_POST_HIGH)) {
    sub MPII_REQ_DESCR_POST_HIGH () {	(0xc4);}
}
unless(defined(&MPII_SGE_FL_LAST)) {
    sub MPII_SGE_FL_LAST () {	(0x1<<31);}
}
unless(defined(&MPII_SGE_FL_EOB)) {
    sub MPII_SGE_FL_EOB () {	(0x1<<30);}
}
unless(defined(&MPII_SGE_FL_TYPE)) {
    sub MPII_SGE_FL_TYPE () {	(0x3<<28);}
}
unless(defined(&MPII_SGE_FL_TYPE_SIMPLE)) {
    sub MPII_SGE_FL_TYPE_SIMPLE () {	(0x1<<28);}
}
unless(defined(&MPII_SGE_FL_TYPE_CHAIN)) {
    sub MPII_SGE_FL_TYPE_CHAIN () {	(0x3<<28);}
}
unless(defined(&MPII_SGE_FL_TYPE_XACTCTX)) {
    sub MPII_SGE_FL_TYPE_XACTCTX () {	(0x<<28);}
}
unless(defined(&MPII_SGE_FL_LOCAL)) {
    sub MPII_SGE_FL_LOCAL () {	(0x1<<27);}
}
unless(defined(&MPII_SGE_FL_DIR)) {
    sub MPII_SGE_FL_DIR () {	(0x1<<26);}
}
unless(defined(&MPII_SGE_FL_DIR_OUT)) {
    sub MPII_SGE_FL_DIR_OUT () {	(0x1<<26);}
}
unless(defined(&MPII_SGE_FL_DIR_IN)) {
    sub MPII_SGE_FL_DIR_IN () {	(0x<<26);}
}
unless(defined(&MPII_SGE_FL_SIZE)) {
    sub MPII_SGE_FL_SIZE () {	(0x1<<25);}
}
unless(defined(&MPII_SGE_FL_SIZE_32)) {
    sub MPII_SGE_FL_SIZE_32 () {	(0x<<25);}
}
unless(defined(&MPII_SGE_FL_SIZE_64)) {
    sub MPII_SGE_FL_SIZE_64 () {	(0x1<<25);}
}
unless(defined(&MPII_SGE_FL_EOL)) {
    sub MPII_SGE_FL_EOL () {	(0x1<<24);}
}
unless(defined(&MPII_FUNCTION_SCSI_IO_REQUEST)) {
    sub MPII_FUNCTION_SCSI_IO_REQUEST () {	(0x);}
}
unless(defined(&MPII_FUNCTION_SCSI_TASK_MGMT)) {
    sub MPII_FUNCTION_SCSI_TASK_MGMT () {	(0x1);}
}
unless(defined(&MPII_FUNCTION_IOC_INIT)) {
    sub MPII_FUNCTION_IOC_INIT () {	(0x2);}
}
unless(defined(&MPII_FUNCTION_IOC_FACTS)) {
    sub MPII_FUNCTION_IOC_FACTS () {	(0x3);}
}
unless(defined(&MPII_FUNCTION_CONFIG)) {
    sub MPII_FUNCTION_CONFIG () {	(0x4);}
}
unless(defined(&MPII_FUNCTION_PORT_FACTS)) {
    sub MPII_FUNCTION_PORT_FACTS () {	(0x5);}
}
unless(defined(&MPII_FUNCTION_PORT_ENABLE)) {
    sub MPII_FUNCTION_PORT_ENABLE () {	(0x6);}
}
unless(defined(&MPII_FUNCTION_EVENT_NOTIFICATION)) {
    sub MPII_FUNCTION_EVENT_NOTIFICATION () {	(0x7);}
}
unless(defined(&MPII_FUNCTION_EVENT_ACK)) {
    sub MPII_FUNCTION_EVENT_ACK () {	(0x8);}
}
unless(defined(&MPII_FUNCTION_FW_DOWNLOAD)) {
    sub MPII_FUNCTION_FW_DOWNLOAD () {	(0x9);}
}
unless(defined(&MPII_FUNCTION_TARGET_CMD_BUFFER_POST)) {
    sub MPII_FUNCTION_TARGET_CMD_BUFFER_POST () {	(0xa);}
}
unless(defined(&MPII_FUNCTION_TARGET_ASSIST)) {
    sub MPII_FUNCTION_TARGET_ASSIST () {	(0xb);}
}
unless(defined(&MPII_FUNCTION_TARGET_STATUS_SEND)) {
    sub MPII_FUNCTION_TARGET_STATUS_SEND () {	(0xc);}
}
unless(defined(&MPII_FUNCTION_TARGET_MODE_ABORT)) {
    sub MPII_FUNCTION_TARGET_MODE_ABORT () {	(0xd);}
}
unless(defined(&MPII_FUNCTION_FW_UPLOAD)) {
    sub MPII_FUNCTION_FW_UPLOAD () {	(0x12);}
}
unless(defined(&MPII_FUNCTION_RAID_ACTION)) {
    sub MPII_FUNCTION_RAID_ACTION () {	(0x15);}
}
unless(defined(&MPII_FUNCTION_RAID_SCSI_IO_PASSTHROUGH)) {
    sub MPII_FUNCTION_RAID_SCSI_IO_PASSTHROUGH () {	(0x16);}
}
unless(defined(&MPII_FUNCTION_TOOLBOX)) {
    sub MPII_FUNCTION_TOOLBOX () {	(0x17);}
}
unless(defined(&MPII_FUNCTION_SCSI_ENCLOSURE_PROCESSOR)) {
    sub MPII_FUNCTION_SCSI_ENCLOSURE_PROCESSOR () {	(0x18);}
}
unless(defined(&MPII_FUNCTION_SMP_PASSTHROUGH)) {
    sub MPII_FUNCTION_SMP_PASSTHROUGH () {	(0x1a);}
}
unless(defined(&MPII_FUNCTION_SAS_IO_UNIT_CONTROL)) {
    sub MPII_FUNCTION_SAS_IO_UNIT_CONTROL () {	(0x1b);}
}
unless(defined(&MPII_FUNCTION_SATA_PASSTHROUGH)) {
    sub MPII_FUNCTION_SATA_PASSTHROUGH () {	(0x1c);}
}
unless(defined(&MPII_FUNCTION_DIAG_BUFFER_POST)) {
    sub MPII_FUNCTION_DIAG_BUFFER_POST () {	(0x1d);}
}
unless(defined(&MPII_FUNCTION_DIAG_RELEASE)) {
    sub MPII_FUNCTION_DIAG_RELEASE () {	(0x1e);}
}
unless(defined(&MPII_FUNCTION_TARGET_CMD_BUF_BASE_POST)) {
    sub MPII_FUNCTION_TARGET_CMD_BUF_BASE_POST () {	(0x24);}
}
unless(defined(&MPII_FUNCTION_TARGET_CMD_BUF_LIST_POST)) {
    sub MPII_FUNCTION_TARGET_CMD_BUF_LIST_POST () {	(0x25);}
}
unless(defined(&MPII_FUNCTION_IOC_MESSAGE_UNIT_RESET)) {
    sub MPII_FUNCTION_IOC_MESSAGE_UNIT_RESET () {	(0x40);}
}
unless(defined(&MPII_FUNCTION_IO_UNIT_RESET)) {
    sub MPII_FUNCTION_IO_UNIT_RESET () {	(0x41);}
}
unless(defined(&MPII_FUNCTION_HANDSHAKE)) {
    sub MPII_FUNCTION_HANDSHAKE () {	(0x42);}
}
unless(defined(&MPII_IOCSTATUS_MASK)) {
    sub MPII_IOCSTATUS_MASK () {	(0x7fff);}
}
unless(defined(&MPII_IOCSTATUS_SUCCESS)) {
    sub MPII_IOCSTATUS_SUCCESS () {	(0x);}
}
unless(defined(&MPII_IOCSTATUS_INVALID_FUNCTION)) {
    sub MPII_IOCSTATUS_INVALID_FUNCTION () {	(0x1);}
}
unless(defined(&MPII_IOCSTATUS_BUSY)) {
    sub MPII_IOCSTATUS_BUSY () {	(0x2);}
}
unless(defined(&MPII_IOCSTATUS_INVALID_SGL)) {
    sub MPII_IOCSTATUS_INVALID_SGL () {	(0x3);}
}
unless(defined(&MPII_IOCSTATUS_INTERNAL_ERROR)) {
    sub MPII_IOCSTATUS_INTERNAL_ERROR () {	(0x4);}
}
unless(defined(&MPII_IOCSTATUS_INVALID_VPID)) {
    sub MPII_IOCSTATUS_INVALID_VPID () {	(0x5);}
}
unless(defined(&MPII_IOCSTATUS_INSUFFICIENT_RESOURCES)) {
    sub MPII_IOCSTATUS_INSUFFICIENT_RESOURCES () {	(0x6);}
}
unless(defined(&MPII_IOCSTATUS_INVALID_FIELD)) {
    sub MPII_IOCSTATUS_INVALID_FIELD () {	(0x7);}
}
unless(defined(&MPII_IOCSTATUS_INVALID_STATE)) {
    sub MPII_IOCSTATUS_INVALID_STATE () {	(0x8);}
}
unless(defined(&MPII_IOCSTATUS_OP_STATE_NOT_SUPPORTED)) {
    sub MPII_IOCSTATUS_OP_STATE_NOT_SUPPORTED () {	(0x9);}
}
unless(defined(&MPII_IOCSTATUS_CONFIG_INVALID_ACTION)) {
    sub MPII_IOCSTATUS_CONFIG_INVALID_ACTION () {	(0x20);}
}
unless(defined(&MPII_IOCSTATUS_CONFIG_INVALID_TYPE)) {
    sub MPII_IOCSTATUS_CONFIG_INVALID_TYPE () {	(0x21);}
}
unless(defined(&MPII_IOCSTATUS_CONFIG_INVALID_PAGE)) {
    sub MPII_IOCSTATUS_CONFIG_INVALID_PAGE () {	(0x22);}
}
unless(defined(&MPII_IOCSTATUS_CONFIG_INVALID_DATA)) {
    sub MPII_IOCSTATUS_CONFIG_INVALID_DATA () {	(0x23);}
}
unless(defined(&MPII_IOCSTATUS_CONFIG_NO_DEFAULTS)) {
    sub MPII_IOCSTATUS_CONFIG_NO_DEFAULTS () {	(0x24);}
}
unless(defined(&MPII_IOCSTATUS_CONFIG_CANT_COMMIT)) {
    sub MPII_IOCSTATUS_CONFIG_CANT_COMMIT () {	(0x25);}
}
unless(defined(&MPII_IOCSTATUS_SCSI_RECOVERED_ERROR)) {
    sub MPII_IOCSTATUS_SCSI_RECOVERED_ERROR () {	(0x40);}
}
unless(defined(&MPII_IOCSTATUS_SCSI_INVALID_DEVHANDLE)) {
    sub MPII_IOCSTATUS_SCSI_INVALID_DEVHANDLE () {	(0x42);}
}
unless(defined(&MPII_IOCSTATUS_SCSI_DEVICE_NOT_THERE)) {
    sub MPII_IOCSTATUS_SCSI_DEVICE_NOT_THERE () {	(0x43);}
}
unless(defined(&MPII_IOCSTATUS_SCSI_DATA_OVERRUN)) {
    sub MPII_IOCSTATUS_SCSI_DATA_OVERRUN () {	(0x44);}
}
unless(defined(&MPII_IOCSTATUS_SCSI_DATA_UNDERRUN)) {
    sub MPII_IOCSTATUS_SCSI_DATA_UNDERRUN () {	(0x45);}
}
unless(defined(&MPII_IOCSTATUS_SCSI_IO_DATA_ERROR)) {
    sub MPII_IOCSTATUS_SCSI_IO_DATA_ERROR () {	(0x46);}
}
unless(defined(&MPII_IOCSTATUS_SCSI_PROTOCOL_ERROR)) {
    sub MPII_IOCSTATUS_SCSI_PROTOCOL_ERROR () {	(0x47);}
}
unless(defined(&MPII_IOCSTATUS_SCSI_TASK_TERMINATED)) {
    sub MPII_IOCSTATUS_SCSI_TASK_TERMINATED () {	(0x48);}
}
unless(defined(&MPII_IOCSTATUS_SCSI_RESIDUAL_MISMATCH)) {
    sub MPII_IOCSTATUS_SCSI_RESIDUAL_MISMATCH () {	(0x49);}
}
unless(defined(&MPII_IOCSTATUS_SCSI_TASK_MGMT_FAILED)) {
    sub MPII_IOCSTATUS_SCSI_TASK_MGMT_FAILED () {	(0x4a);}
}
unless(defined(&MPII_IOCSTATUS_SCSI_IOC_TERMINATED)) {
    sub MPII_IOCSTATUS_SCSI_IOC_TERMINATED () {	(0x4b);}
}
unless(defined(&MPII_IOCSTATUS_SCSI_EXT_TERMINATED)) {
    sub MPII_IOCSTATUS_SCSI_EXT_TERMINATED () {	(0x4c);}
}
unless(defined(&MPII_IOCSTATUS_EEDP_GUARD_ERROR)) {
    sub MPII_IOCSTATUS_EEDP_GUARD_ERROR () {	(0x4d);}
}
unless(defined(&MPII_IOCSTATUS_EEDP_REF_TAG_ERROR)) {
    sub MPII_IOCSTATUS_EEDP_REF_TAG_ERROR () {	(0x4e);}
}
unless(defined(&MPII_IOCSTATUS_EEDP_APP_TAG_ERROR)) {
    sub MPII_IOCSTATUS_EEDP_APP_TAG_ERROR () {	(0x4f);}
}
unless(defined(&MPII_IOCSTATUS_TARGET_INVALID_IO_INDEX)) {
    sub MPII_IOCSTATUS_TARGET_INVALID_IO_INDEX () {	(0x62);}
}
unless(defined(&MPII_IOCSTATUS_TARGET_ABORTED)) {
    sub MPII_IOCSTATUS_TARGET_ABORTED () {	(0x63);}
}
unless(defined(&MPII_IOCSTATUS_TARGET_NO_CONN_RETRYABLE)) {
    sub MPII_IOCSTATUS_TARGET_NO_CONN_RETRYABLE () {	(0x64);}
}
unless(defined(&MPII_IOCSTATUS_TARGET_NO_CONNECTION)) {
    sub MPII_IOCSTATUS_TARGET_NO_CONNECTION () {	(0x65);}
}
unless(defined(&MPII_IOCSTATUS_TARGET_XFER_COUNT_MISMATCH)) {
    sub MPII_IOCSTATUS_TARGET_XFER_COUNT_MISMATCH () {	(0x6a);}
}
unless(defined(&MPII_IOCSTATUS_TARGET_DATA_OFFSET_ERROR)) {
    sub MPII_IOCSTATUS_TARGET_DATA_OFFSET_ERROR () {	(0x6d);}
}
unless(defined(&MPII_IOCSTATUS_TARGET_TOO_MUCH_WRITE_DATA)) {
    sub MPII_IOCSTATUS_TARGET_TOO_MUCH_WRITE_DATA () {	(0x6e);}
}
unless(defined(&MPII_IOCSTATUS_TARGET_IU_TOO_SHORT)) {
    sub MPII_IOCSTATUS_TARGET_IU_TOO_SHORT () {	(0x6f);}
}
unless(defined(&MPII_IOCSTATUS_TARGET_ACK_NAK_TIMEOUT)) {
    sub MPII_IOCSTATUS_TARGET_ACK_NAK_TIMEOUT () {	(0x70);}
}
unless(defined(&MPII_IOCSTATUS_TARGET_NAK_RECEIVED)) {
    sub MPII_IOCSTATUS_TARGET_NAK_RECEIVED () {	(0x71);}
}
unless(defined(&MPII_IOCSTATUS_SAS_SMP_REQUEST_FAILED)) {
    sub MPII_IOCSTATUS_SAS_SMP_REQUEST_FAILED () {	(0x90);}
}
unless(defined(&MPII_IOCSTATUS_SAS_SMP_DATA_OVERRUN)) {
    sub MPII_IOCSTATUS_SAS_SMP_DATA_OVERRUN () {	(0x91);}
}
unless(defined(&MPII_IOCSTATUS_DIAGNOSTIC_RELEASED)) {
    sub MPII_IOCSTATUS_DIAGNOSTIC_RELEASED () {	(0xa0);}
}
unless(defined(&MPII_REP_IOCLOGINFO_TYPE)) {
    sub MPII_REP_IOCLOGINFO_TYPE () {	(0xf<<28);}
}
unless(defined(&MPII_REP_IOCLOGINFO_TYPE_NONE)) {
    sub MPII_REP_IOCLOGINFO_TYPE_NONE () {	(0x<<28);}
}
unless(defined(&MPII_REP_IOCLOGINFO_TYPE_SCSI)) {
    sub MPII_REP_IOCLOGINFO_TYPE_SCSI () {	(0x1<<28);}
}
unless(defined(&MPII_REP_IOCLOGINFO_TYPE_FC)) {
    sub MPII_REP_IOCLOGINFO_TYPE_FC () {	(0x2<<28);}
}
unless(defined(&MPII_REP_IOCLOGINFO_TYPE_SAS)) {
    sub MPII_REP_IOCLOGINFO_TYPE_SAS () {	(0x3<<28);}
}
unless(defined(&MPII_REP_IOCLOGINFO_TYPE_ISCSI)) {
    sub MPII_REP_IOCLOGINFO_TYPE_ISCSI () {	(0x4<<28);}
}
unless(defined(&MPII_REP_IOCLOGINFO_DATA)) {
    sub MPII_REP_IOCLOGINFO_DATA () {	(0xfffffff);}
}
unless(defined(&MPII_EVENT_NONE)) {
    sub MPII_EVENT_NONE () {	(0x);}
}
unless(defined(&MPII_EVENT_LOG_DATA)) {
    sub MPII_EVENT_LOG_DATA () {	(0x1);}
}
unless(defined(&MPII_EVENT_STATE_CHANGE)) {
    sub MPII_EVENT_STATE_CHANGE () {	(0x2);}
}
unless(defined(&MPII_EVENT_HARD_RESET_RECEIVED)) {
    sub MPII_EVENT_HARD_RESET_RECEIVED () {	(0x5);}
}
unless(defined(&MPII_EVENT_EVENT_CHANGE)) {
    sub MPII_EVENT_EVENT_CHANGE () {	(0xa);}
}
unless(defined(&MPII_EVENT_TASK_SET_FULL)) {
    sub MPII_EVENT_TASK_SET_FULL () {	(0xe);}
}
unless(defined(&MPII_EVENT_SAS_DEVICE_STATUS_CHANGE)) {
    sub MPII_EVENT_SAS_DEVICE_STATUS_CHANGE () {	(0xf);}
}
unless(defined(&MPII_EVENT_IR_OPERATION_STATUS)) {
    sub MPII_EVENT_IR_OPERATION_STATUS () {	(0x14);}
}
unless(defined(&MPII_EVENT_SAS_DISCOVERY)) {
    sub MPII_EVENT_SAS_DISCOVERY () {	(0x16);}
}
unless(defined(&MPII_EVENT_SAS_BROADCAST_PRIMITIVE)) {
    sub MPII_EVENT_SAS_BROADCAST_PRIMITIVE () {	(0x17);}
}
unless(defined(&MPII_EVENT_SAS_INIT_DEVICE_STATUS_CHANGE)) {
    sub MPII_EVENT_SAS_INIT_DEVICE_STATUS_CHANGE () {	(0x18);}
}
unless(defined(&MPII_EVENT_SAS_INIT_TABLE_OVERFLOW)) {
    sub MPII_EVENT_SAS_INIT_TABLE_OVERFLOW () {	(0x19);}
}
unless(defined(&MPII_EVENT_SAS_TOPOLOGY_CHANGE_LIST)) {
    sub MPII_EVENT_SAS_TOPOLOGY_CHANGE_LIST () {	(0x1c);}
}
unless(defined(&MPII_EVENT_SAS_ENCL_DEVICE_STATUS_CHANGE)) {
    sub MPII_EVENT_SAS_ENCL_DEVICE_STATUS_CHANGE () {	(0x1d);}
}
unless(defined(&MPII_EVENT_IR_VOLUME)) {
    sub MPII_EVENT_IR_VOLUME () {	(0x1e);}
}
unless(defined(&MPII_EVENT_IR_PHYSICAL_DISK)) {
    sub MPII_EVENT_IR_PHYSICAL_DISK () {	(0x1f);}
}
unless(defined(&MPII_EVENT_IR_CONFIGURATION_CHANGE_LIST)) {
    sub MPII_EVENT_IR_CONFIGURATION_CHANGE_LIST () {	(0x20);}
}
unless(defined(&MPII_EVENT_LOG_ENTRY_ADDED)) {
    sub MPII_EVENT_LOG_ENTRY_ADDED () {	(0x21);}
}
unless(defined(&MPII_WHOINIT_NOONE)) {
    sub MPII_WHOINIT_NOONE () {	(0x);}
}
unless(defined(&MPII_WHOINIT_SYSTEM_BIOS)) {
    sub MPII_WHOINIT_SYSTEM_BIOS () {	(0x1);}
}
unless(defined(&MPII_WHOINIT_ROM_BIOS)) {
    sub MPII_WHOINIT_ROM_BIOS () {	(0x2);}
}
unless(defined(&MPII_WHOINIT_PCI_PEER)) {
    sub MPII_WHOINIT_PCI_PEER () {	(0x3);}
}
unless(defined(&MPII_WHOINIT_HOST_DRIVER)) {
    sub MPII_WHOINIT_HOST_DRIVER () {	(0x4);}
}
unless(defined(&MPII_WHOINIT_MANUFACTURER)) {
    sub MPII_WHOINIT_MANUFACTURER () {	(0x5);}
}
unless(defined(&MPII_IOCFACTS_EXCEPT_CONFIG_CHECKSUM_FAIL)) {
    sub MPII_IOCFACTS_EXCEPT_CONFIG_CHECKSUM_FAIL () {	(1<<0);}
}
unless(defined(&MPII_IOCFACTS_EXCEPT_RAID_CONFIG_INVALID)) {
    sub MPII_IOCFACTS_EXCEPT_RAID_CONFIG_INVALID () {	(1<<1);}
}
unless(defined(&MPII_IOCFACTS_EXCEPT_FW_CHECKSUM_FAIL)) {
    sub MPII_IOCFACTS_EXCEPT_FW_CHECKSUM_FAIL () {	(1<<2);}
}
unless(defined(&MPII_IOCFACTS_EXCEPT_MANUFACT_CHECKSUM_FAIL)) {
    sub MPII_IOCFACTS_EXCEPT_MANUFACT_CHECKSUM_FAIL () {	(1<<3);}
}
unless(defined(&MPII_IOCFACTS_EXCEPT_METADATA_UNSUPPORTED)) {
    sub MPII_IOCFACTS_EXCEPT_METADATA_UNSUPPORTED () {	(1<<4);}
}
unless(defined(&MPII_IOCFACTS_EXCEPT_IR_FOREIGN_CONFIG_MAC)) {
    sub MPII_IOCFACTS_EXCEPT_IR_FOREIGN_CONFIG_MAC () {	(1<<8);}
}
unless(defined(&MPII_IOCFACTS_CAPABILITY_EVENT_REPLAY)) {
    sub MPII_IOCFACTS_CAPABILITY_EVENT_REPLAY () {	(1<<13);}
}
unless(defined(&MPII_IOCFACTS_CAPABILITY_INTEGRATED_RAID)) {
    sub MPII_IOCFACTS_CAPABILITY_INTEGRATED_RAID () {	(1<<12);}
}
unless(defined(&MPII_IOCFACTS_CAPABILITY_TLR)) {
    sub MPII_IOCFACTS_CAPABILITY_TLR () {	(1<<11);}
}
unless(defined(&MPII_IOCFACTS_CAPABILITY_MULTICAST)) {
    sub MPII_IOCFACTS_CAPABILITY_MULTICAST () {	(1<<8);}
}
unless(defined(&MPII_IOCFACTS_CAPABILITY_BIDIRECTIONAL_TARGET)) {
    sub MPII_IOCFACTS_CAPABILITY_BIDIRECTIONAL_TARGET () {	(1<<7);}
}
unless(defined(&MPII_IOCFACTS_CAPABILITY_EEDP)) {
    sub MPII_IOCFACTS_CAPABILITY_EEDP () {	(1<<6);}
}
unless(defined(&MPII_IOCFACTS_CAPABILITY_SNAPSHOT_BUFFER)) {
    sub MPII_IOCFACTS_CAPABILITY_SNAPSHOT_BUFFER () {	(1<<4);}
}
unless(defined(&MPII_IOCFACTS_CAPABILITY_DIAG_TRACE_BUFFER)) {
    sub MPII_IOCFACTS_CAPABILITY_DIAG_TRACE_BUFFER () {	(1<<3);}
}
unless(defined(&MPII_IOCFACTS_CAPABILITY_TASK_SET_FULL_HANDLING)) {
    sub MPII_IOCFACTS_CAPABILITY_TASK_SET_FULL_HANDLING () {	(1<<2);}
}
unless(defined(&MPII_PORTFACTS_PORTTYPE_INACTIVE)) {
    sub MPII_PORTFACTS_PORTTYPE_INACTIVE () {	(0x);}
}
unless(defined(&MPII_PORTFACTS_PORTTYPE_FC)) {
    sub MPII_PORTFACTS_PORTTYPE_FC () {	(0x10);}
}
unless(defined(&MPII_PORTFACTS_PORTTYPE_ISCSI)) {
    sub MPII_PORTFACTS_PORTTYPE_ISCSI () {	(0x20);}
}
unless(defined(&MPII_PORTFACTS_PORTTYPE_SAS_PHYSICAL)) {
    sub MPII_PORTFACTS_PORTTYPE_SAS_PHYSICAL () {	(0x30);}
}
unless(defined(&MPII_PORTFACTS_PORTTYPE_SAS_VIRTUAL)) {
    sub MPII_PORTFACTS_PORTTYPE_SAS_VIRTUAL () {	(0x31);}
}
unless(defined(&MPII_EVENT_ACK_REQUIRED)) {
    sub MPII_EVENT_ACK_REQUIRED () {	(0x1);}
}
unless(defined(&MPII_EVENT_FLAGS_REPLY_KEPT)) {
    sub MPII_EVENT_FLAGS_REPLY_KEPT () {	(1<<7);}
}
unless(defined(&MPII_FWUPLOAD_IMAGETYPE_IOC_FW)) {
    sub MPII_FWUPLOAD_IMAGETYPE_IOC_FW () {	(0x);}
}
unless(defined(&MPII_FWUPLOAD_IMAGETYPE_NV_FW)) {
    sub MPII_FWUPLOAD_IMAGETYPE_NV_FW () {	(0x1);}
}
unless(defined(&MPII_FWUPLOAD_IMAGETYPE_NV_BACKUP)) {
    sub MPII_FWUPLOAD_IMAGETYPE_NV_BACKUP () {	(0x5);}
}
unless(defined(&MPII_FWUPLOAD_IMAGETYPE_NV_MANUFACTURING)) {
    sub MPII_FWUPLOAD_IMAGETYPE_NV_MANUFACTURING () {	(0x6);}
}
unless(defined(&MPII_FWUPLOAD_IMAGETYPE_NV_CONFIG_1)) {
    sub MPII_FWUPLOAD_IMAGETYPE_NV_CONFIG_1 () {	(0x7);}
}
unless(defined(&MPII_FWUPLOAD_IMAGETYPE_NV_CONFIG_2)) {
    sub MPII_FWUPLOAD_IMAGETYPE_NV_CONFIG_2 () {	(0x8);}
}
unless(defined(&MPII_FWUPLOAD_IMAGETYPE_NV_MEGARAID)) {
    sub MPII_FWUPLOAD_IMAGETYPE_NV_MEGARAID () {	(0x9);}
}
unless(defined(&MPII_FWUPLOAD_IMAGETYPE_NV_COMPLETE)) {
    sub MPII_FWUPLOAD_IMAGETYPE_NV_COMPLETE () {	(0xa);}
}
unless(defined(&MPII_FWUPLOAD_IMAGETYPE_COMMON_BOOT_BLOCK)) {
    sub MPII_FWUPLOAD_IMAGETYPE_COMMON_BOOT_BLOCK () {	(0xb);}
}
unless(defined(&MPII_SCSIIO_ATTR_SIMPLE_Q)) {
    sub MPII_SCSIIO_ATTR_SIMPLE_Q () {	(0x);}
}
unless(defined(&MPII_SCSIIO_ATTR_HEAD_OF_Q)) {
    sub MPII_SCSIIO_ATTR_HEAD_OF_Q () {	(0x1);}
}
unless(defined(&MPII_SCSIIO_ATTR_ORDERED_Q)) {
    sub MPII_SCSIIO_ATTR_ORDERED_Q () {	(0x2);}
}
unless(defined(&MPII_SCSIIO_ATTR_ACA_Q)) {
    sub MPII_SCSIIO_ATTR_ACA_Q () {	(0x4);}
}
unless(defined(&MPII_SCSIIO_ATTR_UNTAGGED)) {
    sub MPII_SCSIIO_ATTR_UNTAGGED () {	(0x5);}
}
unless(defined(&MPII_SCSIIO_ATTR_NO_DISCONNECT)) {
    sub MPII_SCSIIO_ATTR_NO_DISCONNECT () {	(0x7);}
}
unless(defined(&MPII_SCSIIO_DIR_NONE)) {
    sub MPII_SCSIIO_DIR_NONE () {	(0x);}
}
unless(defined(&MPII_SCSIIO_DIR_WRITE)) {
    sub MPII_SCSIIO_DIR_WRITE () {	(0x1);}
}
unless(defined(&MPII_SCSIIO_DIR_READ)) {
    sub MPII_SCSIIO_DIR_READ () {	(0x2);}
}
unless(defined(&MPII_CDB_LEN)) {
    sub MPII_CDB_LEN () {	(32);}
}
if((defined(&notyet) ? &notyet : undef)) {
    eval 'sub MPII_SCSIIO_ERR_STATUS_SUCCESS () {1;}' unless defined(&MPII_SCSIIO_ERR_STATUS_SUCCESS);
    eval 'sub MPII_SCSIIO_ERR_STATUS_CHECK_COND () {1;}' unless defined(&MPII_SCSIIO_ERR_STATUS_CHECK_COND);
    eval 'sub MPII_SCSIIO_ERR_STATUS_BUSY () {1;}' unless defined(&MPII_SCSIIO_ERR_STATUS_BUSY);
    eval 'sub MPII_SCSIIO_ERR_STATUS_INTERMEDIATE () {1;}' unless defined(&MPII_SCSIIO_ERR_STATUS_INTERMEDIATE);
    eval 'sub MPII_SCSIIO_ERR_STATUS_INTERMEDIATE_CONDMET () {1;}' unless defined(&MPII_SCSIIO_ERR_STATUS_INTERMEDIATE_CONDMET);
    eval 'sub MPII_SCSIIO_ERR_STATUS_RESERVATION_CONFLICT () {1;}' unless defined(&MPII_SCSIIO_ERR_STATUS_RESERVATION_CONFLICT);
    eval 'sub MPII_SCSIIO_ERR_STATUS_CMD_TERM () {1;}' unless defined(&MPII_SCSIIO_ERR_STATUS_CMD_TERM);
    eval 'sub MPII_SCSIIO_ERR_STATUS_TASK_SET_FULL () {1;}' unless defined(&MPII_SCSIIO_ERR_STATUS_TASK_SET_FULL);
    eval 'sub MPII_SCSIIO_ERR_STATUS_ACA_ACTIVE () {1;}' unless defined(&MPII_SCSIIO_ERR_STATUS_ACA_ACTIVE);
}
unless(defined(&MPII_SCSIIO_ERR_STATE_AUTOSENSE_VALID)) {
    sub MPII_SCSIIO_ERR_STATE_AUTOSENSE_VALID () {	(1<<0);}
}
unless(defined(&MPII_SCSIIO_ERR_STATE_AUTOSENSE_FAILED)) {
    sub MPII_SCSIIO_ERR_STATE_AUTOSENSE_FAILED () {	(1<<1);}
}
unless(defined(&MPII_SCSIIO_ERR_STATE_NO_SCSI_STATUS)) {
    sub MPII_SCSIIO_ERR_STATE_NO_SCSI_STATUS () {	(1<<2);}
}
unless(defined(&MPII_SCSIIO_ERR_STATE_TERMINATED)) {
    sub MPII_SCSIIO_ERR_STATE_TERMINATED () {	(1<<3);}
}
unless(defined(&MPII_SCSIIO_ERR_STATE_RESPONSE_INFO_VALID)) {
    sub MPII_SCSIIO_ERR_STATE_RESPONSE_INFO_VALID () {	(1<<4);}
}
unless(defined(&MPII_SCSIIO_ERR_STATE_QUEUE_TAG_REJECTED)) {
    sub MPII_SCSIIO_ERR_STATE_QUEUE_TAG_REJECTED () {	(0xffff);}
}
unless(defined(&MPII_REQ_DESCR_TYPE_MASK)) {
    sub MPII_REQ_DESCR_TYPE_MASK () {	(0xe);}
}
unless(defined(&MPII_REQ_DESCR_SCSI_IO)) {
    sub MPII_REQ_DESCR_SCSI_IO () {	(0x);}
}
unless(defined(&MPII_REQ_DESCR_SCSI_TARGET)) {
    sub MPII_REQ_DESCR_SCSI_TARGET () {	(0x2);}
}
unless(defined(&MPII_REQ_DESCR_HIGH_PRIORITY)) {
    sub MPII_REQ_DESCR_HIGH_PRIORITY () {	(0x6);}
}
unless(defined(&MPII_REQ_DESCR_DEFAULT)) {
    sub MPII_REQ_DESCR_DEFAULT () {	(0x8);}
}
unless(defined(&MPII_REPLY_DESCR_TYPE_MASK)) {
    sub MPII_REPLY_DESCR_TYPE_MASK () {	(0xf);}
}
unless(defined(&MPII_REPLY_DESCR_SCSI_IO_SUCCESS)) {
    sub MPII_REPLY_DESCR_SCSI_IO_SUCCESS () {	(0x);}
}
unless(defined(&MPII_REPLY_DESCR_ADDRESS_REPLY)) {
    sub MPII_REPLY_DESCR_ADDRESS_REPLY () {	(0x1);}
}
unless(defined(&MPII_REPLY_DESCR_TARGET_ASSIST_SUCCESS)) {
    sub MPII_REPLY_DESCR_TARGET_ASSIST_SUCCESS () {	(0x2);}
}
unless(defined(&MPII_REPLY_DESCR_TARGET_COMMAND_BUFFER)) {
    sub MPII_REPLY_DESCR_TARGET_COMMAND_BUFFER () {	(0x3);}
}
unless(defined(&MPII_REPLY_DESCR_UNUSED)) {
    sub MPII_REPLY_DESCR_UNUSED () {	(0xf);}
}
unless(defined(&MPII_SCSI_TASK_ABORT_TASK)) {
    sub MPII_SCSI_TASK_ABORT_TASK () {	(0x1);}
}
unless(defined(&MPII_SCSI_TASK_ABRT_TASK_SET)) {
    sub MPII_SCSI_TASK_ABRT_TASK_SET () {	(0x2);}
}
unless(defined(&MPII_SCSI_TASK_TARGET_RESET)) {
    sub MPII_SCSI_TASK_TARGET_RESET () {	(0x3);}
}
unless(defined(&MPII_SCSI_TASK_RESET_BUS)) {
    sub MPII_SCSI_TASK_RESET_BUS () {	(0x4);}
}
unless(defined(&MPII_SCSI_TASK_LOGICAL_UNIT_RESET)) {
    sub MPII_SCSI_TASK_LOGICAL_UNIT_RESET () {	(0x5);}
}
unless(defined(&MPII_SAS_OP_CLEAR_PERSISTENT)) {
    sub MPII_SAS_OP_CLEAR_PERSISTENT () {	(0x2);}
}
unless(defined(&MPII_SAS_OP_PHY_LINK_RESET)) {
    sub MPII_SAS_OP_PHY_LINK_RESET () {	(0x6);}
}
unless(defined(&MPII_SAS_OP_PHY_HARD_RESET)) {
    sub MPII_SAS_OP_PHY_HARD_RESET () {	(0x7);}
}
unless(defined(&MPII_SAS_OP_PHY_CLEAR_ERROR_LOG)) {
    sub MPII_SAS_OP_PHY_CLEAR_ERROR_LOG () {	(0x8);}
}
unless(defined(&MPII_SAS_OP_SEND_PRIMITIVE)) {
    sub MPII_SAS_OP_SEND_PRIMITIVE () {	(0xa);}
}
unless(defined(&MPII_SAS_OP_FORCE_FULL_DISCOVERY)) {
    sub MPII_SAS_OP_FORCE_FULL_DISCOVERY () {	(0xb);}
}
unless(defined(&MPII_SAS_OP_TRANSMIT_PORT_SELECT)) {
    sub MPII_SAS_OP_TRANSMIT_PORT_SELECT () {	(0xc);}
}
unless(defined(&MPII_SAS_OP_REMOVE_DEVICE)) {
    sub MPII_SAS_OP_REMOVE_DEVICE () {	(0xd);}
}
unless(defined(&MPII_SAS_OP_LOOKUP_MAPPING)) {
    sub MPII_SAS_OP_LOOKUP_MAPPING () {	(0xe);}
}
unless(defined(&MPII_SAS_OP_SET_IOC_PARAM)) {
    sub MPII_SAS_OP_SET_IOC_PARAM () {	(0xf);}
}
unless(defined(&MPII_SAS_LOOKUP_METHOD_SAS_ADDR)) {
    sub MPII_SAS_LOOKUP_METHOD_SAS_ADDR () {	(0x1);}
}
unless(defined(&MPII_SAS_LOOKUP_METHOD_SAS_ENCL)) {
    sub MPII_SAS_LOOKUP_METHOD_SAS_ENCL () {	(0x2);}
}
unless(defined(&MPII_SAS_LOOKUP_METHOD_SAS_DEVNAME)) {
    sub MPII_SAS_LOOKUP_METHOD_SAS_DEVNAME () {	(0x3);}
}
unless(defined(&MPII_RAID_ACTION_CHANGE_VOL_WRITE_CACHE)) {
    sub MPII_RAID_ACTION_CHANGE_VOL_WRITE_CACHE () {	(0x17);}
}
unless(defined(&MPII_RAID_VOL_WRITE_CACHE_MASK)) {
    sub MPII_RAID_VOL_WRITE_CACHE_MASK () {	(0x3);}
}
unless(defined(&MPII_RAID_VOL_WRITE_CACHE_DISABLE)) {
    sub MPII_RAID_VOL_WRITE_CACHE_DISABLE () {	(0x1);}
}
unless(defined(&MPII_RAID_VOL_WRITE_CACHE_ENABLE)) {
    sub MPII_RAID_VOL_WRITE_CACHE_ENABLE () {	(0x2);}
}
unless(defined(&MPII_CONFIG_REQ_PAGE_TYPE_ATTRIBUTE)) {
    sub MPII_CONFIG_REQ_PAGE_TYPE_ATTRIBUTE () {	(0xf0);}
}
unless(defined(&MPI2_CONFIG_PAGEATTR_READ_ONLY)) {
    sub MPI2_CONFIG_PAGEATTR_READ_ONLY () {	(0x);}
}
unless(defined(&MPI2_CONFIG_PAGEATTR_CHANGEABLE)) {
    sub MPI2_CONFIG_PAGEATTR_CHANGEABLE () {	(0x10);}
}
unless(defined(&MPI2_CONFIG_PAGEATTR_PERSISTENT)) {
    sub MPI2_CONFIG_PAGEATTR_PERSISTENT () {	(0x20);}
}
unless(defined(&MPII_CONFIG_REQ_PAGE_TYPE_MASK)) {
    sub MPII_CONFIG_REQ_PAGE_TYPE_MASK () {	(0xf);}
}
unless(defined(&MPII_CONFIG_REQ_PAGE_TYPE_IO_UNIT)) {
    sub MPII_CONFIG_REQ_PAGE_TYPE_IO_UNIT () {	(0x);}
}
unless(defined(&MPII_CONFIG_REQ_PAGE_TYPE_IOC)) {
    sub MPII_CONFIG_REQ_PAGE_TYPE_IOC () {	(0x1);}
}
unless(defined(&MPII_CONFIG_REQ_PAGE_TYPE_BIOS)) {
    sub MPII_CONFIG_REQ_PAGE_TYPE_BIOS () {	(0x2);}
}
unless(defined(&MPII_CONFIG_REQ_PAGE_TYPE_RAID_VOL)) {
    sub MPII_CONFIG_REQ_PAGE_TYPE_RAID_VOL () {	(0x8);}
}
unless(defined(&MPII_CONFIG_REQ_PAGE_TYPE_MANUFACTURING)) {
    sub MPII_CONFIG_REQ_PAGE_TYPE_MANUFACTURING () {	(0x9);}
}
unless(defined(&MPII_CONFIG_REQ_PAGE_TYPE_RAID_PD)) {
    sub MPII_CONFIG_REQ_PAGE_TYPE_RAID_PD () {	(0xa);}
}
unless(defined(&MPII_CONFIG_REQ_PAGE_TYPE_EXTENDED)) {
    sub MPII_CONFIG_REQ_PAGE_TYPE_EXTENDED () {	(0xf);}
}
unless(defined(&MPII_CONFIG_REQ_PAGE_TYPE_SAS_DEVICE)) {
    sub MPII_CONFIG_REQ_PAGE_TYPE_SAS_DEVICE () {	(0x12);}
}
unless(defined(&MPII_CONFIG_REQ_PAGE_TYPE_RAID_CONFIG)) {
    sub MPII_CONFIG_REQ_PAGE_TYPE_RAID_CONFIG () {	(0x16);}
}
unless(defined(&MPII_CONFIG_REQ_PAGE_TYPE_DRIVER_MAPPING)) {
    sub MPII_CONFIG_REQ_PAGE_TYPE_DRIVER_MAPPING () {	(0x17);}
}
unless(defined(&MPII_CONFIG_REQ_ACTION_PAGE_HEADER)) {
    sub MPII_CONFIG_REQ_ACTION_PAGE_HEADER () {	(0x);}
}
unless(defined(&MPII_CONFIG_REQ_ACTION_PAGE_READ_CURRENT)) {
    sub MPII_CONFIG_REQ_ACTION_PAGE_READ_CURRENT () {	(0x1);}
}
unless(defined(&MPII_CONFIG_REQ_ACTION_PAGE_WRITE_CURRENT)) {
    sub MPII_CONFIG_REQ_ACTION_PAGE_WRITE_CURRENT () {	(0x2);}
}
unless(defined(&MPII_CONFIG_REQ_ACTION_PAGE_DEFAULT)) {
    sub MPII_CONFIG_REQ_ACTION_PAGE_DEFAULT () {	(0x3);}
}
unless(defined(&MPII_CONFIG_REQ_ACTION_PAGE_WRITE_NVRAM)) {
    sub MPII_CONFIG_REQ_ACTION_PAGE_WRITE_NVRAM () {	(0x4);}
}
unless(defined(&MPII_CONFIG_REQ_ACTION_PAGE_READ_DEFAULT)) {
    sub MPII_CONFIG_REQ_ACTION_PAGE_READ_DEFAULT () {	(0x5);}
}
unless(defined(&MPII_CONFIG_REQ_ACTION_PAGE_READ_NVRAM)) {
    sub MPII_CONFIG_REQ_ACTION_PAGE_READ_NVRAM () {	(0x6);}
}
unless(defined(&MPII_CONFIG_REQ_EXTPAGE_TYPE_SAS_IO_UNIT)) {
    sub MPII_CONFIG_REQ_EXTPAGE_TYPE_SAS_IO_UNIT () {	(0x10);}
}
unless(defined(&MPII_CONFIG_REQ_EXTPAGE_TYPE_SAS_EXPANDER)) {
    sub MPII_CONFIG_REQ_EXTPAGE_TYPE_SAS_EXPANDER () {	(0x11);}
}
unless(defined(&MPII_CONFIG_REQ_EXTPAGE_TYPE_SAS_DEVICE)) {
    sub MPII_CONFIG_REQ_EXTPAGE_TYPE_SAS_DEVICE () {	(0x12);}
}
unless(defined(&MPII_CONFIG_REQ_EXTPAGE_TYPE_SAS_PHY)) {
    sub MPII_CONFIG_REQ_EXTPAGE_TYPE_SAS_PHY () {	(0x13);}
}
unless(defined(&MPII_CONFIG_REQ_EXTPAGE_TYPE_LOG)) {
    sub MPII_CONFIG_REQ_EXTPAGE_TYPE_LOG () {	(0x14);}
}
unless(defined(&MPI2_CONFIG_EXTPAGETYPE_ENCLOSURE)) {
    sub MPI2_CONFIG_EXTPAGETYPE_ENCLOSURE () {	(0x15);}
}
unless(defined(&MPI2_CONFIG_EXTPAGETYPE_RAID_CONFIG)) {
    sub MPI2_CONFIG_EXTPAGETYPE_RAID_CONFIG () {	(0x16);}
}
unless(defined(&MPI2_CONFIG_EXTPAGETYPE_DRIVER_MAPPING)) {
    sub MPI2_CONFIG_EXTPAGETYPE_DRIVER_MAPPING () {	(0x17);}
}
unless(defined(&MPI2_CONFIG_EXTPAGETYPE_SAS_PORT)) {
    sub MPI2_CONFIG_EXTPAGETYPE_SAS_PORT () {	(0x18);}
}
unless(defined(&MPII_CFG_IOC_1_REPLY_COALESCING)) {
    sub MPII_CFG_IOC_1_REPLY_COALESCING () {	(1<<0);}
}
unless(defined(&MPII_IOC_PG8_FLAGS_DA_START_SLOT_1)) {
    sub MPII_IOC_PG8_FLAGS_DA_START_SLOT_1 () {	(1<<5);}
}
unless(defined(&MPII_IOC_PG8_FLAGS_RESERVED_TARGETID_0)) {
    sub MPII_IOC_PG8_FLAGS_RESERVED_TARGETID_0 () {	(1<<4);}
}
unless(defined(&MPII_IOC_PG8_FLAGS_MAPPING_MODE_MASK)) {
    sub MPII_IOC_PG8_FLAGS_MAPPING_MODE_MASK () {	(0xe);}
}
unless(defined(&MPII_IOC_PG8_FLAGS_DEVICE_PERSISTENCE_MAPPING)) {
    sub MPII_IOC_PG8_FLAGS_DEVICE_PERSISTENCE_MAPPING () {	(0<<1);}
}
unless(defined(&MPII_IOC_PG8_FLAGS_ENCLOSURE_SLOT_MAPPING)) {
    sub MPII_IOC_PG8_FLAGS_ENCLOSURE_SLOT_MAPPING () {	(1<<1);}
}
unless(defined(&MPII_IOC_PG8_FLAGS_DISABLE_PERSISTENT_MAPPING)) {
    sub MPII_IOC_PG8_FLAGS_DISABLE_PERSISTENT_MAPPING () {	(1<<0);}
}
unless(defined(&MPII_IOC_PG8_FLAGS_ENABLE_PERSISTENT_MAPPING)) {
    sub MPII_IOC_PG8_FLAGS_ENABLE_PERSISTENT_MAPPING () {	(0<<0);}
}
unless(defined(&MPII_IOC_PG8_IRFLAGS_VOLUME_MAPPING_MODE_MASK)) {
    sub MPII_IOC_PG8_IRFLAGS_VOLUME_MAPPING_MODE_MASK () {	(0x3);}
}
unless(defined(&MPII_IOC_PG8_IRFLAGS_LOW_VOLUME_MAPPING)) {
    sub MPII_IOC_PG8_IRFLAGS_LOW_VOLUME_MAPPING () {	(0<<0);}
}
unless(defined(&MPII_IOC_PG8_IRFLAGS_HIGH_VOLUME_MAPPING)) {
    sub MPII_IOC_PG8_IRFLAGS_HIGH_VOLUME_MAPPING () {	(1<<0);}
}
unless(defined(&MPII_CFG_RAID_VOL_ADDR_HANDLE)) {
    sub MPII_CFG_RAID_VOL_ADDR_HANDLE () {	(1<<28);}
}
unless(defined(&MPII_CFG_RAID_VOL_0_STATE_MISSING)) {
    sub MPII_CFG_RAID_VOL_0_STATE_MISSING () {	(0x);}
}
unless(defined(&MPII_CFG_RAID_VOL_0_STATE_FAILED)) {
    sub MPII_CFG_RAID_VOL_0_STATE_FAILED () {	(0x1);}
}
unless(defined(&MPII_CFG_RAID_VOL_0_STATE_INITIALIZING)) {
    sub MPII_CFG_RAID_VOL_0_STATE_INITIALIZING () {	(0x2);}
}
unless(defined(&MPII_CFG_RAID_VOL_0_STATE_ONLINE)) {
    sub MPII_CFG_RAID_VOL_0_STATE_ONLINE () {	(0x3);}
}
unless(defined(&MPII_CFG_RAID_VOL_0_STATE_DEGRADED)) {
    sub MPII_CFG_RAID_VOL_0_STATE_DEGRADED () {	(0x4);}
}
unless(defined(&MPII_CFG_RAID_VOL_0_STATE_OPTIMAL)) {
    sub MPII_CFG_RAID_VOL_0_STATE_OPTIMAL () {	(0x5);}
}
unless(defined(&MPII_CFG_RAID_VOL_0_TYPE_RAID0)) {
    sub MPII_CFG_RAID_VOL_0_TYPE_RAID0 () {	(0x);}
}
unless(defined(&MPII_CFG_RAID_VOL_0_TYPE_RAID1E)) {
    sub MPII_CFG_RAID_VOL_0_TYPE_RAID1E () {	(0x1);}
}
unless(defined(&MPII_CFG_RAID_VOL_0_TYPE_RAID1)) {
    sub MPII_CFG_RAID_VOL_0_TYPE_RAID1 () {	(0x2);}
}
unless(defined(&MPII_CFG_RAID_VOL_0_TYPE_RAID10)) {
    sub MPII_CFG_RAID_VOL_0_TYPE_RAID10 () {	(0x5);}
}
unless(defined(&MPII_CFG_RAID_VOL_0_TYPE_UNKNOWN)) {
    sub MPII_CFG_RAID_VOL_0_TYPE_UNKNOWN () {	(0xff);}
}
unless(defined(&MPII_CFG_RAID_VOL_0_STATUS_SCRUB)) {
    sub MPII_CFG_RAID_VOL_0_STATUS_SCRUB () {	(1<<20);}
}
unless(defined(&MPII_CFG_RAID_VOL_0_STATUS_RESYNC)) {
    sub MPII_CFG_RAID_VOL_0_STATUS_RESYNC () {	(1<<16);}
}
unless(defined(&MPII_CFG_RAID_VOL_0_SETTINGS_CACHE_MASK)) {
    sub MPII_CFG_RAID_VOL_0_SETTINGS_CACHE_MASK () {	(0x3<<0);}
}
unless(defined(&MPII_CFG_RAID_VOL_0_SETTINGS_CACHE_UNCHANGED)) {
    sub MPII_CFG_RAID_VOL_0_SETTINGS_CACHE_UNCHANGED () {	(0x<<0);}
}
unless(defined(&MPII_CFG_RAID_VOL_0_SETTINGS_CACHE_DISABLED)) {
    sub MPII_CFG_RAID_VOL_0_SETTINGS_CACHE_DISABLED () {	(0x1<<0);}
}
unless(defined(&MPII_CFG_RAID_VOL_0_SETTINGS_CACHE_ENABLED)) {
    sub MPII_CFG_RAID_VOL_0_SETTINGS_CACHE_ENABLED () {	(0x2<<0);}
}
unless(defined(&MPII_CFG_RAID_VOL_0_INACTIVE_UNKNOWN)) {
    sub MPII_CFG_RAID_VOL_0_INACTIVE_UNKNOWN () {	(0x);}
}
unless(defined(&MPII_CFG_RAID_VOL_0_INACTIVE_STALE_META)) {
    sub MPII_CFG_RAID_VOL_0_INACTIVE_STALE_META () {	(0x1);}
}
unless(defined(&MPII_CFG_RAID_VOL_0_INACTIVE_FOREIGN_VOL)) {
    sub MPII_CFG_RAID_VOL_0_INACTIVE_FOREIGN_VOL () {	(0x2);}
}
unless(defined(&MPII_CFG_RAID_VOL_0_INACTIVE_NO_RESOURCES)) {
    sub MPII_CFG_RAID_VOL_0_INACTIVE_NO_RESOURCES () {	(0x3);}
}
unless(defined(&MPII_CFG_RAID_VOL_0_INACTIVE_CLONED_VOL)) {
    sub MPII_CFG_RAID_VOL_0_INACTIVE_CLONED_VOL () {	(0x4);}
}
unless(defined(&MPII_CFG_RAID_VOL_0_INACTIVE_INSUF_META)) {
    sub MPII_CFG_RAID_VOL_0_INACTIVE_INSUF_META () {	(0x5);}
}
unless(defined(&MPII_CFG_RAID_PHYS_DISK_ADDR_NUMBER)) {
    sub MPII_CFG_RAID_PHYS_DISK_ADDR_NUMBER () {	(1<<28);}
}
unless(defined(&MPII_CFG_RAID_PHYDISK_0_ENCTYPE_NONE)) {
    sub MPII_CFG_RAID_PHYDISK_0_ENCTYPE_NONE () {	(0x);}
}
unless(defined(&MPII_CFG_RAID_PHYDISK_0_ENCTYPE_SAFTE)) {
    sub MPII_CFG_RAID_PHYDISK_0_ENCTYPE_SAFTE () {	(0x1);}
}
unless(defined(&MPII_CFG_RAID_PHYDISK_0_ENCTYPE_SES)) {
    sub MPII_CFG_RAID_PHYDISK_0_ENCTYPE_SES () {	(0x2);}
}
unless(defined(&MPII_CFG_RAID_PHYDISK_0_STATE_NOTCONFIGURED)) {
    sub MPII_CFG_RAID_PHYDISK_0_STATE_NOTCONFIGURED () {	(0x);}
}
unless(defined(&MPII_CFG_RAID_PHYDISK_0_STATE_NOTCOMPATIBLE)) {
    sub MPII_CFG_RAID_PHYDISK_0_STATE_NOTCOMPATIBLE () {	(0x1);}
}
unless(defined(&MPII_CFG_RAID_PHYDISK_0_STATE_OFFLINE)) {
    sub MPII_CFG_RAID_PHYDISK_0_STATE_OFFLINE () {	(0x2);}
}
unless(defined(&MPII_CFG_RAID_PHYDISK_0_STATE_ONLINE)) {
    sub MPII_CFG_RAID_PHYDISK_0_STATE_ONLINE () {	(0x3);}
}
unless(defined(&MPII_CFG_RAID_PHYDISK_0_STATE_HOTSPARE)) {
    sub MPII_CFG_RAID_PHYDISK_0_STATE_HOTSPARE () {	(0x4);}
}
unless(defined(&MPII_CFG_RAID_PHYDISK_0_STATE_DEGRADED)) {
    sub MPII_CFG_RAID_PHYDISK_0_STATE_DEGRADED () {	(0x5);}
}
unless(defined(&MPII_CFG_RAID_PHYDISK_0_STATE_REBUILDING)) {
    sub MPII_CFG_RAID_PHYDISK_0_STATE_REBUILDING () {	(0x6);}
}
unless(defined(&MPII_CFG_RAID_PHYDISK_0_STATE_OPTIMAL)) {
    sub MPII_CFG_RAID_PHYDISK_0_STATE_OPTIMAL () {	(0x7);}
}
unless(defined(&MPII_CFG_RAID_PHYDISK_0_OFFLINE_MISSING)) {
    sub MPII_CFG_RAID_PHYDISK_0_OFFLINE_MISSING () {	(0x1);}
}
unless(defined(&MPII_CFG_RAID_PHYDISK_0_OFFLINE_FAILED)) {
    sub MPII_CFG_RAID_PHYDISK_0_OFFLINE_FAILED () {	(0x3);}
}
unless(defined(&MPII_CFG_RAID_PHYDISK_0_OFFLINE_INITIALIZING)) {
    sub MPII_CFG_RAID_PHYDISK_0_OFFLINE_INITIALIZING () {	(0x4);}
}
unless(defined(&MPII_CFG_RAID_PHYDISK_0_OFFLINE_REQUESTED)) {
    sub MPII_CFG_RAID_PHYDISK_0_OFFLINE_REQUESTED () {	(0x5);}
}
unless(defined(&MPII_CFG_RAID_PHYDISK_0_OFFLINE_FAILEDREQ)) {
    sub MPII_CFG_RAID_PHYDISK_0_OFFLINE_FAILEDREQ () {	(0x6);}
}
unless(defined(&MPII_CFG_RAID_PHYDISK_0_OFFLINE_OTHER)) {
    sub MPII_CFG_RAID_PHYDISK_0_OFFLINE_OTHER () {	(0xff);}
}
unless(defined(&MPII_CFG_RAID_PHYDISK_0_STATUS_OUTOFSYNC)) {
    sub MPII_CFG_RAID_PHYDISK_0_STATUS_OUTOFSYNC () {	(1<<0);}
}
unless(defined(&MPII_CFG_RAID_PHYDISK_0_STATUS_QUIESCED)) {
    sub MPII_CFG_RAID_PHYDISK_0_STATUS_QUIESCED () {	(1<<1);}
}
unless(defined(&MPII_CFG_RAID_PHYDISK_PATH_INVALID)) {
    sub MPII_CFG_RAID_PHYDISK_PATH_INVALID () {	(1<<0);}
}
unless(defined(&MPII_CFG_RAID_PHYDISK_PATH_BROKEN)) {
    sub MPII_CFG_RAID_PHYDISK_PATH_BROKEN () {	(1<<1);}
}
unless(defined(&MPII_CFG_SAS_DEV_ADDR_NEXT)) {
    sub MPII_CFG_SAS_DEV_ADDR_NEXT () {	(0<<28);}
}
unless(defined(&MPII_CFG_SAS_DEV_ADDR_BUS)) {
    sub MPII_CFG_SAS_DEV_ADDR_BUS () {	(1<<28);}
}
unless(defined(&MPII_CFG_SAS_DEV_ADDR_HANDLE)) {
    sub MPII_CFG_SAS_DEV_ADDR_HANDLE () {	(2<<28);}
}
unless(defined(&MPII_CFG_SAS_DEV_0_DEVINFO_TYPE)) {
    sub MPII_CFG_SAS_DEV_0_DEVINFO_TYPE () {	(0x7);}
}
unless(defined(&MPII_CFG_SAS_DEV_0_DEVINFO_TYPE_NONE)) {
    sub MPII_CFG_SAS_DEV_0_DEVINFO_TYPE_NONE () {	(0x);}
}
unless(defined(&MPII_CFG_SAS_DEV_0_DEVINFO_TYPE_END)) {
    sub MPII_CFG_SAS_DEV_0_DEVINFO_TYPE_END () {	(0x1);}
}
unless(defined(&MPII_CFG_SAS_DEV_0_DEVINFO_TYPE_EDGE_EXPANDER)) {
    sub MPII_CFG_SAS_DEV_0_DEVINFO_TYPE_EDGE_EXPANDER () {	(0x2);}
}
unless(defined(&MPII_CFG_SAS_DEV_0_DEVINFO_TYPE_FANOUT_EXPANDER)) {
    sub MPII_CFG_SAS_DEV_0_DEVINFO_TYPE_FANOUT_EXPANDER () {	(0x3);}
}
unless(defined(&MPII_CFG_SAS_DEV_0_DEVINFO_SATA_HOST)) {
    sub MPII_CFG_SAS_DEV_0_DEVINFO_SATA_HOST () {	(1<<3);}
}
unless(defined(&MPII_CFG_SAS_DEV_0_DEVINFO_SMP_INITIATOR)) {
    sub MPII_CFG_SAS_DEV_0_DEVINFO_SMP_INITIATOR () {	(1<<4);}
}
unless(defined(&MPII_CFG_SAS_DEV_0_DEVINFO_STP_INITIATOR)) {
    sub MPII_CFG_SAS_DEV_0_DEVINFO_STP_INITIATOR () {	(1<<5);}
}
unless(defined(&MPII_CFG_SAS_DEV_0_DEVINFO_SSP_INITIATOR)) {
    sub MPII_CFG_SAS_DEV_0_DEVINFO_SSP_INITIATOR () {	(1<<6);}
}
unless(defined(&MPII_CFG_SAS_DEV_0_DEVINFO_SATA_DEVICE)) {
    sub MPII_CFG_SAS_DEV_0_DEVINFO_SATA_DEVICE () {	(1<<7);}
}
unless(defined(&MPII_CFG_SAS_DEV_0_DEVINFO_SMP_TARGET)) {
    sub MPII_CFG_SAS_DEV_0_DEVINFO_SMP_TARGET () {	(1<<8);}
}
unless(defined(&MPII_CFG_SAS_DEV_0_DEVINFO_STP_TARGET)) {
    sub MPII_CFG_SAS_DEV_0_DEVINFO_STP_TARGET () {	(1<<9);}
}
unless(defined(&MPII_CFG_SAS_DEV_0_DEVINFO_SSP_TARGET)) {
    sub MPII_CFG_SAS_DEV_0_DEVINFO_SSP_TARGET () {	(1<<10);}
}
unless(defined(&MPII_CFG_SAS_DEV_0_DEVINFO_DIRECT_ATTACHED)) {
    sub MPII_CFG_SAS_DEV_0_DEVINFO_DIRECT_ATTACHED () {	(1<<11);}
}
unless(defined(&MPII_CFG_SAS_DEV_0_DEVINFO_LSI_DEVICE)) {
    sub MPII_CFG_SAS_DEV_0_DEVINFO_LSI_DEVICE () {	(1<<12);}
}
unless(defined(&MPII_CFG_SAS_DEV_0_DEVINFO_ATAPI_DEVICE)) {
    sub MPII_CFG_SAS_DEV_0_DEVINFO_ATAPI_DEVICE () {	(1<<13);}
}
unless(defined(&MPII_CFG_SAS_DEV_0_DEVINFO_SEP_DEVICE)) {
    sub MPII_CFG_SAS_DEV_0_DEVINFO_SEP_DEVICE () {	(1<<14);}
}
unless(defined(&MPII_CFG_SAS_DEV_0_FLAGS_DEV_PRESENT)) {
    sub MPII_CFG_SAS_DEV_0_FLAGS_DEV_PRESENT () {	(1<<0);}
}
unless(defined(&MPII_CFG_SAS_DEV_0_FLAGS_DEV_MAPPED)) {
    sub MPII_CFG_SAS_DEV_0_FLAGS_DEV_MAPPED () {	(1<<1);}
}
unless(defined(&MPII_CFG_SAS_DEV_0_FLAGS_DEV_MAPPED_PERSISTENT)) {
    sub MPII_CFG_SAS_DEV_0_FLAGS_DEV_MAPPED_PERSISTENT () {	(1<<2);}
}
unless(defined(&MPII_CFG_SAS_DEV_0_FLAGS_SATA_PORT_SELECTOR)) {
    sub MPII_CFG_SAS_DEV_0_FLAGS_SATA_PORT_SELECTOR () {	(1<<3);}
}
unless(defined(&MPII_CFG_SAS_DEV_0_FLAGS_SATA_FUA)) {
    sub MPII_CFG_SAS_DEV_0_FLAGS_SATA_FUA () {	(1<<4);}
}
unless(defined(&MPII_CFG_SAS_DEV_0_FLAGS_SATA_NCQ)) {
    sub MPII_CFG_SAS_DEV_0_FLAGS_SATA_NCQ () {	(1<<5);}
}
unless(defined(&MPII_CFG_SAS_DEV_0_FLAGS_SATA_SMART)) {
    sub MPII_CFG_SAS_DEV_0_FLAGS_SATA_SMART () {	(1<<6);}
}
unless(defined(&MPII_CFG_SAS_DEV_0_FLAGS_SATA_LBA48)) {
    sub MPII_CFG_SAS_DEV_0_FLAGS_SATA_LBA48 () {	(1<<7);}
}
unless(defined(&MPII_CFG_SAS_DEV_0_FLAGS_UNSUPPORTED)) {
    sub MPII_CFG_SAS_DEV_0_FLAGS_UNSUPPORTED () {	(1<<8);}
}
unless(defined(&MPII_CFG_SAS_DEV_0_FLAGS_SATA_SETTINGS)) {
    sub MPII_CFG_SAS_DEV_0_FLAGS_SATA_SETTINGS () {	(1<<9);}
}
unless(defined(&MPII_CFG_RAID_CONFIG_ACTIVE_CONFIG)) {
    sub MPII_CFG_RAID_CONFIG_ACTIVE_CONFIG () {	(2<<28);}
}
unless(defined(&MPII_CFG_RAID_CONFIG_0_FLAGS_NATIVE)) {
    sub MPII_CFG_RAID_CONFIG_0_FLAGS_NATIVE () {	(0<<0);}
}
unless(defined(&MPII_CFG_RAID_CONFIG_0_FLAGS_FOREIGN)) {
    sub MPII_CFG_RAID_CONFIG_0_FLAGS_FOREIGN () {	(1<<0);}
}
unless(defined(&MPII_RAID_CONFIG_ELEMENT_FLAG_VOLUME)) {
    sub MPII_RAID_CONFIG_ELEMENT_FLAG_VOLUME () {	(0x);}
}
unless(defined(&MPII_RAID_CONFIG_ELEMENT_FLAG_VOLUME_PHYS_DISK)) {
    sub MPII_RAID_CONFIG_ELEMENT_FLAG_VOLUME_PHYS_DISK () {	(0x1);}
}
unless(defined(&MPII_RAID_CONFIG_ELEMENT_FLAG_HSP_PHYS_DISK)) {
    sub MPII_RAID_CONFIG_ELEMENT_FLAG_HSP_PHYS_DISK () {	(0x2);}
}
unless(defined(&MPII_RAID_CONFIG_ELEMENT_ONLINE_CE_PHYS_DISK)) {
    sub MPII_RAID_CONFIG_ELEMENT_ONLINE_CE_PHYS_DISK () {	(0x3);}
}
unless(defined(&MPII_DPM_ADDRESS_FORM_MASK)) {
    sub MPII_DPM_ADDRESS_FORM_MASK () {	(0xf0000000);}
}
unless(defined(&MPII_DPM_ADDRESS_FORM_ENTRY_RANGE)) {
    sub MPII_DPM_ADDRESS_FORM_ENTRY_RANGE () {	(0x);}
}
unless(defined(&MPII_DPM_ADDRESS_ENTRY_COUNT_MASK)) {
    sub MPII_DPM_ADDRESS_ENTRY_COUNT_MASK () {	(0xfff0000);}
}
unless(defined(&MPII_DPM_ADDRESS_ENTRY_COUNT_SHIFT)) {
    sub MPII_DPM_ADDRESS_ENTRY_COUNT_SHIFT () {	(16);}
}
unless(defined(&MPII_DPM_ADDRESS_START_ENTRY_MASK)) {
    sub MPII_DPM_ADDRESS_START_ENTRY_MASK () {	(0xffff);}
}
unless(defined(&MPII_EVENT_SAS_DISC_FLAGS_DEV_CHANGE_MASK)) {
    sub MPII_EVENT_SAS_DISC_FLAGS_DEV_CHANGE_MASK () {	(1<<1);}
}
unless(defined(&MPII_EVENT_SAS_DISC_FLAGS_DEV_CHANGE_NO_CHANGE)) {
    sub MPII_EVENT_SAS_DISC_FLAGS_DEV_CHANGE_NO_CHANGE () {	(0<<1);}
}
unless(defined(&MPII_EVENT_SAS_DISC_FLAGS_DEV_CHANGE_CHANGE)) {
    sub MPII_EVENT_SAS_DISC_FLAGS_DEV_CHANGE_CHANGE () {	(1<<1);}
}
unless(defined(&MPII_EVENT_SAS_DISC_FLAGS_DISC_IN_PROG_MASK)) {
    sub MPII_EVENT_SAS_DISC_FLAGS_DISC_IN_PROG_MASK () {	(1<<0);}
}
unless(defined(&MPII_EVENT_SAS_DISC_FLAGS_DISC_NOT_IN_PROGRESS)) {
    sub MPII_EVENT_SAS_DISC_FLAGS_DISC_NOT_IN_PROGRESS () {	(1<<0);}
}
unless(defined(&MPII_EVENT_SAS_DISC_FLAGS_DISC_IN_PROGRESS)) {
    sub MPII_EVENT_SAS_DISC_FLAGS_DISC_IN_PROGRESS () {	(0<<0);}
}
unless(defined(&MPII_EVENT_SAS_DISC_REASON_CODE_STARTED)) {
    sub MPII_EVENT_SAS_DISC_REASON_CODE_STARTED () {	(0x1);}
}
unless(defined(&MPII_EVENT_SAS_DISC_REASON_CODE_COMPLETED)) {
    sub MPII_EVENT_SAS_DISC_REASON_CODE_COMPLETED () {	(0x2);}
}
unless(defined(&MPII_EVENT_IR_RAIDOP_RESYNC)) {
    sub MPII_EVENT_IR_RAIDOP_RESYNC () {	(0x);}
}
unless(defined(&MPII_EVENT_IR_RAIDOP_OCE)) {
    sub MPII_EVENT_IR_RAIDOP_OCE () {	(0x1);}
}
unless(defined(&MPII_EVENT_IR_RAIDOP_CONS_CHECK)) {
    sub MPII_EVENT_IR_RAIDOP_CONS_CHECK () {	(0x2);}
}
unless(defined(&MPII_EVENT_IR_RAIDOP_BG_INIT)) {
    sub MPII_EVENT_IR_RAIDOP_BG_INIT () {	(0x3);}
}
unless(defined(&MPII_EVENT_IR_RAIDOP_MAKE_CONS)) {
    sub MPII_EVENT_IR_RAIDOP_MAKE_CONS () {	(0x4);}
}
unless(defined(&MPII_EVENT_IR_VOL_RC_SETTINGS_CHANGED)) {
    sub MPII_EVENT_IR_VOL_RC_SETTINGS_CHANGED () {	(0x1);}
}
unless(defined(&MPII_EVENT_IR_VOL_RC_STATUS_CHANGED)) {
    sub MPII_EVENT_IR_VOL_RC_STATUS_CHANGED () {	(0x2);}
}
unless(defined(&MPII_EVENT_IR_VOL_RC_STATE_CHANGED)) {
    sub MPII_EVENT_IR_VOL_RC_STATE_CHANGED () {	(0x3);}
}
unless(defined(&MPII_EVENT_IR_PD_RC_SETTINGS_CHANGED)) {
    sub MPII_EVENT_IR_PD_RC_SETTINGS_CHANGED () {	(0x1);}
}
unless(defined(&MPII_EVENT_IR_PD_RC_STATUS_FLAGS_CHANGED)) {
    sub MPII_EVENT_IR_PD_RC_STATUS_FLAGS_CHANGED () {	(0x2);}
}
unless(defined(&MPII_EVENT_IR_PD_RC_STATUS_CHANGED)) {
    sub MPII_EVENT_IR_PD_RC_STATUS_CHANGED () {	(0x3);}
}
unless(defined(&MPII_EVENT_SAS_TOPO_ES_ADDED)) {
    sub MPII_EVENT_SAS_TOPO_ES_ADDED () {	(0x1);}
}
unless(defined(&MPII_EVENT_SAS_TOPO_ES_NOT_RESPONDING)) {
    sub MPII_EVENT_SAS_TOPO_ES_NOT_RESPONDING () {	(0x2);}
}
unless(defined(&MPII_EVENT_SAS_TOPO_ES_RESPONDING)) {
    sub MPII_EVENT_SAS_TOPO_ES_RESPONDING () {	(0x3);}
}
unless(defined(&MPII_EVENT_SAS_TOPO_ES_DELAY_NOT_RESPONDING)) {
    sub MPII_EVENT_SAS_TOPO_ES_DELAY_NOT_RESPONDING () {	(0x4);}
}
unless(defined(&MPII_EVENT_SAS_TOPO_PS_RC_MASK)) {
    sub MPII_EVENT_SAS_TOPO_PS_RC_MASK () {	(0xf);}
}
unless(defined(&MPII_EVENT_SAS_TOPO_PS_RC_ADDED)) {
    sub MPII_EVENT_SAS_TOPO_PS_RC_ADDED () {	(0x1);}
}
unless(defined(&MPII_EVENT_SAS_TOPO_PS_RC_MISSING)) {
    sub MPII_EVENT_SAS_TOPO_PS_RC_MISSING () {	(0x2);}
}
unless(defined(&MPII_EVT_IR_CFG_CHANGE_LIST_FOREIGN)) {
    sub MPII_EVT_IR_CFG_CHANGE_LIST_FOREIGN () {	(0x1);}
}
unless(defined(&MPII_EVT_IR_CFG_ELEMENT_TYPE_MASK)) {
    sub MPII_EVT_IR_CFG_ELEMENT_TYPE_MASK () {	(0xf);}
}
unless(defined(&MPII_EVT_IR_CFG_ELEMENT_TYPE_VOLUME)) {
    sub MPII_EVT_IR_CFG_ELEMENT_TYPE_VOLUME () {	(0x);}
}
unless(defined(&MPII_EVT_IR_CFG_ELEMENT_TYPE_VOLUME_DISK)) {
    sub MPII_EVT_IR_CFG_ELEMENT_TYPE_VOLUME_DISK () {	(0x1);}
}
unless(defined(&MPII_EVT_IR_CFG_ELEMENT_TYPE_HOT_SPARE)) {
    sub MPII_EVT_IR_CFG_ELEMENT_TYPE_HOT_SPARE () {	(0x2);}
}
unless(defined(&MPII_EVT_IR_CFG_ELEMENT_RC_ADDED)) {
    sub MPII_EVT_IR_CFG_ELEMENT_RC_ADDED () {	(0x1);}
}
unless(defined(&MPII_EVT_IR_CFG_ELEMENT_RC_REMOVED)) {
    sub MPII_EVT_IR_CFG_ELEMENT_RC_REMOVED () {	(0x2);}
}
unless(defined(&MPII_EVT_IR_CFG_ELEMENT_RC_NO_CHANGE)) {
    sub MPII_EVT_IR_CFG_ELEMENT_RC_NO_CHANGE () {	(0x3);}
}
unless(defined(&MPII_EVT_IR_CFG_ELEMENT_RC_HIDE)) {
    sub MPII_EVT_IR_CFG_ELEMENT_RC_HIDE () {	(0x4);}
}
unless(defined(&MPII_EVT_IR_CFG_ELEMENT_RC_UNHIDE)) {
    sub MPII_EVT_IR_CFG_ELEMENT_RC_UNHIDE () {	(0x5);}
}
unless(defined(&MPII_EVT_IR_CFG_ELEMENT_RC_VOLUME_CREATED)) {
    sub MPII_EVT_IR_CFG_ELEMENT_RC_VOLUME_CREATED () {	(0x6);}
}
unless(defined(&MPII_EVT_IR_CFG_ELEMENT_RC_VOLUME_DELETED)) {
    sub MPII_EVT_IR_CFG_ELEMENT_RC_VOLUME_DELETED () {	(0x7);}
}
unless(defined(&MPII_EVT_IR_CFG_ELEMENT_RC_PD_CREATED)) {
    sub MPII_EVT_IR_CFG_ELEMENT_RC_PD_CREATED () {	(0x8);}
}
unless(defined(&MPII_EVT_IR_CFG_ELEMENT_RC_PD_DELETED)) {
    sub MPII_EVT_IR_CFG_ELEMENT_RC_PD_DELETED () {	(0x9);}
}
1;
