require '_h2ph_pre.ph';

no warnings qw(redefine misc);

require 'sys/stat.ph';
unless(defined(&EXT2_ROOTINO)) {
    sub EXT2_ROOTINO () {	(( &ino_t)2);}
}
unless(defined(&EXT2_RESIZEINO)) {
    sub EXT2_RESIZEINO () {	(( &ino_t)7);}
}
unless(defined(&EXT2_FIRSTINO)) {
    sub EXT2_FIRSTINO () {	(( &ino_t)11);}
}
unless(defined(&NDADDR)) {
    sub NDADDR () {	12;}
}
unless(defined(&NIADDR)) {
    sub NIADDR () {	3;}
}
unless(defined(&EXT2_MAXSYMLINKLEN)) {
    sub EXT2_MAXSYMLINKLEN () {	(( &NDADDR+ &NIADDR) * $sizeof{ &u_int32_t});}
}
unless(defined(&E2MAXSYMLINKLEN)) {
    sub E2MAXSYMLINKLEN () {	(( &NDADDR +  &NIADDR) * $sizeof{ &u_int32_t});}
}
unless(defined(&EXT2_IEXEC)) {
    sub EXT2_IEXEC () {	0000100;}
}
unless(defined(&EXT2_IWRITE)) {
    sub EXT2_IWRITE () {	0000200;}
}
unless(defined(&EXT2_IREAD)) {
    sub EXT2_IREAD () {	0000400;}
}
unless(defined(&EXT2_ISVTX)) {
    sub EXT2_ISVTX () {	0001000;}
}
unless(defined(&EXT2_ISGID)) {
    sub EXT2_ISGID () {	0002000;}
}
unless(defined(&EXT2_ISUID)) {
    sub EXT2_ISUID () {	0004000;}
}
unless(defined(&EXT2_IFMT)) {
    sub EXT2_IFMT () {	0170000;}
}
unless(defined(&EXT2_IFIFO)) {
    sub EXT2_IFIFO () {	0010000;}
}
unless(defined(&EXT2_IFCHR)) {
    sub EXT2_IFCHR () {	0020000;}
}
unless(defined(&EXT2_IFDIR)) {
    sub EXT2_IFDIR () {	0040000;}
}
unless(defined(&EXT2_IFBLK)) {
    sub EXT2_IFBLK () {	0060000;}
}
unless(defined(&EXT2_IFREG)) {
    sub EXT2_IFREG () {	0100000;}
}
unless(defined(&EXT2_IFLNK)) {
    sub EXT2_IFLNK () {	0120000;}
}
unless(defined(&EXT2_IFSOCK)) {
    sub EXT2_IFSOCK () {	0140000;}
}
unless(defined(&EXT2_SECRM)) {
    sub EXT2_SECRM () {	0x1;}
}
unless(defined(&EXT2_UNRM)) {
    sub EXT2_UNRM () {	0x2;}
}
unless(defined(&EXT2_COMPR)) {
    sub EXT2_COMPR () {	0x4;}
}
unless(defined(&EXT2_SYNC)) {
    sub EXT2_SYNC () {	0x8;}
}
unless(defined(&EXT2_IMMUTABLE)) {
    sub EXT2_IMMUTABLE () {	0x10;}
}
unless(defined(&EXT2_APPEND)) {
    sub EXT2_APPEND () {	0x20;}
}
unless(defined(&EXT2_NODUMP)) {
    sub EXT2_NODUMP () {	0x40;}
}
unless(defined(&EXT2_REV0_DINODE_SIZE)) {
    sub EXT2_REV0_DINODE_SIZE () {	$sizeof{'struct ext2fs_dinode'};}
}
unless(defined(&EXT2_DINODE_SIZE)) {
    sub EXT2_DINODE_SIZE {
	my($fs) = @_;
	eval q((($fs)-> ($e2fs->{e2fs_rev}) >  &E2FS_REV0 ? ($fs)-> ($e2fs->{e2fs_inode_size}) :  &EXT2_REV0_DINODE_SIZE));
    }
}
unless(defined(&e2di_rdev)) {
    sub e2di_rdev () {	 $e2di_blocks[0];}
}
unless(defined(&e2di_shortlink)) {
    sub e2di_shortlink () {	 &e2di_blocks;}
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&LITTLE_ENDIAN) ? &LITTLE_ENDIAN : undef)) {
    eval 'sub e2fs_iload {
        my($old, $new) = @_;
	    eval q( &memcpy(($new),($old),$sizeof{\'struct ext2fs_dinode\'}));
    }' unless defined(&e2fs_iload);
    eval 'sub e2fs_isave {
        my($old, $new) = @_;
	    eval q( &memcpy(($new),($old),$sizeof{\'struct ext2fs_dinode\'}));
    }' unless defined(&e2fs_isave);
} else {
    eval 'sub e2fs_iload {
        my($old, $new) = @_;
	    eval q( &e2fs_i_bswap(($old), ($new)));
    }' unless defined(&e2fs_iload);
    eval 'sub e2fs_isave {
        my($old, $new) = @_;
	    eval q( &e2fs_i_bswap(($old), ($new)));
    }' unless defined(&e2fs_isave);
}
1;
