require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&SBIC_myid)) {
    sub SBIC_myid () {	0;}
}
unless(defined(&SBIC_cdbsize)) {
    sub SBIC_cdbsize () {	0;}
}
unless(defined(&SBIC_control)) {
    sub SBIC_control () {	1;}
}
unless(defined(&SBIC_timeo)) {
    sub SBIC_timeo () {	2;}
}
unless(defined(&SBIC_cdb1)) {
    sub SBIC_cdb1 () {	3;}
}
unless(defined(&SBIC_tsecs)) {
    sub SBIC_tsecs () {	3;}
}
unless(defined(&SBIC_cdb2)) {
    sub SBIC_cdb2 () {	4;}
}
unless(defined(&SBIC_theads)) {
    sub SBIC_theads () {	4;}
}
unless(defined(&SBIC_cdb3)) {
    sub SBIC_cdb3 () {	5;}
}
unless(defined(&SBIC_tcyl_hi)) {
    sub SBIC_tcyl_hi () {	5;}
}
unless(defined(&SBIC_cdb4)) {
    sub SBIC_cdb4 () {	6;}
}
unless(defined(&SBIC_tcyl_lo)) {
    sub SBIC_tcyl_lo () {	6;}
}
unless(defined(&SBIC_cdb5)) {
    sub SBIC_cdb5 () {	7;}
}
unless(defined(&SBIC_addr_hi)) {
    sub SBIC_addr_hi () {	7;}
}
unless(defined(&SBIC_cdb6)) {
    sub SBIC_cdb6 () {	8;}
}
unless(defined(&SBIC_addr_2)) {
    sub SBIC_addr_2 () {	8;}
}
unless(defined(&SBIC_cdb7)) {
    sub SBIC_cdb7 () {	9;}
}
unless(defined(&SBIC_addr_3)) {
    sub SBIC_addr_3 () {	9;}
}
unless(defined(&SBIC_cdb8)) {
    sub SBIC_cdb8 () {	10;}
}
unless(defined(&SBIC_addr_lo)) {
    sub SBIC_addr_lo () {	10;}
}
unless(defined(&SBIC_cdb9)) {
    sub SBIC_cdb9 () {	11;}
}
unless(defined(&SBIC_secno)) {
    sub SBIC_secno () {	11;}
}
unless(defined(&SBIC_cdb10)) {
    sub SBIC_cdb10 () {	12;}
}
unless(defined(&SBIC_headno)) {
    sub SBIC_headno () {	12;}
}
unless(defined(&SBIC_cdb11)) {
    sub SBIC_cdb11 () {	13;}
}
unless(defined(&SBIC_cylno_hi)) {
    sub SBIC_cylno_hi () {	13;}
}
unless(defined(&SBIC_cdb12)) {
    sub SBIC_cdb12 () {	14;}
}
unless(defined(&SBIC_cylno_lo)) {
    sub SBIC_cylno_lo () {	14;}
}
unless(defined(&SBIC_tlun)) {
    sub SBIC_tlun () {	15;}
}
unless(defined(&SBIC_cmd_phase)) {
    sub SBIC_cmd_phase () {	16;}
}
unless(defined(&SBIC_syn)) {
    sub SBIC_syn () {	17;}
}
unless(defined(&SBIC_count_hi)) {
    sub SBIC_count_hi () {	18;}
}
unless(defined(&SBIC_count_med)) {
    sub SBIC_count_med () {	19;}
}
unless(defined(&SBIC_count_lo)) {
    sub SBIC_count_lo () {	20;}
}
unless(defined(&SBIC_selid)) {
    sub SBIC_selid () {	21;}
}
unless(defined(&SBIC_rselid)) {
    sub SBIC_rselid () {	22;}
}
unless(defined(&SBIC_csr)) {
    sub SBIC_csr () {	23;}
}
unless(defined(&SBIC_cmd)) {
    sub SBIC_cmd () {	24;}
}
unless(defined(&SBIC_data)) {
    sub SBIC_data () {	25;}
}
unless(defined(&SBIC_queue_tag)) {
    sub SBIC_queue_tag () {	26;}
}
unless(defined(&SBIC_aux_status)) {
    sub SBIC_aux_status () {	27;}
}
unless(defined(&SBIC_ASR_INT)) {
    sub SBIC_ASR_INT () {	0x80;}
}
unless(defined(&SBIC_ASR_LCI)) {
    sub SBIC_ASR_LCI () {	0x40;}
}
unless(defined(&SBIC_ASR_BSY)) {
    sub SBIC_ASR_BSY () {	0x20;}
}
unless(defined(&SBIC_ASR_CIP)) {
    sub SBIC_ASR_CIP () {	0x10;}
}
unless(defined(&SBIC_ASR_xxx)) {
    sub SBIC_ASR_xxx () {	0xc;}
}
unless(defined(&SBIC_ASR_PE)) {
    sub SBIC_ASR_PE () {	0x2;}
}
unless(defined(&SBIC_ASR_DBR)) {
    sub SBIC_ASR_DBR () {	0x1;}
}
unless(defined(&SBIC_ID_FS_8_10)) {
    sub SBIC_ID_FS_8_10 () {	0x;}
}
unless(defined(&SBIC_ID_FS_12_15)) {
    sub SBIC_ID_FS_12_15 () {	0x40;}
}
unless(defined(&SBIC_ID_FS_16_20)) {
    sub SBIC_ID_FS_16_20 () {	0x80;}
}
unless(defined(&SBIC_ID_RAF)) {
    sub SBIC_ID_RAF () {	0x20;}
}
unless(defined(&SBIC_ID_EHP)) {
    sub SBIC_ID_EHP () {	0x10;}
}
unless(defined(&SBIC_ID_EAF)) {
    sub SBIC_ID_EAF () {	0x8;}
}
unless(defined(&SBIC_ID_MASK)) {
    sub SBIC_ID_MASK () {	0x7;}
}
unless(defined(&SBIC_ID_CBDSIZE_MASK)) {
    sub SBIC_ID_CBDSIZE_MASK () {	0xf;}
}
unless(defined(&SBIC_CTL_DMA)) {
    sub SBIC_CTL_DMA () {	0x80;}
}
unless(defined(&SBIC_CTL_DBA_DMA)) {
    sub SBIC_CTL_DBA_DMA () {	0x40;}
}
unless(defined(&SBIC_CTL_BURST_DMA)) {
    sub SBIC_CTL_BURST_DMA () {	0x20;}
}
unless(defined(&SBIC_CTL_NO_DMA)) {
    sub SBIC_CTL_NO_DMA () {	0x;}
}
unless(defined(&SBIC_CTL_HHP)) {
    sub SBIC_CTL_HHP () {	0x10;}
}
unless(defined(&SBIC_CTL_EDI)) {
    sub SBIC_CTL_EDI () {	0x8;}
}
unless(defined(&SBIC_CTL_IDI)) {
    sub SBIC_CTL_IDI () {	0x4;}
}
unless(defined(&SBIC_CTL_HA)) {
    sub SBIC_CTL_HA () {	0x2;}
}
unless(defined(&SBIC_CTL_HSP)) {
    sub SBIC_CTL_HSP () {	0x1;}
}
unless(defined(&SBIC_TIMEOUT)) {
    sub SBIC_TIMEOUT {
	my($val,$clk) = @_;
	eval q((((($val) * ($clk)) / 800) + 1));
    }
}
unless(defined(&SBIC_TLUN_VALID)) {
    sub SBIC_TLUN_VALID () {	0x80;}
}
unless(defined(&SBIC_TLUN_DOK)) {
    sub SBIC_TLUN_DOK () {	0x40;}
}
unless(defined(&SBIC_TLUN_xxx)) {
    sub SBIC_TLUN_xxx () {	0x38;}
}
unless(defined(&SBIC_TLUN_MASK)) {
    sub SBIC_TLUN_MASK () {	0x7;}
}
unless(defined(&SBIC_CPH_MASK)) {
    sub SBIC_CPH_MASK () {	0x7f;}
}
unless(defined(&SBIC_CPH)) {
    sub SBIC_CPH {
	my($p) = @_;
	eval q((($p) &  &SBIC_CPH_MASK));
    }
}
unless(defined(&SBIC_FIFO_93_DEPTH)) {
    sub SBIC_FIFO_93_DEPTH () {	5;}
}
unless(defined(&SBIC_FIFO_93AB_DEPTH)) {
    sub SBIC_FIFO_93AB_DEPTH () {	12;}
}
unless(defined(&SBIC_TC_MAX)) {
    sub SBIC_TC_MAX () {	((1<< 24) - 1);}
}
unless(defined(&SBIC_SYN_OFF_MASK)) {
    sub SBIC_SYN_OFF_MASK () {	0xf;}
}
unless(defined(&SBIC_SYN_93_MAX_OFFSET)) {
    sub SBIC_SYN_93_MAX_OFFSET () {	( &SBIC_FIFO_93_DEPTH - 1);}
}
unless(defined(&SBIC_SYN_93AB_MAX_OFFSET)) {
    sub SBIC_SYN_93AB_MAX_OFFSET () {	 &SBIC_FIFO_93AB_DEPTH;}
}
unless(defined(&SBIC_SYN_PER_MASK)) {
    sub SBIC_SYN_PER_MASK () {	0x70;}
}
unless(defined(&SBIC_SYN_MIN_PERIOD)) {
    sub SBIC_SYN_MIN_PERIOD () {	2;}
}
unless(defined(&SBIC_SYN_FSS)) {
    sub SBIC_SYN_FSS () {	0x80;}
}
unless(defined(&SBIC_SYN)) {
    sub SBIC_SYN {
	my($o,$p,$f) = @_;
	eval q(((($o) &  &SBIC_SYN_OFF_MASK) | ((($p) << 4) &  &SBIC_SYN_PER_MASK) | (($f) ?  &SBIC_SYN_FSS : 0)));
    }
}
unless(defined(&SBIC_SID_SCC)) {
    sub SBIC_SID_SCC () {	0x80;}
}
unless(defined(&SBIC_SID_DPD)) {
    sub SBIC_SID_DPD () {	0x40;}
}
unless(defined(&SBIC_SID_FROM_SCSI)) {
    sub SBIC_SID_FROM_SCSI () {	0x40;}
}
unless(defined(&SBIC_SID_TO_SCSI)) {
    sub SBIC_SID_TO_SCSI () {	0x;}
}
unless(defined(&SBIC_SID_xxx)) {
    sub SBIC_SID_xxx () {	0x38;}
}
unless(defined(&SBIC_SID_IDMASK)) {
    sub SBIC_SID_IDMASK () {	0x7;}
}
unless(defined(&SBIC_RID_ER)) {
    sub SBIC_RID_ER () {	0x80;}
}
unless(defined(&SBIC_RID_ES)) {
    sub SBIC_RID_ES () {	0x40;}
}
unless(defined(&SBIC_RID_DSP)) {
    sub SBIC_RID_DSP () {	0x20;}
}
unless(defined(&SBIC_RID_SIV)) {
    sub SBIC_RID_SIV () {	0x8;}
}
unless(defined(&SBIC_RID_MASK)) {
    sub SBIC_RID_MASK () {	0x7;}
}
unless(defined(&SBIC_CSR_CAUSE)) {
    sub SBIC_CSR_CAUSE () {	0xf0;}
}
unless(defined(&SBIC_CSR_RESET)) {
    sub SBIC_CSR_RESET () {	0x;}
}
unless(defined(&SBIC_CSR_CMD_DONE)) {
    sub SBIC_CSR_CMD_DONE () {	0x10;}
}
unless(defined(&SBIC_CSR_CMD_STOPPED)) {
    sub SBIC_CSR_CMD_STOPPED () {	0x20;}
}
unless(defined(&SBIC_CSR_CMD_ERR)) {
    sub SBIC_CSR_CMD_ERR () {	0x40;}
}
unless(defined(&SBIC_CSR_BUS_SERVICE)) {
    sub SBIC_CSR_BUS_SERVICE () {	0x80;}
}
unless(defined(&SBIC_CSR_QUALIFIER)) {
    sub SBIC_CSR_QUALIFIER () {	0xf;}
}
unless(defined(&SBIC_CSR_RESET)) {
    sub SBIC_CSR_RESET () {	0x;}
}
unless(defined(&SBIC_CSR_RESET_AM)) {
    sub SBIC_CSR_RESET_AM () {	0x1;}
}
unless(defined(&SBIC_CSR_TARGET)) {
    sub SBIC_CSR_TARGET () {	0x10;}
}
unless(defined(&SBIC_CSR_INITIATOR)) {
    sub SBIC_CSR_INITIATOR () {	0x11;}
}
unless(defined(&SBIC_CSR_WO_ATN)) {
    sub SBIC_CSR_WO_ATN () {	0x13;}
}
unless(defined(&SBIC_CSR_W_ATN)) {
    sub SBIC_CSR_W_ATN () {	0x14;}
}
unless(defined(&SBIC_CSR_XLATED)) {
    sub SBIC_CSR_XLATED () {	0x15;}
}
unless(defined(&SBIC_CSR_S_XFERRED)) {
    sub SBIC_CSR_S_XFERRED () {	0x16;}
}
unless(defined(&SBIC_CSR_XFERRED)) {
    sub SBIC_CSR_XFERRED () {	0x18;}
}
unless(defined(&SBIC_CSR_MSGIN_W_ACK)) {
    sub SBIC_CSR_MSGIN_W_ACK () {	0x20;}
}
unless(defined(&SBIC_CSR_SDP)) {
    sub SBIC_CSR_SDP () {	0x21;}
}
unless(defined(&SBIC_CSR_SEL_ABRT)) {
    sub SBIC_CSR_SEL_ABRT () {	0x22;}
}
unless(defined(&SBIC_CSR_XFR_PAUSED)) {
    sub SBIC_CSR_XFR_PAUSED () {	0x23;}
}
unless(defined(&SBIC_CSR_XFR_PAUSED_ATN)) {
    sub SBIC_CSR_XFR_PAUSED_ATN () {	0x24;}
}
unless(defined(&SBIC_CSR_RSLT_AM)) {
    sub SBIC_CSR_RSLT_AM () {	0x27;}
}
unless(defined(&SBIC_CSR_MIS)) {
    sub SBIC_CSR_MIS () {	0x28;}
}
unless(defined(&SBIC_CSR_CMD_INVALID)) {
    sub SBIC_CSR_CMD_INVALID () {	0x40;}
}
unless(defined(&SBIC_CSR_DISC)) {
    sub SBIC_CSR_DISC () {	0x41;}
}
unless(defined(&SBIC_CSR_SEL_TIMEO)) {
    sub SBIC_CSR_SEL_TIMEO () {	0x42;}
}
unless(defined(&SBIC_CSR_PE)) {
    sub SBIC_CSR_PE () {	0x43;}
}
unless(defined(&SBIC_CSR_PE_ATN)) {
    sub SBIC_CSR_PE_ATN () {	0x44;}
}
unless(defined(&SBIC_CSR_XLATE_TOOBIG)) {
    sub SBIC_CSR_XLATE_TOOBIG () {	0x45;}
}
unless(defined(&SBIC_CSR_RSLT_NOAM)) {
    sub SBIC_CSR_RSLT_NOAM () {	0x46;}
}
unless(defined(&SBIC_CSR_BAD_STATUS)) {
    sub SBIC_CSR_BAD_STATUS () {	0x47;}
}
unless(defined(&SBIC_CSR_MIS_1)) {
    sub SBIC_CSR_MIS_1 () {	0x48;}
}
unless(defined(&SBIC_CSR_RSLT_NI)) {
    sub SBIC_CSR_RSLT_NI () {	0x80;}
}
unless(defined(&SBIC_CSR_RSLT_IFY)) {
    sub SBIC_CSR_RSLT_IFY () {	0x81;}
}
unless(defined(&SBIC_CSR_SLT)) {
    sub SBIC_CSR_SLT () {	0x82;}
}
unless(defined(&SBIC_CSR_SLT_ATN)) {
    sub SBIC_CSR_SLT_ATN () {	0x83;}
}
unless(defined(&SBIC_CSR_ATN)) {
    sub SBIC_CSR_ATN () {	0x84;}
}
unless(defined(&SBIC_CSR_DISC_1)) {
    sub SBIC_CSR_DISC_1 () {	0x85;}
}
unless(defined(&SBIC_CSR_UNK_GROUP)) {
    sub SBIC_CSR_UNK_GROUP () {	0x87;}
}
unless(defined(&SBIC_CSR_MIS_2)) {
    sub SBIC_CSR_MIS_2 () {	0x88;}
}
unless(defined(&SBIC_PHASE)) {
    sub SBIC_PHASE {
	my($csr) = @_;
	eval q( &SCSI_PHASE($csr));
    }
}
unless(defined(&SBIC_CMD_SBT)) {
    sub SBIC_CMD_SBT () {	0x80;}
}
unless(defined(&SBIC_CMD_MASK)) {
    sub SBIC_CMD_MASK () {	0x7f;}
}
unless(defined(&SBIC_CMD_RESET)) {
    sub SBIC_CMD_RESET () {	0x;}
}
unless(defined(&SBIC_CMD_ABORT)) {
    sub SBIC_CMD_ABORT () {	0x1;}
}
unless(defined(&SBIC_CMD_DISC)) {
    sub SBIC_CMD_DISC () {	0x4;}
}
unless(defined(&SBIC_CMD_SSCC)) {
    sub SBIC_CMD_SSCC () {	0xd;}
}
unless(defined(&SBIC_CMD_SET_IDI)) {
    sub SBIC_CMD_SET_IDI () {	0xf;}
}
unless(defined(&SBIC_CMD_XLATE)) {
    sub SBIC_CMD_XLATE () {	0x18;}
}
unless(defined(&SBIC_CMD_SET_ATN)) {
    sub SBIC_CMD_SET_ATN () {	0x2;}
}
unless(defined(&SBIC_CMD_CLR_ACK)) {
    sub SBIC_CMD_CLR_ACK () {	0x3;}
}
unless(defined(&SBIC_CMD_XFER_PAD)) {
    sub SBIC_CMD_XFER_PAD () {	0x19;}
}
unless(defined(&SBIC_CMD_XFER_INFO)) {
    sub SBIC_CMD_XFER_INFO () {	0x20;}
}
unless(defined(&SBIC_CMD_SND_DISC)) {
    sub SBIC_CMD_SND_DISC () {	0xe;}
}
unless(defined(&SBIC_CMD_RCV_CMD)) {
    sub SBIC_CMD_RCV_CMD () {	0x10;}
}
unless(defined(&SBIC_CMD_RCV_DATA)) {
    sub SBIC_CMD_RCV_DATA () {	0x11;}
}
unless(defined(&SBIC_CMD_RCV_MSG_OUT)) {
    sub SBIC_CMD_RCV_MSG_OUT () {	0x12;}
}
unless(defined(&SBIC_CMD_RCV)) {
    sub SBIC_CMD_RCV () {	0x13;}
}
unless(defined(&SBIC_CMD_SND_STATUS)) {
    sub SBIC_CMD_SND_STATUS () {	0x14;}
}
unless(defined(&SBIC_CMD_SND_DATA)) {
    sub SBIC_CMD_SND_DATA () {	0x15;}
}
unless(defined(&SBIC_CMD_SND_MSG_IN)) {
    sub SBIC_CMD_SND_MSG_IN () {	0x16;}
}
unless(defined(&SBIC_CMD_SND)) {
    sub SBIC_CMD_SND () {	0x17;}
}
unless(defined(&SBIC_CMD_RESELECT)) {
    sub SBIC_CMD_RESELECT () {	0x5;}
}
unless(defined(&SBIC_CMD_SEL_ATN)) {
    sub SBIC_CMD_SEL_ATN () {	0x6;}
}
unless(defined(&SBIC_CMD_SEL)) {
    sub SBIC_CMD_SEL () {	0x7;}
}
unless(defined(&SBIC_CMD_SEL_ATN_XFER)) {
    sub SBIC_CMD_SEL_ATN_XFER () {	0x8;}
}
unless(defined(&SBIC_CMD_SEL_XFER)) {
    sub SBIC_CMD_SEL_XFER () {	0x9;}
}
unless(defined(&SBIC_CMD_RESELECT_RECV)) {
    sub SBIC_CMD_RESELECT_RECV () {	0xa;}
}
unless(defined(&SBIC_CMD_RESELECT_SEND)) {
    sub SBIC_CMD_RESELECT_SEND () {	0xb;}
}
unless(defined(&SBIC_CMD_WAIT_SEL_RECV)) {
    sub SBIC_CMD_WAIT_SEL_RECV () {	0xc;}
}
unless(defined(&PHASE_MASK)) {
    sub PHASE_MASK () {	0x7;}
}
unless(defined(&DATA_OUT_PHASE)) {
    sub DATA_OUT_PHASE () {	0x;}
}
unless(defined(&DATA_IN_PHASE)) {
    sub DATA_IN_PHASE () {	0x1;}
}
unless(defined(&CMD_PHASE)) {
    sub CMD_PHASE () {	0x2;}
}
unless(defined(&STATUS_PHASE)) {
    sub STATUS_PHASE () {	0x3;}
}
unless(defined(&BUS_FREE_PHASE)) {
    sub BUS_FREE_PHASE () {	0x4;}
}
unless(defined(&ARB_SEL_PHASE)) {
    sub ARB_SEL_PHASE () {	0x5;}
}
unless(defined(&MESG_OUT_PHASE)) {
    sub MESG_OUT_PHASE () {	0x6;}
}
unless(defined(&MESG_IN_PHASE)) {
    sub MESG_IN_PHASE () {	0x7;}
}
unless(defined(&SCSI_PHASE)) {
    sub SCSI_PHASE {
	my($reg) = @_;
	eval q((($reg) &  &PHASE_MASK));
    }
}
unless(defined(&SCSI_STATUS_MASK)) {
    sub SCSI_STATUS_MASK () {	0x3e;}
}
unless(defined(&wd33c93_isa_select)) {
    sub wd33c93_isa_select {
	my($cmd) = @_;
	eval q(((($cmd) > 0x5)  && (($cmd) < 0xa)));
    }
}
unless(defined(&PAD)) {
    sub PAD {
	my($n) = @_;
	eval q('char' $n;);
    }
}
unless(defined(&SBIC_MACHINE_DMA_MODE)) {
    sub SBIC_MACHINE_DMA_MODE () {	 &SBIC_CTL_DMA;}
}
unless(defined(&wd33c93_read_reg)) {
    sub wd33c93_read_reg {
	my($sc,$regno,$val) = @_;
	eval q( &do {  &bus_space_write_1(($sc)-> &sc_regt, ($sc)-> &sc_asr_regh, 0, ($regno));  &bus_space_barrier(($sc)-> &sc_regt, ($sc)-> &sc_asr_regh, 0, 1,  &BUS_SPACE_BARRIER_READ |  &BUS_SPACE_BARRIER_WRITE); ($val) =  &bus_space_read_1(($sc)-> &sc_regt, ($sc)-> &sc_data_regh, 0); }  &while (0));
    }
}
unless(defined(&wd33c93_write_reg)) {
    sub wd33c93_write_reg {
	my($sc,$regno,$val) = @_;
	eval q( &do {  &bus_space_write_1(($sc)-> &sc_regt, ($sc)-> &sc_asr_regh, 0, ($regno));  &bus_space_barrier(($sc)-> &sc_regt, ($sc)-> &sc_asr_regh, 0, 1,  &BUS_SPACE_BARRIER_WRITE);  &bus_space_write_1(($sc)-> &sc_regt, ($sc)-> &sc_data_regh, 0, ($val));  &bus_space_barrier(($sc)-> &sc_regt, ($sc)-> &sc_asr_regh, 0, 1,  &BUS_SPACE_BARRIER_READ |  &BUS_SPACE_BARRIER_WRITE); }  &while (0));
    }
}
unless(defined(&SET_SBIC_myid)) {
    sub SET_SBIC_myid {
	my($sc,$val) = @_;
	eval q( &wd33c93_write_reg($sc, &SBIC_myid,$val));
    }
}
unless(defined(&GET_SBIC_myid)) {
    sub GET_SBIC_myid {
	my($sc,$val) = @_;
	eval q( &wd33c93_read_reg($sc, &SBIC_myid,$val));
    }
}
unless(defined(&SET_SBIC_cdbsize)) {
    sub SET_SBIC_cdbsize {
	my($sc,$val) = @_;
	eval q( &wd33c93_write_reg($sc, &SBIC_cdbsize,$val));
    }
}
unless(defined(&GET_SBIC_cdbsize)) {
    sub GET_SBIC_cdbsize {
	my($sc,$val) = @_;
	eval q( &wd33c93_read_reg($sc, &SBIC_cdbsize,$val));
    }
}
unless(defined(&SET_SBIC_control)) {
    sub SET_SBIC_control {
	my($sc,$val) = @_;
	eval q( &wd33c93_write_reg($sc, &SBIC_control,$val));
    }
}
unless(defined(&GET_SBIC_control)) {
    sub GET_SBIC_control {
	my($sc,$val) = @_;
	eval q( &wd33c93_read_reg($sc, &SBIC_control,$val));
    }
}
unless(defined(&SET_SBIC_timeo)) {
    sub SET_SBIC_timeo {
	my($sc,$val) = @_;
	eval q( &wd33c93_write_reg($sc, &SBIC_timeo,$val));
    }
}
unless(defined(&GET_SBIC_timeo)) {
    sub GET_SBIC_timeo {
	my($sc,$val) = @_;
	eval q( &wd33c93_read_reg($sc, &SBIC_timeo,$val));
    }
}
unless(defined(&SET_SBIC_cdb1)) {
    sub SET_SBIC_cdb1 {
	my($sc,$val) = @_;
	eval q( &wd33c93_write_reg($sc, &SBIC_cdb1,$val));
    }
}
unless(defined(&GET_SBIC_cdb1)) {
    sub GET_SBIC_cdb1 {
	my($sc,$val) = @_;
	eval q( &wd33c93_read_reg($sc, &SBIC_cdb1,$val));
    }
}
unless(defined(&SET_SBIC_cdb2)) {
    sub SET_SBIC_cdb2 {
	my($sc,$val) = @_;
	eval q( &wd33c93_write_reg($sc, &SBIC_cdb2,$val));
    }
}
unless(defined(&GET_SBIC_cdb2)) {
    sub GET_SBIC_cdb2 {
	my($sc,$val) = @_;
	eval q( &wd33c93_read_reg($sc, &SBIC_cdb2,$val));
    }
}
unless(defined(&SET_SBIC_cdb3)) {
    sub SET_SBIC_cdb3 {
	my($sc,$val) = @_;
	eval q( &wd33c93_write_reg($sc, &SBIC_cdb3,$val));
    }
}
unless(defined(&GET_SBIC_cdb3)) {
    sub GET_SBIC_cdb3 {
	my($sc,$val) = @_;
	eval q( &wd33c93_read_reg($sc, &SBIC_cdb3,$val));
    }
}
unless(defined(&SET_SBIC_cdb4)) {
    sub SET_SBIC_cdb4 {
	my($sc,$val) = @_;
	eval q( &wd33c93_write_reg($sc, &SBIC_cdb4,$val));
    }
}
unless(defined(&GET_SBIC_cdb4)) {
    sub GET_SBIC_cdb4 {
	my($sc,$val) = @_;
	eval q( &wd33c93_read_reg($sc, &SBIC_cdb4,$val));
    }
}
unless(defined(&SET_SBIC_cdb5)) {
    sub SET_SBIC_cdb5 {
	my($sc,$val) = @_;
	eval q( &wd33c93_write_reg($sc, &SBIC_cdb5,$val));
    }
}
unless(defined(&GET_SBIC_cdb5)) {
    sub GET_SBIC_cdb5 {
	my($sc,$val) = @_;
	eval q( &wd33c93_read_reg($sc, &SBIC_cdb5,$val));
    }
}
unless(defined(&SET_SBIC_cdb6)) {
    sub SET_SBIC_cdb6 {
	my($sc,$val) = @_;
	eval q( &wd33c93_write_reg($sc, &SBIC_cdb6,$val));
    }
}
unless(defined(&GET_SBIC_cdb6)) {
    sub GET_SBIC_cdb6 {
	my($sc,$val) = @_;
	eval q( &wd33c93_read_reg($sc, &SBIC_cdb6,$val));
    }
}
unless(defined(&SET_SBIC_cdb7)) {
    sub SET_SBIC_cdb7 {
	my($sc,$val) = @_;
	eval q( &wd33c93_write_reg($sc, &SBIC_cdb7,$val));
    }
}
unless(defined(&GET_SBIC_cdb7)) {
    sub GET_SBIC_cdb7 {
	my($sc,$val) = @_;
	eval q( &wd33c93_read_reg($sc, &SBIC_cdb7,$val));
    }
}
unless(defined(&SET_SBIC_cdb8)) {
    sub SET_SBIC_cdb8 {
	my($sc,$val) = @_;
	eval q( &wd33c93_write_reg($sc, &SBIC_cdb8,$val));
    }
}
unless(defined(&GET_SBIC_cdb8)) {
    sub GET_SBIC_cdb8 {
	my($sc,$val) = @_;
	eval q( &wd33c93_read_reg($sc, &SBIC_cdb8,$val));
    }
}
unless(defined(&SET_SBIC_cdb9)) {
    sub SET_SBIC_cdb9 {
	my($sc,$val) = @_;
	eval q( &wd33c93_write_reg($sc, &SBIC_cdb9,$val));
    }
}
unless(defined(&GET_SBIC_cdb9)) {
    sub GET_SBIC_cdb9 {
	my($sc,$val) = @_;
	eval q( &wd33c93_read_reg($sc, &SBIC_cdb9,$val));
    }
}
unless(defined(&SET_SBIC_cdb10)) {
    sub SET_SBIC_cdb10 {
	my($sc,$val) = @_;
	eval q( &wd33c93_write_reg($sc, &SBIC_cdb10,$val));
    }
}
unless(defined(&GET_SBIC_cdb10)) {
    sub GET_SBIC_cdb10 {
	my($sc,$val) = @_;
	eval q( &wd33c93_read_reg($sc, &SBIC_cdb10,$val));
    }
}
unless(defined(&SET_SBIC_cdb11)) {
    sub SET_SBIC_cdb11 {
	my($sc,$val) = @_;
	eval q( &wd33c93_write_reg($sc, &SBIC_cdb11,$val));
    }
}
unless(defined(&GET_SBIC_cdb11)) {
    sub GET_SBIC_cdb11 {
	my($sc,$val) = @_;
	eval q( &wd33c93_read_reg($sc, &SBIC_cdb11,$val));
    }
}
unless(defined(&SET_SBIC_cdb12)) {
    sub SET_SBIC_cdb12 {
	my($sc,$val) = @_;
	eval q( &wd33c93_write_reg($sc, &SBIC_cdb12,$val));
    }
}
unless(defined(&GET_SBIC_cdb12)) {
    sub GET_SBIC_cdb12 {
	my($sc,$val) = @_;
	eval q( &wd33c93_read_reg($sc, &SBIC_cdb12,$val));
    }
}
unless(defined(&SET_SBIC_tlun)) {
    sub SET_SBIC_tlun {
	my($sc,$val) = @_;
	eval q( &wd33c93_write_reg($sc, &SBIC_tlun,$val));
    }
}
unless(defined(&GET_SBIC_tlun)) {
    sub GET_SBIC_tlun {
	my($sc,$val) = @_;
	eval q( &wd33c93_read_reg($sc, &SBIC_tlun,$val));
    }
}
unless(defined(&SET_SBIC_cmd_phase)) {
    sub SET_SBIC_cmd_phase {
	my($sc,$val) = @_;
	eval q( &wd33c93_write_reg($sc, &SBIC_cmd_phase,$val));
    }
}
unless(defined(&GET_SBIC_cmd_phase)) {
    sub GET_SBIC_cmd_phase {
	my($sc,$val) = @_;
	eval q( &wd33c93_read_reg($sc, &SBIC_cmd_phase,$val));
    }
}
unless(defined(&SET_SBIC_syn)) {
    sub SET_SBIC_syn {
	my($sc,$val) = @_;
	eval q( &wd33c93_write_reg($sc, &SBIC_syn,$val));
    }
}
unless(defined(&GET_SBIC_syn)) {
    sub GET_SBIC_syn {
	my($sc,$val) = @_;
	eval q( &wd33c93_read_reg($sc, &SBIC_syn,$val));
    }
}
unless(defined(&SET_SBIC_count_hi)) {
    sub SET_SBIC_count_hi {
	my($sc,$val) = @_;
	eval q( &wd33c93_write_reg($sc, &SBIC_count_hi,$val));
    }
}
unless(defined(&GET_SBIC_count_hi)) {
    sub GET_SBIC_count_hi {
	my($sc,$val) = @_;
	eval q( &wd33c93_read_reg($sc, &SBIC_count_hi,$val));
    }
}
unless(defined(&SET_SBIC_count_med)) {
    sub SET_SBIC_count_med {
	my($sc,$val) = @_;
	eval q( &wd33c93_write_reg($sc, &SBIC_count_med,$val));
    }
}
unless(defined(&GET_SBIC_count_med)) {
    sub GET_SBIC_count_med {
	my($sc,$val) = @_;
	eval q( &wd33c93_read_reg($sc, &SBIC_count_med,$val));
    }
}
unless(defined(&SET_SBIC_count_lo)) {
    sub SET_SBIC_count_lo {
	my($sc,$val) = @_;
	eval q( &wd33c93_write_reg($sc, &SBIC_count_lo,$val));
    }
}
unless(defined(&GET_SBIC_count_lo)) {
    sub GET_SBIC_count_lo {
	my($sc,$val) = @_;
	eval q( &wd33c93_read_reg($sc, &SBIC_count_lo,$val));
    }
}
unless(defined(&SET_SBIC_selid)) {
    sub SET_SBIC_selid {
	my($sc,$val) = @_;
	eval q( &wd33c93_write_reg($sc, &SBIC_selid,$val));
    }
}
unless(defined(&GET_SBIC_selid)) {
    sub GET_SBIC_selid {
	my($sc,$val) = @_;
	eval q( &wd33c93_read_reg($sc, &SBIC_selid,$val));
    }
}
unless(defined(&SET_SBIC_rselid)) {
    sub SET_SBIC_rselid {
	my($sc,$val) = @_;
	eval q( &wd33c93_write_reg($sc, &SBIC_rselid,$val));
    }
}
unless(defined(&GET_SBIC_rselid)) {
    sub GET_SBIC_rselid {
	my($sc,$val) = @_;
	eval q( &wd33c93_read_reg($sc, &SBIC_rselid,$val));
    }
}
unless(defined(&SET_SBIC_csr)) {
    sub SET_SBIC_csr {
	my($sc,$val) = @_;
	eval q( &wd33c93_write_reg($sc, &SBIC_csr,$val));
    }
}
unless(defined(&GET_SBIC_csr)) {
    sub GET_SBIC_csr {
	my($sc,$val) = @_;
	eval q( &wd33c93_read_reg($sc, &SBIC_csr,$val));
    }
}
unless(defined(&SET_SBIC_cmd)) {
    sub SET_SBIC_cmd {
	my($sc,$val) = @_;
	eval q( &wd33c93_write_reg($sc, &SBIC_cmd,$val));
    }
}
unless(defined(&GET_SBIC_cmd)) {
    sub GET_SBIC_cmd {
	my($sc,$val) = @_;
	eval q( &wd33c93_read_reg($sc, &SBIC_cmd,$val));
    }
}
unless(defined(&SET_SBIC_data)) {
    sub SET_SBIC_data {
	my($sc,$val) = @_;
	eval q( &wd33c93_write_reg($sc, &SBIC_data,$val));
    }
}
unless(defined(&GET_SBIC_data)) {
    sub GET_SBIC_data {
	my($sc,$val) = @_;
	eval q( &wd33c93_read_reg($sc, &SBIC_data,$val));
    }
}
unless(defined(&SET_SBIC_queue_tag)) {
    sub SET_SBIC_queue_tag {
	my($sc,$val) = @_;
	eval q( &wd33c93_write_reg($sc, &SBIC_queue_tag,$val));
    }
}
unless(defined(&GET_SBIC_queue_tag)) {
    sub GET_SBIC_queue_tag {
	my($sc,$val) = @_;
	eval q( &wd33c93_read_reg($sc, &SBIC_queue_tag,$val));
    }
}
unless(defined(&SBIC_TC_PUT)) {
    sub SBIC_TC_PUT {
	my($sc,$val) = @_;
	eval q( &do {  &wd33c93_write_reg($sc,  &SBIC_count_hi, (($val) >> 16));  &bus_space_write_1(($sc)-> &sc_regt, ($sc)-> &sc_data_regh, 0, ($val) >> 8);  &bus_space_barrier(($sc)-> &sc_regt, ($sc)-> &sc_data_regh, 0, 1,  &BUS_SPACE_BARRIER_WRITE);  &bus_space_write_1(($sc)-> &sc_regt, ($sc)-> &sc_data_regh, 0, ($val));  &bus_space_barrier(($sc)-> &sc_regt, ($sc)-> &sc_data_regh, 0, 1,  &BUS_SPACE_BARRIER_READ |  &BUS_SPACE_BARRIER_WRITE); }  &while (0));
    }
}
unless(defined(&SBIC_TC_GET)) {
    sub SBIC_TC_GET {
	my($sc,$val) = @_;
	eval q( &do {  &wd33c93_read_reg($sc,  &SBIC_count_hi, ($val)); ($val) = (($val) << 8) |  &bus_space_read_1(($sc)-> &sc_regt, ($sc)-> &sc_data_regh, 0); ($val) = (($val) << 8) |  &bus_space_read_1(($sc)-> &sc_regt, ($sc)-> &sc_data_regh, 0); }  &while (0));
    }
}
unless(defined(&SBIC_LOAD_COMMAND)) {
    sub SBIC_LOAD_COMMAND {
	my($sc,$cmd,$cmdsize) = @_;
	eval q( &do {  &uint8_t * &ptr = ( &uint8_t *)($cmd);  &wd33c93_write_reg( &regs,  &SBIC_cdb1, * &ptr++);  &bus_space_barrier(($sc)-> &sc_regt, ($sc)-> &sc_data_regh, 0, 1,  &BUS_SPACE_BARRIER_WRITE);  &bus_space_write_multi_1(($sc)-> &sc_regt, ($sc)-> &sc_data_regh, 0,  &ptr, ($cmdsize) - 1);  &bus_space_barrier(($sc)-> &sc_regt, ($sc)-> &sc_data_regh, 0, 1,  &BUS_SPACE_BARRIER_READ |  &BUS_SPACE_BARRIER_WRITE); }  &while (0));
    }
}
unless(defined(&GET_SBIC_asr)) {
    sub GET_SBIC_asr {
	my($sc,$val) = @_;
	eval q( &do { ($val) =  &bus_space_read_1(($sc)-> &sc_regt, ($sc)-> &sc_asr_regh, 0); }  &while (0));
    }
}
unless(defined(&WAIT_CIP)) {
    sub WAIT_CIP {
	my($sc) = @_;
	eval q( &do {  &while ( &bus_space_read_1(($sc)-> &sc_regt, ($sc)-> &sc_asr_regh, 0) &  &SBIC_ASR_CIP) ; }  &while (0));
    }
}
unless(defined(&SEND_BYTE)) {
    sub SEND_BYTE {
	my($sc, $ch) = @_;
	eval q( &do {  &WAIT_CIP($sc);  &SET_SBIC_cmd($sc,  &SBIC_CMD_SBT |  &SBIC_CMD_XFER_INFO);  &SBIC_WAIT($sc,  &SBIC_ASR_DBR, 0);  &SET_SBIC_data($sc, $ch); }  &while (0));
    }
}
unless(defined(&RECV_BYTE)) {
    sub RECV_BYTE {
	my($sc, $ch) = @_;
	eval q( &do {  &WAIT_CIP($sc);  &SET_SBIC_cmd($sc,  &SBIC_CMD_SBT |  &SBIC_CMD_XFER_INFO);  &SBIC_WAIT($sc,  &SBIC_ASR_DBR, 0);  &GET_SBIC_data($sc, $ch); }  &while (0));
    }
}
1;
