/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.zip;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.zip.ZipException;
import org.apache.commons.compress.zip.AsiExtraField;
import org.apache.commons.compress.zip.UnrecognizedExtraField;
import org.apache.commons.compress.zip.ZipExtraField;
import org.apache.commons.compress.zip.ZipShort;

public class ExtraFieldUtils {
    private static final Hashtable c_implementations = new Hashtable();

    public static ZipExtraField createExtraField(ZipShort headerID) throws InstantiationException, IllegalAccessException {
        Class clazz = (Class)c_implementations.get(headerID);
        if (clazz != null) {
            return (ZipExtraField)clazz.newInstance();
        }
        UnrecognizedExtraField unrecognized = new UnrecognizedExtraField();
        unrecognized.setHeaderID(headerID);
        return unrecognized;
    }

    public static byte[] mergeCentralDirectoryData(ZipExtraField[] data) {
        int sum = 4 * data.length;
        for (int i = 0; i < data.length; ++i) {
            sum += data[i].getCentralDirectoryLength().getValue();
        }
        byte[] result = new byte[sum];
        int start = 0;
        for (int i = 0; i < data.length; ++i) {
            System.arraycopy(data[i].getHeaderID().getBytes(), 0, result, start, 2);
            System.arraycopy(data[i].getCentralDirectoryLength().getBytes(), 0, result, start + 2, 2);
            byte[] local = data[i].getCentralDirectoryData();
            System.arraycopy(local, 0, result, start + 4, local.length);
            start += local.length + 4;
        }
        return result;
    }

    public static byte[] mergeLocalFileDataData(ZipExtraField[] data) {
        int sum = 4 * data.length;
        for (int i = 0; i < data.length; ++i) {
            sum += data[i].getLocalFileDataLength().getValue();
        }
        byte[] result = new byte[sum];
        int start = 0;
        for (int i = 0; i < data.length; ++i) {
            System.arraycopy(data[i].getHeaderID().getBytes(), 0, result, start, 2);
            System.arraycopy(data[i].getLocalFileDataLength().getBytes(), 0, result, start + 2, 2);
            byte[] local = data[i].getLocalFileDataData();
            System.arraycopy(local, 0, result, start + 4, local.length);
            start += local.length + 4;
        }
        return result;
    }

    public static ZipExtraField[] parse(byte[] data) throws ZipException {
        int start;
        int length;
        ArrayList<ZipExtraField> v = new ArrayList<ZipExtraField>();
        for (start = 0; start <= data.length - 4; start += length + 4) {
            ZipShort headerID = new ZipShort(data, start);
            length = new ZipShort(data, start + 2).getValue();
            if (start + 4 + length > data.length) {
                throw new ZipException("data starting at " + start + " is in unknown format");
            }
            try {
                ZipExtraField ze = ExtraFieldUtils.createExtraField(headerID);
                ze.parseFromLocalFileData(data, start + 4, length);
                v.add(ze);
                continue;
            }
            catch (InstantiationException ie) {
                throw new ZipException(ie.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new ZipException(iae.getMessage());
            }
        }
        if (start != data.length) {
            throw new ZipException("data starting at " + start + " is in unknown format");
        }
        ZipExtraField[] result = new ZipExtraField[v.size()];
        return v.toArray(result);
    }

    public static void register(Class clazz) {
        try {
            ZipExtraField ze = (ZipExtraField)clazz.newInstance();
            c_implementations.put(ze.getHeaderID(), clazz);
        }
        catch (ClassCastException cc) {
            throw new RuntimeException(clazz + " doesn't implement ZipExtraField");
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(clazz + " is not a concrete class");
        }
        catch (IllegalAccessException ie) {
            throw new RuntimeException(clazz + "'s no-arg constructor is not public");
        }
    }

    static {
        ExtraFieldUtils.register(AsiExtraField.class);
    }
}

