/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Random;
import org.h2.test.TestBase;
import org.h2.tools.MultiDimension;

public class TestMultiDimension
extends TestBase {
    public void test() throws Exception {
        Random rand = new Random();
        for (int i = 0; i < 1000; ++i) {
            int x = rand.nextInt(1000);
            int y = rand.nextInt(1000);
            int z = rand.nextInt(1000);
            MultiDimension tool = MultiDimension.getInstance();
            long xyz = tool.interleave(new int[]{x, y, z});
            this.check(x, tool.deinterleave(xyz, 3, 0));
            this.check(y, tool.deinterleave(xyz, 3, 1));
            this.check(z, tool.deinterleave(xyz, 3, 2));
        }
        this.deleteDb("multiDimension");
        Connection conn = this.getConnection("multiDimension");
        Statement stat = conn.createStatement();
        stat.execute("CREATE ALIAS MAP FOR \"" + this.getClass().getName() + ".interleave\"");
        stat.execute("CREATE TABLE TEST(X INT NOT NULL, Y INT NOT NULL, Z INT NOT NULL, XYZ BIGINT AS MAP(X, Y, Z), DATA VARCHAR)");
        stat.execute("CREATE INDEX IDX_X ON TEST(X, Y, Z)");
        stat.execute("CREATE INDEX IDX_XYZ ON TEST(XYZ)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(X, Y, Z, DATA) VALUES(?, ?, ?, ?)");
        int max = 10;
        long time = System.currentTimeMillis();
        for (int x = 0; x < max; ++x) {
            for (int y = 0; y < max; ++y) {
                for (int z = 0; z < max; ++z) {
                    long t2 = System.currentTimeMillis();
                    if (t2 - time > 1000L) {
                        int percent = (int)(100.0 * ((double)x * (double)x * (double)x) / ((double)max * (double)max * (double)max));
                        this.trace(percent + "%");
                        time = t2;
                        try {
                            Thread.sleep(10L);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    prep.setInt(1, x);
                    prep.setInt(2, y);
                    prep.setInt(3, z);
                    prep.setString(4, "Test data");
                    prep.execute();
                }
            }
        }
        for (int i = 0; i < 50; ++i) {
            int size = rand.nextInt(max / 10);
            int minX = rand.nextInt(max - size);
            int minY = rand.nextInt(max - size);
            int minZ = rand.nextInt(max - size);
            int maxX = minX + size;
            int maxY = minY + size;
            int maxZ = minZ + size;
            long time1 = System.currentTimeMillis();
            String query1 = MultiDimension.getInstance().getMultiDimensionalQuery("TEST", "XYZ", new String[]{"X", "Y", "Z"}, new int[]{minX, minY, minZ}, new int[]{minX + size, minY + size, minZ + size});
            ResultSet rs1 = conn.createStatement().executeQuery(query1 + " ORDER BY X, Y, Z");
            time1 = System.currentTimeMillis() - time1;
            long time2 = System.currentTimeMillis();
            String query2 = "SELECT * FROM TEST WHERE X BETWEEN " + minX + " AND " + maxX + " AND " + "Y BETWEEN " + minY + " AND " + maxY + " AND " + "Z BETWEEN " + minZ + " AND " + maxZ;
            ResultSet rs2 = conn.createStatement().executeQuery(query2 + " ORDER BY X, Y, Z");
            time2 = System.currentTimeMillis() - time2;
            while (rs1.next()) {
                this.check(rs2.next());
                this.check(rs1.getInt(1), rs2.getInt(1));
                this.check(rs1.getInt(2), rs2.getInt(2));
            }
            this.checkFalse(rs2.next());
            this.trace("t1=" + time1 + " t2=" + time2 + " size=" + size);
        }
        conn.close();
    }

    public static long interleave(int x, int y, int z) {
        return MultiDimension.getInstance().interleave(new int[]{x, y, z});
    }
}

