/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import org.h2.api.DatabaseEventListener;
import org.h2.command.Prepared;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.result.Row;
import org.h2.value.ValueInt;
import org.h2.value.ValueString;

public class MetaRecord {
    private int id;
    private int objectType;
    private int headPos;
    private String sql;

    MetaRecord(Row r) throws SQLException {
        this.id = r.getValue(0).getInt();
        this.headPos = r.getValue(1).getInt();
        this.objectType = r.getValue(2).getInt();
        this.sql = r.getValue(3).getString();
    }

    public void setRecord(Row r) {
        r.setValue(0, ValueInt.get(this.id));
        r.setValue(1, ValueInt.get(this.headPos));
        r.setValue(2, ValueInt.get(this.objectType));
        r.setValue(3, ValueString.get(this.sql));
    }

    public MetaRecord(DbObject obj) {
        this.id = obj.getId();
        this.objectType = obj.getType();
        this.headPos = obj.getHeadPos();
        this.sql = obj.getCreateSQL();
    }

    void execute(Database db, Session systemSession, DatabaseEventListener listener) throws SQLException {
        try {
            Prepared command = systemSession.prepare(this.sql);
            command.setObjectId(this.id);
            command.setHeadPos(this.headPos);
            command.update();
        }
        catch (SQLException e) {
            db.getTrace("engine").error(this.sql, e);
            if (listener != null) {
                listener.exceptionThrown(e);
            }
            throw e;
        }
    }

    public int getHeadPos() {
        return this.headPos;
    }

    public void setHeadPos(int headPos) {
        this.headPos = headPos;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getObjectType() {
        return this.objectType;
    }

    public void setObjectType(int objectType) {
        this.objectType = objectType;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }
}

