/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import org.h2.test.TestBase;

public class TestStatement
extends TestBase {
    Connection conn;

    public void test() throws Exception {
        this.deleteDb("statement");
        this.conn = this.getConnection("statement");
        if (this.config.jdk14) {
            this.testSavepoint();
        }
        this.testStatement();
        if (this.config.jdk14) {
            this.testIdentity();
        }
        this.conn.close();
    }

    void testSavepoint() throws Exception {
        Statement stat = this.conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        this.conn.setAutoCommit(false);
        stat.execute("INSERT INTO TEST VALUES(0, 'Hi')");
        Savepoint savepoint1 = this.conn.setSavepoint();
        int id1 = savepoint1.getSavepointId();
        try {
            savepoint1.getSavepointName();
            this.error("exception expected");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
        }
        stat.execute("DELETE FROM TEST");
        this.conn.rollback(savepoint1);
        stat.execute("UPDATE TEST SET NAME='Hello'");
        Savepoint savepoint2a = this.conn.setSavepoint();
        Savepoint savepoint2 = this.conn.setSavepoint();
        this.conn.releaseSavepoint(savepoint2a);
        try {
            savepoint2a.getSavepointId();
            this.error("exception expected");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
        }
        int id2 = savepoint2.getSavepointId();
        this.check(id1 != id2);
        stat.execute("UPDATE TEST SET NAME='Hallo' WHERE NAME='Hello'");
        Savepoint savepointTest = this.conn.setSavepoint("Joe's");
        stat.execute("DELETE FROM TEST");
        this.check(savepointTest.getSavepointName(), "Joe's");
        try {
            savepointTest.getSavepointId();
            this.error("exception expected");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
        }
        this.conn.rollback(savepointTest);
        this.conn.commit();
        ResultSet rs = stat.executeQuery("SELECT NAME FROM TEST");
        rs.next();
        String name = rs.getString(1);
        this.check(name, "Hallo");
        this.checkFalse(rs.next());
        try {
            this.conn.rollback(savepoint2);
            this.error("exception expected");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
        }
        stat.execute("DROP TABLE TEST");
        this.conn.setAutoCommit(true);
    }

    void testStatement() throws Exception {
        Statement stat = this.conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT)");
        stat.execute("SELECT * FROM TEST");
        stat.execute("DROP TABLE TEST");
        this.conn.getTypeMap();
        if (this.config.jdk14) {
            this.check(stat.getResultSetHoldability(), 1L);
        }
        this.check(stat.getResultSetConcurrency(), 1008L);
        stat.cancel();
        stat.setQueryTimeout(10);
        this.check(stat.getQueryTimeout() == 10);
        stat.setQueryTimeout(0);
        this.check(stat.getQueryTimeout() == 0);
        try {
            stat.setQueryTimeout(-1);
            this.error("setQueryTimeout(-1) didn't throw an exception");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
        }
        this.check(stat.getQueryTimeout() == 0);
        this.trace("executeUpdate");
        int count = stat.executeUpdate("CREATE TABLE TEST(ID INT PRIMARY KEY,VALUE VARCHAR(255))");
        this.check(count, 0L);
        count = stat.executeUpdate("INSERT INTO TEST VALUES(1,'Hello')");
        this.check(count, 1L);
        count = stat.executeUpdate("INSERT INTO TEST(VALUE,ID) VALUES('JDBC',2)");
        this.check(count, 1L);
        count = stat.executeUpdate("UPDATE TEST SET VALUE='LDBC' WHERE ID=2 OR ID=1");
        this.check(count, 2L);
        count = stat.executeUpdate("UPDATE TEST SET VALUE='\\LDBC\\' WHERE VALUE LIKE 'LDBC' ");
        this.check(count, 2L);
        count = stat.executeUpdate("UPDATE TEST SET VALUE='LDBC' WHERE VALUE LIKE '\\\\LDBC\\\\'");
        this.trace("count:" + count);
        this.check(count, 2L);
        count = stat.executeUpdate("DELETE FROM TEST WHERE ID=-1");
        this.check(count, 0L);
        count = stat.executeUpdate("DELETE FROM TEST WHERE ID=2");
        this.check(count, 1L);
        try {
            stat.executeUpdate("SELECT * FROM TEST");
            this.error("executeUpdate allowed SELECT");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
            this.trace("no error - SELECT not allowed with executeUpdate");
        }
        count = stat.executeUpdate("DROP TABLE TEST");
        this.check(count == 0);
        this.trace("execute");
        boolean result = stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY,VALUE VARCHAR(255))");
        this.check(!result);
        result = stat.execute("INSERT INTO TEST VALUES(1,'Hello')");
        this.check(!result);
        result = stat.execute("INSERT INTO TEST(VALUE,ID) VALUES('JDBC',2)");
        this.check(!result);
        result = stat.execute("UPDATE TEST SET VALUE='LDBC' WHERE ID=2");
        this.check(!result);
        result = stat.execute("DELETE FROM TEST WHERE ID=3");
        this.check(!result);
        result = stat.execute("SELECT * FROM TEST");
        this.check(result);
        result = stat.execute("DROP TABLE TEST");
        this.check(!result);
        this.trace("executeQuery");
        try {
            stat.executeQuery("CREATE TABLE TEST(ID INT PRIMARY KEY,VALUE VARCHAR(255))");
            this.error("executeQuery allowed CREATE TABLE");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
            this.trace("no error - CREATE not allowed with executeQuery");
        }
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY,VALUE VARCHAR(255))");
        try {
            stat.executeQuery("INSERT INTO TEST VALUES(1,'Hello')");
            this.error("executeQuery allowed INSERT");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
            this.trace("no error - INSERT not allowed with executeQuery");
        }
        try {
            stat.executeQuery("UPDATE TEST SET VALUE='LDBC' WHERE ID=2");
            this.error("executeQuery allowed UPDATE");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
            this.trace("no error - UPDATE not allowed with executeQuery");
        }
        try {
            stat.executeQuery("DELETE FROM TEST WHERE ID=3");
            this.error("executeQuery allowed DELETE");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
            this.trace("no error - DELETE not allowed with executeQuery");
        }
        stat.executeQuery("SELECT * FROM TEST");
        try {
            stat.executeQuery("DROP TABLE TEST");
            this.error("executeQuery allowed DROP");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
            this.trace("no error - DROP not allowed with executeQuery");
        }
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST");
        this.checkFalse(stat.getMoreResults());
        try {
            rs.next();
            this.error("getMoreResults didn't close this result set");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
            this.trace("no error - getMoreResults is supposed to close the result set");
        }
        this.check(stat.getUpdateCount() == -1);
        count = stat.executeUpdate("DELETE FROM TEST");
        this.checkFalse(stat.getMoreResults());
        this.check(stat.getUpdateCount() == -1);
        stat.execute("DROP TABLE TEST");
        stat.executeUpdate("DROP TABLE IF EXISTS TEST");
        this.check(stat.getWarnings() == null);
        stat.clearWarnings();
        this.check(stat.getWarnings() == null);
        this.check(this.conn == stat.getConnection());
        stat.close();
    }

    private void testIdentity() throws Exception {
        Statement stat = this.conn.createStatement();
        stat.execute("CREATE SEQUENCE SEQ");
        stat.execute("CREATE TABLE TEST(ID INT)");
        stat.execute("INSERT INTO TEST VALUES(NEXT VALUE FOR SEQ)");
        ResultSet rs = stat.getGeneratedKeys();
        rs.next();
        this.check(rs.getInt(1), 1L);
        this.checkFalse(rs.next());
        stat.execute("INSERT INTO TEST VALUES(NEXT VALUE FOR SEQ)", 1);
        rs = stat.getGeneratedKeys();
        rs.next();
        this.check(rs.getInt(1), 2L);
        this.checkFalse(rs.next());
        stat.execute("INSERT INTO TEST VALUES(NEXT VALUE FOR SEQ)", new int[]{1});
        rs = stat.getGeneratedKeys();
        rs.next();
        this.check(rs.getInt(1), 3L);
        this.checkFalse(rs.next());
        stat.execute("INSERT INTO TEST VALUES(NEXT VALUE FOR SEQ)", new String[]{"ID"});
        rs = stat.getGeneratedKeys();
        rs.next();
        this.check(rs.getInt(1), 4L);
        this.checkFalse(rs.next());
        stat.executeUpdate("INSERT INTO TEST VALUES(NEXT VALUE FOR SEQ)", 1);
        rs = stat.getGeneratedKeys();
        rs.next();
        this.check(rs.getInt(1), 5L);
        this.checkFalse(rs.next());
        stat.executeUpdate("INSERT INTO TEST VALUES(NEXT VALUE FOR SEQ)", new int[]{1});
        rs = stat.getGeneratedKeys();
        rs.next();
        this.check(rs.getInt(1), 6L);
        this.checkFalse(rs.next());
        stat.executeUpdate("INSERT INTO TEST VALUES(NEXT VALUE FOR SEQ)", new String[]{"ID"});
        rs = stat.getGeneratedKeys();
        rs.next();
        this.check(rs.getInt(1), 7L);
        this.checkFalse(rs.next());
        stat.execute("DROP TABLE TEST");
    }
}

