/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.SQLException;
import java.util.HashMap;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.table.PlanItem;
import org.h2.table.TableFilter;

public class Plan {
    private TableFilter[] filters;
    private HashMap planItems = new HashMap();
    private Expression condition;

    public Plan(TableFilter[] filters, int count, Expression condition) {
        this.filters = new TableFilter[count];
        System.arraycopy(filters, 0, this.filters, 0, count);
        this.condition = condition;
    }

    public PlanItem getItem(TableFilter filter) {
        return (PlanItem)this.planItems.get(filter);
    }

    public TableFilter[] getFilters() {
        return this.filters;
    }

    public void removeUnusableIndexConditions() {
        int i;
        for (i = 0; i < this.filters.length; ++i) {
            TableFilter tableFilter = this.filters[i];
            PlanItem item = (PlanItem)this.planItems.get(tableFilter);
            tableFilter.setPlanItem(item);
            do {
                Expression cond;
                if (this.condition != null) {
                    this.condition.setEvaluatable(tableFilter, true);
                }
                if ((cond = tableFilter.getJoinCondition()) != null) {
                    cond.setEvaluatable(tableFilter, true);
                }
                if (i < this.filters.length - 1) {
                    tableFilter.optimizeFullCondition();
                }
                tableFilter.removeUnusableIndexConditions();
            } while ((tableFilter = tableFilter.getJoin()) != null);
        }
        for (i = 0; i < this.filters.length; ++i) {
            this.setEvaluatable(this.filters[i], false);
        }
    }

    public double calculateCost(Session session) throws SQLException {
        int i;
        double cost = 1.0;
        for (i = 0; i < this.filters.length; ++i) {
            TableFilter tableFilter = this.filters[i];
            PlanItem item = tableFilter.getBestPlanItem(session);
            this.planItems.put(tableFilter, item);
            cost += cost * item.cost;
            this.setEvaluatable(tableFilter, true);
        }
        for (i = 0; i < this.filters.length; ++i) {
            this.setEvaluatable(this.filters[i], false);
        }
        return cost;
    }

    private void setEvaluatable(TableFilter filter, boolean b) {
        if (this.condition != null) {
            do {
                this.condition.setEvaluatable(filter, b);
                Expression cond = filter.getJoinCondition();
                if (cond == null) continue;
                cond.setEvaluatable(filter, b);
            } while ((filter = filter.getJoin()) != null);
        }
    }
}

