/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.blocking;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Statistics;
import net.sf.ehcache.Status;
import net.sf.ehcache.bootstrap.BootstrapCacheLoader;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.constructs.blocking.LockTimeoutException;
import net.sf.ehcache.constructs.concurrent.ConcurrencyUtil;
import net.sf.ehcache.constructs.concurrent.Mutex;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.exceptionhandler.CacheExceptionHandler;
import net.sf.ehcache.extension.CacheExtension;
import net.sf.ehcache.loader.CacheLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingCache
implements Ehcache {
    public static final int LOCK_NUMBER = 2048;
    protected final Mutex[] locks = new Mutex[2048];
    protected final Ehcache cache;
    protected int timeoutMillis;

    public BlockingCache(Ehcache cache) throws CacheException {
        for (int i = 0; i < 2048; ++i) {
            this.locks[i] = new Mutex();
        }
        this.cache = cache;
    }

    protected Ehcache getCache() {
        return this.cache;
    }

    @Override
    public String getName() {
        return this.cache.getName();
    }

    @Override
    public void setName(String name) {
        this.cache.setName(name);
    }

    @Override
    public boolean isExpired(Element element) throws IllegalStateException, NullPointerException {
        return this.cache.isExpired(element);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public RegisteredEventListeners getCacheEventNotificationService() {
        return this.cache.getCacheEventNotificationService();
    }

    @Override
    public boolean isElementInMemory(Serializable key) {
        return this.cache.isElementInMemory(key);
    }

    @Override
    public boolean isElementInMemory(Object key) {
        return this.cache.isElementInMemory(key);
    }

    @Override
    public boolean isElementOnDisk(Serializable key) {
        return this.cache.isElementOnDisk(key);
    }

    @Override
    public boolean isElementOnDisk(Object key) {
        return this.cache.isElementOnDisk(key);
    }

    @Override
    public String getGuid() {
        return this.cache.getGuid();
    }

    @Override
    public CacheManager getCacheManager() {
        return this.cache.getCacheManager();
    }

    @Override
    public void clearStatistics() {
        this.cache.clearStatistics();
    }

    @Override
    public int getStatisticsAccuracy() {
        return this.cache.getStatisticsAccuracy();
    }

    @Override
    public void setStatisticsAccuracy(int statisticsAccuracy) {
        this.cache.setStatisticsAccuracy(statisticsAccuracy);
    }

    @Override
    public void evictExpiredElements() {
        this.cache.evictExpiredElements();
    }

    @Override
    public boolean isKeyInCache(Object key) {
        return this.cache.isKeyInCache(key);
    }

    @Override
    public boolean isValueInCache(Object value) {
        return this.cache.isValueInCache(value);
    }

    @Override
    public Statistics getStatistics() throws IllegalStateException {
        return this.cache.getStatistics();
    }

    @Override
    public void setCacheManager(CacheManager cacheManager) {
        this.cache.setCacheManager(cacheManager);
    }

    @Override
    public BootstrapCacheLoader getBootstrapCacheLoader() {
        return this.cache.getBootstrapCacheLoader();
    }

    @Override
    public void setBootstrapCacheLoader(BootstrapCacheLoader bootstrapCacheLoader) throws CacheException {
        this.cache.setBootstrapCacheLoader(bootstrapCacheLoader);
    }

    @Override
    public void setDiskStorePath(String diskStorePath) throws CacheException {
        this.cache.setDiskStorePath(diskStorePath);
    }

    @Override
    public void initialise() {
        this.cache.initialise();
    }

    @Override
    public void bootstrap() {
        this.cache.bootstrap();
    }

    @Override
    public void dispose() throws IllegalStateException {
        this.cache.dispose();
    }

    @Override
    public CacheConfiguration getCacheConfiguration() {
        return this.cache.getCacheConfiguration();
    }

    @Override
    public Element get(Object key) throws RuntimeException, LockTimeoutException {
        Mutex lock = this.getLockForKey(key);
        try {
            if (this.timeoutMillis == 0) {
                lock.acquire();
            } else {
                boolean acquired = lock.attempt(this.timeoutMillis);
                if (!acquired) {
                    StringBuffer message = new StringBuffer("Lock timeout. Waited more than ").append(this.timeoutMillis).append("ms to acquire lock for key ").append(key).append(" on blocking cache ").append(this.cache.getName());
                    throw new LockTimeoutException(message.toString());
                }
            }
            Element element = this.cache.get(key);
            if (element != null) {
                lock.release();
                return element;
            }
            return null;
        }
        catch (InterruptedException e) {
            throw new CacheException("Get interrupted for key " + key + ". Message was: " + e.getMessage());
        }
    }

    protected Mutex getLockForKey(Object key) {
        int lockNumber = ConcurrencyUtil.selectLock(key, 2048);
        return this.locks[lockNumber];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Element element) {
        if (element == null) {
            return;
        }
        Object key = element.getObjectKey();
        Object value = element.getObjectValue();
        Mutex lock = this.getLockForKey(key);
        try {
            if (value != null) {
                this.cache.put(element);
            } else {
                this.cache.remove(key);
            }
        }
        finally {
            lock.release();
        }
    }

    @Override
    public void put(Element element, boolean doNotNotifyCacheReplicators) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.cache.put(element, doNotNotifyCacheReplicators);
    }

    @Override
    public void putQuiet(Element element) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.cache.putQuiet(element);
    }

    @Override
    public Element get(Serializable key) throws IllegalStateException, CacheException {
        return this.get((Object)key);
    }

    @Override
    public Element getQuiet(Serializable key) throws IllegalStateException, CacheException {
        return this.cache.getQuiet(key);
    }

    @Override
    public Element getQuiet(Object key) throws IllegalStateException, CacheException {
        return this.cache.getQuiet(key);
    }

    @Override
    public List getKeys() throws CacheException {
        return this.cache.getKeys();
    }

    @Override
    public List getKeysWithExpiryCheck() throws IllegalStateException, CacheException {
        return this.cache.getKeysWithExpiryCheck();
    }

    @Override
    public List getKeysNoDuplicateCheck() throws IllegalStateException {
        return this.cache.getKeysNoDuplicateCheck();
    }

    @Override
    public boolean remove(Serializable key) throws IllegalStateException {
        return this.cache.remove(key);
    }

    @Override
    public boolean remove(Object key) throws IllegalStateException {
        return this.cache.remove(key);
    }

    @Override
    public boolean remove(Serializable key, boolean doNotNotifyCacheReplicators) throws IllegalStateException {
        return this.cache.remove(key, doNotNotifyCacheReplicators);
    }

    @Override
    public boolean remove(Object key, boolean doNotNotifyCacheReplicators) throws IllegalStateException {
        return this.cache.remove(key, doNotNotifyCacheReplicators);
    }

    @Override
    public boolean removeQuiet(Serializable key) throws IllegalStateException {
        return this.cache.removeQuiet(key);
    }

    @Override
    public boolean removeQuiet(Object key) throws IllegalStateException {
        return this.cache.removeQuiet(key);
    }

    @Override
    public void removeAll() throws IllegalStateException, CacheException {
        this.cache.removeAll();
    }

    @Override
    public void removeAll(boolean doNotNotifyCacheReplicators) throws IllegalStateException, CacheException {
        this.cache.removeAll(doNotNotifyCacheReplicators);
    }

    @Override
    public void flush() throws IllegalStateException, CacheException {
        this.cache.flush();
    }

    @Override
    public int getSize() throws IllegalStateException, CacheException {
        return this.cache.getSize();
    }

    @Override
    public long calculateInMemorySize() throws IllegalStateException, CacheException {
        return this.cache.calculateInMemorySize();
    }

    @Override
    public long getMemoryStoreSize() throws IllegalStateException {
        return this.cache.getMemoryStoreSize();
    }

    @Override
    public int getDiskStoreSize() throws IllegalStateException {
        return this.cache.getDiskStoreSize();
    }

    @Override
    public Status getStatus() {
        return this.cache.getStatus();
    }

    public synchronized String liveness() {
        return this.getName();
    }

    public void setTimeoutMillis(int timeoutMillis) {
        if (timeoutMillis < 0) {
            throw new CacheException("The lock timeout must be a positive number of ms. Value was " + timeoutMillis);
        }
        this.timeoutMillis = timeoutMillis;
    }

    public int getTimeoutMillis() {
        return this.timeoutMillis;
    }

    @Override
    public void registerCacheExtension(CacheExtension cacheExtension) {
        this.cache.registerCacheExtension(cacheExtension);
    }

    @Override
    public void unregisterCacheExtension(CacheExtension cacheExtension) {
        this.cache.unregisterCacheExtension(cacheExtension);
    }

    @Override
    public List<CacheExtension> getRegisteredCacheExtensions() {
        return this.cache.getRegisteredCacheExtensions();
    }

    @Override
    public float getAverageGetTime() {
        return this.cache.getAverageGetTime();
    }

    @Override
    public void setCacheExceptionHandler(CacheExceptionHandler cacheExceptionHandler) {
        this.cache.setCacheExceptionHandler(cacheExceptionHandler);
    }

    @Override
    public CacheExceptionHandler getCacheExceptionHandler() {
        return this.cache.getCacheExceptionHandler();
    }

    @Override
    public void registerCacheLoader(CacheLoader cacheLoader) {
        throw new CacheException("This method is not appropriate for a blocking cache.");
    }

    @Override
    public void unregisterCacheLoader(CacheLoader cacheLoader) {
        throw new CacheException("This method is not appropriate for a blocking cache.");
    }

    @Override
    public List<CacheLoader> getRegisteredCacheLoaders() {
        return this.cache.getRegisteredCacheLoaders();
    }

    @Override
    public Element getWithLoader(Object key, CacheLoader loader, Object loaderArgument) throws CacheException {
        throw new CacheException("This method is not appropriate for a Blocking Cache");
    }

    @Override
    public Map getAllWithLoader(Collection keys, Object loaderArgument) throws CacheException {
        throw new CacheException("This method is not appropriate for a Blocking Cache");
    }

    @Override
    public void load(Object key) throws CacheException {
        throw new CacheException("This method is not appropriate for a Blocking Cache");
    }

    @Override
    public void loadAll(Collection keys, Object argument) throws CacheException {
        throw new CacheException("This method is not appropriate for a Blocking Cache");
    }

    @Override
    public boolean isDisabled() {
        return this.cache.isDisabled();
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.cache.setDisabled(disabled);
    }
}

