/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.util;

import java.util.Timer;
import java.util.TimerTask;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

public abstract class ExpirableObject
implements Destroyable {
    public static final long DEFAULT_TIMEOUT = 3600000L;
    private static final Timer EXPIRER = new Timer(true);
    private final Destroyer destroyer = new Destroyer(this);

    protected ExpirableObject() {
        this(3600000L);
    }

    protected ExpirableObject(long delay) {
        EXPIRER.schedule((TimerTask)this.destroyer, delay);
    }

    public final void destroy() throws DestroyFailedException {
        this.doDestroy();
        this.destroyer.cancel();
    }

    protected abstract void doDestroy() throws DestroyFailedException;

    private final class Destroyer
    extends TimerTask {
        private final ExpirableObject target;

        Destroyer(ExpirableObject target) {
            this.target = target;
        }

        public void run() {
            try {
                if (!this.target.isDestroyed()) {
                    this.target.doDestroy();
                }
            }
            catch (DestroyFailedException destroyFailedException) {}
        }
    }
}

