/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.beans.encoder;

import gnu.java.beans.encoder.Context;
import gnu.java.beans.encoder.GenericScannerState;
import gnu.java.beans.encoder.IgnoringScannerState;
import gnu.java.beans.encoder.ObjectId;
import gnu.java.beans.encoder.Root;
import gnu.java.beans.encoder.ScannerState;
import gnu.java.beans.encoder.StAXWriter;
import gnu.java.beans.encoder.Writer;
import java.beans.Expression;
import java.beans.Statement;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Stack;

public class ScanEngine {
    boolean DEBUG = false;
    HashMap states = new HashMap();
    Stack parents = new Stack();
    ScannerState current;
    Root root;
    Writer writer;
    IdentityHashMap objects = new IdentityHashMap();

    public ScanEngine(OutputStream os) {
        this.writer = new StAXWriter(os);
        this.root = new Root();
        this.current = new GenericScannerState(this.root);
        GenericScannerState start = this.current;
        this.register("default", new IgnoringScannerState());
        this.register("start", start);
        this.register("ignoreAll", new IgnoringScannerState()).setDefaultSuccessor("ignoreAll");
        start.putSuccessor(14, "simple");
        start.putSuccessor(13, "simple");
        start.putSuccessor(12, "simple");
        this.register("simple", new GenericScannerState(this.root)).setDefaultSuccessor("ignoreAll");
        start.putSuccessor(3, "classRes0");
        this.register("classRes0", new GenericScannerState(this.root)).setDefaultSuccessor("ignoreAll");
        start.putSuccessor(4, "newObj0");
        ScannerState conf = this.register("newObj0", new GenericScannerState(this.root));
        conf.setDefaultSuccessor("ignoreAll");
        conf.putSuccessor(0, "start");
        start.putSuccessor(5, "newPrimitive0");
        this.register("newPrimitive0", new GenericScannerState(this.root)).setDefaultSuccessor("ignoreAll");
        start.putSuccessor(6, "newObjectArray");
        conf = this.register("newObjectArray", new GenericScannerState(this.root));
        conf.putSuccessor(9, "newOArrayGet");
        conf.putSuccessor(8, "ignoreAll");
        conf.putSuccessor(3, "ignoreAll");
        conf.putSuccessor(5, "ignoreAll");
        conf = new GenericScannerState(this.root);
        this.register("newOArrayGet", conf);
        conf.putSuccessor(5, "newOArrayGet_ignoreFirstInteger");
        conf.putSuccessor(14, "simple");
        conf.putSuccessor(13, "simple");
        conf.putSuccessor(12, "simple");
        conf.putSuccessor(3, "classRes0");
        conf.putSuccessor(4, "newObj0");
        conf.putSuccessor(7, "newPrimitiveArray");
        conf.putSuccessor(6, "newObjectArray");
        conf = this.register("newOArrayGet_ignoreFirstInteger", new GenericScannerState(this.root, 1));
        conf.putSuccessor(3, "ignoreAll");
        conf.putSuccessor(5, "ignoreAll");
        conf.putSuccessor(14, "ignoreAll");
        conf.putSuccessor(13, "ignoreAll");
        conf.setDefaultSuccessor("start");
        start.putSuccessor(7, "newPrimitiveArray");
        conf = this.register("newPrimitiveArray", new GenericScannerState(this.root));
        conf.putSuccessor(9, "ignoreAll");
        conf.putSuccessor(8, "newPArraySet");
        conf.putSuccessor(3, "ignoreAll");
        conf.putSuccessor(5, "ignoreAll");
        conf = this.register("newPArraySet", new GenericScannerState(this.root));
        conf.putSuccessor(5, "newPArraySet_ignoreFirstInteger");
        conf.putSuccessor(14, "ignoreAll");
        conf.putSuccessor(13, "ignoreAll");
        conf.putSuccessor(12, "ignoreAll");
        conf.putSuccessor(3, "ingoreAll");
        conf.putSuccessor(4, "ignoreAll");
        conf.putSuccessor(7, "ignoreAll");
        conf.putSuccessor(6, "ignoreAll");
        conf = this.register("newPArraySet_ignoreFirstInteger", new GenericScannerState(this.root, 1));
        conf.putSuccessor(3, "ignoreAll");
        conf.putSuccessor(5, "ignoreAll");
        conf.putSuccessor(14, "ignoreAll");
        conf.putSuccessor(13, "ignoreAll");
        conf.setDefaultSuccessor("start");
    }

    private ScannerState register(String name, ScannerState state) {
        state.init(name);
        this.states.put(name, state);
        return state;
    }

    private ObjectId retrieveId(Object value) {
        Class<? extends Object> valueClass = value.getClass();
        ObjectId id = null;
        if (valueClass != String.class && valueClass.getSuperclass() != Number.class && valueClass != Boolean.class && (id = (ObjectId)this.objects.get(value)) == null) {
            id = new ObjectId(valueClass);
            this.objects.put(value, id);
        }
        return id;
    }

    public void writeExpression(Expression expr) {
        String methodName = expr.getMethodName();
        Object[] args = expr.getArguments();
        Object target = expr.getTarget();
        Object value = null;
        try {
            value = expr.getValue();
        }
        catch (Exception e) {
            throw (InternalError)new InternalError("The Expression's value should be available at this point.").initCause(e);
        }
        Class<? extends Object> valueClass = value.getClass();
        if (target == Array.class) {
            if (methodName.equals("newInstance")) {
                ObjectId id = this.retrieveId(value);
                Class ct = (Class)args[0];
                if (ct.isPrimitive() || ct == Boolean.class || ct == Byte.class || ct == Short.class || ct == Integer.class || ct == Long.class || ct == Float.class || ct == Double.class) {
                    this.primitiveArrayInstantiation(ct.getName(), args[1].toString(), id);
                } else {
                    this.objectArrayInstantiation(ct.getName(), args[1].toString(), id);
                }
                return;
            }
            if (methodName.equals("get")) {
                this.arrayGet(args[1].toString());
                ObjectId id = (ObjectId)this.objects.get(value);
                if (id != null && valueClass != Class.class) {
                    this.objectReference(id);
                    this.end();
                }
                return;
            }
            if (methodName.equals("set")) {
                this.arraySet(args[1].toString());
                return;
            }
        }
        ObjectId id = this.retrieveId(value);
        if (target instanceof Class) {
            if (methodName.equals("new")) {
                Class targetClass = (Class)target;
                if (valueClass == Boolean.class) {
                    this.primitiveInstantiation("boolean", args[0].toString());
                } else if (valueClass == Byte.class) {
                    this.primitiveInstantiation("byte", args[0].toString());
                } else if (valueClass == Short.class) {
                    this.primitiveInstantiation("short", args[0].toString());
                } else if (valueClass == Integer.class) {
                    this.primitiveInstantiation("int", args[0].toString());
                } else if (valueClass == Long.class) {
                    this.primitiveInstantiation("long", args[0].toString());
                } else if (valueClass == Float.class) {
                    this.primitiveInstantiation("float", args[0].toString());
                } else if (valueClass == Double.class) {
                    this.primitiveInstantiation("double", args[0].toString());
                } else {
                    this.objectInstantiation(targetClass.getName(), id);
                }
                return;
            }
            if (value instanceof Class) {
                String className = ((Class)value).getName();
                if (methodName.equals("forName")) {
                    this.classResolution(className);
                    return;
                }
                if (methodName.equals("getField")) {
                    this.staticFieldAccess(className, args[0].toString());
                    return;
                }
                this.staticMethodInvocation(className, methodName);
                return;
            }
        } else if (target instanceof List) {
            if (methodName.equals("get")) {
                this.listGet();
                return;
            }
            if (methodName.equals("set")) {
                this.listSet();
                return;
            }
        }
        this.methodInvocation(methodName);
    }

    public void end() {
        this.current.end();
        if (this.DEBUG) {
            System.err.print("back from " + this.current.getName());
        }
        this.current = (ScannerState)this.parents.pop();
        if (this.DEBUG) {
            System.err.println(" to " + this.current.getName());
        }
    }

    public void revoke() {
        this.current = (ScannerState)this.parents.pop();
        this.root.deleteLast();
    }

    public void writeStatement(Statement stmt) {
        String methodName = stmt.getMethodName();
        Object target = stmt.getTarget();
        Object[] args = stmt.getArguments();
        if (target == Array.class && methodName.equals("set")) {
            this.arraySet(args[1].toString());
            return;
        }
        if (target instanceof List && methodName.equals("set")) {
            this.listSet();
            return;
        }
        this.methodInvocation(methodName);
    }

    public boolean writeObject(Object o) {
        ObjectId id = null;
        if (o == null) {
            this.nullObject();
            this.end();
        } else if (o.getClass() == String.class) {
            this.stringReference((String)o);
            this.end();
        } else {
            id = (ObjectId)this.objects.get(o);
            if (id != null) {
                if (o.getClass() == Class.class) {
                    this.classResolution(((Class)o).getName());
                    this.end();
                    return false;
                }
                this.objectReference(id);
                this.end();
                return false;
            }
        }
        return true;
    }

    public void flush() {
        this.objects.clear();
        this.root.traverse(this.writer);
    }

    public void close() {
        this.flush();
        this.root.close(this.writer);
    }

    private void transition(int transition) {
        this.parents.push(this.current);
        String stateName = this.current.getSuccessor(transition);
        if (this.DEBUG) {
            System.err.println("from state: " + this.current.getName() + "\n\troute: " + ScannerState.transitionNames[transition] + "\n\t\tto state: " + stateName);
        }
        ScannerState newState = (ScannerState)this.states.get(stateName);
        newState.enter(new Context(this.current.getName(), this.current.getCalls()));
        assert (newState != null) : "State '" + stateName + "' was not defined.";
        this.current = newState;
    }

    void methodInvocation(String methodName) {
        this.transition(0);
        this.current.methodInvocation(methodName);
    }

    void staticMethodInvocation(String className, String methodName) {
        this.transition(1);
        this.current.staticMethodInvocation(className, methodName);
    }

    void staticFieldAccess(String className, String fieldName) {
        this.transition(2);
        this.current.staticFieldAccess(className, fieldName);
    }

    void classResolution(String className) {
        this.transition(3);
        this.current.classResolution(className);
    }

    void objectInstantiation(String className, ObjectId objectId) {
        this.transition(4);
        this.current.objectInstantiation(className, objectId);
    }

    void primitiveInstantiation(String primitiveName, String valueAsString) {
        this.transition(5);
        this.current.primitiveInstantiation(primitiveName, valueAsString);
    }

    void objectArrayInstantiation(String arrayClassName, String lengthAsString, ObjectId objectId) {
        this.transition(6);
        this.current.objectArrayInstantiation(arrayClassName, lengthAsString, objectId);
    }

    void primitiveArrayInstantiation(String arrayClassName, String lengthAsString, ObjectId objectId) {
        this.transition(7);
        this.current.objectArrayInstantiation(arrayClassName, lengthAsString, objectId);
    }

    void arraySet(String indexAsString) {
        this.transition(8);
        this.current.arraySet(indexAsString);
    }

    void arrayGet(String indexAsString) {
        this.transition(9);
        this.current.arrayGet(indexAsString);
    }

    void listSet() {
        this.transition(10);
        this.current.listSet();
    }

    void listGet() {
        this.transition(11);
        this.current.listGet();
    }

    void nullObject() {
        this.transition(12);
        this.current.nullObject();
    }

    void stringReference(String string) {
        this.transition(13);
        this.current.stringReference(string);
    }

    void objectReference(ObjectId id) {
        this.transition(14);
        this.current.objectReference(id);
    }
}

