/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStreamImpl;

public class MemoryCacheImageInputStream
extends ImageInputStreamImpl {
    private InputStream stream;
    private BufferedInputStream buffer;
    private int READLIMIT;

    private /* synthetic */ void finit$() {
        this.READLIMIT = 2048;
    }

    public MemoryCacheImageInputStream(InputStream inputStream) {
        this.finit$();
        this.stream = inputStream;
        this.buffer = new BufferedInputStream(inputStream);
        this.buffer.mark(this.READLIMIT);
    }

    public void close() throws IOException {
        super.close();
        this.stream.close();
    }

    public void flushBefore(long l) throws IOException {
        long l2 = this.getFlushedPosition();
        super.flushBefore(l);
        this.buffer.reset();
        this.buffer.skip(this.getFlushedPosition() - l2);
        this.buffer.mark(this.READLIMIT);
    }

    public boolean isCached() {
        return true;
    }

    public boolean isCachedFile() {
        return false;
    }

    public boolean isCachedMemory() {
        return true;
    }

    public int read() throws IOException {
        this.setBitOffset(0);
        int n = this.buffer.read();
        if (n != -1) {
            ++this.streamPos;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.setBitOffset(0);
        int n3 = this.buffer.read(byArray, n, n2);
        if (n3 != -1) {
            this.streamPos += (long)n3;
        }
        return n3;
    }

    public void seek(long l) throws IOException {
        super.seek(l);
        this.buffer.reset();
        this.buffer.skip(l - this.getFlushedPosition());
    }
}

