/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Writer;

public class BufferedWriter
extends Writer {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private Writer out;
    char[] buffer;
    int count;

    public BufferedWriter(Writer writer) {
        this(writer, 8192);
    }

    public BufferedWriter(Writer writer, int n) {
        super(writer.lock);
        this.out = writer;
        this.buffer = new char[n];
        this.count = 0;
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.localFlush();
                this.out.close();
                this.buffer = null;
            }
            finally {
                Object var2_2 = null;
            }
            return;
        }
    }

    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.buffer == null) {
                    throw new IOException("Stream closed");
                }
                this.localFlush();
                this.out.flush();
            }
            finally {
                Object var2_2 = null;
            }
            return;
        }
    }

    public void newLine() throws IOException {
        this.write(System.getProperty("line.separator"));
    }

    public void write(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                try {
                    if (this.buffer == null) {
                        throw new IOException("Stream closed");
                    }
                    this.buffer[this.count++] = (char)n;
                    if (this.count != this.buffer.length) break block4;
                    this.localFlush();
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
            Object var3_3 = null;
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                try {
                    if (this.buffer == null) {
                        throw new IOException("Stream closed");
                    }
                    if (this.count + n2 > this.buffer.length) {
                        this.localFlush();
                        this.out.write(cArray, n, n2);
                        break block5;
                    }
                    System.arraycopy(cArray, n, this.buffer, this.count, n2);
                    this.count += n2;
                    if (this.count != this.buffer.length) break block5;
                    this.localFlush();
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
            Object var5_5 = null;
        }
    }

    public void write(String string, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                try {
                    if (this.buffer == null) {
                        throw new IOException("Stream closed");
                    }
                    if (this.count + n2 > this.buffer.length) {
                        this.localFlush();
                        this.out.write(string, n, n2);
                        break block5;
                    }
                    string.getChars(n, n + n2, this.buffer, this.count);
                    this.count += n2;
                    if (this.count != this.buffer.length) break block5;
                    this.localFlush();
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
            Object var5_5 = null;
        }
    }

    private void localFlush() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buffer, 0, this.count);
            this.count = 0;
        }
    }
}

