/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GtkComponentPeer;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.im.InputMethodRequests;
import java.awt.peer.TextComponentPeer;
import java.awt.peer.TextFieldPeer;

public class GtkTextFieldPeer
extends GtkComponentPeer
implements TextComponentPeer,
TextFieldPeer {
    native void create(int var1);

    native void gtkWidgetSetBackground(int var1, int var2, int var3);

    native void gtkWidgetSetForeground(int var1, int var2, int var3);

    public native void connectSignals();

    public native int getCaretPosition();

    public native void setCaretPosition(int var1);

    public native int getSelectionStart();

    public native int getSelectionEnd();

    public native String getText();

    public native void select(int var1, int var2);

    public native void setEditable(boolean var1);

    public native void setText(String var1);

    public int getIndexAtPoint(int n, int n2) {
        return 0;
    }

    public Rectangle getCharacterBounds(int n) {
        return null;
    }

    public long filterEvents(long l) {
        return l;
    }

    void create() {
        Font font = this.awtComponent.getFont();
        if (font == null) {
            font = new Font("Dialog", 0, 12);
            this.awtComponent.setFont(font);
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        TextField textField = (TextField)this.awtComponent;
        int n = textField.getColumns();
        int n2 = n * fontMetrics.getMaxAdvance();
        this.create(n2);
        this.setEditable(textField.isEditable());
    }

    native int gtkEntryGetBorderWidth();

    public GtkTextFieldPeer(TextField textField) {
        super(textField);
        this.setText(textField.getText());
        this.setCaretPosition(0);
        if (textField.echoCharIsSet()) {
            this.setEchoChar(textField.getEchoChar());
        }
    }

    public Dimension getMinimumSize(int n) {
        return this.minimumSize(n);
    }

    public Dimension getPreferredSize(int n) {
        return this.preferredSize(n);
    }

    public native void setEchoChar(char var1);

    public Dimension minimumSize(int n) {
        int[] nArray = new int[2];
        this.gtkWidgetGetPreferredDimensions(nArray);
        Font font = this.awtComponent.getFont();
        if (font == null) {
            return new Dimension(2 * this.gtkEntryGetBorderWidth(), nArray[1]);
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n2 = n * fontMetrics.getMaxAdvance();
        int n3 = n2 + 2 * this.gtkEntryGetBorderWidth();
        return new Dimension(n3, nArray[1]);
    }

    public Dimension preferredSize(int n) {
        int[] nArray = new int[2];
        this.gtkWidgetGetPreferredDimensions(nArray);
        Font font = this.awtComponent.getFont();
        if (font == null) {
            return new Dimension(2 * this.gtkEntryGetBorderWidth(), nArray[1]);
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n2 = n * fontMetrics.getMaxAdvance();
        int n3 = n2 + 2 * this.gtkEntryGetBorderWidth();
        return new Dimension(n3, nArray[1]);
    }

    public void setEchoCharacter(char c) {
        this.setEchoChar(c);
    }

    public void handleEvent(AWTEvent aWTEvent) {
        KeyEvent keyEvent;
        if (aWTEvent.getID() == 401 && !(keyEvent = (KeyEvent)aWTEvent).isConsumed() && keyEvent.getKeyCode() == 10) {
            this.postActionEvent(this.getText(), keyEvent.getModifiersEx());
        }
        super.handleEvent(aWTEvent);
    }

    public InputMethodRequests getInputMethodRequests() {
        return null;
    }
}

