/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.h2.test.TestBase;

public class TestBigResult
extends TestBase {
    public void test() throws Exception {
        int i;
        if (this.config.memory) {
            return;
        }
        this.deleteDb("bigResult");
        Connection conn = this.getConnection("bigResult");
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, Name VARCHAR(255), FirstName VARCHAR(255), Points INT,LicenseID INT)");
        int len = this.getSize(10, 5000);
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?, ?, ?, ?, ?)");
        for (int i2 = 0; i2 < len; ++i2) {
            prep.setInt(1, i2);
            prep.setString(2, "Name " + i2);
            prep.setString(3, "First Name " + i2);
            prep.setInt(4, i2 * 10);
            prep.setInt(5, i2 * i2);
            prep.execute();
        }
        conn.close();
        conn = this.getConnection("bigResult");
        stat = conn.createStatement();
        stat.setMaxRows(len + 1);
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        for (i = 0; i < len; ++i) {
            rs.next();
            this.check(i, rs.getInt(1));
            this.check("Name " + i, rs.getString(2));
            this.check("First Name " + i, rs.getString(3));
            this.check(i * 10, rs.getInt(4));
            this.check(i * i, rs.getInt(5));
        }
        stat.setMaxRows(len + 1);
        rs = stat.executeQuery("SELECT * FROM TEST WHERE ID >= 1000 ORDER BY ID");
        for (i = 1000; i < len; ++i) {
            rs.next();
            this.check(i, rs.getInt(1));
            this.check("Name " + i, rs.getString(2));
            this.check("First Name " + i, rs.getString(3));
            this.check(i * 10, rs.getInt(4));
            this.check(i * i, rs.getInt(5));
        }
        stat.execute("SET MAX_MEMORY_ROWS 2");
        rs = stat.executeQuery("SELECT Name, SUM(ID) FROM TEST GROUP BY NAME");
        while (rs.next()) {
            rs.getString(1);
            rs.getInt(2);
        }
        conn.setAutoCommit(false);
        stat.setMaxRows(0);
        stat.execute("SET MAX_MEMORY_ROWS 0");
        stat.execute("CREATE TABLE DATA(ID INT, NAME VARCHAR_IGNORECASE(255))");
        prep = conn.prepareStatement("INSERT INTO DATA VALUES(?, ?)");
        for (i = 0; i < len; ++i) {
            prep.setInt(1, i);
            prep.setString(2, "" + i / 200);
            prep.execute();
        }
        Statement s2 = conn.createStatement(1004, 1008);
        rs = s2.executeQuery("SELECT NAME FROM DATA");
        rs.last();
        conn.setAutoCommit(true);
        rs = s2.executeQuery("SELECT NAME FROM DATA ORDER BY ID");
        while (rs.next()) {
        }
        conn.close();
    }
}

