/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.bnf;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.h2.test.bnf.Config;
import org.h2.test.bnf.Rule;
import org.h2.test.bnf.RuleCopy;
import org.h2.test.bnf.RuleElement;
import org.h2.test.bnf.RuleHead;
import org.h2.test.bnf.RuleList;
import org.h2.test.bnf.RuleOptional;

public class RuleParser {
    private static final String SEPARATORS = " [](){}|.,\r\n<>:-+*/=<\">!'";
    private Config config;
    private String syntax;
    private String currentToken;
    private String[] tokens;
    private char firstChar;
    private int index;
    private Rule lastRepeat;
    private ArrayList statements;

    public Config getConfig() {
        return this.config;
    }

    public void parse() throws Exception {
        this.config = new Config();
        Class.forName("org.h2.Driver");
        Connection conn = DriverManager.getConnection("jdbc:h2:.", "", "");
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT * FROM INFORMATION_SCHEMA.HELP  WHERE SECTION NOT IN('System tables') ORDER BY ID");
        Rule functions = null;
        this.statements = new ArrayList();
        while (rs.next()) {
            int id = rs.getInt("ID");
            String topic = rs.getString("TOPIC").toLowerCase();
            topic = RuleParser.replaceAll(topic, " ", "");
            topic = RuleParser.replaceAll(topic, "_", "");
            this.syntax = rs.getString("SYNTAX");
            String section = rs.getString("SECTION");
            if (section.startsWith("Function")) {
                int end = this.syntax.indexOf(58);
                this.syntax = this.syntax.substring(0, end);
            }
            this.tokens = this.tokenize();
            this.index = 0;
            Rule rule = this.parseRule();
            RuleHead head = this.config.addRule(topic, id, section, rule);
            if (section.startsWith("Function")) {
                if (functions == null) {
                    functions = rule;
                    continue;
                }
                functions = new RuleList(rule, functions, true);
                continue;
            }
            if (!section.startsWith("Commands")) continue;
            this.statements.add(head);
        }
        this.config.addRule("@func@", 0, "Function", functions);
        this.config.addFixedRule("@ymd@", 0);
        this.config.addFixedRule("@hms@", 1);
        this.config.addFixedRule("@nanos@", 2);
        this.config.addFixedRule("anything", 3);
        this.config.addFixedRule("@hexStart@", 5);
        this.config.addFixedRule("@concat@", 6);
        this.config.addFixedRule("@az@", 7);
        this.config.addFixedRule("@af@", 8);
        this.config.addFixedRule("@digit@", 9);
    }

    public String getSyntax(String rule, String syntax) {
        StringTokenizer tokenizer = new StringTokenizer(syntax, SEPARATORS, true);
        StringBuffer buff = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            if (s.length() == 1 || s.toUpperCase().equals(s)) {
                buff.append(s);
                continue;
            }
            String section = null;
            int id = -1;
            for (int i = 0; i < s.length(); ++i) {
                String test = s.substring(i).toLowerCase();
                RuleHead r = (RuleHead)this.config.getRuleMap().get(test);
                if (r == null) continue;
                id = r.id;
                section = r.section;
                break;
            }
            if (id == -1) {
                buff.append(s);
                continue;
            }
            String page = "grammar.html";
            if (section.startsWith("Data Types")) {
                page = "datatypes.html";
            } else if (section.startsWith("Functions")) {
                page = "functions.html";
            }
            buff.append("<a href=\"" + page + "#sql" + id + "\">");
            buff.append(s);
            buff.append("</a>");
        }
        return buff.toString();
    }

    private Rule parseRule() {
        this.read();
        Rule r = this.parseOr();
        return r;
    }

    private Rule parseOr() {
        Rule r = this.parseList();
        if (this.firstChar == '|') {
            this.read();
            r = new RuleList(r, this.parseOr(), true);
        }
        this.lastRepeat = r;
        return r;
    }

    private Rule parseList() {
        Rule r = this.parseToken();
        if (this.firstChar != '|' && this.firstChar != ']' && this.firstChar != '}' && this.firstChar != '\u0000') {
            r = new RuleList(r, this.parseList(), false);
        }
        this.lastRepeat = r;
        return r;
    }

    private Rule parseToken() {
        Rule r;
        if (this.firstChar >= 'A' && this.firstChar <= 'Z' || this.firstChar >= 'a' && this.firstChar <= 'z') {
            r = new RuleElement(this.currentToken + " syntax:" + this.syntax);
        } else if (this.firstChar == '[') {
            this.read();
            Rule r2 = this.parseOr();
            boolean repeat = false;
            if (r2.last() instanceof RuleCopy) {
                repeat = true;
            }
            r = new RuleOptional(r2, repeat);
            if (this.firstChar != ']') {
                throw new Error("expected ], got " + this.currentToken + " syntax:" + this.syntax);
            }
        } else if (this.firstChar == '{') {
            this.read();
            r = this.parseOr();
            if (this.firstChar != '}') {
                throw new Error("expected }, got " + this.currentToken + " syntax:" + this.syntax);
            }
        } else {
            r = "@dots@".equals(this.currentToken) ? new RuleCopy(this.lastRepeat) : new RuleElement(this.currentToken);
        }
        if (!",".equals(this.currentToken)) {
            this.lastRepeat = r;
        }
        this.read();
        return r;
    }

    private void read() {
        if (this.index < this.tokens.length) {
            this.currentToken = this.tokens[this.index++];
            this.firstChar = this.currentToken.charAt(0);
        } else {
            this.currentToken = "";
            this.firstChar = '\u0000';
        }
    }

    public static String replaceAll(String s, String pattern, String replacement) {
        int start = 0;
        int idx;
        while ((idx = s.indexOf(pattern, start)) >= 0) {
            s = s.substring(0, idx) + replacement + s.substring(idx + pattern.length());
            start = idx + replacement.length();
        }
        return s;
    }

    private String[] tokenize() {
        ArrayList<String> list = new ArrayList<String>();
        this.syntax = RuleParser.replaceAll(this.syntax, "yyyy-MM-dd", "@ymd@");
        this.syntax = RuleParser.replaceAll(this.syntax, "hh:mm:ss", "@hms@");
        this.syntax = RuleParser.replaceAll(this.syntax, "nnnnnnnnn", "@nanos@");
        this.syntax = RuleParser.replaceAll(this.syntax, "function", "@func@");
        this.syntax = RuleParser.replaceAll(this.syntax, "0x", "@hexStart@");
        this.syntax = RuleParser.replaceAll(this.syntax, "...", "@dots@");
        this.syntax = RuleParser.replaceAll(this.syntax, "||", "@concat@");
        this.syntax = RuleParser.replaceAll(this.syntax, "a-z", "@az@");
        this.syntax = RuleParser.replaceAll(this.syntax, "A-Z", "@az@");
        this.syntax = RuleParser.replaceAll(this.syntax, "a-f", "@af@");
        this.syntax = RuleParser.replaceAll(this.syntax, "A-F", "@af@");
        this.syntax = RuleParser.replaceAll(this.syntax, "0-9", "@digit@");
        StringTokenizer tokenizer = new StringTokenizer(this.syntax, SEPARATORS, true);
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            if (s.length() == 1 && " \r\n".indexOf(s.charAt(0)) >= 0) continue;
            list.add(s);
        }
        return list.toArray(new String[0]);
    }

    public ArrayList getStatements() {
        return this.statements;
    }
}

