/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.Ber;
import com.sun.jndi.ldap.BerDecoder;
import com.sun.jndi.ldap.BerEncoder;
import com.sun.jndi.ldap.LdapClient;
import com.sun.jndi.ldap.LdapRequest;
import com.sun.jndi.ldap.Obj;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import javax.naming.CommunicationException;
import javax.naming.InterruptedNamingException;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.ldap.Control;

public final class Connection
implements Runnable {
    private static final boolean debug = false;
    private static final int dump = 0;
    private Thread worker;
    private boolean v3 = true;
    public String host;
    public int port;
    private boolean bound = false;
    private OutputStream traceFile = null;
    private String traceTagIn = null;
    private String traceTagOut = null;
    public InputStream inStream;
    public OutputStream outStream;
    public Socket sock;
    private LdapClient parent = null;
    private int outMsgId = 0;
    private LdapRequest pendingRequests = null;
    private Object pauseLock = new Object();
    private boolean paused = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$net$Socket;

    void setV3(boolean bl) {
        this.v3 = bl;
    }

    void setBound() {
        this.bound = true;
    }

    Connection(LdapClient ldapClient, String string, int n, String string2, int n2, OutputStream outputStream) throws NamingException {
        this.host = string;
        this.port = n;
        this.parent = ldapClient;
        if (outputStream != null) {
            this.traceFile = outputStream;
            this.traceTagIn = "<- " + string + ":" + n + "\n\n";
            this.traceTagOut = "-> " + string + ":" + n + "\n\n";
        }
        try {
            this.sock = this.createSocket(string, n, string2, n2);
            this.inStream = new BufferedInputStream(this.sock.getInputStream());
            this.outStream = new BufferedOutputStream(this.sock.getOutputStream());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            CommunicationException communicationException = new CommunicationException(string + ":" + n);
            communicationException.setRootCause(throwable);
            throw communicationException;
        }
        catch (Exception exception) {
            CommunicationException communicationException = new CommunicationException(string + ":" + n);
            communicationException.setRootCause(exception);
            throw communicationException;
        }
        this.worker = Obj.helper.createThread(this);
        this.worker.setDaemon(true);
        this.worker.start();
    }

    private Object createInetSocketAddress(String string, int n) throws NoSuchMethodException {
        try {
            Class<?> clazz = Class.forName("java.net.InetSocketAddress");
            Constructor<?> constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = Connection.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE);
            return constructor.newInstance(string, new Integer(n));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoSuchMethodException();
        }
        catch (InstantiationException instantiationException) {
            throw new NoSuchMethodException();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new NoSuchMethodException();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NoSuchMethodException();
        }
    }

    private Socket createSocket(String string, int n, String string2, int n2) throws Exception {
        Socket socket = null;
        if (string2 != null) {
            Class clazz = Obj.helper.loadClass(string2);
            Method method = clazz.getMethod("getDefault", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            Method method2 = null;
            if (n2 > 0) {
                try {
                    method2 = clazz.getMethod("createSocket", new Class[0]);
                    Method method3 = (class$java$net$Socket == null ? (class$java$net$Socket = Connection.class$("java.net.Socket")) : class$java$net$Socket).getMethod("connect", Class.forName("java.net.SocketAddress"), Integer.TYPE);
                    Object object2 = this.createInetSocketAddress(string, n);
                    socket = (Socket)method2.invoke(object, new Object[0]);
                    method3.invoke((Object)socket, object2, new Integer(n2));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (socket == null) {
                method2 = clazz.getMethod("createSocket", class$java$lang$String == null ? (class$java$lang$String = Connection.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE);
                socket = (Socket)method2.invoke(object, string, new Integer(n));
            }
        } else {
            if (n2 > 0) {
                try {
                    Constructor constructor = (class$java$net$Socket == null ? (class$java$net$Socket = Connection.class$("java.net.Socket")) : class$java$net$Socket).getConstructor(new Class[0]);
                    Method method = (class$java$net$Socket == null ? (class$java$net$Socket = Connection.class$("java.net.Socket")) : class$java$net$Socket).getMethod("connect", Class.forName("java.net.SocketAddress"), Integer.TYPE);
                    Object object = this.createInetSocketAddress(string, n);
                    socket = (Socket)constructor.newInstance(new Object[0]);
                    method.invoke((Object)socket, object, new Integer(n2));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (socket == null) {
                socket = new Socket(string, n);
            }
        }
        return socket;
    }

    synchronized int getMsgId() {
        return ++this.outMsgId;
    }

    LdapRequest writeRequest(BerEncoder berEncoder, int n) throws IOException {
        return this.writeRequest(berEncoder, n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LdapRequest writeRequest(BerEncoder berEncoder, int n, boolean bl) throws IOException {
        LdapRequest ldapRequest = new LdapRequest(n, bl);
        this.addRequest(ldapRequest);
        if (this.traceFile != null) {
            Ber.dumpBER(this.traceFile, this.traceTagOut, berEncoder.getBuf(), 0, berEncoder.getDataLen());
        }
        this.unpauseReader();
        Connection connection = this;
        synchronized (connection) {
            this.outStream.write(berEncoder.getBuf(), 0, berEncoder.getDataLen());
            this.outStream.flush();
        }
        return ldapRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BerDecoder readReply(LdapRequest ldapRequest) throws IOException, NamingException {
        BerDecoder berDecoder;
        while ((berDecoder = ldapRequest.getReplyBer()) == null) {
            try {
                Connection connection = this;
                synchronized (connection) {
                    if (this.sock == null) {
                        throw new ServiceUnavailableException(this.host + ":" + this.port + "; socket closed");
                    }
                }
                LdapRequest ldapRequest2 = ldapRequest;
                synchronized (ldapRequest2) {
                    berDecoder = ldapRequest.getReplyBer();
                    if (berDecoder != null) {
                        break;
                    }
                    ldapRequest.wait(15000L);
                }
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedNamingException("Interrupted during LDAP operation");
            }
        }
        return berDecoder;
    }

    private synchronized void addRequest(LdapRequest ldapRequest) {
        LdapRequest ldapRequest2 = this.pendingRequests;
        if (ldapRequest2 == null) {
            this.pendingRequests = ldapRequest;
            ldapRequest.next = null;
        } else {
            ldapRequest.next = this.pendingRequests;
            this.pendingRequests = ldapRequest;
        }
    }

    synchronized LdapRequest findRequest(int n) {
        LdapRequest ldapRequest = this.pendingRequests;
        while (ldapRequest != null) {
            if (ldapRequest.msgId == n) {
                return ldapRequest;
            }
            ldapRequest = ldapRequest.next;
        }
        return null;
    }

    synchronized void removeRequest(LdapRequest ldapRequest) {
        LdapRequest ldapRequest2 = this.pendingRequests;
        LdapRequest ldapRequest3 = null;
        while (ldapRequest2 != null) {
            if (ldapRequest2 == ldapRequest) {
                ldapRequest2.cancel();
                if (ldapRequest3 != null) {
                    ldapRequest3.next = ldapRequest2.next;
                } else {
                    this.pendingRequests = ldapRequest2.next;
                }
                ldapRequest2.next = null;
            }
            ldapRequest3 = ldapRequest2;
            ldapRequest2 = ldapRequest2.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abandonRequest(LdapRequest ldapRequest, Control[] controlArray) {
        this.removeRequest(ldapRequest);
        BerEncoder berEncoder = new BerEncoder(256);
        int n = this.getMsgId();
        try {
            berEncoder.beginSeq(48);
            berEncoder.encodeInt(n);
            berEncoder.encodeInt(ldapRequest.msgId, 80);
            if (this.v3) {
                LdapClient.encodeControls(berEncoder, controlArray);
            }
            berEncoder.endSeq();
            if (this.traceFile != null) {
                Ber.dumpBER(this.traceFile, this.traceTagOut, berEncoder.getBuf(), 0, berEncoder.getDataLen());
            }
            Connection connection = this;
            synchronized (connection) {
                this.outStream.write(berEncoder.getBuf(), 0, berEncoder.getDataLen());
                this.outStream.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    synchronized void abandonOutstandingReqs(Control[] controlArray) {
        LdapRequest ldapRequest = this.pendingRequests;
        while (ldapRequest != null) {
            this.abandonRequest(ldapRequest, controlArray);
            this.pendingRequests = ldapRequest = ldapRequest.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ldapUnbind(Control[] controlArray) {
        BerEncoder berEncoder = new BerEncoder(256);
        int n = this.getMsgId();
        try {
            berEncoder.beginSeq(48);
            berEncoder.encodeInt(n);
            berEncoder.encodeByte(66);
            berEncoder.encodeByte(0);
            if (this.v3) {
                LdapClient.encodeControls(berEncoder, controlArray);
            }
            berEncoder.endSeq();
            if (this.traceFile != null) {
                Ber.dumpBER(this.traceFile, this.traceTagOut, berEncoder.getBuf(), 0, berEncoder.getDataLen());
            }
            Connection connection = this;
            synchronized (connection) {
                this.outStream.write(berEncoder.getBuf(), 0, berEncoder.getDataLen());
                this.outStream.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    synchronized void cleanup(Control[] var1_1) {
        if (this.sock != null) {
            block10: {
                this.abandonOutstandingReqs(var1_1);
                if (this.bound) {
                    this.ldapUnbind(var1_1);
                }
                var3_2 = null;
                try {
                    this.outStream.flush();
                    this.sock.close();
                }
                catch (IOException var4_4) {
                    // empty catch block
                }
                var4_4 = this.pendingRequests;
                while (var4_4 != null) {
                    var4_4.cancel();
                    var4_4 = var4_4.next;
                }
                {
                    break block10;
                }
                catch (Throwable var2_6) {
                    var3_3 = null;
                    try {
                        this.outStream.flush();
                        this.sock.close();
                    }
                    catch (IOException var4_5) {
                        // empty catch block
                    }
                    var4_5 = this.pendingRequests;
                    ** while (var4_5 != null)
                }
lbl-1000:
                // 1 sources

                {
                    var4_5.cancel();
                    var4_5 = var4_5.next;
                    continue;
                }
lbl35:
                // 1 sources

                this.sock = null;
                throw var2_6;
            }
            this.sock = null;
            this.parent.notifyUnsolicited(new CommunicationException(this.host + ":" + this.port + " connection closed"));
        }
    }

    public synchronized void replaceStreams(InputStream inputStream, OutputStream outputStream) {
        this.inStream = inputStream;
        try {
            this.outStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.outStream = outputStream;
    }

    private synchronized InputStream getInputStream() {
        return this.inStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpauseReader() throws IOException {
        Object object = this.pauseLock;
        synchronized (object) {
            if (this.paused) {
                this.paused = false;
                this.pauseLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pauseReader() throws IOException {
        Object object = this.pauseLock;
        synchronized (object) {
            this.paused = true;
            try {
                while (this.paused) {
                    this.pauseLock.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException("Pause/unpause reader has problems.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        InputStream inputStream = null;
        try {
            try {
                block8: while (true) {
                    try {
                        while (true) {
                            int n;
                            byte[] byArray = new byte[2048];
                            int n2 = 0;
                            int n3 = 0;
                            int n4 = 0;
                            inputStream = this.getInputStream();
                            int n5 = inputStream.read(byArray, n2, 1);
                            if (n5 < 0) {
                                if (inputStream == this.getInputStream()) break block8;
                                continue;
                            }
                            if (byArray[n2++] != 48) continue;
                            n5 = inputStream.read(byArray, n2, 1);
                            if (n5 < 0) break block8;
                            if (((n3 = byArray[n2++]) & 0x80) == 128) {
                                n4 = n3 & 0x7F;
                                n5 = 0;
                                boolean bl = false;
                                while (n5 < n4) {
                                    int n6 = inputStream.read(byArray, n2 + n5, n4 - n5);
                                    if (n6 < 0) {
                                        bl = true;
                                        break;
                                    }
                                    n5 += n6;
                                }
                                if (bl) break block8;
                                n3 = 0;
                                int n7 = 0;
                                while (n7 < n4) {
                                    n3 = (n3 << 8) + (byArray[n2 + n7] & 0xFF);
                                    ++n7;
                                }
                                n2 += n5;
                            }
                            if (n2 + (n = n3) > byArray.length) {
                                byte[] byArray2 = new byte[n2 + n];
                                System.arraycopy(byArray, 0, byArray2, 0, n2);
                                byArray = byArray2;
                            }
                            while (n > 0) {
                                n5 = inputStream.read(byArray, n2, n);
                                if (n5 < 0) break;
                                n2 += n5;
                                n -= n5;
                            }
                            try {
                                BerDecoder berDecoder = new BerDecoder(byArray, 0, n2);
                                if (this.traceFile != null) {
                                    Ber.dumpBER(this.traceFile, this.traceTagIn, byArray, 0, n2);
                                }
                                berDecoder.parseSeq(null);
                                int n8 = berDecoder.parseInt();
                                berDecoder.reset();
                                boolean bl = false;
                                if (n8 == 0) {
                                    this.parent.processUnsolicited(berDecoder);
                                } else {
                                    LdapRequest ldapRequest = this.findRequest(n8);
                                    if (ldapRequest != null) {
                                        bl = ldapRequest.addReplyBer(berDecoder);
                                    }
                                }
                                if (!bl) continue block8;
                                this.pauseReader();
                                continue block8;
                            }
                            catch (Ber.DecodeException decodeException) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (IOException iOException) {
                        if (inputStream == this.getInputStream()) throw iOException;
                        continue;
                    }
                    break;
                }
                Object var15_19 = null;
                this.cleanup(null);
                return;
            }
            catch (IOException iOException) {
                Object var15_20 = null;
                this.cleanup(null);
            }
            return;
        }
        catch (Throwable throwable) {
            Object var15_21 = null;
            this.cleanup(null);
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

