/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap;

import android.media.AudioManager;
import com.phonegap.AudioPlayer;
import com.phonegap.api.Plugin;
import com.phonegap.api.PluginResult;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;

public class AudioHandler
extends Plugin {
    public static String TAG = "AudioHandler";
    HashMap<String, AudioPlayer> players = new HashMap();
    ArrayList<AudioPlayer> pausedForPhone = new ArrayList();

    public PluginResult execute(String action, JSONArray args, String callbackId) {
        PluginResult.Status status = PluginResult.Status.OK;
        String result = "";
        try {
            if (action.equals("startRecordingAudio")) {
                this.startRecordingAudio(args.getString(0), args.getString(1));
            } else if (action.equals("stopRecordingAudio")) {
                this.stopRecordingAudio(args.getString(0));
            } else if (action.equals("startPlayingAudio")) {
                this.startPlayingAudio(args.getString(0), args.getString(1));
            } else if (action.equals("seekToAudio")) {
                this.seekToAudio(args.getString(0), args.getInt(1));
            } else if (action.equals("pausePlayingAudio")) {
                this.pausePlayingAudio(args.getString(0));
            } else if (action.equals("stopPlayingAudio")) {
                this.stopPlayingAudio(args.getString(0));
            } else if (action.equals("setVolume")) {
                try {
                    this.setVolume(args.getString(0), Float.parseFloat(args.getString(1)));
                }
                catch (NumberFormatException nfe) {}
            } else {
                if (action.equals("getCurrentPositionAudio")) {
                    float f = this.getCurrentPositionAudio(args.getString(0));
                    return new PluginResult(status, f);
                }
                if (action.equals("getDurationAudio")) {
                    float f = this.getDurationAudio(args.getString(0), args.getString(1));
                    return new PluginResult(status, f);
                }
                if (action.equals("release")) {
                    boolean b = this.release(args.getString(0));
                    return new PluginResult(status, b);
                }
            }
            return new PluginResult(status, result);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return new PluginResult(PluginResult.Status.JSON_EXCEPTION);
        }
    }

    public boolean isSynch(String action) {
        if (action.equals("getCurrentPositionAudio")) {
            return true;
        }
        return action.equals("getDurationAudio");
    }

    public void onDestroy() {
        for (AudioPlayer audio : this.players.values()) {
            audio.destroy();
        }
        this.players.clear();
    }

    public void onMessage(String id, Object data) {
        if (id.equals("telephone")) {
            if ("ringing".equals(data) || "offhook".equals(data)) {
                for (AudioPlayer audio : this.players.values()) {
                    if (audio.getState() != AudioPlayer.MEDIA_RUNNING) continue;
                    this.pausedForPhone.add(audio);
                    audio.pausePlaying();
                }
            } else if ("idle".equals(data)) {
                for (AudioPlayer audio : this.pausedForPhone) {
                    audio.startPlaying(null);
                }
                this.pausedForPhone.clear();
            }
        }
    }

    private boolean release(String id) {
        if (!this.players.containsKey(id)) {
            return false;
        }
        AudioPlayer audio = this.players.get(id);
        this.players.remove(id);
        audio.destroy();
        return true;
    }

    public void startRecordingAudio(String id, String file) {
        if (this.players.containsKey(id)) {
            return;
        }
        AudioPlayer audio = new AudioPlayer(this, id);
        this.players.put(id, audio);
        audio.startRecording(file);
    }

    public void stopRecordingAudio(String id) {
        AudioPlayer audio = this.players.get(id);
        if (audio != null) {
            audio.stopRecording();
            this.players.remove(id);
        }
    }

    public void startPlayingAudio(String id, String file) {
        AudioPlayer audio = this.players.get(id);
        if (audio == null) {
            audio = new AudioPlayer(this, id);
            this.players.put(id, audio);
        }
        audio.startPlaying(file);
    }

    public void seekToAudio(String id, int milliseconds) {
        AudioPlayer audio = this.players.get(id);
        if (audio != null) {
            audio.seekToPlaying(milliseconds);
        }
    }

    public void pausePlayingAudio(String id) {
        AudioPlayer audio = this.players.get(id);
        if (audio != null) {
            audio.pausePlaying();
        }
    }

    public void stopPlayingAudio(String id) {
        AudioPlayer audio = this.players.get(id);
        if (audio != null) {
            audio.stopPlaying();
        }
    }

    public float getCurrentPositionAudio(String id) {
        AudioPlayer audio = this.players.get(id);
        if (audio != null) {
            return (float)audio.getCurrentPosition() / 1000.0f;
        }
        return -1.0f;
    }

    public float getDurationAudio(String id, String file) {
        AudioPlayer audio = this.players.get(id);
        if (audio != null) {
            return audio.getDuration(file);
        }
        audio = new AudioPlayer(this, id);
        this.players.put(id, audio);
        return audio.getDuration(file);
    }

    public void setAudioOutputDevice(int output) {
        AudioManager audiMgr = (AudioManager)this.ctx.getSystemService("audio");
        if (output == 2) {
            audiMgr.setRouting(0, 2, -1);
        } else if (output == 1) {
            audiMgr.setRouting(0, 1, -1);
        } else {
            System.out.println("AudioHandler.setAudioOutputDevice() Error: Unknown output device.");
        }
    }

    public int getAudioOutputDevice() {
        AudioManager audiMgr = (AudioManager)this.ctx.getSystemService("audio");
        if (audiMgr.getRouting(0) == 1) {
            return 1;
        }
        if (audiMgr.getRouting(0) == 2) {
            return 2;
        }
        return -1;
    }

    public void setVolume(String id, float volume) {
        AudioPlayer audio = this.players.get(id);
        if (audio != null) {
            audio.setVolume(volume);
        } else {
            System.out.println("AudioHandler.setVolume() Error: Unknown Audio Player " + id);
        }
    }
}

