/* -*- mode: c ; c-file-style: "canonware-c-style" -*-
 ******************************************************************************
 *
 * Copyright (C) 1996-2005 Jason Evans <jasone@canonware.com>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice(s), this list of conditions and the following disclaimer
 *    unmodified other than the allowable addition of one or more
 *    copyright notices.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice(s), this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 *
 * Version: Onyx 5.1.2
 *
 ******************************************************************************/

typedef void cw_nxo_handle_eval_t (void *a_opaque, cw_nxo_t *a_thread);

typedef cw_nxoe_t *cw_nxo_handle_ref_iter_t (void *a_opaque, bool a_reset);

typedef bool cw_nxo_handle_delete_t (void *a_opaque, uint32_t a_iter);

void
nxo_handle_new(cw_nxo_t *a_nxo, void *a_opaque, cw_nxo_handle_eval_t *a_eval_f,
	       cw_nxo_handle_ref_iter_t *a_ref_iter_f,
	       cw_nxo_handle_delete_t *a_delete_f);

cw_nxo_t *
nxo_handle_tag_get(const cw_nxo_t *a_nxo);

void *
nxo_handle_opaque_get(const cw_nxo_t *a_nxo);

void
nxo_handle_opaque_set(cw_nxo_t *a_nxo, void *a_opaque);

void
nxo_handle_eval(cw_nxo_t *a_nxo, cw_nxo_t *a_thread);
